#include <math.h>
#include "Renderer_Impl.h"

namespace videonext { namespace media {

Image_Calibration::Image_Calibration()
{
    contrast   = 1.0f;
    brightness = 0.0f;
    saturation = 1.0f;
}

Image_Calibration::Image_Calibration(const vn_image_calibration_t &o)
{
    contrast   = o.contrast;
    brightness = o.brightness;
    saturation = o.saturation;
}

bool operator== (const Image_Calibration &ic1, const Image_Calibration &ic2)
{
    const float diff_epsilon = 0.00001;

    return fabs(ic1.contrast - ic2.contrast) <= diff_epsilon
        && fabs(ic1.brightness - ic2.brightness) <= diff_epsilon
        && fabs(ic1.saturation - ic2.saturation) <= diff_epsilon;
}

bool operator!= (const Image_Calibration &ic1, const Image_Calibration &ic2)
{
    return !(ic1 == ic2);
}

Image_Pan_Zoom::Image_Pan_Zoom()
{
    pan_x = 0.5f;
    pan_y = 0.5f;
    scale = 1.0f;
    mode  = VN_IMAGE_ZOOM_BILENEAR;
}

Image_Pan_Zoom::Image_Pan_Zoom(const vn_image_pan_zoom_t &o)
{
    pan_x = o.pan_x;
    pan_y = o.pan_y;
    scale = o.scale;
    mode  = o.mode;
}

bool operator== (const Image_Pan_Zoom &pz1, const Image_Pan_Zoom &pz2)
{
    const float diff_epsilon = 0.00001;

    return fabs(pz1.pan_x - pz2.pan_x) <= diff_epsilon
        && fabs(pz1.pan_y - pz2.pan_y) <= diff_epsilon
        && fabs(pz1.scale - pz2.scale) <= diff_epsilon
        && pz1.mode == pz2.mode;
}

bool operator!= (const Image_Pan_Zoom &pz1, const Image_Pan_Zoom &pz2)
{
    return !(pz1 == pz2);
}

Renderer_Impl::Renderer_Impl()
    : show_metadata_(false)
{
}

/*virtual*/ Renderer_Impl::~Renderer_Impl()
{
}

}}
