#ifndef _RENDERER_H_
#define _RENDERER_H_

#include "Renderer_Impl.h"

namespace videonext { namespace media {
        
class Renderer
{
public:

    Renderer();

    virtual ~Renderer();

    int init(void* window_handle);

    int process(const vn_player_frame_t *frame);

    int draw(VN_IMAGE_FILL_MODE mode, struct vn_image_calibration_t *ic, struct vn_image_pan_zoom_t *pz);

    VN_PLAYER_PIXEL_FORMAT get_preferred_pixel_format();
    
    // TODO:
    // PIXEL_FORMAT get_prefered_pixel_format();
    // unsigned char *get_image_buffer(int width, int height, int *pitch)
    // void lock_image_buffer();
    // void unlock_image_buffer();
    // in VideoFrameConsumer.cpp:
    // replace ffmpeg_getBuffer...
    
private:
    Renderer_Impl *impl_;
};
        
}}

#endif /* _RENDERER_H_ */
