#include "sdl2/SDL2_Renderer_Impl.h"
#include "win32/D3D9_Renderer_Impl.h"
#include "Renderer.h"

namespace videonext { namespace media {

Renderer::Renderer()
    : impl_(0)
{
}

Renderer::~Renderer()
{
    delete impl_;
}

int Renderer::init(void* window_handle)
{
#ifdef WIN32
    impl_ = new D3D9_Render_Impl();
    HRESULT hr = impl_->init(window_handle);
    if (SUCCEEDED(hr))
        return 0;
    // If still here let's try out SDL2 renderer
#endif
    impl_ = new SDL2_Renderer_Impl();
    return impl_->init(window_handle);
}

int Renderer::process(const vn_player_frame_t *frame)
{
    return impl_->process(frame);
}

int Renderer::draw(VN_IMAGE_FILL_MODE _mode, struct vn_image_calibration_t *_ic, struct vn_image_pan_zoom_t *_pz)
{
    Image_Fill_Mode mode = (Image_Fill_Mode)_mode;
    Image_Calibration ic = (_ic ? Image_Calibration(*_ic) : Image_Calibration());
    Image_Pan_Zoom pz    = (_pz ? Image_Pan_Zoom(*_pz) : Image_Pan_Zoom());

    return impl_->draw(mode, (_ic ? &ic : 0), (_pz ? &pz : 0));
}

VN_PLAYER_PIXEL_FORMAT Renderer::get_preferred_pixel_format()
{
    return impl_->get_preferred_pixel_format();
}

}}
