#ifndef _PERF_H_
#define _PERF_H_
#include "ace/Time_Value.h"
#include <vector>

#define PERF_BEGIN(name)                        \
do {                                            \
    std::vector<int> name ## _results;           \
    uint64_t name ## usec_s;                    \
    uint64_t name ## usec_e;                                                

#define PERF_START(name)                                                \
    {                                                                   \
        ACE_Time_Value tv = ACE_OS::gettimeofday();                     \
        name ## usec_s = (uint64_t)tv.sec() * 1000000 + tv.usec(); \
    }

#define PERF_FINISH(name)                                               \
    {                                                                   \
        ACE_Time_Value tv = ACE_OS::gettimeofday();                     \
        name ## usec_e = (uint64_t)tv.sec() * 1000000 + tv.usec(); \
        name ## _results.push_back(name ## usec_e - name ## usec_s);     \
    }


#define PERF_END(name, message, ...)                                    \
    /* Calculating max, min, average */                                 \
    if (name ## _results.size())                                         \
    {                                                                   \
        int min, max, sum;                                              \
        for (size_t i = 0; i < name ## _results.size(); i++)            \
        {                                                               \
            if (i == 0)                                                 \
            {                                                           \
                min = max = sum = name ## _results[i];                   \
                continue;                                               \
            }                                                           \
                                                                        \
            if (name ## _results[i] > max)                               \
                max = name ## _results[i];                               \
                                                                        \
            if (name ## _results[i] < min)                               \
                min = name ## _results[i];                               \
                                                                        \
            sum += name ## _results[i];                                  \
        }                                                               \
                                                                        \
        printf("Test %s: num_iter:%d, total:%d, min:%d, max:%d, avg:%d ("message")\n", # name, \
               name ## _results.size(),                                 \
               sum,                                                     \
               min,                                                     \
               max,                                                     \
               sum / name ## _results.size(),                           \
               ##__VA_ARGS__);                                          \
    }                                                                   \
} while (0);


#endif /* _PERF_H_ */
