/**
 * @version $Id: Rectangle.h 22592 2011-05-06 13:56:18Z nkrachkovsky $
 * ------------------------------------------------------------------------------
 * Rectangle
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2010
 * ------------------------------------------------------------------------------
 */
 
#include "Point.h"

#pragma once
#ifndef H_Rectangle
#define H_Rectangle

class Rectangle2 {
public:
    Rectangle2(void) {}
    Rectangle2(int x, int y, int width, int height)
    {
        this->x = x;
        this->y = y;
        this->width = width;
        this->height = height;
    }
    Rectangle2( int width, int height )
    : x(0), y(0), width( width ), height( height )
    { }

    bool contains(const Point2& p) const
    {
        return this->contains(p.x, p.y);
    }

    bool contains(int x, int y) const
    {
        return this->inside(x, y);
    }

    int right() const
    {
        return x + width;
    }

    int bottom() const
    {
        return y + height;
    }

    /**
     * Checks whether or not this <code>Rectangle</code> contains the 
     * point at the specified location {@code (X,Y)}.
     *
     * @param  X the specified X coordinate
     * @param  Y the specified Y coordinate
     * @return    <code>true</code> if the point 
     *            {@code (X,Y)} is inside this 
     *            <code>Rectangle</code>; 
     *            <code>false</code> otherwise.
     */
    bool inside(int X, int Y) const
    {
        int w = this->width;
        int h = this->height;
        if ((w | h) < 0) {
            // At least one of the dimensions is negative...
            return false;
        }
        // Note: if either dimension is zero, tests below must return false...
        int x = this->x;
        int y = this->y;
        if (X < x || Y < y) {
            return false;
        }
        w += x;
        h += y;
        //    overflow || intersect
        return ((w < x || w > X) &&
            (h < y || h > Y));
    }

    void setBounds(Rectangle2 r)
    {
        setBounds(r.x, r.y, r.width, r.height);
    }

    void setBounds(int x, int y, int width, int height)
    {
        reshape(x, y, width, height);
    }

    void reshape(int x, int y, int width, int height)
    {
        this->x = x;
        this->y = y;
        this->width = width;
        this->height = height;
    }

    Point2 location() const
    {
        return Point2(x, y);
    }
public:
    int x;
    int y;
    int width;
    int height;
};

#endif
