/*
 *  GraphicsProxy.h
 *
 */
#pragma once
#ifndef GRAPHICS_PROXY_H_
#define GRAPHICS_PROXY_H_

#include <string>
#include "Graphics.h"

// Objects tracking start codes
#define OBJ_SEQUENCE_START_CODE       0x0A
#define OBJ_START_CODE                0x01
#define OBJ_DRAW_TYPE_START_CODE      0x02
#define OBJ_X_COORD_START_CODE        0x03
#define OBJ_Y_COORD_START_CODE        0x04
#define OBJ_HEIGHT_START_CODE         0x05
#define OBJ_WIDTH_START_CODE          0x06
#define OBJ_COLOR_START_CODE          0x07
#define OBJ_LINEWIDTH_START_CODE      0x08
#define OBJ_TEXT_START_CODE           0x09
#define OBJ_POLYGON_START_CODE        0x0B
#define OBJ_ARROWHEADSIZE_START_CODE  0x0C
#define OBJ_SEQUENCE_END_START_CODE   0x7F

#define OBJ_DRAW_TYPE_BOX             0x01
#define OBJ_DRAW_TYPE_MLINE           0x02
#define OBJ_DRAW_TYPE_TEXT            0x03
#define OBJ_DRAW_TYPE_TIMESTAMP       0x04
#define OBJ_DRAW_TYPE_POLYGON         0x05
#define OBJ_DRAW_TYPE_TRIPWIRE_ARROW  0x06
#define OBJ_DRAW_TYPE_ARROW           0x07
#define OBJ_DRAW_TYPE_ELLIPSE         0x08

class GraphicsProxy : public Graphics
{
public:
    GraphicsProxy();
    virtual ~GraphicsProxy();
    virtual bool drawImage(const Image* img, int x, int y, int width, int height);
    virtual void drawLine(int x1, int y1, int x2, int y2);
    virtual void setColor(Color c);
    virtual void drawRect(int x, int y, int width, int height);
    virtual void fillRect(int x, int y, int width, int height);
    virtual void drawEllipse(int x, int y, int width, int height);
    virtual void fillEllipse(int x, int y, int width, int height);
    virtual void drawPolyline( const std::vector<int>& xCoords, const std::vector<int>& yCoords, int count );
    virtual void drawPolyline( const std::vector<Point2>& points );
    virtual void fillPolygon( const std::vector<int>& xCoords, const std::vector<int>& yCoords, int count );
    virtual void fillPolygon( const std::vector<Point2>& points );

    virtual float getStrokeWidth() const ;
    virtual void setStrokeWidth( float strokeWidth );

    virtual void setFont( const char* fontName, float fontSize, FONT_STYLE fontStyle );
    virtual float fontAscent() const ;
    virtual float fontDescent() const ;
    virtual Point2 measureText( const std::string& text );
    virtual Rectangle2 drawString( const std::string& text, float x, float y, HORZ_ALIGN horzAlign = Left, VERT_ALIGN vertAlign = BaseLine );

    virtual void pushState();
    virtual void popState();
    virtual void setTransform2Identity();
    virtual void setTransform2( Transform2Matrix matrix );
    virtual Transform2Matrix getTransform2();
    virtual void multiplyTransform2( Transform2Matrix matrix );
    virtual void scaleTransform2( float sx, float sy );
    virtual void rotateTransform2( float angle ); // angle in degrees
    virtual void translateTransform2( float dx, float dy );
    
    void initSequence();
    void push8( char x );
    void push16( short x );
    void push32( int x );
    void push8_8( char x, char y ) { push8( x ); push8( y ); }
    void push8_16( char x, short y ) { push8( x ); push16( y ); }
    void push8_32( char x, int y ) { push8( x ); push32( y ); }
    void finalizeSequence();
public:
    std::string binaryData;
    int obj_id;
    float stroke_width;
    float font_size;
    Color clr;
};

#endif
