#ifndef GRAPHICSGDIMPL_H
#define GRAPHICSGDIMPL_H

#include "Graphics.h"
#include <gd.h>

//#define DEBUG_CALL_FUNC

class GraphicsGDImpl : public Graphics
{
public:
    GraphicsGDImpl(gdImagePtr im /*uint8_t* data, unsigned& dataSize*/);
    ~GraphicsGDImpl();

    static int fprintf(FILE* f, const char *fmt, ...);
    /*virtual*/ void drawLine(int x1, int y1, int x2, int y2);
    /*virtual*/ void setColor(Color c);
    /*virtual*/ void drawRect(int x, int y, int width, int height);
    /*virtual*/ void fillRect(int x, int y, int width, int height);
    /*virtual*/ void drawEllipse(int x, int y, int width, int height);
    /*virtual*/ void fillEllipse(int x, int y, int width, int height);
    /*virtual*/ void drawPolyline( const std::vector<int>& xCoords, const std::vector<int>& yCoords, int count );
    /*virtual*/ void drawPolyline( const std::vector<Point2>& points );
    /*virtual*/ void fillPolygon( const std::vector<int>& xCoords, const std::vector<int>& yCoords, int count );
    /*virtual*/ void fillPolygon( const std::vector<Point2>& points );

    /*virtual*/ float getStrokeWidth() const;
    /*virtual*/ void setStrokeWidth( float strokeWidth );

    /*virtual*/ void setFont( const char* fontName, float fontSize, FONT_STYLE fontStyle );
    /*virtual*/ float fontAscent() const;
    /*virtual*/ float fontDescent() const;
    /*virtual*/ Point2 measureText( const std::string& text );
    /*virtual*/ Rectangle2 drawString( const std::string& text, float x, float y, HORZ_ALIGN horzAlign = Left, VERT_ALIGN vertAlign = BaseLine );

                bool drawImage(const Image*, int, int, int, int) {return true;}
                void pushState() {}
                void popState() {}
                void setTransform2Identity() {}
                void setTransform2( Transform2Matrix /*matrix*/ ) {}
                Transform2Matrix getTransform2() {return Transform2Matrix( 0., 0., 0., 0., 0., 0. );}
                void multiplyTransform2( Transform2Matrix /*matrix*/ ) {}
                void scaleTransform2( float, float) {}
                void rotateTransform2( float ) {} // angle in degrees
                void translateTransform2( float, float ) {}
private:
    gdImagePtr im_;
    float strokeWidth_;
    int color_;
    FILE* f_;
};

#endif // GRAPHICSGDIMPL_H
