#ifndef VN_MEDIA_STREAM_PRODUCER_H_
#define VN_MEDIA_STREAM_PRODUCER_H_

#include <map>
#include "MediaStreamHandler.h"

namespace videonext { namespace media {

class MediaStreamProducerImpl;

/**
 *  
 */
class MediaStreamProducer
{
public:    

    MediaStreamProducer(MediaStreamHandler *h, const std::string &url, 
                        unsigned cacheSize, unsigned streamId, bool streamOverTCP,
                        unsigned bufferLen /*msec*/, float speed = 1.f);

   virtual ~MediaStreamProducer();
    
public:

   /** 
    * Opening stream.
    * OPENING/OPENED statuses will inform about process
    */
   void open();
    
  /**
    * Trying to play stream or resume paused stream. 
    * This is entry point and basically does not return until teardown() is called
    * Player's statuses "PLAY_FROM_SERVER/PLAY_FROM_BUFFER" will inform about success playing.   
    */
   void play();
        
   /**
    * Pause stream. Live stream is not really paused. Just stopping invoke MediaStreamHandler::newFrame,
    * but cache will be filled as usually.        
    */    
   void pause();
    
   /**
    * Teardown stream. Deletes all alocated resources.        
    */
   void teardown();    
    
   /**
    * Currently applied only for buffer. 
    * If negative value - playing back.
    */
   void setPlayDirection(int);
    
   /**
    * Enable/disable step mode. Works on both server and buffer streams.
    * When step mode enabled, play() will invoke MediaEventHandler::onNewFrame() once 
    * and will set status IDLE. 
    * pause() also is necessary before setting step mode.       
    */
   void setStepMode(bool);


   void setSpeed(float);

    
   void setJitterBufferLen(unsigned);
    
   /** 
    * If possible jump to another time in archive
    * 
    * @param time unix epoch time stamp 
    */
   void moveToTimestamp(time_t time);


   /**
    * By default producer does not do any decoding and sends just parsed raw frames.
    * You can enable decoding facility here. Also you can set prefered pixel format for 
    * decoded video frames 
    */
   void enableDecoding(unsigned type, PIXEL_FORMAT preferedPixelFormat = PIX_RGB32);

   /** 
    * Starts recording of frames to a local file.
    */
   bool startRecording(const char* file_name, const std::map<std::string, std::string>& metadata);

   /** 
    * Ends recording of frames to a local file.
    */
   bool endRecording(bool stop = false);


    void muteAudio(bool mute);
    
private:
    MediaStreamProducerImpl *pimpl_;
};

}}

#endif /*VN_MEDIA_STREAM_PRODUCER_H_*/
