/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 03/04/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef AUDIOFRAMECONSUMER_H
#define AUDIOFRAMECONSUMER_H

extern "C" {
#include "libavcodec/avcodec.h"
#include "libswresample/swresample.h"
}

#include "liveMedia.hh"
#include "c_ptr.h"
#include "FrameConsumer.h"

namespace videonext { namespace media {

class AudioFrameConsumer: public FrameConsumer {
public:
  static AudioFrameConsumer* createNew(AdaptiveUsageEnvironment& env,
                                       AudioVideoPlaybackController *controller,
                                       unsigned bufferSize,
                                       unsigned decoderType,
                                       StreamInfo *streamInfo);

   virtual bool init();


   virtual void addData(unsigned char* data, unsigned dataSize,
                        const struct timeval &presentationTime,
                        bool parseOurHeader = true, const std::string* pObjectsData = NULL);


    virtual void mute(bool mute);

protected:
  AudioFrameConsumer(AdaptiveUsageEnvironment& env,
                     AudioVideoPlaybackController *controller,
                     unsigned bufferSize,
                     unsigned decoderType,
                     StreamInfo *streamInfo);

      // called only by createNew()
  virtual ~AudioFrameConsumer();



protected:
   /**
    * Just play raw PCM data
    * @param cpMediaFrame
    */
    virtual void playFrame(CPMediaFrame &, bool show);

    virtual void setFrameType(CPMediaFrame &);


private:
    uint8_t* findHeader(uint8_t* data, unsigned dataSize);
    bool initSDLAudio();

private:
    AVCodecContext *fCodecCtx;
    SwrContext *fSwr;
    uint8_t **fSwrBuf;

    uint32_t fAudioDevice;
    bool fMuted;
};

}}

#endif
