#ifndef _VN_JSTREAMER_H_
#define _VN_JSTREAMER_H_

#include <jni.h>
extern "C" {
#include  "libavcodec/avcodec.h"
#include "libavutil/opt.h"
}
#include "MediaClientImpl.h"

class VN_JStreamer : public videonext::media::PushMediaClient
{
public:
    VN_JStreamer();
    ~VN_JStreamer();

    /** 
     * Initialize streamer
     * 
     * @param rtsp_url 
     * @param video_width
     * @param video_height 
     * 
     * @return -1 if failed
     */
    int init(const std::string &rtsp_url, 
             int video_width, int video_height);

    /** 
     * Encode and send video frame
     * 
     * @param img data in the NV21 native android format
     * @param gps_lat
     * @param gps_long
     * @param gps_alt
     *
     * @return -1 if failed
     */
    int process_video_frame(uint8_t *img, float gps_lat, float gps_long, float gps_alt);

private:
    struct AVFrame *av_picture_;
    struct AVCodec *en_codec_;
    struct AVCodecContext *en_ctx_;
    unsigned char *out_buf_;
    int video_width_;
    int video_height_;
    uint8_t *av_picture_data_[3];
};

#ifdef __cplusplus
extern "C"
{
#endif

/** 
 * Init streaming
 * 
 * @param url RTSP URL
 * @param width
 * @param height
 * 
 * @return pointer to VN_JStreamer instance
 */
JNIEXPORT jlong JNICALL Java_com_videonext_MediaStreamer_nativeInit(JNIEnv *, jobject, jstring url, jint width, jint height);

/** 
 * Stops Streaming. Frees resources
 * 
 * @param streamer pointer to VN_JStreamer instance
 *
 */
JNIEXPORT void JNICALL Java_com_videonext_MediaStreamer_nativeDestroy(JNIEnv *, jobject, jlong streamer);

/** 
 * Send video frame. 
 * 
 * @param streamer pointer to VN_JStreamer instance
 * @param img Image data in NV21 format
 * @param gpsLat latitude
 * @param gpsLong longitude
 * @param gpsAlt altitude
 * 
 */
JNIEXPORT jint JNICALL Java_com_videonext_MediaStreamer_nativeSendVideo(JNIEnv *jenv, jobject jobj, jlong id, jbyteArray img,
                                                                        jfloat gpsLat, jfloat gpsLong, jfloat gpsAlt);

#ifdef __cplusplus
}
#endif


#endif /* _VN_JSTREAMER_H_ */
