#ifndef _VN_JPLAYER_H_
#define _VN_JPLAYER_H_

#include <jni.h>
#include <string>
#include <map>
#include <vector>

#include "impl/Mutex.h"
#include "vn_player.h"

using namespace videonext::media;

//class JsonObjectsTracker;

class VN_JPlayer
{
public:
    VN_JPlayer(JavaVM *jvm,
               jobject jobj,
               const std::map<std::string, jmethodID> &jmethods);
    virtual ~VN_JPlayer();

    void open(const std::string &url);
    void play();
    void resume(int direction);
    void pause();
    void teardown(JNIEnv *jenv);
    void jump(time_t timestamp);
    void mute_audio(bool val);

private:
    static void new_frame(const vn_player_frame_t*, const vn_player_cache_boundaries_t*, int buf_num, void *client_data);
    static void buffer_changed(const vn_player_cache_boundaries_t*, void *client_data);
    static void state_changed(VN_PLAYER_STREAM_STATE, const vn_player_result_status_t*, void *client_data);
    static void new_stream(const vn_player_stream_info_t*, void *client_data);
    static void stream_removed(const vn_player_stream_info_t*, void *client_data);
    static void* create_image_buffer(int width, int height, float dar, void *client_data);
    static void lock_image_buffer(void *client_data);
    static void unlock_image_buffer(void *client_data);
    static void msg_log(const char *msg, void *client_data);

private: // jni stuff
    JavaVM *jvm_;
    jobject jobj_;
    std::map<std::string, jmethodID> jmethods_;

    jintArray jpict_;
    jint *jpict_data_;

private:
    struct vn_player_config_t conf_;
    struct vn_player_context_t *ctx_;
    //JsonObjectsTracker *jsOT_;
};


#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Start playing URL
 *
 * @param url RTSP URL to open
 *
 * @return pointer to VN_JPlayer instance
 */
JNIEXPORT jlong JNICALL Java_com_videonext_MediaPlayer_nativeOpen(JNIEnv *, jobject, jstring url);

/**
 * Start playing URL
 *
 * @param player pointer to VN_JPlayer instance
 *
 */
JNIEXPORT void JNICALL Java_com_videonext_MediaPlayer_nativePlay(JNIEnv *, jobject, jlong player);

/**
 * Stop playing URL
 *
 * @param player pointer to VN_JPlayer instance
 *
 */
JNIEXPORT void JNICALL Java_com_videonext_MediaPlayer_nativeStop(JNIEnv *, jobject, jlong player);

/**
 * Pause
 *
 * @param player pointer to VN_JPlayer instance
 *
 */
JNIEXPORT void JNICALL Java_com_videonext_MediaPlayer_nativePause(JNIEnv *, jobject, jlong player);

/**
 * Resume after pause
 *
 * @param player pointer to VN_JPlayer instance
 * @param direction. Positive - play forward, negative - play backward
 *
 */
JNIEXPORT void JNICALL Java_com_videonext_MediaPlayer_nativeResume(JNIEnv *, jobject, jlong player, jint direction);

/**
 * Jump to time
 *
 * @param player pointer to VN_JPlayer instance
 * @param timestamp Unix timestamp
 */
JNIEXPORT void JNICALL Java_com_videonext_MediaPlayer_nativeJump(JNIEnv *, jobject, jlong player, jint timestamp);

/**
 * Mute/unmute audio
 *
 * @param player pointer to VN_JPlayer instance
 * @param v
 */
JNIEXPORT void JNICALL Java_com_videonext_MediaPlayer_nativeMuteAudio(JNIEnv *, jobject, jlong player, jboolean v);

#ifdef __cplusplus
}
#endif


#endif /* _VN_JPLAYER_H_ */
