#ifndef _VN_JCLIENT_H_
#define _VN_JCLIENT_H_

#include <jni.h>

#ifdef __cplusplus
extern "C"
{
#endif

JNIEXPORT jlong JNICALL Java_com_videonext_MediaClient_nativeInit(JNIEnv *, jobject, 
                                                                  jstring host, jshort port, 
                                                                  jboolean ssl, jlong timeout);

JNIEXPORT void JNICALL Java_com_videonext_MediaClient_nativeDestroy(JNIEnv *, jobject, jlong hndl);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeLogin(JNIEnv *jenv, jobject jobj, 
                                                                     jlong handle, 
                                                                     jstring user_name, jstring pasword);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeGetRoles(JNIEnv *jenv, jobject jobj, 
                                                                        jlong handle);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeGetSets(JNIEnv *jenv, jobject jobj, 
                                                                       jlong handle, jstring role_id);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeGetObjects(JNIEnv *jenv, jobject jobj, 
                                                                          jlong handle, jstring set_id);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeGetEvents(JNIEnv *jenv, jobject jobj, 
                                                                         jlong handle, jstring roleid, jstring filter);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeGetSnapshot(JNIEnv *jenv, jobject jobj, 
                                                                           jlong handle,
                                                                           jstring objid, jlong ts, jint stream_num, jboolean metadata);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeGetMediaURL(JNIEnv *jenv, jobject jobj, 
                                                                           jlong handle,
                                                                           jstring video_obj_id, jstring audio_obj_id,
                                                                           jlong start, jlong end, 
                                                                           jstring transcode_codec, jstring transcode_resolution,
                                                                           jint analytics);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeAddObject(JNIEnv *jenv, jobject jobj,
                                                                         jlong hndl,
                                                                         jstring hwid,
                                                                         jstring name);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativePerformPTZCommand(JNIEnv *jenv, jobject jobj,
                                                                                 jlong hndl, jstring obj_id,
                                                                                 jstring mode, jstring cmd);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeGetGEO(JNIEnv *jenv, jobject jobj,
                                                                      jlong hndl, jobjectArray obj_ids);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeGetServerInfo(JNIEnv *jenv, jobject jobj,
                                                                             jlong hndl);

JNIEXPORT jobject JNICALL Java_com_videonext_MediaClient_nativeSubmitAction(JNIEnv *jenv, jobject jobj,
                                                                            jlong hndl, jint eventid,
                                                                            jstring action, jstring roleid,
                                                                            jstring data);
#ifdef __cplusplus
}
#endif


#endif /* _VN_JCLIENT_H_ */
