#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#include <pthread.h>
#endif

#include <stdio.h>
#include <string.h>

#include "vn_player.h"

class Media_Player
{
public:
   Media_Player();
   ~Media_Player();

   void play(const char *url);
   void pause();
   void resume();

   // etc...	

private:
   static void new_frame(const vn_player_frame_t*, const vn_player_cache_boundaries_t*, void *client_data);
   
   static void buffer_changed(const vn_player_cache_boundaries_t*, void *client_data);  
        
   static void state_changed(VN_PLAYER_STREAM_STATE, const vn_player_result_status_t*, void *client_data);
       
   static void new_stream(const vn_player_stream_info_t*, void *client_data); 
        
   static void stream_removed(const vn_player_stream_info_t*, void *client_data); 
   
   static void msg_log(const char *msg, void *client_data);

private:
   struct vn_player_config_t conf_;	
   struct vn_player_env_t *env_; 
   struct vn_player_context_t *ctx_;
};

Media_Player::Media_Player()
{
	env_ = vn_player_env_create();
	vn_player_env_set_logging_callback(env_, msg_log, this);

	conf_.cache_size = 10;
	conf_.enable_decoding = 1;
	conf_.pixel_format = RGB32;
	conf_.rtp_transport = RTP_TRANSPORT_TCP;
	conf_.client_data = this;
        conf_.buffer_len = 0;

    struct vn_player_callbacks_t callbacks;
	callbacks.buffer_changed = buffer_changed;
	callbacks.new_frame      = new_frame;
	callbacks.new_stream     = new_stream;
	callbacks.state_changed  = state_changed;
	callbacks.stream_removed = stream_removed;

	ctx_ = vn_player_create(env_, &conf_);
	vn_player_set_callbacks(ctx_, &callbacks);
}

Media_Player::~Media_Player()
{
	vn_player_destroy(ctx_);
	vn_player_env_destroy(env_);
}
void Media_Player::play(const char *url)
{
	vn_player_play(ctx_, url);
}

void Media_Player::pause()
{
	vn_player_pause(ctx_);
}

void Media_Player::resume()
{
   vn_player_resume(ctx_, -1);
}

void Media_Player::new_frame(const vn_player_frame_t *frame, const vn_player_cache_boundaries_t *bounds, void *client_data)
{
	printf("new_frame: size=%dx%d\n", frame->width, frame->height);
}

void Media_Player::buffer_changed(const vn_player_cache_boundaries_t *bounds, void *client_data)
{
//	printf("buffer_changed\n");
}
        
void Media_Player::state_changed(VN_PLAYER_STREAM_STATE state, const vn_player_result_status_t *result_status, void *client_data)
{
   //  if (result_status->error_code)
	printf("state_changed: %d. result: %s(%d)\n", state, result_status->error_str, result_status->error_code);
/*
        if (result_status->error_code && result_status->error_code < 10000)
        {
           char err_buf[512];
           strerror_r(result_status->error_code, err_buf, sizeof(err_buf));
           printf("ERROR: %s\n", err_buf);
        }
*/
}
       
void Media_Player::new_stream(const vn_player_stream_info_t *stream_info, void *client_data)
{
//	printf("new_stream\n");
}
        
void Media_Player::stream_removed(const vn_player_stream_info_t *stream_info, void *client_data)
{
//	printf("stream_removed\n");
}

void Media_Player::msg_log(const char *msg, void *client_data)
{
	printf("%s", msg);
}

const unsigned PLYAERS_NUM = 1;
int main(int argc, char* argv[])
{
   for (unsigned k = 0; k < 300; k++)
   {      
      printf("Iteration: %d\n", k);
      Media_Player *player[PLYAERS_NUM];
      for (unsigned i = 0; i < PLYAERS_NUM; i++)
      {
         player[i] = new Media_Player;
         player[i]->play("rtsp://192.168.0.110:8554/xmedia?dev=101&authorizationid=1");
      }
#ifdef WIN32
      Sleep(50000);
#else
      usleep(5000000);
#endif

      for (unsigned i = 0; i < PLYAERS_NUM; i++)
      {             
         delete player[i];
      }
   }



#ifdef WIN32
      Sleep(100000);
#else
      usleep(200000000);
#endif
      
   return 0;

}



