#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "MediaClient.h"
#include "MediaStreamHandler.h"

using namespace videonext;
using namespace videonext::media;

int main(int argc, char *argv[])
{
   if (argc != 5) 
   {
      fprintf(stderr, "Usage: %s masterip port user passwd\n", argv[0]);
      return 1;
   }

   MediaClient *mediaClient = MediaClient::instance();
   ResultStatus result;

   // logging in
   mediaClient->login(&result, argv[1], atol(argv[2]), argv[3], argv[4]);

   if (result.errorCode != 0)
   {
      fprintf(stderr, "Login error: '%s'\n", result.errorString.c_str());
      return 1;
   }

   fprintf(stdout, "Login success\n");


   // getting roles
   std::map<unsigned/*role id*/, Role> roles;
   
   mediaClient->getUserRoles(&result, &roles);

   if (result.errorCode != 0)
   {
      fprintf(stderr, "Error: '%s'\n", result.errorString.c_str());
      return 1;
   }

   std::map<unsigned/*role id*/, Role>::iterator iter     =  roles.begin();
   std::map<unsigned/*role id*/, Role>::iterator iter_end =  roles.end();

   fprintf(stdout, "User Roles: \n");
   for (; iter != iter_end; ++iter)
   {
      fprintf(stdout, "ID: '%d', name: '%s', descr: '%s'\n", iter->first, iter->second.name.c_str(), iter->second.descr.c_str());
   }

   // getting objects
   std::map<unsigned/*obj id*/, MediaObject> objects;
   
   mediaClient->getMediaObjects(&result, &objects);

   if (result.errorCode != 0)
   {
      fprintf(stderr, "Error: '%s'\n", result.errorString.c_str());
      return 1;
   }

   std::map<unsigned/*obj id*/, MediaObject>::iterator iter2     =  objects.begin();
   std::map<unsigned/*obj id*/, MediaObject>::iterator iter2_end =  objects.end();

   fprintf(stdout, "Objects: \n");
   for (; iter2 != iter2_end; ++iter2)
   {
      fprintf(stdout, "ID: '%d', deviceId: '%s', node: '%s', name: '%s', location: '%s', ptzDriver: '%s'\n", 
              iter2->first, 
              iter2->second.params["DEVID"].c_str(),
              iter2->second.params["NODE_IP"].c_str(),
              iter2->second.params["NAME"].c_str(),
              iter2->second.params["LOCATION"].c_str(),
              iter2->second.params["POSITIONCTL"].c_str());
   }


   mediaClient->setUserRole(&result, 11);

   // getting objects sets
   std::map<unsigned/*set id*/, MediaObjectsSet> sets;
   
   mediaClient->getMediaObjectSets(&result, &sets);

   if (result.errorCode != 0)
   {
      fprintf(stderr, "Error: '%s'\n", result.errorString.c_str());
      return 1;
   }

   std::map<unsigned/*set id*/, MediaObjectsSet>::iterator iter3     =  sets.begin();
   std::map<unsigned/*set id*/, MediaObjectsSet>::iterator iter3_end =  sets.end();

   fprintf(stdout, "User Sets: \n");
   for (; iter3 != iter3_end; ++iter3)
   {
      fprintf(stdout, "ID: '%d', name: '%s'", iter3->first, iter3->second.name.c_str());
      std::set<unsigned>::iterator obj = iter3->second.objects.begin();
      fprintf(stdout, "(");
      for (; obj != iter3->second.objects.end(); ++obj)
      {
         fprintf(stdout, "%d ", *obj);
      }
      fprintf(stdout, ")\n");
      
   }


   // getting media URL for some object
   std::string url;
   mediaClient->getMediaURL(&result,
                            &url, 
                            102,
                            0, 
                            0,
                            0,
                            "h264");

   if (result.errorCode != 0)
   {
      fprintf(stderr, "Error: '%s'\n", result.errorString.c_str());
      return 1;
   }

   fprintf(stdout, "\nURL: %s\n", url.c_str());



   // getting last 20 events for today
   std::map<unsigned, Event> events;
   mediaClient->getEvents(&result,
                          &events,
                          0,
                          time(0),
                          20);

   if (result.errorCode != 0)
   {
      fprintf(stderr, "Error: '%s'\n", result.errorString.c_str());
      return 1;
   }

   std::map<unsigned, Event>::reverse_iterator iter4 =  events.rbegin();
   std::map<unsigned, Event>::reverse_iterator iter4_end =  events.rend();

   fprintf(stdout, "Last 20 events: \n");
   for (; iter4 != iter4_end; ++iter4)
   {
      fprintf(stdout, "ID: '%d', ObjID: '%s', WHEN: '%s'\n", 
              iter4->first, 
              iter4->second.params["OBJID"].c_str(),
              iter4->second.params["WHEN"].c_str());
      
   }
 
   // getting server info
   DynaParams info;
   mediaClient->getServerInfo(&result, &info);

   if (result.errorCode != 0)
   {
      fprintf(stderr, "Error: '%s'\n", result.errorString.c_str());
      return 1;
   }

   DynaParams::iterator iter5 =  info.begin();

   fprintf(stdout, "Server info: \n");
   for (; iter5 != info.end(); ++iter5)
   {
      fprintf(stdout, "Param: '%s', Value: '%s'\n", 
              iter5->first.c_str(), 
              iter5->second.c_str());
   }




   delete mediaClient;

   return 0;

}
