#include <stdio.h>
#include <windows.h>
#include "vn_capture.h"

int main()
{
    vn_capture_context_t *ctx = vn_capture_create();
    
    fprintf(stderr, "Audio capture devices:\n");
    char **devices = vn_capture_get_audio_devices(ctx);
    for (char **audio_device = devices; *audio_device != NULL; audio_device++)
    {
        fprintf(stdout, "%s\n", *audio_device);
    }

    fprintf(stderr, "Video capture devices:\n");
    devices = vn_capture_get_video_devices(ctx);
    for (char **video_device = devices; *video_device != NULL; video_device++)
    {
         fprintf(stdout, "%s\n", *video_device);
    }

    //     const char  *filenameSrc = "video=Logitech HD Pro Webcam C920:audio=Микрофон (HD Pro Webcam C920)";


    char **resolutions = vn_capture_get_video_device_parameters(ctx, "Logitech HD Pro Webcam C920");
    for (char **r = resolutions; *r != NULL; r++)
    {
        fprintf(stdout, "Res: %s\n", *r);
    }
    

    vn_capture_start(ctx, "Микрофон (HD Pro Webcam C920)", "Logitech HD Pro Webcam C920",
                     "1280x720/I420/30",
                     "rtsp://10.168.0.105:8554/xmedia?dev=102&authorizationid=1", 1000000);


    while (1)
    {
        Sleep(1000);
    }
    vn_capture_destroy(ctx);
    
}
