BUILD_TARGET=x86_64-darwin-iphonesimulator

include common.mak

ARCH=x86_64
HOST=x86_64-apple-darwin
#IOS_MIN_VERSION=9.0
IOS_MIN_VERSION=$(shell xcrun -sdk iphonesimulator --show-sdk-version)
SDK_PATH=$(shell xcrun -sdk iphonesimulator --show-sdk-path)
CC="$(shell xcrun -f -sdk iphonesimulator clang) -arch $(ARCH) -isysroot $(SDK_PATH) -mios-simulator-version-min=$(IOS_MIN_VERSION) -std=c99 "
CXX="$(shell xcrun -f -sdk iphonesimulator clang++) -arch $(ARCH) -isysroot $(SDK_PATH) -mios-simulator-version-min=$(IOS_MIN_VERSION) -stdlib=libc++ "
CFLAGS+= -pthread -arch $(ARCH)
CXXFLAGS+= $(CFLAGS)
CPP=$(shell xcrun -f -sdk iphonesimulator clang)
CPPFLAGS="-I$(SDK_PATH)/usr/include -L$(SDK_PATH)/usr/lib -L$(SDK_PATH)/usr/lib/system -L$(SDK_PATH)/System/Library/Frameworks "
AS=$(shell xcrun -f -sdk iphonesimulator as)
AR=$(shell xcrun -f -sdk iphonesimulator ar)
RANLIB=$(shell xcrun -f -sdk iphonesimulator ranlib)
LDFLAGS+= -arch $(ARCH)
LD=$(shell xcrun -f -sdk iphonesimulator ld)
