#!/bin/sh

[ -z $BUILD_TARGET ] && echo "Environment \$BUILD_TARGET variable MUST be set" && exit 1

INC_SRC=../../src/core
LIB_SRC=../../lib/$BUILD_TARGET
PREBUILD_SRC=../../3rdparty/prebuild/$BUILD_TARGET

DST=client-sdk
INC_DST=$DST/include/core
LIB_DST=$DST/lib/$BUILD_TARGET
PREBUILD_DST=$DST/3rdparty/prebuild

mkdir -p $INC_DST/include
mkdir -p $INC_DST/impl/ot
cp $INC_SRC/*.h $INC_DST/
cp $INC_SRC/include/*.h $INC_DST/include/
cp $INC_SRC/impl/*.h $INC_DST/impl/
cp $INC_SRC/impl/ot/*.h $INC_DST/impl/ot/

mkdir -p $LIB_DST
cp -r $LIB_SRC/* $LIB_DST/

mkdir -p $PREBUILD_DST
mkdir -p $DST/3rdparty/src # small hack;)
cp -r $PREBUILD_SRC $PREBUILD_DST

TAR_NAME=$DST-$(git log | head -1 | cut -c8-19).$BUILD_TARGET.tar.bz2
tar -cjvf $TAR_NAME $DST/
md5sum $TAR_NAME > $TAR_NAME.md5sum

#rm -rf $DST
