CC=gcc
CXX=g++
LD=ld
CFLAGS=-pipe
CPP=cpp
AS=as
AR=ar
RANLIB=ranlib

SDK_ROOT:=$(shell pwd)/..

PREBUILD_DIR=$(SDK_ROOT)/3rdparty/prebuild/$(BUILD_TARGET)

DEP_LIBS += $(PREBUILD_DIR)/ace/lib/libACE.a $(PREBUILD_DIR)/ace/lib/libACE_SSL.a \
            $(PREBUILD_DIR)/curl/lib/libcurl.a \
            $(PREBUILD_DIR)/openssl/lib/libssl.a $(PREBUILD_DIR)/openssl/lib/libcrypto.a \
            $(PREBUILD_DIR)/ffmpeg/lib/libavformat.a \
            $(PREBUILD_DIR)/ffmpeg/lib/libavcodec.a \
            $(PREBUILD_DIR)/ffmpeg/lib/libswscale.a \
            $(PREBUILD_DIR)/ffmpeg/lib/libavdevice.a \
            $(PREBUILD_DIR)/ffmpeg/lib/libavfilter.a \
            $(PREBUILD_DIR)/ffmpeg/lib/libavutil.a \
            $(PREBUILD_DIR)/ffmpeg/lib/libswresample.a \
            $(PREBUILD_DIR)/live555/lib/libliveMedia.a \
            $(PREBUILD_DIR)/live555/lib/libgroupsock.a \
            $(PREBUILD_DIR)/live555/lib/libBasicUsageEnvironment.a \
            $(PREBUILD_DIR)/live555/lib/libUsageEnvironment.a \
            $(PREBUILD_DIR)/SDL2/lib/libSDL2.a \
            $(PREBUILD_DIR)/libwebsockets/lib/libwebsockets.a

ifneq (,$(wildcard $(PREBUILD_DIR)/x264/lib/libx264.a))
DEP_LIBS += $(PREBUILD_DIR)/x264/lib/libx264.a
endif

ifneq (,$(wildcard $(PREBUILD_DIR)/libxml2/lib/libxml2.a))
DEP_LIBS += $(PREBUILD_DIR)/libxml2/lib/libxml2.a
endif

ifneq (,$(wildcard $(PREBUILD_DIR)/SDL2/lib/libSDL2main.a))
DEP_LIBS += $(PREBUILD_DIR)/SDL2/lib/libSDL2main.a
endif

ifneq (,$(wildcard $(PREBUILD_DIR)/zlib/lib/libz.a))
DEP_LIBS += $(PREBUILD_DIR)/zlib/lib/libz.a
endif

CXXFLAGS += -Wno-deprecated-declarations \
            -I$(SDK_ROOT)/src/include -I$(SDK_ROOT)/src/impl -I$(SDK_ROOT)/src/impl/ot -I$(SDK_ROOT)/src \
			-I${PREBUILD_DIR} \
			-I$(PREBUILD_DIR)/ffmpeg/include \
            -I$(PREBUILD_DIR)/live555/include/liveMedia -I$(PREBUILD_DIR)/live555/include/UsageEnvironment \
            -I$(PREBUILD_DIR)/live555/include/groupsock -I$(PREBUILD_DIR)/live555/include/BasicUsageEnvironment \
            -I$(PREBUILD_DIR)/ace/include -I$(PREBUILD_DIR)/curl/include -I$(PREBUILD_DIR)/curl/include -I$(PREBUILD_DIR)/openssl/include \
			-I$(PREBUILD_DIR)/SDL2/include \
            -I$(PREBUILD_DIR)/libxml2/include -I/usr/include/libxml2 \
			-I$(PREBUILD_DIR)/libwebsockets/include

sdk:
	export CC=$(CC) 		&&\
	export CXX=$(CXX) 		&&\
	export CFLAGS="$(CFLAGS)"	&&\
	export CXXFLAGS="$(CXXFLAGS)" 	&&\
	export CPP=$(CPP) 		&&\
	export CPPFLAGS=$(CPPFLAGS) 	&&\
	export AS=$(AS) 		&&\
	export AR=$(AR) 		&&\
	export RANLIB=$(RANLIB) 	&&\
	export LDFLAGS="$(LDFLAGS)"	&&\
	export LD=$(LD)                 &&\
	export WINDRES=$(WINDRES)       &&\
	export STRIP=$(STRIP)           &&\
	export BUILD_TARGET=$(BUILD_TARGET) &&\
        export DEP_LIBS="$(DEP_LIBS)" &&\
	cd ../src/core && make all

examples:
	export CC=$(CC)                 &&\
        export CXX=$(CXX)               &&\
        export CFLAGS="$(CFLAGS)"       &&\
        export CXXFLAGS="$(CXXFLAGS)"   &&\
        export CPP=$(CPP)               &&\
        export CPPFLAGS=$(CPPFLAGS)     &&\
        export AS=$(AS)                 &&\
        export AR=$(AR)                 &&\
        export RANLIB=$(RANLIB)         &&\
        export LDFLAGS="$(LDFLAGS)"     &&\
        export LD=$(LD)                 &&\
	export WINDRES=$(WINDRES)       &&\
        export DEP_LIBS="$(DEP_LIBS)"   &&\
	export BUILD_TARGET=$(BUILD_TARGET) &&\
	export DEP_LIBS="$(DEP_LIBS)"     &&\
        cd ../examples && make all

tests:
	export CC=$(CC)                 &&\
        export CXX=$(CXX)               &&\
        export CFLAGS="$(CFLAGS)"       &&\
        export CXXFLAGS="$(CXXFLAGS)"   &&\
        export CPP=$(CPP)               &&\
        export CPPFLAGS=$(CPPFLAGS)     &&\
        export AS=$(AS)                 &&\
        export AR=$(AR)                 &&\
        export RANLIB=$(RANLIB)         &&\
        export LDFLAGS="$(LDFLAGS)"     &&\
        export LD=$(LD)                 &&\
	export WINDRES=$(WINDRES)       &&\
        export BUILD_TARGET=$(BUILD_TARGET) &&\
	export DEP_LIBS="$(DEP_LIBS)"     &&\
        cd ../tests && make all

clean:
	export CC=$(CC) 		&&\
	export CXX=$(CXX) 		&&\
	export CFLAGS="$(CFLAGS)"	&&\
	export CXXFLAGS="$(CFLAGS)" 	&&\
	export CPP=$(CPP) 		&&\
	export CPPFLAGS=$(CPPFLAGS) 	&&\
	export AS=$(AS) 		&&\
	export AR=$(AR) 		&&\
	export RANLIB=$(RANLIB) 	&&\
	export LDFLAGS="$(LDFLAGS)"	&&\
	export LD=$(LD)                 &&\
	export STRIP=$(STRIP)           &&\
	export WINDRES=$(WINDRES)       &&\
	export BUILD_TARGET=$(BUILD_TARGET) &&\
	cd ../src/core && make clean ;\
	cd ../../examples && make clean
