BUILD_TARGET=arm64-darwin-iphoneos

include common.mak

ARCH=arm64
HOST=arm-apple-darwin
IOS_MIN_VERSION=9.0
IOS_VERSION=$(shell xcrun -sdk iphoneos --show-sdk-version)
SDK_PATH=$(shell xcrun -sdk iphoneos --show-sdk-path)
CC="$(shell xcrun -f -sdk iphoneos clang) -arch $(ARCH) -isysroot $(SDK_PATH) -miphoneos-version-min=$(IOS_MIN_VERSION) "
CXX="$(shell xcrun -f -sdk iphoneos clang++) -arch $(ARCH) -isysroot $(SDK_PATH) -miphoneos-version-min=$(IOS_MIN_VERSION) -stdlib=libc++ "
CFLAGS+= -pthread -arch $(ARCH) -fembed-bitcode-marker -fembed-bitcode
CXXFLAGS+= $(CFLAGS)
CPP=$(shell xcrun -f -sdk iphoneos cpp)
CPPFLAGS="-I$(SDK_PATH)/usr/include -L$(SDK_PATH)/usr/lib -L$(SDK_PATH)/usr/lib/system -L$(SDK_PATH)/System/Library/Frameworks "
#AS="scripts/gas-preprocessor.pl $(shell xcrun -f -sdk iphoneos clang)"
AR=$(shell xcrun -f -sdk iphoneos ar)
RANLIB=$(shell xcrun -f -sdk iphoneos ranlib)
LDFLAGS+= -arch $(ARCH)
LD=$(shell xcrun -f -sdk iphoneos ld)
