BUILD_TARGET=arm64-android

# hack
-include common.mak

ifndef ANDROID_NDK
 $(error Please set ANDROID_NDK (>=r16) environment variable)
endif

export ANDROID_API=21

UNAME := $(shell uname -s)
ifeq ($(UNAME), Darwin)
	export ANDROID_TOOLCHAIN=$(ANDROID_NDK)/toolchains/aarch64-linux-android-4.9/prebuilt/darwin-x86_64
else
	export ANDROID_TOOLCHAIN=$(ANDROID_NDK)/toolchains/aarch64-linux-android-4.9/prebuilt/linux-x86_64
endif

export PATH := $(ANDROID_TOOLCHAIN)/bin:$(PATH)

TARGET_HOST=aarch64-linux-android
export AR=$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-ar
export AS=$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-gcc
export CC=$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-gcc
export CXX=$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-g++
export CPP="$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-gcc -E"
export CXXCPP="$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-g++ -E"
export LD=$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-ld
export STRIP=$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-strip
export RANLIB=$(ANDROID_TOOLCHAIN)/bin/$(TARGET_HOST)-ranlib

CFLAGS+=-fPIC -D__ANDROID_API__=$(ANDROID_API) -DANDROID \
        -DACE_HAS_CUSTOM_EXPORT_MACROS=0 -D__ACE_INLINE__ -DACE_AS_STATIC_LIBS -DACE_LACKS_LINUX_NPTL -D_REENTRANT -D_GNU_SOURCE \
        -isysroot $(ANDROID_NDK)/sysroot -isystem $(ANDROID_NDK)/sysroot/usr/include/$(TARGET_HOST)
CXXFLAGS+=$(CFLAGS) -funwind-tables \
        -isystem $(ANDROID_NDK)/sources/cxx-stl/gnu-libstdc++/4.9/include/backward \
        -isystem $(ANDROID_NDK)/sources/cxx-stl/gnu-libstdc++/4.9/include \
        -isystem $(ANDROID_NDK)/sources/cxx-stl/gnu-libstdc++/4.9/libs/arm64-v8a/include
#CPPFLAGS+=-D__ANDROID_API__=$(ANDROID_API) -DANDROID -DACE_HAS_CUSTOM_EXPORT_MACROS=0 -D__ACE_INLINE__ -DACE_AS_STATIC_LIBS -DACE_LACKS_LINUX_NPTL -D_REENTRANT -D_GNU_SOURCE
LDFLAGS=--sysroot=$(ANDROID_NDK)/platforms/android-$(ANDROID_API)/arch-arm64

HOST=arm64-linux
