# Media client SDK
The set of components for creating applications which allow to do all API operations, audio/video playback, local media capturing  etc..

## Supported platform/architectures

- Linux x86/arm
- Windows x86
- Mac OS x86/arm
- Android x86/arm
- iOS x86/arm

## Building 3rd party components
```shell
cd 3rdparty/src
./build.sh [arch-platform]
```

To list all supported values just run **./build.sh** without parameters

## Building SDK
```shell
cd build
make -f [arch-platform].mak
```

## Installing cygwnin's dependencies (thanks to Andrey S.)
Download cygwin setup from https://cygwin.com/install.html

Silent install with next command:
```
setup-x86_64.exe -a x86_64 -q -R d:\etc\cygwin64 -P "_autorebase,alternatives,autoconf,autoconf2.1,autoconf2.5,autogen,automake,automake1.10,automake1.11,automake1.12,automake1.13,automake1.14,automake1.15,automake1.16,automake1.9,base-cygwin,base-files,bash,binutils,bison,byacc,bzip2,ca-certificates,cmake,cocom,compiler-rt,coreutils,crypto-policies,csih,curl,cygrunsrv,cygutils,cygwin,cygwin-devel,dash,dejagnu,desktop-file-utils,diffutils,doxygen,editrights,expect,file,findutils,flex,gamin,gawk,gcc-core,gcc-g++,gdb,getent,gettext,gettext-devel,git,grep,groff,gsettings-desktop-schemas,gzip,hostname,inetutils,info,ipc-utils,less,libarchive13,libargp,libatomic1,libattr1,libblkid1,libboost-devel,libboost_atomic1.66,libboost_chrono1.66,libboost_container1.66,libboost_context1.66,libboost_coroutine1.66,libboost_date_time1.66,libboost_filesystem1.66,libboost_graph1.66,libboost_iostreams1.66,libboost_locale1.66,libboost_log1.66,libboost_math1.66,libboost_program_options1.66,libboost_random1.66,libboost_regex1.66,libboost_serialization1.66,libboost_signals1.66,libboost_stacktrace1.66,libboost_system1.66,libboost_test1.66,libboost_thread1.66,libboost_timer1.66,libboost_type_erasure1.66,libboost_wave1.66,libbrotlicommon1,libbrotlidec1,libbz2_1,libc++-devel,libc++1,libc++abi-devel,libc++abi1,libcharset1,libclang8,libcom_err2,libcroco0.6_3,libcrypt-devel,libcrypt0,libcrypt2,libcurl4,libdb5.3,libedit-devel,libedit0,libexpat1,libext2fs2,libfam0,libfdisk1,libffi6,libfreetype6,libgc1,libgcc1,libgdbm4,libgdbm6,libgdbm_compat4,libglib2.0_0,libgmp10,libgnutls30,libgomp1,libgssapi_krb5_2,libguile2.0_22,libguile2.2_1,libhogweed4,libiconv,libiconv-devel,libiconv2,libicu-devel,libicu61,libicu65,libidn2_0,libimagequant0,libintl-devel,libintl8,libisl15,libjbig2,libjpeg8,libjsoncpp19,libk5crypto3,libkrb5_3,libkrb5support0,liblcms2_2,libllvm-devel,libllvm8,libltdl7,liblz4_1,liblzma-devel,liblzma5,libmetalink3,libmpc3,libmpfr6,libncurses++w10,libncurses-devel,libncursesw10,libnettle6,libnghttp2_14,libnsl2,libopenjp2_7,libopenldap2_4_2,libopts25,libp11-kit0,libpcre1,libpipeline1,libpkgconf3,libpng16,libpolly-devel,libpolly8,libpopt-common,libpopt0,libpsl5,libquadmath0,libreadline7,librhash0,libsasl2_3,libsigsegv2,libslang2,libsmartcols1,libsqlite3-devel,libsqlite3_0,libssh-common,libssh2_1,libssh4,libssl1.0,libssl1.1,libstdc++6,libtasn1_6,libtiff6,libtirpc-common,libtirpc3,libunistring2,libunwind-devel,libunwind1,libuuid-devel,libuuid1,libuv1,libwebp7,libwebpdemux2,libwebpmux3,libxapian30,libxml2,libxml2-devel,libyaml0_2,llvm,login,m4,make,man-db,mc,mingw64-x86_64-binutils,mingw64-x86_64-gcc-core,mingw64-x86_64-gcc-g++,mingw64-x86_64-headers,mingw64-x86_64-runtime,mingw64-x86_64-windows-default-manifest,mingw64-x86_64-winpthreads,mingw64-x86_64-zlib,mintty,nasm,ncurses,openssh,openssl,p11-kit,p11-kit-trust,patch,perl,perl-Error,perl-Scalar-List-Utils,perl-TermReadKey,perl-Test-Harness,perl-TimeDate,perl-Unicode-Normalize,perl_autorebase,perl_base,pkg-config,pkgconf,publicsuffix-list-dafsa,python-pip-wheel,python-setuptools-wheel,python2,python27,python27-cffi,python27-chardet,python27-imaging,python27-olefile,python27-ply,python27-pycparser,python27-pygments,python27-yaml,python3,python36,rebase,rsync,run,sed,shared-mime-info,sqlite3,sqlite3-vfslog,tar,tcl,terminfo,terminfo-extra,texinfo,tzcode,tzdata,unzip,util-linux,vim,vim-common,vim-minimal,w32api-headers,w32api-runtime,wget,which,windows-default-manifest,xxd,xz,yasm,zip,zlib-devel,zlib0"
```

## Receive media url

### Login
Login will return session PHPSESSID cookie, it should be added or every next request
$endpoint - ip\dns of cluster
```text
Request
POST https://$endpoint/api/call/login
{"name":"user","password":"password"}

Response
{
    "status": "LoggedIn",
    "error": "",
    "code": 200
}
```

Example
```shell
curl -i 'https://go.cavu.me/api/call/login' -X POST -H 'content-type: application/json; charset=utf-8' --data-raw '{"name":"user","password":"password"}'
HTTP/2 200
content-type: application/json; charset=utf-8
set-cookie: PHPSESSID=e8accbc02adad31749d0b5935f5b2f48aad7dcf43a38c0b307593fd7abd2a228; path=/

{
    "status": "LoggedIn",
    "error": "",
    "code": 200
}
```

### Get list of cameras
```text
Request
POST https://$endpoint/api/graphql/
{"operationName":"cameras","variables":{"types":[{"type":"MEDIA"}]},"query":"query cameras($types: [DeviceFunctionalAspectFilter!]!) {\n  devicesByAspectTypes(types: $types) {\n    id\n    name\n    healthStatus\n  }\n}\n"}

Response
{
    "data":{
        "devicesByAspectTypes":[
            {"id":"e2502d02-22f5-11ed-9175-00155dd9270b","name":"!nano-window:h264","healthStatus":"NORMAL"}
        ]
    }
}
```
Example
```shell
curl 'https://go.cavu.me/api/graphql/' -X POST -H 'content-type: application/json' -H 'Cookie: PHPSESSID=36a304dc3cc6d1b407319338d0cf425ab9d5ed5eb7e8d675fd14d9107ff2858f' --data-raw '{"operationName":"cameras","variables":{"types":[{"type":"MEDIA"}]},"query":"query cameras($types: [DeviceFunctionalAspectFilter!]!) {\n  devicesByAspectTypes(types: $types) {\n    id\n    name\n    healthStatus\n  }\n}\n"}'
{"data":{"devicesByAspectTypes":[{"id":"e2502d02-22f5-11ed-9175-00155dd9270b","name":"!nano-window:h264","healthStatus":"NORMAL"},{"id":"75b2335a-5db3-11ec-9173-00155dd9270b","name":"!mini-window:h264","healthStatus":"BROKEN"},{"id":"a87485b8-1632-11ec-9173-00155dd9270b","name":"aspect-test","healthStatus":"OFF"}]}}
```

### Get camera Media URL
```text
Request
$cameraid - cameraid
$isLocal - true|false, specify true if request should return local avatar address, false - external address to connect
GET https://$endpoint/api/call/getMobileMediaURL?cameraid=$cameraid&isLocal=$isLocal

Response
{
    "url": "wss:\/\/172-16-3-225.dev1.videonext.net:30681\/?objid=e2502d02-22f5-11ed-9175-00155dd9270b&streamnum=1&ticket=I0edWN0wza9go9piTXETrWpu1Xk8pVyEFsjlFIjfBIv9BdBeHO2LUstVPnXyYOp%2BIN4kJcKe0B5KUSe1CBlieys3hFMMnfOAZQiN%2BZgawhhOMi2eXoW%2FWyQuI0vXOM4IEioj%2FV%2B0%2FfI4Vi78NYNbYCmTV%2FEhNkOpBOuG71nm%2BQ%3D%3D&cloud=1",
    "error": "",
    "code": 200
}
```

Example
```shell
curl 'https://dev1.videonext.net/api/call/getMobileMediaURL?cameraid=e2502d02-22f5-11ed-9175-00155dd9270b&isLocal=false' -X GET -H 'content-type: application/json' -H 'Cookie: PHPSESSID=36a304dc3cc6d1b407319338d0cf425ab9d5ed
5eb7e8d675fd14d9107ff2858f'
{
    "url": "wss:\/\/172-16-3-225.dev1.videonext.net:30681\/?objid=e2502d02-22f5-11ed-9175-00155dd9270b&streamnum=1&ticket=I0edWN0wza9go9piTXETrWpu1Xk8pVyEFsjlFIjfBIv9BdBeHO2LUstVPnXyYOp%2BIN4kJcKe0B5KUSe1CBlieys3hFMMnfOAZQiN%2BZgawhhOMi2eXoW%2FWyQuI0vXOM4IEioj%2FV%2B0%2FfI4Vi78NYNbYCmTV%2FEhNkOpBOuG71nm%2BQ%3D%3D&cloud=1",
    "error": "",
    "code": 200
}
```
