/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer.internal;

import com.videonext.mplayer.internal.Drawable;
import com.videonext.mplayer.internal.MediaPlayerListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;

class ZoomControl
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final float imageZoomFactorDX = 0.05f;
    private Rectangle imageRect = new Rectangle(0, 0, 1, 1);
    private Point currentMousePos = new Point(0, 0);
    private Point lastDraggedMousePos = new Point(0, 0);
    private Point mouseInLittleRectClickPos = new Point(0, 0);
    private boolean isMouseLeftButtonPressed = false;
    private float minImageZoomFactor = 0.1f;
    private final float maxImageZoomFactor = 2.0f;
    private Rectangle smallRect = new Rectangle(0, 0, 1, 1);
    private Rectangle littleRect = new Rectangle(0, 0, 1, 1);
    private float imageZoomFactor = 1.5f;
    private Rectangle closeButtonRect = new Rectangle(0, 0, 12, 12);
    private boolean isZoom = false;
    private MediaPlayerListener listener;
    private Component canvas;
    private Rectangle screenRect;
    private BufferedImage im;
    private float pixelAspectRatio = 0.0f;

    ZoomControl() {
    }

    public void setMediaPlayerListener(MediaPlayerListener listener) {
        this.listener = listener;
    }

    public void setScreenRect(Rectangle screenRect) {
        this.screenRect = screenRect;
    }

    public void setCanvas(Component canvas) {
        this.canvas = canvas;
    }

    public void setIm(BufferedImage im) {
        this.im = im;
    }

    public void setPixelAspectRatio(float pixelAspectRatio) {
        this.pixelAspectRatio = pixelAspectRatio;
    }

    public Rectangle getSmallRect() {
        return this.smallRect;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.currentMousePos.setLocation(e.getX(), e.getY());
        if (!this.littleRect.contains(this.currentMousePos) && !this.closeButtonRect.contains(this.currentMousePos)) {
            this.listener.mouseClicked(e, true);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.currentMousePos.setLocation(e.getX(), e.getY());
        if (e.getButton() == 1) {
            if (this.littleRect.contains(this.currentMousePos)) {
                this.isMouseLeftButtonPressed = true;
                this.mouseInLittleRectClickPos.setLocation(this.currentMousePos.x - this.littleRect.x, this.currentMousePos.y - this.littleRect.y);
                this.calculateZoomRectangles();
            }
            if (this.closeButtonRect.contains(this.currentMousePos)) {
                this.isZoom = false;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.isMouseLeftButtonPressed = false;
            this.canvas.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.canvas.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.canvas.repaint();
        this.listener.mouseExit(e, true);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.currentMousePos.setLocation(e.getX(), e.getY());
        if (this.isZoom && this.isMouseLeftButtonPressed) {
            this.lastDraggedMousePos.setLocation(this.currentMousePos);
            this.calculateZoomRectangles();
            this.canvas.repaint();
            this.canvas.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.currentMousePos.setLocation(e.getX(), e.getY());
        int cursorType = 0;
        if (this.isZoom) {
            if (this.littleRect.contains(this.currentMousePos)) {
                cursorType = 13;
            }
            if (this.closeButtonRect.contains(this.currentMousePos)) {
                cursorType = 12;
            }
        }
        this.canvas.setCursor(Cursor.getPredefinedCursor(cursorType));
        this.listener.mouseMoved(e, true);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.calculateZoomRectangles();
        int rotation = e.getWheelRotation();
        if (rotation < 0) {
            this.calculateImageZoomFactor(0.05f);
        } else if (rotation > 0) {
            this.calculateImageZoomFactor(-0.05f);
        }
        this.calculateImageRectSize();
        this.canvas.repaint();
    }

    public boolean isZoomed() {
        return this.isZoom;
    }

    public float getImageZoomFactor() {
        return this.imageZoomFactor;
    }

    public Rectangle getPartRect() {
        float xFactor = 1.0f;
        float yFactor = 1.0f;
        if ((double)this.pixelAspectRatio > 1.0) {
            xFactor = this.pixelAspectRatio;
        } else if (this.pixelAspectRatio < 1.0f && this.pixelAspectRatio != 0.0f) {
            yFactor = 1.0f / this.pixelAspectRatio;
        }
        return new Rectangle((int)(xFactor * (float)(-this.imageRect.x) / this.imageZoomFactor), (int)(yFactor * (float)(-this.imageRect.y) / this.imageZoomFactor), (int)(xFactor * (float)(-this.imageRect.x + this.screenRect.width) / this.imageZoomFactor), (int)(yFactor * (float)(-this.imageRect.y + this.screenRect.height) / this.imageZoomFactor));
    }

    public Boolean paint(Graphics g, Drawable zoomControlDraw) {
        Boolean wasDraw = false;
        if (this.imageRect.width != this.screenRect.width || this.imageRect.height != this.screenRect.height) {
            wasDraw = true;
            g.drawImage(this.im, this.smallRect.x - this.screenRect.x, this.smallRect.y - this.screenRect.y, this.smallRect.width, this.smallRect.height, null);
            if (zoomControlDraw != null) {
                zoomControlDraw.draw(g, new Rectangle(this.smallRect.x - this.screenRect.x, this.smallRect.y - this.screenRect.y, this.smallRect.width, this.smallRect.height));
            }
            Color color = new Color(100, 100, 100, 200);
            g.setColor(color);
            g.fillRect(this.smallRect.x - this.screenRect.x, this.smallRect.y - this.screenRect.y, this.smallRect.width, this.littleRect.y - this.smallRect.y);
            g.fillRect(this.littleRect.x + this.littleRect.width - this.screenRect.x, this.smallRect.y - this.screenRect.y, this.smallRect.x + this.smallRect.width - (this.littleRect.x + this.littleRect.width), this.smallRect.height);
            g.fillRect(this.smallRect.x - this.screenRect.x, this.littleRect.y + this.littleRect.height - this.screenRect.y, this.smallRect.width, this.smallRect.y + this.smallRect.height - (this.littleRect.y + this.littleRect.height));
            g.fillRect(this.smallRect.x - this.screenRect.x, this.smallRect.y - this.screenRect.y, this.littleRect.x - this.smallRect.x, this.smallRect.height);
            g.setColor(Color.GREEN);
            g.drawRect(this.smallRect.x - this.screenRect.x, this.smallRect.y - this.screenRect.y, this.smallRect.width, this.smallRect.height);
            g.drawRect(this.closeButtonRect.x - this.screenRect.x, this.closeButtonRect.y - this.screenRect.y, this.closeButtonRect.width, this.closeButtonRect.height);
            g.drawLine(this.closeButtonRect.x - this.screenRect.x, this.closeButtonRect.y - this.screenRect.y, this.closeButtonRect.x - this.screenRect.x + this.closeButtonRect.width, this.closeButtonRect.y - this.screenRect.y + this.closeButtonRect.height);
            g.drawLine(this.closeButtonRect.x - this.screenRect.x, this.closeButtonRect.y - this.screenRect.y + this.closeButtonRect.height, this.closeButtonRect.x - this.screenRect.x + this.closeButtonRect.width, this.closeButtonRect.y - this.screenRect.y);
            g.drawRect(this.littleRect.x - this.screenRect.x, this.littleRect.y - this.screenRect.y, this.littleRect.width, this.littleRect.height);
        }
        return wasDraw;
    }

    public void calculateImageRectSize() {
        if (this.im == null) {
            System.out.println("im is null");
            return;
        }
        this.calculateZoomRectangles();
        this.calculateImageZoomFactor(0.0f);
        Rectangle newImageRect = new Rectangle();
        newImageRect.width = (int)((float)this.im.getWidth() * this.imageZoomFactor);
        newImageRect.height = (int)((float)this.im.getHeight() * this.imageZoomFactor);
        if ((double)this.pixelAspectRatio > 1.0) {
            newImageRect.width = (int)((float)newImageRect.width / this.pixelAspectRatio);
        } else if (this.pixelAspectRatio < 1.0f && this.pixelAspectRatio != 0.0f) {
            newImageRect.height = (int)((float)newImageRect.height * this.pixelAspectRatio);
        }
        this.imageRect.width = newImageRect.width;
        this.imageRect.height = newImageRect.height;
        this.calculateZoomRectangles();
    }

    private void calculateImageZoomFactor(float factorDX) {
        if (this.im == null) {
            System.out.println("im is null");
            return;
        }
        this.minImageZoomFactor = (float)this.screenRect.height / (float)this.im.getHeight();
        float newImageZoomFactor = this.imageZoomFactor;
        boolean newIsZoom = this.isZoom;
        if (!this.isZoom) {
            newIsZoom = true;
            newImageZoomFactor = this.minImageZoomFactor;
        }
        if (this.minImageZoomFactor < 2.0f) {
            if ((newImageZoomFactor += factorDX) > 2.0f) {
                newImageZoomFactor = 2.0f;
            } else if (newImageZoomFactor < this.minImageZoomFactor + 0.01f) {
                newImageZoomFactor = this.minImageZoomFactor;
                newIsZoom = false;
            }
            this.imageZoomFactor = newImageZoomFactor;
            this.isZoom = newIsZoom;
        } else {
            this.isZoom = false;
        }
    }

    private void calculateZoomRectangles() {
        this.smallRect.width = this.screenRect.width / 3;
        this.smallRect.height = this.screenRect.height / 3;
        this.smallRect.x = this.screenRect.x + this.screenRect.width - this.smallRect.width - 3;
        this.smallRect.y = this.screenRect.y + this.screenRect.height - this.smallRect.height - 3;
        this.closeButtonRect.x = this.smallRect.x + this.smallRect.width - this.closeButtonRect.width;
        this.closeButtonRect.y = this.smallRect.y - this.closeButtonRect.height;
        if (this.smallRect.width != 0 && this.smallRect.height != 0) {
            Point newImagePos = new Point();
            newImagePos.x = -(this.lastDraggedMousePos.x - this.mouseInLittleRectClickPos.x - this.smallRect.x) * this.imageRect.width / this.smallRect.width;
            newImagePos.y = -(this.lastDraggedMousePos.y - this.mouseInLittleRectClickPos.y - this.smallRect.y) * this.imageRect.width / this.smallRect.width;
            if (newImagePos.x > 0) {
                newImagePos.x = 0;
            } else if (newImagePos.x + this.imageRect.width < this.screenRect.width) {
                newImagePos.x = this.screenRect.width - this.imageRect.width;
            }
            if (newImagePos.y > 0) {
                newImagePos.y = 0;
            } else if (newImagePos.y + this.imageRect.height < this.screenRect.height) {
                newImagePos.y = this.screenRect.height - this.imageRect.height;
            }
            this.imageRect.x = newImagePos.x;
            this.imageRect.y = newImagePos.y;
            this.littleRect.x = this.smallRect.x - this.imageRect.x * this.smallRect.width / this.imageRect.width;
            this.littleRect.y = this.smallRect.y - this.imageRect.y * this.smallRect.width / this.imageRect.width;
            this.littleRect.width = this.screenRect.width * this.smallRect.width / this.imageRect.width;
            this.littleRect.height = this.screenRect.width * this.smallRect.height / this.imageRect.width;
        }
    }
}

