/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer.internal;

import com.videonext.mplayer.internal.MediaPlayer;
import com.videonext.mplayer.internal.MediaPlayerListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SwingMediaPlayer
extends JPanel {
    private static final long serialVersionUID = -659563983522171343L;
    MediaPlayer mediaPlayer;
    MediaPlayerListener playerListener;
    JPanel panel;
    JButton btnPlay;
    JButton btnStop;
    JButton btnPause;
    JFrame parent;
    String url;
    JFrame fullscreenFrame;
    Rectangle restoredBounds;
    static GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];

    public SwingMediaPlayer(String url, MediaPlayerListener playerListener) throws Exception {
        this.url = url;
        this.mediaPlayer = new MediaPlayer("");
        this.initialize();
        this.mediaPlayer.setMediaPlayerListener(playerListener);
        this.mediaPlayer.setCacheSize(10000000);
        this.mediaPlayer.setBackground(Color.BLACK);
        this.mediaPlayer.setParameter("videoURL", url);
        this.mediaPlayer.sendCommand("play");
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    private void initialize() throws Exception {
        this.setBounds(100, 100, 694, 437);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mediaPlayer, "Center");
        this.panel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel.getLayout();
        flowLayout.setAlignment(0);
        this.add((Component)this.panel, "South");
        this.btnPlay = new JButton("Play");
        this.btnPlay.setEnabled(false);
        this.btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!SwingMediaPlayer.this.btnStop.isEnabled()) {
                    SwingMediaPlayer.this.mediaPlayer.setParameter("videoURL", SwingMediaPlayer.this.url);
                }
                SwingMediaPlayer.this.mediaPlayer.sendCommand("play");
                SwingMediaPlayer.this.btnPlay.setEnabled(false);
                SwingMediaPlayer.this.btnPause.setEnabled(true);
                SwingMediaPlayer.this.btnStop.setEnabled(true);
            }
        });
        this.panel.add(this.btnPlay);
        this.btnStop = new JButton("Stop");
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingMediaPlayer.this.mediaPlayer.sendCommand("stop");
                SwingMediaPlayer.this.btnPlay.setEnabled(true);
                SwingMediaPlayer.this.btnPause.setEnabled(false);
                SwingMediaPlayer.this.btnStop.setEnabled(false);
            }
        });
        this.btnPause = new JButton("Pause");
        this.btnPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingMediaPlayer.this.mediaPlayer.sendCommand("pause");
                SwingMediaPlayer.this.btnPlay.setEnabled(true);
                SwingMediaPlayer.this.btnPause.setEnabled(false);
            }
        });
        this.panel.add(this.btnPause);
        this.panel.add(this.btnStop);
        JButton fullscreenButton = new JButton("FullScr");
        fullscreenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingMediaPlayer.this.fullscreenFrame == null) {
                    SwingMediaPlayer.this.fullscreenFrame = new JFrame();
                    SwingMediaPlayer.this.parent = (JFrame)SwingUtilities.getWindowAncestor(SwingMediaPlayer.this);
                    SwingMediaPlayer.this.restoredBounds = SwingMediaPlayer.this.parent.getBounds();
                    --SwingMediaPlayer.this.restoredBounds.height;
                    SwingMediaPlayer.this.parent.setBounds(SwingMediaPlayer.this.restoredBounds);
                    SwingMediaPlayer.this.fullscreenFrame.setDefaultCloseOperation(3);
                    SwingMediaPlayer.this.fullscreenFrame.setExtendedState(6);
                    SwingMediaPlayer.this.fullscreenFrame.setUndecorated(true);
                    SwingMediaPlayer.this.fullscreenFrame.getContentPane().add((Component)SwingMediaPlayer.this, "Center");
                    SwingMediaPlayer.this.fullscreenFrame.setResizable(false);
                    SwingMediaPlayer.this.fullscreenFrame.setAlwaysOnTop(false);
                    device.setFullScreenWindow(SwingMediaPlayer.this.fullscreenFrame);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    SwingMediaPlayer.this.fullscreenFrame.setBounds(0, 0, screenSize.width, screenSize.height);
                    SwingMediaPlayer.this.fullscreenFrame.pack();
                    SwingMediaPlayer.this.fullscreenFrame.repaint();
                } else {
                    SwingMediaPlayer.this.parent.getContentPane().add((Component)SwingMediaPlayer.this, "Center");
                    SwingMediaPlayer.this.parent.setBounds(SwingMediaPlayer.this.restoredBounds);
                    SwingMediaPlayer.this.parent.pack();
                    SwingMediaPlayer.this.parent.repaint();
                    SwingMediaPlayer.this.fullscreenFrame.setVisible(false);
                    SwingMediaPlayer.this.fullscreenFrame.dispose();
                    device.setFullScreenWindow(null);
                    SwingMediaPlayer.this.fullscreenFrame = null;
                    ++SwingMediaPlayer.this.restoredBounds.height;
                    SwingMediaPlayer.this.parent.setBounds(SwingMediaPlayer.this.restoredBounds);
                    SwingMediaPlayer.this.parent.repaint();
                }
            }
        });
        this.panel.add(fullscreenButton);
    }
}

