/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer.internal;

import com.videonext.mplayer.internal.MediaPlayer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class NativeHelper {
    public static String getPlayerVersion() {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    Manifest manifest;
                    Attributes mainAttribs;
                    String version;
                    URL url = resEnum.nextElement();
                    InputStream is = url.openStream();
                    if (is == null || (version = (mainAttribs = (manifest = new Manifest(is)).getMainAttributes()).getValue("Bundle-Version")) == null) continue;
                    return version;
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static void copyFile(File in, File out) throws Exception {
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destinationChannel = null;
        try {
            sourceChannel = new FileInputStream(in).getChannel();
            destinationChannel = new FileOutputStream(out).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), (WritableByteChannel)((Object)destinationChannel));
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destinationChannel != null) {
                destinationChannel.close();
            }
        }
    }

    private static long getPlayerLibSize(String libName) {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources(libName);
            if (resEnum.hasMoreElements()) {
                URLConnection conn = resEnum.nextElement().openConnection();
                return conn.getContentLength();
            }
        }
        catch (IOException iOException) {}
        return 0L;
    }

    public static void loadFromJar(String version, String name) throws Exception {
        String outFileName = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + name + "." + version;
        System.out.println("loadFromJar: " + outFileName);
        File f = new File(outFileName);
        if (f.length() > 0L && f.length() == NativeHelper.getPlayerLibSize("jni-lib/" + name)) {
            System.out.println("loadFromJar: skipping");
            System.load(outFileName);
            return;
        }
        InputStream in = MediaPlayer.class.getResourceAsStream("/jni-lib/" + name);
        FileOutputStream out = null;
        try {
            int readBytes;
            byte[] buffer = new byte[65536];
            out = new FileOutputStream(new File(outFileName));
            while ((readBytes = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, readBytes);
            }
        }
        catch (Exception e) {
            System.err.println("Could not copy jni library: " + e.toString());
        }
        in.close();
        if (out != null) {
            ((OutputStream)out).close();
        }
        System.out.println("Load native library: " + outFileName);
        System.load(outFileName);
    }
}

