/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer.internal;

import com.videonext.mplayer.internal.Drawable;
import com.videonext.mplayer.internal.LogFormatter;
import com.videonext.mplayer.internal.MediaPlayerListener;
import com.videonext.mplayer.internal.NativeHelper;
import com.videonext.mplayer.internal.ZoomControl;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JPanel;

public class MediaPlayer
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 6546613028913051662L;
    public static final int DEFAULT_MAX_HARDWARE_FRAME_RATE = 120;
    public static final int STATUS_INITIALIZED = -1;
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_PLAY_SERVER = 1;
    public static final int STATUS_PLAY_BUFFER = 2;
    public static final int STATUS_STOPPED = 3;
    public static final int STATUS_OPENING = 4;
    public static final int STATUS_BUFFERING = 5;
    public static final int STATUS_OPENED = 6;
    public static final int SIGN_NONE = 0;
    public static final int SIGN_RED_CROSS = 1;
    private Logger log;
    private String playerId;
    private boolean isWorking = false;
    private ObjectsTracker objsTracker = null;
    private int width = 0;
    private int height = 0;
    private boolean displayBusy = false;
    private BufferedImage im = null;
    private BufferedImage backBufferImage = null;
    private Rectangle screenRect = new Rectangle(0, 0, 1, 1);
    private int streamOverTCP = 1;
    private int streamOverHTTP = 0;
    private int maxHWFrameRate = 120;
    private int cacheSize = 0;
    private int jitterBuffer = 0;
    private int useHWDecoder = 0;
    private String videoURL = null;
    private long mpVideoID = 0L;
    private VideoSession videoSession = null;
    private boolean videoPaused = false;
    private boolean serverVideoPaused = false;
    private String audioURL = null;
    private long mpAudioID = 0L;
    private AudioSession audioSession = null;
    private SourceDataLine audioLine = null;
    private boolean audioPaused = false;
    private boolean serverAudioPaused = false;
    public int isConnecting = 0;
    private int direction = 1;
    private int stepMode = 0;
    private int status = 0;
    private boolean mute = true;
    private boolean isActive = true;
    private boolean isScreenCleared = false;
    private String errorMessage = null;
    private int signId = 0;
    private String resultMsg = "";
    private int resultCode = 0;
    private Font messageFont = new Font("Dialog", 1, 14);
    private Hashtable visibleMetadata = new Hashtable();
    private boolean isCenterSignShown = false;
    private AtomicBoolean clearScreenMargins = new AtomicBoolean(true);
    protected float frameRate = 0.0f;
    protected int nextFrameTimeout = 2000;
    protected boolean isStretchPixelAspectRatio = false;
    protected float pixelAspectRatio = 0.0f;
    protected String streamType;
    protected String analyticsWarnMsg = null;
    protected boolean liveMode = false;
    protected long frameTimestamp = 0L;
    protected long framePrevTimestamp = 0L;
    protected long bufferStartTimestamp = 0L;
    protected long bufferEndTimestamp = 0L;
    private ChangeStatusEvent changeStatusEvent;
    private ZoomControl zoomControl = new ZoomControl();
    private String snapshotFileName = null;
    private MediaPlayerListener listener;
    private boolean showSnapshotDialog = true;
    private boolean videoDisplayed = false;
    private Lock imageMutex = new ReentrantLock(true);
    JPanel overlay = new JPanel();

    static {
        Toolkit.getDefaultToolkit();
        System.loadLibrary("jawt");
        String playerVersion = NativeHelper.getPlayerVersion();
        if (playerVersion == null) {
            System.err.println("Player version is not set");
        }
        String nativeLibName = null;
        String sys = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        if (sys == null) {
            System.err.println("Unable to identify your OS");
        }
        nativeLibName = sys.startsWith("Windows") ? (arch.startsWith("x86") ? "VNMediaClient.dll" : "VNMediaClient-64.dll") : (System.getProperty("mrj.version") != null || sys.startsWith("Mac") ? "libVNMediaClient.dylib" : (arch.startsWith("x86") ? "libVNMediaClient.so" : "libVNMediaClient-64.so"));
        try {
            NativeHelper.loadFromJar(playerVersion, nativeLibName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MediaPlayer(String playerId) throws Exception {
        this(playerId, Logger.getAnonymousLogger());
        this.setLayout(null);
        this.overlay.setBounds(0, 0, 1, 1);
        this.overlay.setOpaque(false);
        this.add(this.overlay);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        handler.setFormatter(new LogFormatter(playerId));
        this.log.addHandler(handler);
        this.log.setLevel(Level.INFO);
        this.log.setUseParentHandlers(false);
        this.init();
    }

    public MediaPlayer(String playerId, Logger log) throws Exception {
        this.playerId = playerId;
        this.log = log;
        this.init();
    }

    private native void open(String var1, int var2, int var3, int var4, int var5);

    private native void play(long var1);

    private native void stop(long var1);

    private native void pause(long var1);

    private native void speed(long var1, float var3);

    private native void stepMode(long var1, int var3);

    private native void jumpToTimestamp(long var1, int var3);

    private native void saveCurrentVideoFrame(String var1, byte[] var2);

    private native void setBandwidth(long var1, int var3);

    private native void setJitterBufferLen(long var1, int var3);

    private native void setAnalyticsKeysVisualisation(long var1, String var3);

    private native void resume(long var1, int var3);

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void setJitterBuffer(int value) {
        this.jitterBuffer = value;
        if (this.mpVideoID != 0L) {
            this.setJitterBufferLen(this.mpVideoID, value);
        }
    }

    public void setUseHWDecoder(int value) {
        this.useHWDecoder = value;
    }

    public void setEnableLogging(boolean value) {
        Handler[] handlerArray = this.log.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            if (value) {
                h.setLevel(Level.ALL);
            } else {
                h.setLevel(Level.OFF);
            }
            ++n2;
        }
    }

    public void setMediaPlayerListener(MediaPlayerListener listener) {
        this.listener = listener;
        this.zoomControl.setMediaPlayerListener(listener);
    }

    private void init() throws Exception {
        this.isScreenCleared = true;
        this.addComponentListener(this);
        this.addMouseListener(this.zoomControl);
        this.addMouseMotionListener(this.zoomControl);
        this.addMouseWheelListener(this.zoomControl);
        this.zoomControl.setScreenRect(this.screenRect);
        this.zoomControl.setCanvas(this);
        this.isWorking = true;
        this.changeStatusEvent = new ChangeStatusEvent();
        this.changeStatusEvent.start();
        this.log("Player initialized");
    }

    public void setOnHold(boolean isOnHold) {
        if (isOnHold) {
            this.isActive = false;
        } else {
            this.isActive = true;
            this.repaint();
        }
    }

    public void destroy() {
        this.isWorking = false;
        this.stopSessions();
        this.changeStatusEvent.done();
        try {
            this.changeStatusEvent.wait();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {}
        this.changeStatusEvent = null;
        this.removeComponentListener(this);
        this.removeMouseWheelListener(this.zoomControl);
        this.removeMouseMotionListener(this.zoomControl);
        this.removeMouseListener(this.zoomControl);
        if (this.im != null) {
            this.im.flush();
        }
        this.messageFont = null;
    }

    public void setParameter(String param, String value) {
        if (!this.isWorking) {
            this.log.severe("Setting parameter \"" + param + " = " + value + "\" when player is not ready");
            return;
        }
        this.log.info("setParameter: " + param + " = " + value);
        if (param.equals("streamOverTCP")) {
            if (value.equals("1") || value.equals("true")) {
                this.streamOverTCP = 1;
            } else if (value.equals("0") || value.equals("false")) {
                this.streamOverTCP = 0;
            }
        } else if (param.equals("streamOverHTTP")) {
            if (value.equals("1") || value.equals("true")) {
                this.streamOverHTTP = 1;
            } else if (value.equals("0") || value.equals("false")) {
                this.streamOverHTTP = 0;
            }
        } else if (param.equals("videoURL")) {
            this.videoURL = value;
            this.liveMode = !this.videoURL.contains("start=");
            this.frameTimestamp = 0L;
            this.bufferStartTimestamp = 0L;
            this.bufferEndTimestamp = 0L;
        } else if (param.equals("audioURL")) {
            this.audioURL = value;
            this.liveMode = !this.audioURL.contains("start=");
            this.frameTimestamp = 0L;
            this.bufferStartTimestamp = 0L;
            this.bufferEndTimestamp = 0L;
        } else if (param.equals("direction")) {
            if (value.equals("1")) {
                this.direction = 1;
            } else if (value.equals("-1")) {
                this.direction = -1;
            }
        } else if (param.equals("streamSpeed")) {
            try {
                Float val = Float.valueOf(Float.parseFloat(value));
                this.changeSessionsSpeed(val.floatValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warning("Parameter \"streamSpeed\" must be float value!");
            }
        } else if (param.equals("stepMode")) {
            if (value.equals("1") || value.equals("on")) {
                this.changeStepMode(1);
            } else if (value.equals("0") || value.equals("off")) {
                this.changeStepMode(0);
            } else {
                this.log.warning("Parameter \"stepMode\" must be one of [0,1,on, off]");
            }
        } else if (param.equals("jump2timestamp")) {
            try {
                Integer val = Integer.parseInt(value);
                this.jump2timestamp(val);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warning("Parameter \"jump2timestamp\" must be integer value!");
            }
        } else if (param.equals("snapshotFileName")) {
            this.snapshotFileName = value;
        } else if (param.equals("showSnapshotDialog")) {
            if (value.equals("1") || value.equals("on")) {
                this.showSnapshotDialog = true;
            } else if (value.equals("0") || value.equals("off")) {
                this.showSnapshotDialog = false;
            } else {
                this.log.warning("Parameter \"showSnapshotDialog\" must be one of [0,1,on, off]");
            }
        } else if (param.equals("frameRate")) {
            try {
                Float val = Float.valueOf(Float.parseFloat(value));
                this.frameRate = Math.abs(val.floatValue());
                this.nextFrameTimeout = (double)this.frameRate == 0.0 ? 2000 : Math.round(1000.0f / this.frameRate) + 2000;
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warning("Parameter \"frameRate\" must be float value!");
                this.frameRate = 0.0f;
                this.nextFrameTimeout = 2000;
            }
        } else if (param.equals("pixelAspectRatio")) {
            if (value.equals("stretch")) {
                this.isStretchPixelAspectRatio = true;
            } else {
                this.isStretchPixelAspectRatio = false;
                try {
                    Float val = Float.valueOf(Float.parseFloat(value));
                    this.pixelAspectRatio = Math.abs(val.floatValue());
                    this.zoomControl.setPixelAspectRatio(this.pixelAspectRatio);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (param.equals("bandwidth")) {
            try {
                Integer val = value.equals("auto") ? Integer.valueOf(0) : (value.equals("full") ? Integer.valueOf(-1) : Integer.valueOf(Integer.parseInt(value)));
                if (this.mpVideoID != 0L) {
                    this.setBandwidth(this.mpVideoID, val);
                }
                if (this.mpAudioID != 0L) {
                    this.setBandwidth(this.mpAudioID, val);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warning("Parameter \"bandwidth\" must be integer value!");
            }
        } else if (param.equalsIgnoreCase("maxHWFrameRate")) {
            try {
                int val = Integer.parseInt(value);
                if (val <= 1) {
                    throw new NumberFormatException();
                }
                this.maxHWFrameRate = val;
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warning("Invalid value of parameter \"" + param + "\"");
            }
        } else if (param.equals("mute")) {
            if (value.equals("1") || value.equals("on")) {
                this.mute = true;
                if (this.audioLine != null) {
                    this.audioLine.flush();
                }
            } else if (value.equals("0") || value.equals("off")) {
                this.mute = false;
            } else {
                this.log.warning("Parameter \"mute\" must be one of [0,1,on,off]");
            }
        } else if (param.equals("metadataTagInfo")) {
            if (this.mpVideoID != 0L) {
                this.setMetadataTagInfo(this.mpVideoID, value);
            }
            if (this.mpAudioID != 0L) {
                this.setMetadataTagInfo(this.mpAudioID, value);
            }
        } else if (param.equals("analyticsKeysVisualisation")) {
            if (this.mpVideoID != 0L) {
                this.setAnalyticsKeysVisualisation(this.mpVideoID, value);
            }
        } else if (param.equals("jitterBuffer")) {
            try {
                Integer val = Integer.parseInt(value);
                this.setJitterBuffer(val);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warning("Parameter \"bandwidth\" must be integer value!");
            }
        }
        this.framePrevTimestamp = 0L;
    }

    public void sendCommand(String command) {
        if (!this.isWorking) {
            this.log.severe("Sending command \"" + command + "\" when player is not ready");
            return;
        }
        this.log.info("sendCommand: " + command);
        if (command.equals("open")) {
            if (this.stepMode == 1 && (this.status == 1 || this.status == 2)) {
                this.log.info("Not ready");
            } else {
                this.open(this.videoURL, this.streamOverTCP, this.streamOverHTTP, this.videoURL != null ? 0 : 1, this.maxHWFrameRate);
            }
        } else if (command.equals("play")) {
            if (this.stepMode == 1 && (this.status == 1 || this.status == 2)) {
                this.log.info("Not ready");
            } else {
                this.clearResults();
                if (this.status != 6) {
                    this.pauseSessions(false, false);
                }
                this.playSessions();
            }
        } else if (command.equals("stop")) {
            this.clearResults();
            this.objsTracker = null;
            this.stopSessions();
            this.repaint();
        } else if (command.equals("pause")) {
            this.clearResults();
            this.pauseSessions(true, false);
            this.repaint();
        } else if (command.equals("snapshot")) {
            this.saveSnapshot();
        } else if (command.equals("clear")) {
            this.clear();
        }
    }

    private void playSessions() {
        if (this.videoURL == null && this.audioURL == null) {
            this.log.severe("Please specify 'videoURL' or 'audioURL' param");
        }
        if (this.videoSession == null && this.videoURL != null) {
            this.videoSession = new VideoSession();
            this.videoSession.start();
        }
        if (this.audioSession == null && this.audioURL != null) {
            this.audioSession = new AudioSession();
            this.audioSession.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSessions() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (this.mpVideoID != 0L) {
                this.stop(this.mpVideoID);
                this.videoSession = null;
                this.mpVideoID = 0L;
                this.videoPaused = false;
                this.serverVideoPaused = false;
            }
            if (this.mpAudioID != 0L) {
                this.stop(this.mpAudioID);
                this.audioSession = null;
                this.mpAudioID = 0L;
                this.audioPaused = false;
                this.serverAudioPaused = false;
            }
            if (this.audioLine != null) {
                try {
                    this.audioLine.close();
                }
                catch (Exception e) {
                    this.log.warning(e.toString());
                }
            }
        }
        this.changeStatus(3, false);
    }

    private void pauseSessions() {
        this.pauseSessions(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseSessions(boolean changeStatus, boolean sendStatusNotification) {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (this.mpVideoID != 0L && !this.serverVideoPaused) {
                this.pause(this.mpVideoID);
                this.videoSession = null;
                this.videoPaused = true;
                this.videoDisplayed = false;
            }
            if (this.mpAudioID != 0L && !this.serverAudioPaused) {
                this.pause(this.mpAudioID);
                this.audioSession = null;
                this.audioPaused = true;
            }
            if (this.audioLine != null) {
                this.audioLine.flush();
            }
        }
        if (changeStatus && (this.mpVideoID != 0L || this.mpAudioID != 0L)) {
            this.changeStatus(0, sendStatusNotification);
        }
    }

    private void jump2timestamp(int value) {
        if (this.mpVideoID != 0L) {
            this.jumpToTimestamp(this.mpVideoID, value);
        }
        if (this.mpAudioID != 0L) {
            this.jumpToTimestamp(this.mpAudioID, value);
        }
        this.videoDisplayed = false;
        if (this.audioLine != null) {
            this.audioLine.flush();
        }
    }

    private void changeSessionsSpeed(float value) {
        if (this.mpVideoID != 0L) {
            this.speed(this.mpVideoID, value);
        }
        if (this.mpAudioID != 0L) {
            this.speed(this.mpAudioID, value);
        }
    }

    private void changeStepMode(int value) {
        this.stepMode = value;
        if (this.mpVideoID != 0L) {
            this.stepMode(this.mpVideoID, value);
        }
        if (this.mpAudioID != 0L) {
            this.stepMode(this.mpAudioID, value);
        }
    }

    private void changeStatus(int status) {
        if (!this.isWorking) {
            return;
        }
        this.changeStatus(status, true);
    }

    public int getStatus() {
        return this.status;
    }

    private void changeStatus(int status, boolean sendStatusNotification) {
        if (!(status == 3 || this.status != status || status == 0 && sendStatusNotification)) {
            return;
        }
        this.log.info("changeStatus: " + status);
        this.status = status;
        this.isConnecting = 0;
        if (status == 3) {
            if (this.mpVideoID != 0L) {
                this.stop(this.mpVideoID);
                this.videoSession = null;
                this.mpVideoID = 0L;
                this.videoPaused = false;
                this.serverVideoPaused = false;
            }
            if (this.mpAudioID != 0L) {
                this.audioSession = null;
                this.mpAudioID = 0L;
                this.audioPaused = false;
                this.serverAudioPaused = false;
            }
            if (this.audioLine != null) {
                try {
                    this.audioLine.close();
                }
                catch (Exception e) {
                    this.log.warning(e.toString());
                }
            }
            this.bufferStartTimestamp = 0L;
            this.bufferEndTimestamp = 0L;
            this.videoDisplayed = false;
        } else if (status == 0 && this.audioLine != null) {
            this.audioLine.flush();
        }
        if (sendStatusNotification) {
            this.changeStatusEvent.add(status);
        }
    }

    private void saveSnapshot() {
        if (this.im != null && this.mpVideoID != 0L && this.snapshotFileName != null) {
            SaveSnapshotThread snapshotThread = new SaveSnapshotThread();
            snapshotThread.start();
        }
    }

    private void setMetadataTagInfo(long mpID, String info) {
        try {
            JsonValue v = new JsonLiteReader(info).v();
            this.visibleMetadata.clear();
            int i = 0;
            while (i < v.size()) {
                JsonValue obj = v.at(i);
                JsonValue tag = obj.at("tag");
                this.visibleMetadata.put(tag.asString(), obj.at("view"));
                ++i;
            }
        }
        catch (Exception ex) {
            this.log.warning("MediaPlayer.setMetadataTagInfo: " + ex.toString());
        }
    }

    private int isDisplayReady() {
        return this.displayBusy || !this.isWorking ? 0 : 1;
    }

    private int canDisplayFrame(long secs, long usecs) {
        Date date = new Date(secs * 1000000L + usecs / 1000L);
        return this.listener.canDisplayFrame(date) ? 1 : 0;
    }

    private byte[] createRGB24Image(int width, int height, float pixelAspectRatio) {
        if (!this.isStretchPixelAspectRatio && this.pixelAspectRatio == 0.0f) {
            this.pixelAspectRatio = pixelAspectRatio;
            this.zoomControl.setPixelAspectRatio(pixelAspectRatio);
        }
        if (this.im == null || this.im.getWidth() != width || this.im.getHeight() != height) {
            this.im = new BufferedImage(width, height, 5);
            this.zoomControl.setIm(this.im);
        }
        this.im.setAccelerationPriority(1.0f);
        this.clearScreenMargins.set(true);
        this.updatePaintParameters();
        this.videoDisplayed = true;
        return ((DataBufferByte)this.im.getRaster().getDataBuffer()).getData();
    }

    private void configureAudioDevice(int rate, int bits, int channels) {
        this.log.info("Configure audio device: rate=" + rate + " bits=" + bits + " channeld=" + channels);
        AudioFormat af = new AudioFormat(rate, 16, channels, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, af);
        try {
            this.audioLine = (SourceDataLine)AudioSystem.getLine(info);
            this.audioLine.open(af, 2 * rate * channels / 10);
            this.audioLine.start();
        }
        catch (LineUnavailableException e) {
            this.log.log(Level.WARNING, "Failed to get audio line", e);
        }
    }

    private void lockImageBuffer() {
        this.imageMutex.lock();
    }

    private void unlockImageBuffer() {
        this.imageMutex.unlock();
    }

    private void displayFrame(int currentFrameSec, int currentFrameUSec, int bufferLBSec, int bufferLBUSec, int bufferRBSec, int bufferRBUSec, int bufferUsage, byte[] objsTrackData) {
        this.videoDisplayed = true;
        this.frameTimestamp = (long)currentFrameSec * 1000L + (long)(currentFrameUSec / 1000);
        this.bufferStartTimestamp = (long)bufferLBSec * 1000L + (long)(bufferLBUSec / 1000);
        this.bufferEndTimestamp = (long)bufferRBSec * 1000L + (long)(bufferRBUSec / 1000);
        if (!this.isWorking) {
            return;
        }
        if (this.im == null) {
            this.log.warning("[" + this.playerId + "] Buffered image was not created yet");
        } else {
            this.listener.newFrame(this.frameTimestamp, this.bufferStartTimestamp, this.bufferEndTimestamp, this.im);
            this.framePrevTimestamp = this.frameTimestamp;
            if (objsTrackData != null) {
                this.objsTracker = new ObjectsTracker(objsTrackData);
            }
            this.isScreenCleared = false;
            this.errorMessage = null;
            this.signId = 0;
            if (this.isActive) {
                this.repaint();
            }
        }
        if (this.stepMode == 1 && this.mpVideoID != 0L) {
            this.pauseSessions();
        }
    }

    private void playPCMFrame(byte[] data, int size, int currentFrameSec, int currentFrameUSec, int bufferLBSec, int bufferLBUSec, int bufferRBSec, int bufferRBUSec, int bufferUsage) {
        if (this.videoSession == null) {
            this.frameTimestamp = (long)currentFrameSec * 1000L + (long)(currentFrameUSec / 1000);
            this.bufferStartTimestamp = (long)bufferLBSec * 1000L + (long)(bufferLBUSec / 1000);
            this.bufferEndTimestamp = (long)bufferRBSec * 1000L + (long)(bufferRBUSec / 1000);
        }
        if (this.isWorking && this.audioLine != null && !this.mute) {
            if (this.videoSession != null && !this.videoDisplayed) {
                return;
            }
            int bytesWritten = this.audioLine.write(data, 0, size);
            if (bytesWritten != size) {
                this.log.warning("bytesWritten != size (" + bytesWritten + " != " + size + ")");
            }
            if (this.videoSession == null) {
                if (this.listener != null && (this.stepMode == 1 || this.frameTimestamp >= this.framePrevTimestamp + 250L || this.frameTimestamp <= this.framePrevTimestamp - 250L)) {
                    this.framePrevTimestamp = this.frameTimestamp;
                }
                if (this.stepMode == 1) {
                    this.pauseSessions();
                }
            }
        }
    }

    private void bufferChanged(int bufferLBSec, int bufferLBUSec, int bufferRBSec, int bufferRBUSec) {
        this.bufferStartTimestamp = (long)bufferLBSec * 1000L + (long)(bufferLBUSec / 1000);
        this.bufferEndTimestamp = (long)bufferRBSec * 1000L + (long)(bufferRBUSec / 1000);
        if (this.isWorking && this.listener != null) {
            this.listener.bufferChanged(this.bufferStartTimestamp, this.bufferEndTimestamp);
        }
    }

    private void log(String msg) {
        this.log.info(msg);
    }

    private void clear() {
        if (this.status == -1 || this.status == 3) {
            this.frameTimestamp = 0L;
        }
        this.isScreenCleared = true;
        this.errorMessage = null;
        this.signId = 0;
        this.clearScreenMargins.set(true);
        this.repaint();
    }

    private void setStreamType(String streamType) {
        this.streamType = streamType;
    }

    public String getStreamType() {
        return this.streamType;
    }

    public Container getOverlay() {
        return this.overlay;
    }

    private void setResultMsg(String msg) {
        this.resultMsg = msg;
    }

    public String getResultMsg() {
        return this.resultMsg;
    }

    private void setResultCode(int code) {
        this.resultCode = code;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    private void clearResults() {
        this.resultCode = 0;
        this.resultMsg = "";
    }

    public void printError(String msg) {
        this.errorMessage = msg;
        this.clearScreenMargins.set(true);
        this.repaint();
    }

    public void displaySign(int signId) {
        this.signId = signId;
        this.clearScreenMargins.set(true);
        this.repaint();
    }

    public void showCenterSign(boolean showSign) {
        this.isCenterSignShown = showSign;
        this.clearScreenMargins.set(true);
        this.repaint();
    }

    public Rectangle getFramePosition() {
        return this.screenRect;
    }

    public long getCurrentTS() {
        return this.frameTimestamp;
    }

    public long getBufferStartTS() {
        return this.bufferStartTimestamp;
    }

    public long getBufferEndTS() {
        return this.bufferEndTimestamp;
    }

    private float calculateStretchPixelAspectRatio(int sourceWidth, int sourceHeight, int destWidth, int destHeight) {
        float factorSource = (float)sourceWidth / (float)sourceHeight;
        float factorDest = (float)destWidth / (float)destHeight;
        float aspectRatio = factorSource / factorDest;
        return aspectRatio;
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (!this.isWorking) {
            return;
        }
        this.clearScreenMargins.set(true);
        if (this.im != null && !this.isScreenCleared) {
            if (this.clearScreenMargins.compareAndSet(true, false)) {
                g.setColor(this.getBackground());
                if (this.screenRect.x > 0) {
                    g.fillRect(0, 0, this.screenRect.x, height);
                    g.fillRect(this.screenRect.x + this.screenRect.width, 0, width - (this.screenRect.x + this.screenRect.width), height);
                } else if (this.screenRect.y > 0) {
                    g.fillRect(0, 0, width, this.screenRect.y);
                    g.fillRect(0, this.screenRect.y + this.screenRect.height, width, height - (this.screenRect.y + this.screenRect.height));
                }
            }
            if (this.zoomControl.isZoomed() || this.objsTracker != null) {
                Rectangle imagePartRect = this.zoomControl.isZoomed() ? this.zoomControl.getPartRect() : new Rectangle(0, 0, this.im.getWidth(), this.im.getHeight());
                Graphics2D backBufferImageGraphics = (Graphics2D)this.backBufferImage.getGraphics();
                this.displayBusy = true;
                backBufferImageGraphics.drawImage(this.im, 0, 0, this.screenRect.width, this.screenRect.height, imagePartRect.x, imagePartRect.y, imagePartRect.width, imagePartRect.height, null);
                if (this.objsTracker != null) {
                    backBufferImageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (!this.zoomControl.isZoomed()) {
                        this.objsTracker.parseAndDraw(backBufferImageGraphics);
                    } else {
                        imagePartRect.width -= imagePartRect.x;
                        imagePartRect.height -= imagePartRect.y;
                        this.objsTracker.parseAndDraw(backBufferImageGraphics, new Rectangle(0, 0, this.screenRect.width, this.screenRect.height), imagePartRect, this.zoomControl.getImageZoomFactor());
                    }
                }
                if (this.zoomControl.isZoomed()) {
                    this.zoomControl.paint(backBufferImageGraphics, this.objsTracker);
                }
                this.displayBusy = false;
                backBufferImageGraphics.dispose();
                g.drawImage(this.backBufferImage, this.screenRect.x, this.screenRect.y, null);
            } else {
                this.displayBusy = true;
                g.drawImage(this.im, this.screenRect.x, this.screenRect.y, this.screenRect.width, this.screenRect.height, null);
                this.displayBusy = false;
            }
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
            this.clearScreenMargins.set(false);
        }
        if (!this.isScreenCleared) {
            if (this.signId != 0) {
                this.paintSign(g, this.signId, this.screenRect.x, this.screenRect.y, this.screenRect.width, this.screenRect.height);
            }
            if (this.isCenterSignShown) {
                this.paintCenterSign(g);
            }
        }
        this.overlay.setBounds(this.screenRect.x, this.screenRect.y, this.screenRect.width, this.screenRect.height);
        this.revalidate();
        if (this.errorMessage != null) {
            this.paintMessage(g, this.errorMessage);
        }
    }

    protected void paintSign(Graphics g, int signId, int imX, int imY, int imW, int imH) {
        if (signId == 1) {
            int xcw;
            int y;
            int x;
            int xwidth;
            if (imW > 0) {
                xwidth = Math.min(imW / 2, imH / 2);
                x = imX;
                y = imY;
            } else {
                xwidth = Math.min(this.getWidth() / 2, this.getHeight() / 2);
                x = 0;
                y = 0;
            }
            int xheight = xwidth;
            int xch = xcw = xwidth <= 24 ? 1 : xwidth * 10 / 240;
            Polygon x1 = new Polygon();
            x1.addPoint(x + xcw, y + 0);
            x1.addPoint(x + xwidth, y + xheight - xch);
            x1.addPoint(x + xwidth - xcw, y + xheight);
            x1.addPoint(x + 0, y + xch);
            Polygon x2 = new Polygon();
            x2.addPoint(x + 0, y + xheight - xch);
            x2.addPoint(x + xwidth - xcw, y + 0);
            x2.addPoint(x + xwidth, y + xch);
            x2.addPoint(x + xcw, y + xheight);
            g.setColor(Color.RED);
            g.fillPolygon(x1);
            g.fillPolygon(x2);
        }
    }

    protected void paintCenterSign(Graphics g) {
        g.setColor(Color.RED);
        int xc = Math.round(this.getWidth() / 2);
        int yc = Math.round(this.getHeight() / 2);
        int w2 = 16;
        g.drawRect(xc - w2, yc - w2, 2 * w2, 2 * w2);
        g.drawLine(xc - w2 / 2, yc, xc - w2 / 2 - w2, yc);
        g.drawLine(xc + w2 / 2, yc, xc + w2 / 2 + w2, yc);
        g.drawLine(xc, yc - w2 / 2, xc, yc - w2 / 2 - w2);
        g.drawLine(xc, yc + w2 / 2, xc, yc + w2 / 2 + w2);
    }

    protected void paintMessage(Graphics g, String msg) {
        FontMetrics fm = this.getFontMetrics(this.messageFont);
        int textY = this.getHeight() - 6 - fm.getDescent();
        int textX = (this.getWidth() - fm.stringWidth(msg)) / 2;
        if (textX < 1) {
            textX = 1;
        }
        int boxX = textX / 3 * 2;
        int boxY = this.getHeight() - fm.getHeight() - 9;
        Graphics2D g2 = (Graphics2D)g;
        Composite originalComposite = g2.getComposite();
        g2.setColor(Color.WHITE);
        g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g2.fillRoundRect(boxX, boxY, this.getWidth() - boxX * 2, fm.getHeight() + 6, 12, 12);
        g2.setComposite(originalComposite);
        g2.setColor(Color.BLACK);
        g2.drawRoundRect(boxX, boxY, this.getWidth() - boxX * 2, fm.getHeight() + 6, 12, 12);
        g2.setColor(Color.RED);
        g2.setFont(this.messageFont);
        g2.drawString(msg, textX, textY);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updatePaintParameters();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void updatePaintParameters() {
        if (this.im == null) {
            return;
        }
        if (this.isStretchPixelAspectRatio) {
            this.pixelAspectRatio = this.calculateStretchPixelAspectRatio(this.im.getWidth(), this.im.getHeight(), this.getWidth(), this.getHeight());
            this.zoomControl.setPixelAspectRatio(this.pixelAspectRatio);
        }
        int canvasWidth = this.getWidth();
        int canvasHeight = this.getHeight();
        float appletAspectRatio = (float)canvasWidth / (float)canvasHeight;
        float imageAspectRatio = (float)this.im.getWidth() / (float)this.im.getHeight();
        if ((imageAspectRatio /= this.pixelAspectRatio) <= appletAspectRatio) {
            this.screenRect.height = canvasHeight;
            this.screenRect.width = Math.round((float)canvasHeight * imageAspectRatio);
            this.screenRect.x = (canvasWidth - this.screenRect.width) / 2;
            this.screenRect.y = 0;
        } else {
            this.screenRect.width = canvasWidth;
            this.screenRect.height = Math.round((float)canvasWidth / imageAspectRatio);
            this.screenRect.x = 0;
            this.screenRect.y = (canvasHeight - this.screenRect.height) / 2;
        }
        if (this.backBufferImage == null || this.backBufferImage.getWidth() != this.screenRect.width || this.backBufferImage.getHeight() != this.screenRect.height) {
            this.backBufferImage = new BufferedImage(this.screenRect.width, this.screenRect.height, 6);
        }
        this.zoomControl.setScreenRect(this.screenRect);
        this.zoomControl.calculateImageRectSize();
    }

    class AudioSession {
        public void start() {
            if (MediaPlayer.this.audioPaused && MediaPlayer.this.status != 6) {
                MediaPlayer.this.audioPaused = false;
                MediaPlayer.this.serverAudioPaused = false;
                MediaPlayer.this.resume(MediaPlayer.this.mpAudioID, MediaPlayer.this.direction);
            } else {
                MediaPlayer.this.isConnecting = 1;
                MediaPlayer.this.play(MediaPlayer.this.mpAudioID);
            }
        }
    }

    class ChangeStatusEvent
    extends Thread {
        private SynchronousQueue<Integer> changeStatusQueue = new SynchronousQueue(true);
        private Object readySync = new Object();

        ChangeStatusEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            Object object = this.readySync;
            synchronized (object) {
                super.start();
            }
        }

        public void add(int status) {
            try {
                this.changeStatusQueue.put(new Integer(status));
            }
            catch (InterruptedException interruptedException) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.readySync;
            synchronized (object) {
                if (MediaPlayer.this.listener != null) {
                    MediaPlayer.this.listener.statusChanged(-1, MediaPlayer.this.resultCode, MediaPlayer.this.resultMsg);
                }
            }
            while (true) {
                try {
                    int status;
                    while ((status = this.changeStatusQueue.take().intValue()) != Integer.MIN_VALUE) {
                        if (MediaPlayer.this.listener == null) continue;
                        MediaPlayer.this.listener.statusChanged(status, MediaPlayer.this.resultCode, MediaPlayer.this.resultMsg);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void done() {
            try {
                this.changeStatusQueue.put(new Integer(Integer.MIN_VALUE));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class JsonLiteReader {
        private String json;
        private int idx;
        private JsonValue value;

        private JsonLiteReader(String jsonText) throws Exception {
            this.json = jsonText;
            this.idx = 0;
            this.value = this.eatNext();
        }

        public JsonValue v() {
            return this.value;
        }

        private void eatWhitespace() {
            while (" \t\n\r".indexOf(this.json.charAt(this.idx)) >= 0) {
                ++this.idx;
            }
        }

        private JsonValue eatNext() throws Exception {
            this.eatWhitespace();
            JsonValue value = null;
            int cnt = 0;
            switch (this.json.charAt(this.idx)) {
                case '\"': {
                    value = this.eatString();
                    break;
                }
                case '[': {
                    ++this.idx;
                    cnt = 0;
                    value = new JsonValue(JsonValueType.jsArray);
                    this.eatWhitespace();
                    while (this.json.charAt(this.idx) != ']') {
                        value.put(cnt++, this.eatNext());
                        this.eatWhitespace();
                        if (this.json.charAt(this.idx) != ',') break;
                        ++this.idx;
                    }
                    if (this.json.charAt(this.idx) == ']') {
                        ++this.idx;
                        break;
                    }
                    throw new Exception("array, at " + this.idx);
                }
                case '{': {
                    ++this.idx;
                    cnt = 0;
                    value = new JsonValue(JsonValueType.jsObject);
                    this.eatWhitespace();
                    while (this.json.charAt(this.idx) != '}') {
                        this.eatWhitespace();
                        JsonValue key = this.eatString();
                        this.eatWhitespace();
                        if (this.json.charAt(this.idx) != ':') {
                            throw new Exception("object, ':' expected but '" + this.json.charAt(this.idx) + "' found, at " + this.idx);
                        }
                        ++this.idx;
                        this.eatWhitespace();
                        value.put(key.asString(), this.eatNext());
                        this.eatWhitespace();
                        if (this.json.charAt(this.idx) != ',') break;
                        ++this.idx;
                    }
                    if (this.json.charAt(this.idx) == '}') {
                        ++this.idx;
                        break;
                    }
                    throw new Exception("object, at " + this.idx);
                }
                default: {
                    throw new Exception("unknown, at " + this.idx);
                }
            }
            return value;
        }

        private JsonValue eatString() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.json.charAt(this.idx) != '\"') {
                throw new Exception("object, ':' expected but '" + this.json.charAt(this.idx) + "' found, at " + this.idx);
            }
            ++this.idx;
            while (this.json.charAt(this.idx) != '\"') {
                if (this.json.charAt(this.idx) == '\\') {
                    ++this.idx;
                    switch (this.json.charAt(this.idx)) {
                        case 'b': {
                            sb.append('\b');
                            break;
                        }
                        case 'f': {
                            sb.append('\f');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case 'u': {
                            ++this.idx;
                            String hex = this.json.substring(this.idx, this.idx + 4).toUpperCase();
                            if (!hex.matches("[0-9A-F]{4}")) {
                                throw new Exception("\\u not followed by 4 hex-digits: " + hex);
                            }
                            this.idx += 3;
                            sb.append((char)Integer.parseInt(hex, 16));
                            break;
                        }
                        default: {
                            sb.append(this.json.charAt(this.idx));
                            break;
                        }
                    }
                } else {
                    sb.append(this.json.charAt(this.idx));
                }
                ++this.idx;
            }
            JsonValue v = new JsonValue(sb.toString());
            ++this.idx;
            return v;
        }
    }

    class JsonValue {
        private JsonValueType type;
        private int arraySize = 0;
        private Object value;

        public JsonValue() {
            this.type = JsonValueType.jsNull;
        }

        public JsonValue(String text) {
            this.type = JsonValueType.jsString;
            this.value = text;
        }

        public JsonValue(JsonValueType Type2) {
            this.type = Type2;
            switch (this.type) {
                case jsString: {
                    this.value = "";
                    break;
                }
                case jsArray: {
                    this.value = new Hashtable();
                    break;
                }
                case jsObject: {
                    this.value = new Hashtable();
                    break;
                }
                default: {
                    this.type = JsonValueType.jsNull;
                    this.value = null;
                }
            }
        }

        public boolean isNull() {
            return this.type == JsonValueType.jsNull;
        }

        public boolean isArray() {
            return this.type == JsonValueType.jsArray;
        }

        public boolean isObject() {
            return this.type == JsonValueType.jsObject;
        }

        public boolean isString() {
            return this.type == JsonValueType.jsString;
        }

        public String asString() throws Exception {
            if (this.isString()) {
                return (String)this.value;
            }
            throw new Exception("json asString - not a string");
        }

        public void set(String text) {
            this.type = JsonValueType.jsString;
            this.value = text;
        }

        public JsonValue at(int index) throws Exception {
            if (this.isArray()) {
                Hashtable ht = (Hashtable)this.value;
                if (index + 1 > this.arraySize) {
                    this.arraySize = index + 1;
                }
                if (ht.containsKey(index)) {
                    return (JsonValue)ht.get(index);
                }
                return ht.put(index, new JsonValue());
            }
            throw new Exception("json at - not an array");
        }

        public JsonValue at(String index) throws Exception {
            if (this.isObject()) {
                Hashtable ht = (Hashtable)this.value;
                if (ht.containsKey(index)) {
                    return (JsonValue)ht.get(index);
                }
                return ht.put(index, new JsonValue());
            }
            throw new Exception("json at - not an object");
        }

        public JsonValue put(int index, JsonValue v) throws Exception {
            if (this.isArray()) {
                Hashtable ht = (Hashtable)this.value;
                if (index + 1 > this.arraySize) {
                    this.arraySize = index + 1;
                }
                return ht.put(index, v);
            }
            throw new Exception("json put - not an array");
        }

        public JsonValue put(String index, JsonValue v) throws Exception {
            if (this.isObject()) {
                Hashtable ht = (Hashtable)this.value;
                return ht.put(index, v);
            }
            throw new Exception("json put - not an object");
        }

        public boolean exists(String index) throws Exception {
            if (this.isObject()) {
                Hashtable ht = (Hashtable)this.value;
                return ht.containsKey(index);
            }
            throw new Exception("json exists - not an object");
        }

        public int size() throws Exception {
            if (this.isArray()) {
                return this.arraySize;
            }
            throw new Exception("json size - not an array");
        }
    }

    public static enum JsonValueType {
        jsNull,
        jsString,
        jsArray,
        jsObject;

    }

    class ObjectsTracker
    implements Drawable {
        private byte[] bitstream;
        private int offset;
        private int length;
        private int bufa;
        private int bufb;
        private int position = 0;
        private Rectangle dstRect;
        private Rectangle srcRect;
        private float zoomFactor;
        private float kW;
        private float kH;
        private int objID = -1;
        private int objDrawType = 0;
        private int objXcoord = 0;
        private int objYcoord = 0;
        private int objWidth = 0;
        private int objHeight = 0;
        private int objColor = -1;
        private int objEndColor = -1;
        private int objLineWidth = 2;
        private int arrowHead = 8;
        private String text = null;
        private int[] xPoints;
        private int[] yPoints;
        private int nPoints;
        private float[] xTripPoints;
        private float[] yTripPoints;
        private static final byte OBJ_SEQUENCE_START_CODE = 10;
        private static final byte OBJ_START_CODE = 1;
        private static final byte OBJ_DRAW_TYPE_START_CODE = 2;
        private static final byte OBJ_X_COORD_START_CODE = 3;
        private static final byte OBJ_Y_COORD_START_CODE = 4;
        private static final byte OBJ_HEIGHT_START_CODE = 5;
        private static final byte OBJ_WIDTH_START_CODE = 6;
        private static final byte OBJ_COLOR_START_CODE = 7;
        private static final byte OBJ_LINEWIDTH_START_CODE = 8;
        private static final byte OBJ_TEXT_START_CODE = 9;
        private static final byte OBJ_POLYDATA_START_CODE = 11;
        private static final byte OBJ_ARROWHEADSIZE_START_CODE = 12;
        private static final byte OBJ_SEQUENCE_END_START_CODE = 127;
        private static final byte OBJ_DRAW_TYPE_BOX = 1;
        private static final byte OBJ_DRAW_TYPE_MLINE = 2;
        private static final byte OBJ_DRAW_TYPE_TEXT = 3;
        private static final byte OBJ_DRAW_TYPE_TIMESTAMP = 4;
        private static final byte OBJ_DRAW_TYPE_POLYGON = 5;
        private static final byte OBJ_DRAW_TYPE_TRIPWIRE_ARROW = 6;
        private static final byte OBJ_DRAW_TYPE_ARROW = 7;
        private static final byte OBJ_DRAW_TYPE_OVAL = 8;
        private static final int METADATA_TAGID = 65535;

        public ObjectsTracker(byte[] bitstream) {
            this.bitstream = bitstream;
            this.xTripPoints = new float[2];
            this.yTripPoints = new float[2];
        }

        private void skipBits(int bits) {
            this.position += bits;
            if (this.position >= 32) {
                this.bufa = this.bufb;
                try {
                    this.bufb = (this.bitstream[this.offset + 0] & 0xFF) << 24;
                    this.bufb |= (this.bitstream[this.offset + 1] & 0xFF) << 16;
                    this.bufb |= (this.bitstream[this.offset + 2] & 0xFF) << 8;
                    this.bufb |= this.bitstream[this.offset + 3] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                this.offset += 4;
                this.position -= 32;
            }
        }

        private int showBits(int bits) {
            if (this.offset > this.length + 8) {
                MediaPlayer.this.log.warning("[" + MediaPlayer.this.playerId + "] Broken objects data!!!");
                return -1;
            }
            int nbit = bits + this.position - 32;
            if (nbit > 0) {
                return (this.bufa & -1 >>> this.position) << nbit | this.bufb >>> 32 - nbit;
            }
            return (this.bufa & -1 >>> this.position) >>> 32 - this.position - bits;
        }

        private int getBits(int n) {
            int ret = this.showBits(n);
            this.skipBits(n);
            return ret;
        }

        private String getText() {
            int size = this.getBits(8);
            byte[] text = new byte[size];
            int i = 0;
            while (i < size) {
                text[i] = (byte)this.getBits(8);
                ++i;
            }
            return new String(text);
        }

        private void fillPolygonData() {
            this.nPoints = this.getBits(8);
            this.xPoints = new int[this.nPoints];
            this.yPoints = new int[this.nPoints];
            int i = 0;
            while (i < this.nPoints) {
                this.xPoints[i] = this.getBits(16);
                this.yPoints[i] = this.getBits(16);
                ++i;
            }
            if (this.nPoints == 2) {
                i = 0;
                while (i < this.nPoints) {
                    this.xTripPoints[i] = this.xPoints[i];
                    this.yTripPoints[i] = this.yPoints[i];
                    ++i;
                }
            }
        }

        public void parseAndDraw(Graphics2D g2) {
            this.parseAndDraw(g2, new Rectangle(((MediaPlayer)MediaPlayer.this).screenRect.width, ((MediaPlayer)MediaPlayer.this).screenRect.height), new Rectangle(MediaPlayer.this.im.getWidth(), MediaPlayer.this.im.getHeight()), MediaPlayer.this.zoomControl.getImageZoomFactor());
        }

        @Override
        public void draw(Graphics g, Rectangle dstRect) {
            this.parseAndDraw((Graphics2D)g, dstRect, new Rectangle(MediaPlayer.this.im.getWidth(), MediaPlayer.this.im.getHeight()), (float)((MediaPlayer)MediaPlayer.this).screenRect.width / (float)MediaPlayer.this.im.getWidth());
        }

        public void parseAndDraw(Graphics2D g2, Rectangle dstRect, Rectangle srcRect, float zoomFactor) {
            this.dstRect = dstRect;
            this.srcRect = srcRect;
            this.zoomFactor = zoomFactor;
            this.kW = (float)dstRect.width / (float)srcRect.width;
            this.kH = (float)dstRect.height / (float)srcRect.height;
            this.objEndColor = -1;
            this.objID = -1;
            this.position = 0;
            this.offset = 0;
            this.length = this.bitstream.length;
            try {
                this.bufa = (this.bitstream[this.offset + 0] & 0xFF) << 24;
                this.bufa |= (this.bitstream[this.offset + 1] & 0xFF) << 16;
                this.bufa |= (this.bitstream[this.offset + 2] & 0xFF) << 8;
                this.bufa |= this.bitstream[this.offset + 3] & 0xFF;
                this.bufb = (this.bitstream[this.offset + 4] & 0xFF) << 24;
                this.bufb |= (this.bitstream[this.offset + 5] & 0xFF) << 16;
                this.bufb |= (this.bitstream[this.offset + 6] & 0xFF) << 8;
                this.bufb |= this.bitstream[this.offset + 7] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            this.offset += 8;
            boolean done = false;
            boolean bEndColor = false;
            int tagYPos = 7;
            while (!done) {
                switch (this.getBits(8)) {
                    case 10: {
                        break;
                    }
                    case 1: {
                        if (this.objID == 65535) {
                            if (MediaPlayer.this.visibleMetadata.containsKey("" + this.objYcoord)) {
                                this.objYcoord = tagYPos;
                                this.objXcoord = 3;
                                this.objHeight = (MediaPlayer.this.im.getHeight() + 12) / 25;
                                tagYPos += this.objHeight + 2;
                            } else {
                                this.objID = -1;
                            }
                        }
                        if (this.objID != -1) {
                            this.drawObject(g2);
                        }
                        this.objID = this.getBits(16);
                        this.objLineWidth = 2;
                        this.arrowHead = 8;
                        bEndColor = false;
                        break;
                    }
                    case 2: {
                        this.objDrawType = this.getBits(8);
                        break;
                    }
                    case 3: {
                        this.objXcoord = this.getBits(16);
                        break;
                    }
                    case 4: {
                        this.objYcoord = this.getBits(16);
                        break;
                    }
                    case 5: {
                        this.objHeight = this.getBits(16);
                        break;
                    }
                    case 6: {
                        this.objWidth = this.getBits(16);
                        break;
                    }
                    case 7: {
                        if (bEndColor) {
                            this.objEndColor = this.getBits(32);
                            break;
                        }
                        this.objColor = this.getBits(32);
                        bEndColor = true;
                        break;
                    }
                    case 8: {
                        this.objLineWidth = this.getBits(8);
                        break;
                    }
                    case 12: {
                        this.arrowHead = this.getBits(8);
                        break;
                    }
                    case 9: {
                        this.text = this.getText();
                        break;
                    }
                    case 11: {
                        this.fillPolygonData();
                        break;
                    }
                    case 127: {
                        if (this.objID == 65535) {
                            if (MediaPlayer.this.visibleMetadata.containsKey("" + this.objYcoord)) {
                                this.objYcoord = tagYPos;
                                this.objXcoord = 3;
                                this.objHeight = (MediaPlayer.this.im.getHeight() + 12) / 25;
                                tagYPos += this.objHeight + 2;
                            } else {
                                this.objID = -1;
                            }
                        }
                        if (this.objID != -1) {
                            this.drawObject(g2);
                        }
                        done = true;
                    }
                }
            }
        }

        private void drawObject(Graphics2D g2) {
            Stroke origStroke = g2.getStroke();
            int stroke = (int)(this.zoomFactor * (float)this.objLineWidth);
            Composite originalComposite = g2.getComposite();
            g2.setColor(new Color(this.objColor));
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            switch (this.objDrawType) {
                case 1: {
                    g2.setStroke(new BasicStroke(stroke < 1 ? 1 : stroke));
                    g2.drawRect((int)((double)((float)this.dstRect.x + this.kW * ((float)(this.objXcoord - this.srcRect.x) - (float)this.objWidth / 2.0f)) + 0.5), (int)((double)((float)this.dstRect.y + this.kH * ((float)(this.objYcoord - this.srcRect.y) - (float)this.objHeight / 2.0f)) + 0.5), (int)((double)(this.kW * (float)this.objWidth) + 0.5), (int)((double)(this.kH * (float)this.objHeight) + 0.5));
                    g2.setStroke(origStroke);
                    break;
                }
                case 8: {
                    g2.setStroke(new BasicStroke(stroke < 1 ? 1 : stroke));
                    g2.drawOval((int)((double)((float)this.dstRect.x + this.kW * ((float)(this.objXcoord - this.srcRect.x) - (float)this.objWidth / 2.0f)) + 0.5), (int)((double)((float)this.dstRect.y + this.kH * ((float)(this.objYcoord - this.srcRect.y) - (float)this.objHeight / 2.0f)) + 0.5), (int)((double)(this.kW * (float)this.objWidth) + 0.5), (int)((double)(this.kH * (float)this.objHeight) + 0.5));
                    g2.setStroke(origStroke);
                    break;
                }
                case 2: 
                case 5: {
                    int i = 0;
                    while (i < this.nPoints) {
                        this.xPoints[i] = (int)((double)((float)this.dstRect.x + this.kW * (float)(this.xPoints[i] - this.srcRect.x)) + 0.5);
                        this.yPoints[i] = (int)((double)((float)this.dstRect.y + this.kH * (float)(this.yPoints[i] - this.srcRect.y)) + 0.5);
                        ++i;
                    }
                    if (this.objDrawType == 2) {
                        g2.setStroke(new BasicStroke(stroke < 1 ? 1 : stroke));
                        if (this.objColor >= 0 && this.objEndColor >= 0) {
                            Color startColor = new Color(this.objColor);
                            Color endColor = new Color(this.objEndColor);
                            Color eColor = startColor;
                            int i2 = 1;
                            while (i2 < this.nPoints) {
                                Color sColor = eColor;
                                eColor = new Color(startColor.getRed() + (int)((float)(endColor.getRed() - startColor.getRed()) * ((float)i2 / (float)(this.nPoints - 1))), startColor.getGreen() + (int)((float)(endColor.getGreen() - startColor.getGreen()) * ((float)i2 / (float)(this.nPoints - 1))), startColor.getBlue() + (int)((float)(endColor.getBlue() - startColor.getBlue()) * ((float)i2 / (float)(this.nPoints - 1))));
                                GradientPaint gradient = new GradientPaint(this.xPoints[i2 - 1], this.yPoints[i2 - 1], sColor, this.xPoints[i2], this.yPoints[i2], eColor);
                                g2.setPaint(gradient);
                                g2.drawLine(this.xPoints[i2 - 1], this.yPoints[i2 - 1], this.xPoints[i2], this.yPoints[i2]);
                                ++i2;
                            }
                        } else {
                            g2.drawPolyline(this.xPoints, this.yPoints, this.nPoints);
                        }
                        g2.setStroke(origStroke);
                    } else {
                        g2.fillPolygon(this.xPoints, this.yPoints, this.nPoints);
                    }
                    this.objEndColor = -1;
                    break;
                }
                case 3: {
                    if (this.text == null) break;
                    Font font = new Font("Serif", 1, (int)(this.kH * (float)this.objHeight));
                    FontMetrics fm = MediaPlayer.this.getFontMetrics(font);
                    g2.setFont(font);
                    g2.drawString(this.text, (int)((double)((float)this.dstRect.x + this.kW * (float)(this.objXcoord - this.srcRect.x)) + 0.5), (int)((double)((float)this.dstRect.y + this.kH * (float)(this.objYcoord - this.srcRect.y + fm.getAscent() - fm.getDescent())) + 0.5));
                    break;
                }
                case 4: {
                    break;
                }
                case 7: {
                    if (this.xTripPoints.length < 2 || this.yTripPoints.length < 2) break;
                    int i = 0;
                    while (i < 2) {
                        this.xTripPoints[i] = (float)this.dstRect.x + this.kW * (this.xTripPoints[i] - (float)this.srcRect.x);
                        this.yTripPoints[i] = (float)this.dstRect.y + this.kH * (this.yTripPoints[i] - (float)this.srcRect.y);
                        ++i;
                    }
                    double size = Math.sqrt(Math.pow(this.xTripPoints[1] - this.xTripPoints[0], 2.0) + Math.pow(this.yTripPoints[1] - this.yTripPoints[0], 2.0));
                    if (this.kW < this.kH) {
                        // empty if block
                    }
                    double a = (double)((this.xTripPoints[1] - this.xTripPoints[0]) * this.kW) / size;
                    double b = (double)((this.yTripPoints[1] - this.yTripPoints[0]) * this.kH) / size;
                    double tmpX = (this.xTripPoints[0] + this.xTripPoints[1]) / 2.0f;
                    double tmpY = (this.yTripPoints[0] + this.yTripPoints[1]) / 2.0f;
                    int[] x_points = new int[3];
                    int[] y_points = new int[3];
                    x_points[0] = (int)(tmpX - (double)this.arrowHead * b + 0.5);
                    y_points[0] = (int)(tmpY + (double)this.arrowHead * a + 0.5);
                    x_points[1] = (int)(tmpX + (double)this.arrowHead * b + 0.5);
                    y_points[1] = (int)(tmpY - (double)this.arrowHead * a + 0.5);
                    x_points[2] = (int)(tmpX + (double)this.arrowHead * a + 0.5);
                    y_points[2] = (int)(tmpY + (double)this.arrowHead * b + 0.5);
                    g2.fillPolygon(x_points, y_points, 3);
                    break;
                }
                case 6: {
                    if (this.xTripPoints.length < 2 || this.yTripPoints.length < 2) break;
                    int i = 0;
                    while (i < 2) {
                        this.xTripPoints[i] = (float)this.dstRect.x + this.kW * (this.xTripPoints[i] - (float)this.srcRect.x);
                        this.yTripPoints[i] = (float)this.dstRect.y + this.kH * (this.yTripPoints[i] - (float)this.srcRect.y);
                        ++i;
                    }
                    double[] x_tmp = new double[4];
                    double[] y_tmp = new double[4];
                    double size = Math.sqrt(Math.pow(this.xTripPoints[1] - this.xTripPoints[0], 2.0) + Math.pow(this.yTripPoints[1] - this.yTripPoints[0], 2.0));
                    double cfr_ignored_0 = this.kW < this.kH ? this.kW : this.kH;
                    double a = (double)(this.kW * (this.xTripPoints[1] - this.xTripPoints[0])) / size;
                    double b = (double)(this.kH * (this.yTripPoints[1] - this.yTripPoints[0])) / size;
                    double tmpX = (this.xTripPoints[0] + this.xTripPoints[1]) / 2.0f;
                    double tmpY = (this.yTripPoints[0] + this.yTripPoints[1]) / 2.0f;
                    x_tmp[0] = tmpX - 10.0 * b;
                    y_tmp[0] = tmpY + 10.0 * a;
                    x_tmp[1] = tmpX + 10.0 * b;
                    y_tmp[1] = tmpY - 10.0 * a;
                    x_tmp[2] = x_tmp[1] + 4.0 * a;
                    y_tmp[2] = y_tmp[1] + 4.0 * b;
                    x_tmp[3] = x_tmp[0] + 4.0 * a;
                    y_tmp[3] = y_tmp[0] + 4.0 * b;
                    int[] x_points = new int[7];
                    int[] y_points = new int[7];
                    int i3 = 0;
                    while (i3 < x_tmp.length) {
                        x_points[i3] = (int)(x_tmp[i3] - 0.5);
                        y_points[i3] = (int)(y_tmp[i3] - 0.5);
                        ++i3;
                    }
                    x_points[4] = (int)(x_tmp[3] - 2.0 * a + a * (double)this.arrowHead - 0.5);
                    y_points[4] = (int)(y_tmp[3] - 2.0 * b + b * (double)this.arrowHead - 0.5);
                    x_points[5] = (int)(x_tmp[3] - 2.0 * a - b * (double)this.arrowHead - 0.5);
                    y_points[5] = (int)(y_tmp[3] - 2.0 * b + a * (double)this.arrowHead - 0.5);
                    x_points[6] = (int)(x_tmp[3] - 2.0 * a - a * (double)this.arrowHead - 0.5);
                    y_points[6] = (int)(y_tmp[3] - 2.0 * b - b * (double)this.arrowHead - 0.5);
                    g2.fillPolygon(x_points, y_points, 7);
                }
            }
            g2.setComposite(originalComposite);
        }
    }

    class SaveSnapshotThread
    extends Thread {
        SaveSnapshotThread() {
        }

        private String selectFileName() {
            FileDialog fd = null;
            Container c = MediaPlayer.this.getParent();
            while (c != null) {
                if (c instanceof Frame) {
                    fd = new FileDialog((Frame)c, "Save snapshot", 1);
                    break;
                }
                if (c instanceof Dialog) {
                    fd = new FileDialog((Dialog)c, "Save snapshot", 1);
                    break;
                }
                c = c.getParent();
            }
            if (fd == null) {
                MediaPlayer.this.log.severe("[" + MediaPlayer.this.playerId + "] Failed to get parent component to display File input dialog");
                return null;
            }
            System.getProperty("os.name").startsWith("Windows");
            String fileName = MediaPlayer.this.snapshotFileName;
            fd.setFile(fileName);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                fileName = String.valueOf(fd.getDirectory()) + fd.getFile().replaceAll(".%unused%", "");
                if (!fileName.endsWith(".jpg")) {
                    fileName = String.valueOf(fileName) + ".jpg";
                }
                return fileName;
            }
            return null;
        }

        @Override
        public void run() {
            String fileName = MediaPlayer.this.snapshotFileName;
            if (MediaPlayer.this.showSnapshotDialog) {
                fileName = this.selectFileName();
            }
            if (fileName != null) {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    param.setCompressionQuality(0.75f);
                    writer.setOutput(data);
                    writer.write(MediaPlayer.this.im);
                    MediaPlayer.this.saveCurrentVideoFrame(fileName, data.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (MediaPlayer.this.listener != null) {
                MediaPlayer.this.listener.snapshotFinished();
            }
        }
    }

    class VideoSession {
        public void start() {
            if (MediaPlayer.this.videoPaused && MediaPlayer.this.status != 6) {
                MediaPlayer.this.videoPaused = false;
                MediaPlayer.this.serverVideoPaused = false;
                MediaPlayer.this.resume(MediaPlayer.this.mpVideoID, MediaPlayer.this.direction);
            } else {
                MediaPlayer.this.isConnecting = 1;
                MediaPlayer.this.play(MediaPlayer.this.mpVideoID);
            }
        }
    }
}

