/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer.internal;

import com.videonext.mplayer.internal.MediaExporterListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaExporter {
    private ExportThread exportThread = null;
    private MediaExporterListener listener = null;

    public void setMediaExporterListener(MediaExporterListener listener) {
        this.listener = listener;
    }

    public boolean startExport(String url, String outFilename) {
        if (outFilename == null || outFilename.length() == 0) {
            System.out.println("Output file name is not specified.");
            return false;
        }
        try {
            this.exportThread = new ExportThread(url, outFilename);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return false;
        }
        this.exportThread.start();
        return true;
    }

    public void cancelExport() {
        if (this.exportThread != null) {
            this.exportThread.cancel();
        }
    }

    class ExportThread
    extends Thread {
        private Boolean canceled;
        private String outFileName;
        private String url;

        public ExportThread(String url, String filename) throws MalformedURLException {
            super("ExportThread");
            this.canceled = false;
            this.outFileName = null;
            this.url = null;
            this.setDaemon(true);
            this.url = url;
            this.outFileName = filename;
        }

        public void cancel() {
            this.canceled = true;
        }

        @Override
        public void run() {
            Boolean success;
            block25: {
                RandomAccessFile of = null;
                DataInputStream is = null;
                OutputStream os = null;
                success = false;
                try {
                    String header;
                    String line;
                    String host = this.getHostFromURL(this.url);
                    int port = this.getPortFromURL(this.url, 8554);
                    Socket socket = new Socket(host, port);
                    is = new DataInputStream(socket.getInputStream());
                    os = socket.getOutputStream();
                    System.out.println("Connected to " + host + ":" + port);
                    String req = "XEXPORT " + this.url + " RTSP/1.0\r\nCSeq: 1\r\n\r\n";
                    System.out.println("Request:");
                    System.out.println(req);
                    os.write(req.getBytes());
                    String resp = is.readLine();
                    boolean signed = false;
                    while ((line = is.readLine()) != null && line.length() != 0) {
                        if (!line.contains("X-Signed: yes")) continue;
                        signed = true;
                    }
                    System.out.println("Response:");
                    System.out.println(resp);
                    if (!resp.contains("RTSP/1.0 200")) {
                        socket.close();
                        throw new Exception("Request failed. Server returns: " + resp);
                    }
                    byte[] data = new byte[262144];
                    String contentType = null;
                    int contentLength = -1;
                    int oldprogress = 0;
                    int progress = 0;
                    long seek = 0L;
                    long clipSize = 0L;
                    Pattern contentTypeRegex = Pattern.compile("^Content-Type: (.+)");
                    Pattern contentLengthRegex = Pattern.compile("^Content-Length: (.+)");
                    Pattern xProgressRegex = Pattern.compile("^X-Progress: (.+)%");
                    Pattern xSeekRegex = Pattern.compile("^X-Seek: (.+)");
                    System.out.println("Downloading " + this.outFileName + " from " + this.url);
                    of = new RandomAccessFile(this.outFileName, "rw");
                    of.setLength(0L);
                    while ((header = is.readLine()) != null && !this.canceled.booleanValue()) {
                        Matcher m = contentTypeRegex.matcher(header);
                        if (m.find()) {
                            contentType = m.group(1);
                        } else {
                            m = contentLengthRegex.matcher(header);
                            if (m.find()) {
                                contentLength = Integer.parseInt(m.group(1));
                            } else {
                                m = xProgressRegex.matcher(header);
                                if (m.find()) {
                                    progress = Integer.parseInt(m.group(1));
                                } else {
                                    m = xSeekRegex.matcher(header);
                                    if (m.find()) {
                                        seek = Long.parseLong(m.group(1));
                                    }
                                }
                            }
                        }
                        if (header.length() != 0 || contentLength < 0) continue;
                        if (contentLength == 0 && progress == 100) {
                            success = true;
                            if (signed && (data[4] != 100 || data[5] != 115 || data[6] != 105 || data[7] != 103)) {
                                if (MediaExporter.this.listener == null) break;
                                MediaExporter.this.listener.newDataChunk(0L, 100, "Digital signature is missing in the movie. Please contact your system administrator.");
                                break;
                            }
                            if (MediaExporter.this.listener == null) break;
                            MediaExporter.this.listener.newDataChunk(0L, 100, "");
                            break;
                        }
                        int bytesRead = 0;
                        while (bytesRead < contentLength) {
                            int ret = is.read(data, bytesRead, contentLength - bytesRead);
                            if (ret <= 0) {
                                System.out.println("ERROR ret <= 0");
                                if (MediaExporter.this.listener == null) break;
                                MediaExporter.this.listener.newDataChunk(0L, 0, "Read data from network failed");
                                break;
                            }
                            bytesRead += ret;
                        }
                        if (!contentType.equalsIgnoreCase("video/quicktime")) {
                            System.out.println("ERROR: content type is " + contentType);
                            System.out.println(new String(data));
                            if (MediaExporter.this.listener == null) break;
                            MediaExporter.this.listener.newDataChunk(0L, 0, "Export failed due server issues");
                            break;
                        }
                        clipSize += (long)contentLength;
                        if (oldprogress != progress) {
                            if (MediaExporter.this.listener != null) {
                                MediaExporter.this.listener.newDataChunk(clipSize, progress, "");
                            }
                            oldprogress = progress;
                        }
                        if (seek != 0L) {
                            of.seek(seek);
                            seek = 0L;
                        }
                        of.write(data, 0, contentLength);
                        contentLength = -1;
                    }
                    if (of != null) {
                        of.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception ex) {
                    System.err.println("Error: " + ex.toString());
                    ex.printStackTrace(System.err);
                    if (MediaExporter.this.listener == null) break block25;
                    MediaExporter.this.listener.newDataChunk(0L, 0, "Requested video fragment is not available in videoarchive");
                }
            }
            if (success.booleanValue()) {
                System.out.println(String.valueOf(this.outFileName) + " downloaded successfully");
            } else {
                new File(this.outFileName).delete();
                System.out.println(String.valueOf(this.outFileName) + " download failed");
            }
        }

        private int getPortFromURL(String url, int defaultPort) {
            String hostStr = null;
            int sepIdx = url.indexOf("//");
            if (sepIdx < 0) {
                return defaultPort;
            }
            hostStr = url.substring(sepIdx + 2);
            if ((sepIdx = hostStr.indexOf("/")) < 0) {
                return defaultPort;
            }
            if ((sepIdx = (hostStr = hostStr.substring(0, sepIdx)).indexOf(58)) < 0) {
                return defaultPort;
            }
            String portStr = hostStr.substring(sepIdx + 1).trim();
            try {
                return Integer.parseInt(portStr);
            }
            catch (NumberFormatException numberFormatException) {
                return defaultPort;
            }
        }

        private String getHostFromURL(String url) {
            String hostStr = null;
            int sepIdx = url.indexOf("//");
            if (sepIdx < 0) {
                return "";
            }
            hostStr = url.substring(sepIdx + 2);
            if ((sepIdx = hostStr.indexOf("/")) < 0) {
                return "";
            }
            if ((sepIdx = (hostStr = hostStr.substring(0, sepIdx)).indexOf(58)) < 0) {
                return hostStr;
            }
            return hostStr.substring(0, sepIdx);
        }
    }
}

