/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer.internal;

import java.net.SocketException;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    protected String playerId;

    public LogFormatter(String playerId) {
        this.playerId = playerId;
    }

    @Override
    public String format(LogRecord record) {
        Throwable cause;
        StackTraceElement[] elements;
        Throwable t;
        String className = record.getSourceClassName();
        int i = record.getSourceClassName().lastIndexOf(46);
        if (i != -1) {
            className = className.substring(i + 1);
        }
        if ((t = record.getThrown()) == null) {
            return String.format("%1$tH:%1$tM:%1$tS.%1$tL %2$s [%3$s] %4$s\n", record.getMillis(), record.getLevel(), this.playerId, this.trimMessage(record.getMessage()));
        }
        String tMsg = t.getMessage();
        if (tMsg == null) {
            tMsg = t.getClass().getName();
        }
        StringBuilder stackTrace = new StringBuilder();
        if (!(t instanceof SocketException) && (elements = t.getStackTrace()) != null && elements.length > 0) {
            stackTrace.append("\n");
            int e = 0;
            while (e < elements.length) {
                stackTrace.append(elements[e].toString());
                stackTrace.append("\n");
                ++e;
            }
        }
        if ((cause = t.getCause()) != null) {
            stackTrace.append(" Caused by ");
            stackTrace.append(cause.getClass().getName());
            stackTrace.append(" - ");
            stackTrace.append(cause.getMessage());
        }
        return String.format("%1$tH:%1$tM:%1$tS.%1$tL %2$s [%3s] %4$s:%5$s %6$s/%7$s%8$s\n", record.getMillis(), record.getLevel(), this.playerId, className, record.getSourceMethodName(), this.trimMessage(record.getMessage()), tMsg, stackTrace.toString());
    }

    private String trimMessage(String str) {
        int len;
        int i = len = str.length() - 1;
        while (i >= 0 && " \n\r\t\f".indexOf(str.charAt(i)) != -1) {
            --i;
        }
        if (i == len) {
            return str;
        }
        if (i == -1) {
            return "";
        }
        return str.substring(0, i + 1);
    }
}

