/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer;

import com.videonext.mplayer.PlayerGroup;
import com.videonext.mplayer.api.ControllerEvent;
import com.videonext.mplayer.api.IControllerListener;
import com.videonext.mplayer.api.IPlayer;
import com.videonext.mplayer.api.events.NewFrameEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class SinglePlayerSyncronizer
implements IControllerListener {
    private final long m_syncPeriod = 3000L;
    private final long m_exceptableError = 250L;
    private Boolean m_isJustJumped = false;
    private SyncState m_syncState = SyncState.Playing;
    private IPlayer m_player;
    private float m_speed = 1.0f;
    private float m_empiricSpeed = 1.0f;
    private long m_realStartCountTime = 0L;
    private long m_startCountTime = 0L;
    private long m_playingTime = 0L;
    private PlayerGroup m_group;
    private long m_lastSyncTime = 0L;
    private Timer m_awaker;
    private long m_frameIncomeTime = new Date().getTime();
    private Boolean m_needJumpToPlayTime = false;
    private PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);

    private void setState(SyncState newState) {
        if (this.m_syncState == newState) {
            return;
        }
        SyncState oldState = this.m_syncState;
        this.m_syncState = newState;
        this.m_propertyChangeSupport.firePropertyChange("SyncState", (Object)oldState, (Object)newState);
    }

    public void switchToPlaying() {
        this.setState(SyncState.Playing);
    }

    public SyncState getState() {
        return this.m_syncState;
    }

    public IPlayer getPlayer() {
        return this.m_player;
    }

    public void setSpeed(float value) {
        if ((double)Math.abs(value - this.m_speed) < 1.0E-4) {
            return;
        }
        this.m_speed = value;
        this.m_player.changeSpeed(value);
        this.m_startCountTime = 0L;
        this.m_realStartCountTime = 0L;
    }

    public float getSpeed() {
        return this.m_speed;
    }

    public float getEmpiricSpeed() {
        return this.m_empiricSpeed;
    }

    public long getPlayingTime() {
        return this.m_playingTime;
    }

    public PlayerGroup getGroup() {
        return this.m_group;
    }

    public void resetEmpiricSpeed() {
        this.m_startCountTime = 0L;
    }

    public void setJumpToPlayTime() {
        this.m_needJumpToPlayTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jumpTo(Date date) {
        IPlayer iPlayer = this.m_player;
        synchronized (iPlayer) {
            this.m_player.jumpTo(date);
            this.m_isJustJumped = true;
        }
    }

    private float adjustSpeed() {
        if (this.m_playingTime == 0L) {
            return this.m_group.getMetronome().getSpeed();
        }
        long playingTimeFinishingSync = this.m_group.getPlayingTime() + (long)(3000.0f * this.m_group.getMetronome().getSpeed());
        long syncTime = playingTimeFinishingSync - this.m_playingTime;
        float newPlayerSpeed = (float)syncTime / 3000.0f;
        if (newPlayerSpeed < 0.0f && this.m_group.getMetronome().getDirection() == 1 || newPlayerSpeed > 0.0f && this.m_group.getMetronome().getDirection() == -1) {
            newPlayerSpeed = this.m_group.getMetronome().getSpeed() / 10.0f;
        }
        return newPlayerSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        IPlayer iPlayer = this.m_player;
        synchronized (iPlayer) {
            this.m_lastSyncTime = new Date().getTime();
            long timeDiff = Math.abs(this.m_playingTime - this.m_group.getPlayingTime());
            if (timeDiff < 250L) {
                this.setState(SyncState.Playing);
                this.setSpeed(this.m_group.getMetronome().getSpeed());
                return;
            }
            if (timeDiff > 12000L) {
                this.m_startCountTime = 0L;
                this.m_realStartCountTime = 0L;
                this.setSpeed(this.m_group.getMetronome().getSpeed());
                this.setState(SyncState.Playing);
                this.jumpTo(new Date(this.m_group.getPlayingTime()));
                return;
            }
            float newSpeed = this.adjustSpeed();
            this.setSpeed(newSpeed);
            this.setState(SyncState.Synchronizing);
        }
    }

    public SinglePlayerSyncronizer(IPlayer player, PlayerGroup group) {
        this.m_player = player;
        this.m_player.addControllerListener(this);
        this.m_group = group;
        this.m_awaker = new Timer();
        this.m_awaker.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IPlayer iPlayer = SinglePlayerSyncronizer.this.m_player;
                synchronized (iPlayer) {
                    if (SinglePlayerSyncronizer.this.m_group.getContext().getState() == PlayerGroup.ContextState.Live) {
                        return;
                    }
                    if (SinglePlayerSyncronizer.this.m_syncState == SyncState.Waiting && (SinglePlayerSyncronizer.this.m_playingTime - SinglePlayerSyncronizer.this.m_group.getPlayingTime()) * (long)SinglePlayerSyncronizer.this.m_group.getMetronome().getDirection() < 3000L) {
                        SinglePlayerSyncronizer.this.m_player.play(SinglePlayerSyncronizer.this.m_group.getMetronome().getDirection());
                    }
                    if (new Date().getTime() - SinglePlayerSyncronizer.this.m_frameIncomeTime > 3000L && (SinglePlayerSyncronizer.this.m_player.getState() == 2 || SinglePlayerSyncronizer.this.m_player.getState() == 1)) {
                        System.out.println("Restarting context");
                        SinglePlayerSyncronizer.this.m_group.getContext().Apply(SinglePlayerSyncronizer.this.m_player);
                    }
                }
            }
        }, 3000L, 3000L);
    }

    public void Dispose() {
        this.m_player.removeControllerListener(this);
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (!(event instanceof NewFrameEvent)) {
            return;
        }
        if (this.m_group.getContext().getState() == PlayerGroup.ContextState.Live) {
            return;
        }
        if (this.m_needJumpToPlayTime.booleanValue()) {
            this.jumpTo(new Date(this.m_group.getPlayingTime()));
            this.m_needJumpToPlayTime = false;
            return;
        }
        NewFrameEvent e = (NewFrameEvent)event;
        this.m_playingTime = e.getFramePTSMillis();
        this.m_frameIncomeTime = new Date().getTime();
        if ((this.m_playingTime - this.m_group.getPlayingTime()) * (long)this.m_group.getMetronome().getDirection() > 3000L) {
            this.m_player.pause();
            this.setState(SyncState.Waiting);
        }
        if (this.m_startCountTime == 0L || this.m_isJustJumped.booleanValue()) {
            this.m_startCountTime = this.m_playingTime;
            this.m_realStartCountTime = new Date().getTime();
            this.m_empiricSpeed = 0.0f;
            this.m_isJustJumped = false;
        } else {
            this.m_empiricSpeed = (float)(this.m_playingTime - this.m_startCountTime) / (float)(new Date().getTime() - this.m_realStartCountTime);
        }
        if (this.m_empiricSpeed > 10.0f) {
            this.m_empiricSpeed = 1.0f;
        }
        if (this.m_lastSyncTime == 0L) {
            this.m_lastSyncTime = new Date().getTime();
        } else if (new Date().getTime() - this.m_lastSyncTime > 3000L) {
            this.sync();
        }
    }

    @Override
    public boolean canDisplayFrame(Date date) {
        return false;
    }

    public String getLog() {
        String state = "";
        switch (this.m_syncState) {
            case Playing: {
                state = "[Pl]";
                break;
            }
            case Synchronizing: {
                state = "[Sn]";
                break;
            }
            case Waiting: {
                state = "[Wt]";
            }
        }
        return String.format("(%.3f, %.3f) %tT %s", Float.valueOf(this.m_empiricSpeed), Float.valueOf(this.m_speed), new Date(this.m_playingTime), state);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public static enum SyncState {
        Waiting,
        Synchronizing,
        Playing;

    }
}

