/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer;

import com.videonext.mplayer.NetObserver;
import com.videonext.mplayer.SinglePlayerSyncronizer;
import com.videonext.mplayer.api.ControllerEvent;
import com.videonext.mplayer.api.IControllerListener;
import com.videonext.mplayer.api.IPlayer;
import com.videonext.mplayer.api.IPlayerController;
import com.videonext.mplayer.api.IPlayerGroup;
import com.videonext.mplayer.api.IPlayerURLProvider;
import com.videonext.mplayer.api.events.ChangeStateEvent;
import com.videonext.mplayer.api.events.NewFrameEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class PlayerGroup
implements IControllerListener,
IPlayerGroup {
    private ArrayList<IControllerListener> m_listeners = new ArrayList();
    private ArrayList<SinglePlayerSyncronizer> m_syncronizers = new ArrayList();
    private Metronome m_metronome;
    private Timer m_metronomeTimer;
    private IPlayerURLProvider m_provider;
    private long m_playingTime = new Date().getTime();
    private final int m_metronomePeriod = 200;
    private final int m_speedUpdatePeriod = 3000;
    private Context m_context = new Context();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    @Override
    public ArrayList<SinglePlayerSyncronizer> getSynchronizers() {
        return this.m_syncronizers;
    }

    @Override
    public Metronome getMetronome() {
        return this.m_metronome;
    }

    @Override
    public long getPlayingTime() {
        return this.m_playingTime;
    }

    private IPlayer[] getPlayers() {
        IPlayer[] res = new IPlayer[this.m_syncronizers.size()];
        int i = 0;
        for (SinglePlayerSyncronizer s : this.m_syncronizers) {
            res[i] = s.getPlayer();
            ++i;
        }
        return res;
    }

    public PlayerGroup() {
        this.setMetronome();
        NetObserver.get().registerPlayerGroup(this);
    }

    void setMetronome() {
        this.m_metronomeTimer = new Timer();
        this.m_metronome = new Metronome();
        this.m_metronomeTimer.schedule((TimerTask)this.m_metronome, 200L, 200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(int direction) {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.getPlayer().play(direction);
            }
            this.m_metronome.setDirection(direction);
            this.m_metronome.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.getPlayer().pause();
            }
            this.m_metronome.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.getPlayer().stop();
            }
            this.m_metronome.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.getPlayer().close();
            }
            this.m_metronome.pause();
        }
    }

    @Override
    public int getState() {
        switch (this.m_metronome.getState()) {
            case Play: {
                return 1;
            }
            case Pause: {
                return 0;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addControllerListener(IControllerListener listener) {
        ArrayList<IControllerListener> arrayList = this.m_listeners;
        synchronized (arrayList) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeControllerListener(IControllerListener listener) {
        ArrayList<IControllerListener> arrayList = this.m_listeners;
        synchronized (arrayList) {
            this.m_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAspectRation(int value) {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.getPlayer().setAspectRation(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSpeed(float value) {
        this.m_metronome.setSpeed(value);
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.setSpeed(value);
                p.switchToPlaying();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jumpTo(Date date) {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.jumpTo(date);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStepMode(boolean flag) {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.getPlayer().setStepMode(flag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextStep(int direction) {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.getPlayer().nextStep(direction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrightness(float value) {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                p.getPlayer().setBrightness(value);
            }
        }
    }

    @Override
    public void setPlayerURLProvider(IPlayerURLProvider provider) {
        this.m_provider = provider;
    }

    public Context getContext() {
        return this.m_context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchToLive() {
        this.m_context.setState(ContextState.Live);
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            String[] urls = this.m_provider.getLiveURL(this.getPlayers());
            int i = 0;
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                this.m_context.Apply(p.getPlayer(), urls[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchToArchive(Date startTime, Date endTime) {
        this.m_context.setState(ContextState.Archive);
        this.m_context.setTime(startTime, endTime);
        this.m_playingTime = startTime.getTime();
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            String[] urls = this.m_provider.getArchiveURL(this.getPlayers(), startTime, endTime);
            int i = 0;
            for (SinglePlayerSyncronizer p : this.m_syncronizers) {
                this.m_context.Apply(p.getPlayer(), urls[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlayer(IPlayer newPlayer) {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            this.m_context.Apply(newPlayer);
            SinglePlayerSyncronizer s = new SinglePlayerSyncronizer(newPlayer, this);
            this.m_syncronizers.add(s);
            newPlayer.addControllerListener(this);
            NetObserver.get().registerPlayer(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlayer(IPlayer oldPlayer) {
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            SinglePlayerSyncronizer sync = null;
            for (SinglePlayerSyncronizer s : this.m_syncronizers) {
                if (s.getPlayer() != oldPlayer) continue;
                sync = s;
                break;
            }
            if (sync != null) {
                sync.Dispose();
                this.m_syncronizers.remove(sync);
            }
        }
    }

    private void pushToListeners(ControllerEvent event) {
        for (IControllerListener l : this.m_listeners) {
            l.controllerUpdate(event);
        }
    }

    private SinglePlayerSyncronizer getSynchronizer(IPlayer player) {
        for (SinglePlayerSyncronizer s : this.m_syncronizers) {
            if (s.getPlayer() != player) continue;
            return s;
        }
        return null;
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof ChangeStateEvent) {
            ChangeStateEvent e = (ChangeStateEvent)event;
            switch (e.getCurrentState()) {
                case 6: {
                    IPlayerController pc = (IPlayerController)e.getSource();
                    if (this.m_metronome.getState() != MetronomeState.Play) break;
                    pc.play(this.m_metronome.getDirection());
                    SinglePlayerSyncronizer s = this.getSynchronizer((IPlayer)pc);
                    s.setJumpToPlayTime();
                    break;
                }
            }
            if (e.getSource() == this.m_syncronizers.get(0).getPlayer()) {
                this.pushToListeners(event);
            }
        } else if (event instanceof NewFrameEvent) {
            NewFrameEvent e = (NewFrameEvent)event;
            switch (this.m_context.getState()) {
                case Live: {
                    if (e.getFramePTSMillis() <= this.m_playingTime) break;
                    this.m_playingTime = e.getFramePTSMillis();
                    this.pushToListeners(event);
                    break;
                }
                case Archive: {
                    if (e.getSource() != this) break;
                    this.pushToListeners(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLog() {
        String res = "";
        ArrayList<SinglePlayerSyncronizer> arrayList = this.m_syncronizers;
        synchronized (arrayList) {
            for (SinglePlayerSyncronizer s : this.m_syncronizers) {
                res = String.valueOf(res) + String.format("%s\n", s.getLog());
            }
        }
        res = String.valueOf(res) + String.format("(%.3f, %.3f) %tT [Mt]\n%s", Float.valueOf(this.m_metronome.getMagicCoeff()), Float.valueOf(this.m_metronome.getSpeed()), new Date(this.m_playingTime), NetObserver.get().getLog());
        return res;
    }

    @Override
    public boolean canDisplayFrame(Date date) {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void setMute(boolean val) {
    }

    @Override
    public void changeJitterBufferLen(int value) {
    }

    class Context {
        private ContextState m_state = ContextState.Live;
        private Date m_startTime = new Date();
        private Date m_endTime = new Date();

        Context() {
        }

        public void setState(ContextState state) {
            this.m_state = state;
        }

        public ContextState getState() {
            return this.m_state;
        }

        public void setTime(Date startTime, Date endTime) {
            this.m_startTime = startTime;
            this.m_endTime = endTime;
        }

        public Date getStartTime() {
            return this.m_startTime;
        }

        public Date getEndTime() {
            return this.m_endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void Apply(IPlayer player) {
            IPlayer iPlayer = player;
            synchronized (iPlayer) {
                String[] url = null;
                switch (this.m_state) {
                    case Live: {
                        url = PlayerGroup.this.m_provider.getLiveURL(new IPlayer[]{player});
                        break;
                    }
                    case Archive: {
                        url = PlayerGroup.this.m_provider.getArchiveURL(new IPlayer[]{player}, this.m_startTime, this.m_endTime);
                    }
                }
                if (url != null && url.length > 0) {
                    this.Apply(player, (String)url[0]);
                }
            }
        }

        public void Apply(IPlayer player, String url) {
            player.close();
            player.open(url);
        }
    }

    static enum ContextState {
        Live,
        Archive;

    }

    class JumperTask
    implements IControllerListener {
        IPlayerController m_pc;

        public JumperTask(IPlayerController pc) {
            this.m_pc = pc;
        }

        @Override
        public void controllerUpdate(ControllerEvent event) {
            System.out.println("motherfucker yohoho");
            this.m_pc.removeControllerListener(this);
            if (PlayerGroup.this.getContext().getState() == ContextState.Live) {
                return;
            }
            this.m_pc.jumpTo(new Date(PlayerGroup.this.m_playingTime));
        }

        @Override
        public boolean canDisplayFrame(Date date) {
            System.out.println("motherfucker yohoho");
            this.m_pc.removeControllerListener(this);
            if (PlayerGroup.this.getContext().getState() == ContextState.Live) {
                return true;
            }
            this.m_pc.jumpTo(new Date(PlayerGroup.this.m_playingTime));
            return false;
        }
    }

    public class Metronome
    extends TimerTask {
        private MetronomeState m_state = MetronomeState.Pause;
        private float m_speed = 1.0f;
        private long m_realTime = new Date().getTime();
        private float m_magicRealtimeCoeff = 1.0f;
        private int m_direction = 1;
        private long m_prevSpeedUpdate = 0L;
        private float m_maxSpeed = 24.0f;

        private void setMagicRealTimeCoeff(float val) {
            this.m_magicRealtimeCoeff = Math.min(1.1f, Math.max(0.9f, val));
        }

        public float getMagicCoeff() {
            return this.m_magicRealtimeCoeff;
        }

        public void setDirection(int direction) {
            this.m_direction = direction;
        }

        public int getDirection() {
            return this.m_direction;
        }

        public void play() {
            this.m_state = MetronomeState.Play;
        }

        public void pause() {
            this.m_state = MetronomeState.Pause;
        }

        public MetronomeState getState() {
            return this.m_state;
        }

        public void setSpeed(float value) {
            this.m_speed = value;
        }

        public float getSpeed() {
            return Math.min(this.m_speed, this.m_maxSpeed);
        }

        public float getMaxSpeed() {
            return this.m_maxSpeed;
        }

        public void setMaxSpeed(float value) {
            if (this.m_speed > value) {
                for (SinglePlayerSyncronizer p : PlayerGroup.this.m_syncronizers) {
                    p.setSpeed(value);
                    p.switchToPlaying();
                }
            }
            this.m_maxSpeed = value;
        }

        @Override
        public void run() {
            long realTime = new Date().getTime();
            long timeDiff = realTime - this.m_realTime;
            this.m_realTime = realTime;
            if (this.m_state == MetronomeState.Pause || PlayerGroup.this.m_context.getState() == ContextState.Live) {
                return;
            }
            PlayerGroup playerGroup = PlayerGroup.this;
            playerGroup.m_playingTime = playerGroup.m_playingTime + (long)((float)timeDiff * this.getSpeed() * this.m_magicRealtimeCoeff * (float)this.m_direction);
            PlayerGroup.this.controllerUpdate(new NewFrameEvent(PlayerGroup.this, PlayerGroup.this.m_playingTime, PlayerGroup.this.m_playingTime, PlayerGroup.this.m_playingTime));
            if (this.m_prevSpeedUpdate == 0L) {
                this.m_prevSpeedUpdate = realTime;
            }
            if (realTime - this.m_prevSpeedUpdate > 3000L) {
                int playerNum = 0;
                float magicRealTimeCoeff = 0.0f;
                for (SinglePlayerSyncronizer s : PlayerGroup.this.m_syncronizers) {
                    if (s.getState() == SinglePlayerSyncronizer.SyncState.Waiting || s.getSpeed() == 0.0f || s.getEmpiricSpeed() == 0.0f) continue;
                    magicRealTimeCoeff += s.getEmpiricSpeed() / s.getSpeed();
                    ++playerNum;
                }
                if (playerNum != 0) {
                    this.setMagicRealTimeCoeff(magicRealTimeCoeff /= (float)playerNum);
                }
                this.m_prevSpeedUpdate = realTime;
            }
            PlayerGroup.this.changeSupport.firePropertyChange("log", "", PlayerGroup.this.getLog());
        }
    }

    static enum MetronomeState {
        Play,
        Pause;

    }
}

