/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer;

import com.videonext.mplayer.api.IControllerListener;
import com.videonext.mplayer.api.IPlayer;
import com.videonext.mplayer.api.events.BufferChangedEvent;
import com.videonext.mplayer.api.events.ChangeStateEvent;
import com.videonext.mplayer.api.events.NewFrameEvent;
import com.videonext.mplayer.api.events.UIEvent;
import com.videonext.mplayer.internal.MediaPlayer;
import com.videonext.mplayer.internal.MediaPlayerListener;
import com.videonext.mplayer.internal.ScalablePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Player
extends JPanel
implements IPlayer {
    private static final long serialVersionUID = 1L;
    private MediaPlayer impl;
    private LinkedList<IControllerListener> listeners = new LinkedList();
    private Object id;
    private Map<String, Object> config;
    private JPanel previewPanel;
    private byte[] stillImage;
    private JLabel statusLabel;
    private JLabel statusIcon;

    public Player(Object id, Map<String, Object> config) {
        this.setBackground(new Color(0, 0, 0));
        this.id = id;
        this.config = config;
        try {
            this.impl = new MediaPlayer(id.toString());
            this.impl.setCacheSize(0);
            this.impl.setBackground(Color.BLACK);
            this.impl.setMediaPlayerListener(new MediaPlayerListenerImpl());
            if (config != null) {
                for (Map.Entry<String, Object> entry : this.config.entrySet()) {
                    this.impl.setParameter(entry.getKey(), entry.getValue().toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.impl.setBounds(new Rectangle(0, 0, 300, 200));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOverlay(boolean show) {
        Player player = this;
        synchronized (player) {
            if (show) {
                this.setupStatusOverlay();
            } else if (this.previewPanel != null) {
                this.removeStatusOverlay();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupStatusOverlay() {
        Player player = this;
        synchronized (player) {
            Image image = null;
            this.previewPanel = new JPanel();
            this.previewPanel.setBackground(Color.DARK_GRAY);
            this.previewPanel.setLayout(new BorderLayout());
            JPanel contentPanel = this.previewPanel;
            this.removeAll();
            this.add((Component)this.previewPanel, "Center");
            if (this.stillImage != null) {
                image = Toolkit.getDefaultToolkit().createImage(this.stillImage);
                JLabel picLabel = new JLabel();
                picLabel.setIcon(new ImageIcon(image));
                ScalablePane sp = new ScalablePane(image);
                sp.setBackground(Color.DARK_GRAY);
                this.previewPanel.add((Component)sp, "Center");
                contentPanel = sp;
            }
            BoxLayout layoutMgr = new BoxLayout(contentPanel, 0);
            contentPanel.setLayout(layoutMgr);
            ClassLoader cldr = this.getClass().getClassLoader();
            URL imageURL = cldr.getResource("img/spinner_white.gif");
            ImageIcon imageIcon = new ImageIcon(imageURL);
            this.statusIcon = new JLabel();
            this.statusIcon.setIcon(imageIcon);
            imageIcon.setImageObserver(this.statusIcon);
            this.statusLabel = new JLabel("  Connecting...");
            this.statusLabel.setForeground(Color.WHITE);
            contentPanel.add(Box.createHorizontalGlue());
            contentPanel.add(this.statusIcon);
            contentPanel.add(this.statusLabel);
            contentPanel.add(Box.createHorizontalGlue());
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStatusOverlay() {
        Player player = this;
        synchronized (player) {
            this.removeAll();
            this.add((Component)this.impl, "Center");
            this.impl.setBounds(this.getBounds());
            this.invalidate();
            this.repaint();
            this.previewPanel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String url) {
        Player player = this;
        synchronized (player) {
            this.updateOverlay(true);
            this.impl.setParameter("videoURL", url);
            this.impl.sendCommand("open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(int direction) {
        Player player = this;
        synchronized (player) {
            this.impl.setParameter("direction", Integer.toString(direction));
            this.impl.sendCommand("play");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Player player = this;
        synchronized (player) {
            this.impl.sendCommand("pause");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Player player = this;
        synchronized (player) {
            this.impl.sendCommand("stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Player player = this;
        synchronized (player) {
            this.removeAll();
            this.impl.sendCommand("stop");
        }
    }

    @Override
    public Container getOverlay() {
        return this.impl.getOverlay();
    }

    @Override
    public int getState() {
        return this.impl.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addControllerListener(IControllerListener listener) {
        LinkedList<IControllerListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeControllerListener(IControllerListener listener) {
        LinkedList<IControllerListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSpeed(float value) {
        Player player = this;
        synchronized (player) {
            this.impl.setParameter("streamSpeed", Float.toString(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeJitterBufferLen(int value) {
        Player player = this;
        synchronized (player) {
            this.impl.setParameter("jitterBuffer", Integer.toString(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jumpTo(Date date) {
        Player player = this;
        synchronized (player) {
            this.impl.setParameter("jump2timestamp", Long.toString(date.getTime() / 1000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStepMode(boolean flag) {
        Player player = this;
        synchronized (player) {
            this.impl.setParameter("stepMode", flag ? "1" : "0");
        }
    }

    @Override
    public void nextStep(int direction) {
    }

    @Override
    public void setBrightness(float value) {
    }

    @Override
    public void setAspectRation(int value) {
    }

    @Override
    public Object getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStillImage(byte[] img) {
        Player player = this;
        synchronized (player) {
            this.stillImage = img;
        }
    }

    @Override
    public void setMute(boolean val) {
        this.impl.setParameter("mute", val ? "on" : "off");
    }

    class MediaPlayerListenerImpl
    implements MediaPlayerListener {
        MediaPlayerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void statusChanged(int status, int resultCode, String resultMessage) {
            if (status == 3) {
                Player.this.statusLabel.setForeground(Color.RED);
                Player.this.statusLabel.setText("  " + Player.this.impl.getResultMsg());
                ClassLoader cldr = this.getClass().getClassLoader();
                URL imageURL = cldr.getResource("img/alarm_red.png");
                ImageIcon imageIcon = new ImageIcon(imageURL);
                Player.this.statusIcon.setIcon(imageIcon);
                imageIcon.setImageObserver(Player.this.statusIcon);
            } else if (status == 4) {
                Player.this.statusLabel.setText("  Openning...");
            } else if (status == 5) {
                Player.this.statusLabel.setText("  Buffering...");
            }
            LinkedList linkedList = Player.this.listeners;
            synchronized (linkedList) {
                ChangeStateEvent event = new ChangeStateEvent(Player.this, status, resultCode, resultMessage);
                for (IControllerListener listener : Player.this.listeners) {
                    listener.controllerUpdate(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void newFrame(long frameTimestamp, long bufStartTimestamp, long bufEndTimestamp, BufferedImage img) {
            if (Player.this.previewPanel != null) {
                Player.this.updateOverlay(false);
            }
            LinkedList linkedList = Player.this.listeners;
            synchronized (linkedList) {
                NewFrameEvent event = new NewFrameEvent(Player.this, frameTimestamp, bufStartTimestamp, bufEndTimestamp);
                for (IControllerListener listener : Player.this.listeners) {
                    listener.controllerUpdate(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bufferChanged(long startTimestamp, long endTimestamp) {
            LinkedList linkedList = Player.this.listeners;
            synchronized (linkedList) {
                BufferChangedEvent event = new BufferChangedEvent(Player.this, startTimestamp, endTimestamp);
                for (IControllerListener listener : Player.this.listeners) {
                    listener.controllerUpdate(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e, boolean isPlayerActive) {
            LinkedList linkedList = Player.this.listeners;
            synchronized (linkedList) {
                UIEvent event = new UIEvent(Player.this, 1);
                event.setMouseEvent(e);
                for (IControllerListener listener : Player.this.listeners) {
                    listener.controllerUpdate(event);
                }
            }
        }

        @Override
        public void snapshotFinished() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent e, boolean isPlayerActive) {
            LinkedList linkedList = Player.this.listeners;
            synchronized (linkedList) {
                UIEvent event = new UIEvent(Player.this, 0);
                event.setMouseEvent(e);
                for (IControllerListener listener : Player.this.listeners) {
                    listener.controllerUpdate(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseExit(MouseEvent e, boolean isPlayerActive) {
            LinkedList linkedList = Player.this.listeners;
            synchronized (linkedList) {
                UIEvent event = new UIEvent(Player.this, 2);
                event.setMouseEvent(e);
                for (IControllerListener listener : Player.this.listeners) {
                    listener.controllerUpdate(event);
                }
            }
        }

        @Override
        public boolean canDisplayFrame(Date date) {
            for (IControllerListener listener : Player.this.listeners) {
                if (listener.canDisplayFrame(date)) continue;
                return false;
            }
            return true;
        }
    }
}

