/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer;

import com.videonext.mplayer.PlayerGroup;
import com.videonext.mplayer.SinglePlayerSyncronizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class NetObserver {
    private final long ObserverPeriod = 5000L;
    private Timer m_observeTimer = new Timer();
    private States m_state = States.NormalBandwith;
    private ArrayList<PlayerGroup> m_playerGroups = new ArrayList();
    private HashMap<Object, Long> m_synchronizingPlayerTime = new HashMap();
    private float m_minPlayerSpeed = 0.0f;
    private float m_currentPlayerSpeed = 0.0f;
    private int m_lowBandwithStartPeriods = 0;
    private int m_searchingTopSpeedPeriods = 0;
    private SyncStateListener m_syncStateListener = new SyncStateListener();
    private static NetObserver m_netObserver = new NetObserver();

    private void setMinPlayerSpeed(float val) {
        this.m_minPlayerSpeed = Math.max(0.1f, val);
    }

    public void registerPlayer(SinglePlayerSyncronizer s) {
        s.addPropertyChangeListener("SyncState", this.m_syncStateListener);
    }

    private void updateMaxSpeed(float value) {
        for (PlayerGroup p : this.m_playerGroups) {
            p.getMetronome().setMaxSpeed(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalBandwith() {
        float latePlayerAvgSpeed = 0.0f;
        HashMap<Object, Long> hashMap = this.m_synchronizingPlayerTime;
        synchronized (hashMap) {
            Boolean isPlayersLate = false;
            for (Map.Entry<Object, Long> latePalyer : this.m_synchronizingPlayerTime.entrySet()) {
                if (new Date().getTime() - latePalyer.getValue() > 5000L) {
                    isPlayersLate = true;
                }
                latePlayerAvgSpeed += ((SinglePlayerSyncronizer)latePalyer.getKey()).getEmpiricSpeed();
            }
            if (this.m_synchronizingPlayerTime.size() > 0 && isPlayersLate.booleanValue()) {
                this.setMinPlayerSpeed((latePlayerAvgSpeed /= (float)this.m_synchronizingPlayerTime.size()) * 0.75f);
                this.updateMaxSpeed(this.m_minPlayerSpeed);
                this.m_state = States.LowBandwithStart;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowBandwithStart() {
        ArrayList<PlayerGroup> arrayList = this.m_playerGroups;
        synchronized (arrayList) {
            for (PlayerGroup p : this.m_playerGroups) {
                ArrayList<SinglePlayerSyncronizer> synchronizers;
                ArrayList<SinglePlayerSyncronizer> arrayList2 = synchronizers = p.getSynchronizers();
                synchronized (arrayList2) {
                    for (SinglePlayerSyncronizer s : synchronizers) {
                        if (s.getState() != SinglePlayerSyncronizer.SyncState.Synchronizing) continue;
                        if (this.m_searchingTopSpeedPeriods > 3) {
                            this.m_minPlayerSpeed *= 0.9f;
                            this.updateMaxSpeed(this.m_minPlayerSpeed);
                            this.m_lowBandwithStartPeriods = 0;
                            return;
                        }
                        ++this.m_searchingTopSpeedPeriods;
                        return;
                    }
                }
            }
        }
        this.m_lowBandwithStartPeriods = 0;
        this.m_currentPlayerSpeed = this.m_minPlayerSpeed;
        this.m_state = States.SearchingTopSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchingTopSpeed() {
        ArrayList<PlayerGroup> arrayList = this.m_playerGroups;
        synchronized (arrayList) {
            for (PlayerGroup p : this.m_playerGroups) {
                ArrayList<SinglePlayerSyncronizer> synchronizers;
                ArrayList<SinglePlayerSyncronizer> arrayList2 = synchronizers = p.getSynchronizers();
                synchronized (arrayList2) {
                    for (SinglePlayerSyncronizer s : synchronizers) {
                        if (s.getState() != SinglePlayerSyncronizer.SyncState.Synchronizing) continue;
                        if (this.m_lowBandwithStartPeriods > 1) {
                            this.m_currentPlayerSpeed = (this.m_currentPlayerSpeed + this.m_minPlayerSpeed) / 2.0f;
                            this.updateMaxSpeed(this.m_currentPlayerSpeed);
                            this.m_searchingTopSpeedPeriods = 0;
                            this.m_state = States.LowBandwithPlay;
                            return;
                        }
                        ++this.m_lowBandwithStartPeriods;
                        return;
                    }
                }
            }
        }
        this.m_currentPlayerSpeed = (float)((double)this.m_currentPlayerSpeed + 0.05);
        this.updateMaxSpeed(this.m_currentPlayerSpeed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowBandwithPlay() {
        int latePlayerCount = 0;
        float latePlayerAvgSpeed = 0.0f;
        ArrayList<PlayerGroup> arrayList = this.m_playerGroups;
        synchronized (arrayList) {
            for (PlayerGroup p : this.m_playerGroups) {
                ArrayList<SinglePlayerSyncronizer> synchronizers;
                ArrayList<SinglePlayerSyncronizer> arrayList2 = synchronizers = p.getSynchronizers();
                synchronized (arrayList2) {
                    for (SinglePlayerSyncronizer s : synchronizers) {
                        if ((double)(s.getEmpiricSpeed() / s.getSpeed()) > 0.5 || s.getState() != SinglePlayerSyncronizer.SyncState.Synchronizing) continue;
                        ++latePlayerCount;
                        latePlayerAvgSpeed += s.getEmpiricSpeed();
                    }
                }
            }
            if (latePlayerCount > 0) {
                this.setMinPlayerSpeed((latePlayerAvgSpeed /= (float)latePlayerCount) * 0.75f);
                this.updateMaxSpeed(this.m_minPlayerSpeed);
                this.m_state = States.LowBandwithStart;
            }
        }
    }

    protected NetObserver() {
        this.m_observeTimer.schedule((TimerTask)new ObserveTask(), 5000L, 5000L);
    }

    public static NetObserver get() {
        return m_netObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlayerGroup(PlayerGroup group) {
        ArrayList<PlayerGroup> arrayList = this.m_playerGroups;
        synchronized (arrayList) {
            this.m_playerGroups.add(group);
            for (SinglePlayerSyncronizer s : group.getSynchronizers()) {
                s.addPropertyChangeListener("SyncState", this.m_syncStateListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayerGroup(PlayerGroup group) {
        ArrayList<PlayerGroup> arrayList = this.m_playerGroups;
        synchronized (arrayList) {
            this.m_playerGroups.remove(group);
        }
    }

    public String getLog() {
        String state = "";
        switch (this.m_state) {
            case LowBandwithPlay: {
                state = "[LBP]";
                break;
            }
            case LowBandwithStart: {
                state = "[LBS]";
                break;
            }
            case NormalBandwith: {
                state = "[NB]";
                break;
            }
            case SearchingTopSpeed: {
                state = "[STS]";
            }
        }
        return String.format("%.3f. %.3f, %s", Float.valueOf(this.m_minPlayerSpeed), Float.valueOf(this.m_currentPlayerSpeed), state);
    }

    private class ObserveTask
    extends TimerTask {
        private ObserveTask() {
        }

        @Override
        public void run() {
            switch (NetObserver.this.m_state) {
                case LowBandwithPlay: {
                    NetObserver.this.lowBandwithPlay();
                    break;
                }
                case LowBandwithStart: {
                    NetObserver.this.lowBandwithStart();
                    break;
                }
                case NormalBandwith: {
                    NetObserver.this.normalBandwith();
                    break;
                }
                case SearchingTopSpeed: {
                    NetObserver.this.searchingTopSpeed();
                }
            }
        }
    }

    public static enum States {
        NormalBandwith,
        LowBandwithStart,
        SearchingTopSpeed,
        LowBandwithPlay;

    }

    class SyncStateListener
    implements PropertyChangeListener {
        SyncStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getNewValue() instanceof SinglePlayerSyncronizer.SyncState)) {
                return;
            }
            SinglePlayerSyncronizer.SyncState newState = (SinglePlayerSyncronizer.SyncState)((Object)evt.getNewValue());
            HashMap hashMap = NetObserver.this.m_synchronizingPlayerTime;
            synchronized (hashMap) {
                if (newState == SinglePlayerSyncronizer.SyncState.Synchronizing) {
                    NetObserver.this.m_synchronizingPlayerTime.put(evt.getSource(), new Date().getTime());
                } else {
                    NetObserver.this.m_synchronizingPlayerTime.remove(evt.getSource());
                }
            }
        }
    }
}

