/*
 * Decompiled with CFR 0.152.
 */
package com.videonext.mplayer;

import com.videonext.mplayer.api.ICapturer;
import com.videonext.mplayer.api.ICapturerURLProvider;
import com.videonext.mplayer.api.IControllerListener;
import com.videonext.mplayer.api.events.CapturerEvent;
import com.videonext.mplayer.internal.NativeHelper;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.LinkedList;
import java.util.List;

public class Capturer
implements ICapturer {
    private ICapturerURLProvider urlProvider;
    private long captureId;
    private boolean isRunning = false;
    private Thread captureThread;
    private LinkedList<IControllerListener> listeners = new LinkedList();
    private BufferedImage previewImage;
    private byte[] previewBuffer;
    private int previewWidth = 0;
    private int previewHeight = 0;

    static {
        String playerVersion = NativeHelper.getPlayerVersion();
        if (playerVersion == null) {
            System.err.println("Player version is not set");
        }
        String nativeLibName = null;
        String sys = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        if (sys == null) {
            System.err.println("Unable to identify your OS");
        }
        nativeLibName = sys.startsWith("Windows") ? (arch.startsWith("x86") ? "VNMediaClient.dll" : "VNMediaClient-64.dll") : (System.getProperty("mrj.version") != null || sys.startsWith("Mac") ? "libVNMediaClient.dylib" : (arch.startsWith("x86") ? "libVNMediaClient.so" : "libVNMediaClient-64.so"));
        try {
            NativeHelper.loadFromJar(playerVersion, nativeLibName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws Exception {
        this.captureId = this.nativeInit();
    }

    @Override
    public List<String> getVideoDevices() throws Exception {
        if (this.captureId == 0L) {
            throw new Exception("Capturing is not initialized");
        }
        return this.nativeGetVideoDevices(this.captureId);
    }

    @Override
    public List<String> getAudioDevices() throws Exception {
        if (this.captureId == 0L) {
            throw new Exception("Capturing is not initialized");
        }
        return this.nativeGetAudioDevices(this.captureId);
    }

    @Override
    public List<String> getVideoParams(String videoDevice) throws Exception {
        if (this.captureId == 0L) {
            throw new Exception("Capturing is not initialized");
        }
        return this.nativeGetVideoParams(this.captureId, videoDevice);
    }

    @Override
    public void start(String audioDevice, String videoDevice, String videoParams, int bitRate) throws Exception {
        if (this.captureId == 0L) {
            throw new Exception("Capturing is not initialized");
        }
        if (this.isRunning) {
            throw new Exception("Capturing already running");
        }
        if (this.captureThread != null) {
            System.err.println("Waitong for pending capturing task");
            this.captureThread.join();
        }
        this.isRunning = true;
        this.captureThread = new CaptureThread(audioDevice, videoDevice, videoParams, bitRate);
        this.captureThread.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.captureId == 0L) {
            throw new Exception("Capturing is not initialized");
        }
        if (!this.isRunning) {
            throw new Exception("Capturing already stoped");
        }
        this.isRunning = false;
        this.nativeStopCapture(this.captureId);
    }

    @Override
    public void setURLProvider(ICapturerURLProvider provider) {
        this.urlProvider = provider;
    }

    @Override
    public byte[] getPreviewBuffer() {
        return this.previewBuffer;
    }

    @Override
    public int getPreviewWidth() {
        return this.previewWidth;
    }

    @Override
    public int getPreviewHeight() {
        return this.previewHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(int errorCode, String errorMessage) {
        LinkedList<IControllerListener> linkedList = this.listeners;
        synchronized (linkedList) {
            CapturerEvent event = new CapturerEvent(this, true, errorMessage, null);
            for (IControllerListener listener : this.listeners) {
                listener.controllerUpdate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAudioStats(short[] samples) {
        LinkedList<IControllerListener> linkedList = this.listeners;
        synchronized (linkedList) {
            CapturerEvent event = new CapturerEvent(this, false, null, samples);
            for (IControllerListener listener : this.listeners) {
                listener.controllerUpdate(event);
            }
        }
    }

    private byte[] createPreviewBuffer(int width, int height) {
        this.previewWidth = width;
        this.previewHeight = height;
        this.previewImage = new BufferedImage(width, height, 5);
        this.previewBuffer = ((DataBufferByte)this.previewImage.getRaster().getDataBuffer()).getData();
        return this.previewBuffer;
    }

    public BufferedImage getPreviewImage() {
        return this.previewImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addControllerListener(IControllerListener listener) {
        LinkedList<IControllerListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeControllerListener(IControllerListener listener) {
        LinkedList<IControllerListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    private native long nativeInit();

    private native List<String> nativeGetVideoDevices(long var1);

    private native List<String> nativeGetAudioDevices(long var1);

    private native List<String> nativeGetVideoParams(long var1, String var3);

    private native long nativeStartCapture(long var1, String var3, String var4, String var5, String var6, int var7);

    private native long nativeStopCapture(long var1);

    class CaptureThread
    extends Thread {
        private String audioDevice;
        private String videoDevice;
        private String videoParams;
        private int bitRate;

        public CaptureThread(String audioDevice, String videoDevice, String videoParams, int bitRate) {
            this.audioDevice = audioDevice;
            this.videoDevice = videoDevice;
            this.videoParams = videoParams;
            this.bitRate = bitRate;
        }

        @Override
        public void run() {
            while (Capturer.this.isRunning) {
                String url = Capturer.this.urlProvider.getURL();
                try {
                    Capturer.this.nativeStartCapture(Capturer.this.captureId, this.audioDevice, this.videoDevice, this.videoParams, url, this.bitRate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Capturer.this.isRunning) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!Capturer.this.isRunning) continue;
                System.err.println("Restarting capturing");
            }
        }
    }
}

