/*
 * Decompiled with CFR 0.152.
 */
package com.videonext;

import android.util.Log;

public class MediaStreamer {
    private long id = 0L;

    static {
        System.loadLibrary("VNMediaClient-jni");
    }

    private native long nativeInit(String var1, int var2, int var3);

    private native void nativeDestroy(long var1);

    private native int nativeSendVideo(long var1, byte[] var3, float var4, float var5, float var6);

    public void init(String url, int width, int height) throws Exception {
        try {
            this.id = this.nativeInit(url, width, height);
        }
        catch (Exception e) {
            Log.e((String)"--", (String)e.getMessage());
        }
        if (this.id == 0L) {
            throw new Exception("Streamer initialization failed");
        }
    }

    public void destroy() {
        if (this.id != 0L) {
            this.nativeDestroy(this.id);
            this.id = 0L;
        }
    }

    public void sendVideoFrame(byte[] img, float gpsLat, float gpsLong, float gpsAlt) throws Exception {
        if (this.id == 0L) {
            throw new Exception("Streamer not ready");
        }
        int ret = this.nativeSendVideo(this.id, img, gpsLat, gpsLong, gpsAlt);
        if (ret != 0) {
            throw new Exception("Failed to send video frame. Error: " + ret);
        }
    }
}

