/*
 * Decompiled with CFR 0.152.
 */
package com.videonext;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.Log;
import android.view.View;

public class MediaPlayer {
    private long playerId = 0L;
    private String resultMsg = "";
    private int resultCode = 0;
    private int[] imgBuf = null;
    private View contentView = null;
    private int width = 0;
    private int height = 0;
    private int timeSecond;
    private int timeUSecond;
    private ObjectsTracker objsTracker = null;

    static {
        System.loadLibrary("VNMediaClient-jni");
    }

    private native long nativePlay(String var1);

    private native void nativeStop(long var1);

    private native void nativePause(long var1);

    private native void nativeJump(long var1, int var3);

    private native void nativeResume(long var1, int var3);

    public MediaPlayer(View view) {
        this.contentView = view;
        this.width = 0;
        this.height = 0;
    }

    public void play(String url) {
        this.playerId = this.nativePlay(url);
    }

    public void stop() {
        if (this.playerId != 0L) {
            this.nativeStop(this.playerId);
            this.playerId = 0L;
        }
    }

    public void pause() {
        if (this.playerId != 0L) {
            this.nativePause(this.playerId);
        }
    }

    public void jump(int timestamp) {
        if (this.playerId != 0L) {
            this.nativeJump(this.playerId, timestamp);
        }
    }

    public long getTimeSecond() {
        return this.timeSecond;
    }

    public long getTimeUSecond() {
        return this.timeUSecond;
    }

    private int[] allocImageBuf(int width, int height) {
        this.width = width;
        this.height = height;
        this.imgBuf = new int[width * height];
        return this.imgBuf;
    }

    private void onStateChanged(int state, int resultCode, String resultString) {
    }

    private void onNewVideoFrame(int[] frame, int width, int height, byte[] objsData, int timeSec, int timeUSec) {
        if (objsData != null && objsData.length != 0) {
            this.objsTracker = new ObjectsTracker(objsData);
        }
        this.contentView.postInvalidate();
        this.timeSecond = timeSec;
        this.timeUSecond = timeUSec;
    }

    private Bitmap getResizedBitmap(Bitmap bm, int newHeight, int newWidth) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        return resizedBitmap;
    }

    private Bitmap resizeImage(Bitmap bm, int maxHeight, int maxWidth) {
        return this.resizeImage(bm, maxHeight, maxWidth, ScaleMode.FillStretch);
    }

    private Bitmap resizeImage(Bitmap bm, int maxHeight, int maxWidth, ScaleMode mode) {
        int newImgHeight = bm.getHeight();
        int newImgWidth = bm.getWidth();
        switch (mode) {
            case FillStretch: {
                newImgHeight = maxHeight;
                newImgWidth = maxWidth;
                break;
            }
            case FillProportional: {
                float ratio = Math.min((float)maxWidth / (float)bm.getWidth(), (float)maxHeight / (float)bm.getHeight());
                newImgWidth = Math.round(ratio * (float)bm.getWidth());
                newImgHeight = Math.round(ratio * (float)bm.getHeight());
            }
        }
        return this.getResizedBitmap(bm, newImgHeight, newImgWidth);
    }

    public void paint(Canvas canvas, int headerHeight, int screenWidth, int screenHeight) {
        if (this.imgBuf == null) {
            return;
        }
        Bitmap origImg = Bitmap.createBitmap((int[])this.imgBuf, (int)0, (int)this.width, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Bitmap newBitmap = this.resizeImage(origImg, canvas.getHeight() - headerHeight, canvas.getWidth(), ScaleMode.FillProportional);
        if (this.objsTracker != null) {
            this.objsTracker.parseAndDraw(new Canvas(newBitmap));
        }
        canvas.drawBitmap(newBitmap, (float)((screenWidth - newBitmap.getWidth()) / 2), 0.0f, null);
    }

    class ObjectsTracker {
        private byte[] bitstream;
        private int offset;
        private int length;
        private int bufa;
        private int bufb;
        private int position = 0;
        private int objID = -1;
        private int objDrawType = 0;
        private float objXcoord = 0.0f;
        private float objYcoord = 0.0f;
        private float objWidth = 0.0f;
        private float objHeight = 0.0f;
        private int objColor = -1;
        private int objEndColor = -1;
        private int objLineWidth = 2;
        private int arrowHead = 8;
        private String text = null;
        private float[] xPoints;
        private float[] yPoints;
        private int nPoints;
        private float[] xTripPoints;
        private float[] yTripPoints;
        private static final byte OBJ_SEQUENCE_START_CODE = 10;
        private static final byte OBJ_START_CODE = 1;
        private static final byte OBJ_DRAW_TYPE_START_CODE = 2;
        private static final byte OBJ_X_COORD_START_CODE = 3;
        private static final byte OBJ_Y_COORD_START_CODE = 4;
        private static final byte OBJ_HEIGHT_START_CODE = 5;
        private static final byte OBJ_WIDTH_START_CODE = 6;
        private static final byte OBJ_COLOR_START_CODE = 7;
        private static final byte OBJ_LINEWIDTH_START_CODE = 8;
        private static final byte OBJ_TEXT_START_CODE = 9;
        private static final byte OBJ_POLYDATA_START_CODE = 11;
        private static final byte OBJ_ARROWHEADSIZE_START_CODE = 12;
        private static final byte OBJ_SEQUENCE_END_START_CODE = 127;
        private static final byte OBJ_DRAW_TYPE_BOX = 1;
        private static final byte OBJ_DRAW_TYPE_MLINE = 2;
        private static final byte OBJ_DRAW_TYPE_TEXT = 3;
        private static final byte OBJ_DRAW_TYPE_TIMESTAMP = 4;
        private static final byte OBJ_DRAW_TYPE_POLYGON = 5;
        private static final byte OBJ_DRAW_TYPE_TRIPWIRE_ARROW = 6;
        private static final byte OBJ_DRAW_TYPE_ARROW = 7;
        private static final byte OBJ_DRAW_TYPE_OVAL = 8;
        private static final int METADATA_TAGID = 65535;

        public ObjectsTracker(byte[] bitstream) {
            this.bitstream = bitstream;
            this.xTripPoints = new float[2];
            this.yTripPoints = new float[2];
        }

        private void skipBits(int bits) {
            this.position += bits;
            if (this.position >= 32) {
                this.bufa = this.bufb;
                try {
                    this.bufb = (this.bitstream[this.offset + 0] & 0xFF) << 24;
                    this.bufb |= (this.bitstream[this.offset + 1] & 0xFF) << 16;
                    this.bufb |= (this.bitstream[this.offset + 2] & 0xFF) << 8;
                    this.bufb |= this.bitstream[this.offset + 3] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                this.offset += 4;
                this.position -= 32;
            }
        }

        private int showBits(int bits) {
            if (this.offset > this.length + 8) {
                Log.e((String)"MediaPlayer", (String)"Broken objects data!!!");
                return -1;
            }
            int nbit = bits + this.position - 32;
            if (nbit > 0) {
                return (this.bufa & -1 >>> this.position) << nbit | this.bufb >>> 32 - nbit;
            }
            return (this.bufa & -1 >>> this.position) >>> 32 - this.position - bits;
        }

        private int getBits(int n) {
            int ret = this.showBits(n);
            this.skipBits(n);
            return ret;
        }

        private String getText() {
            int size = this.getBits(8);
            byte[] text = new byte[size];
            int i = 0;
            while (i < size) {
                text[i] = (byte)this.getBits(8);
                ++i;
            }
            return new String(text);
        }

        private void fillPolygonData() {
            this.nPoints = this.getBits(8);
            this.xPoints = new float[this.nPoints];
            this.yPoints = new float[this.nPoints];
            int i = 0;
            while (i < this.nPoints) {
                this.xPoints[i] = this.getBits(16);
                this.yPoints[i] = this.getBits(16);
                ++i;
            }
            if (this.nPoints == 2) {
                i = 0;
                while (i < this.nPoints) {
                    this.xTripPoints[i] = this.xPoints[i];
                    this.yTripPoints[i] = this.yPoints[i];
                    ++i;
                }
            }
        }

        public void parseAndDraw(Canvas c) {
            this.objEndColor = -1;
            this.objID = -1;
            this.position = 0;
            this.offset = 0;
            this.length = this.bitstream.length;
            try {
                this.bufa = (this.bitstream[this.offset + 0] & 0xFF) << 24;
                this.bufa |= (this.bitstream[this.offset + 1] & 0xFF) << 16;
                this.bufa |= (this.bitstream[this.offset + 2] & 0xFF) << 8;
                this.bufa |= this.bitstream[this.offset + 3] & 0xFF;
                this.bufb = (this.bitstream[this.offset + 4] & 0xFF) << 24;
                this.bufb |= (this.bitstream[this.offset + 5] & 0xFF) << 16;
                this.bufb |= (this.bitstream[this.offset + 6] & 0xFF) << 8;
                this.bufb |= this.bitstream[this.offset + 7] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.offset += 8;
            boolean done = false;
            boolean bEndColor = false;
            while (!done) {
                switch (this.getBits(8)) {
                    case 10: {
                        break;
                    }
                    case 1: {
                        if (this.objID != -1) {
                            this.drawObject(c);
                        }
                        this.objID = this.getBits(16);
                        this.objLineWidth = 2;
                        this.arrowHead = 8;
                        bEndColor = false;
                        break;
                    }
                    case 2: {
                        this.objDrawType = this.getBits(8);
                        break;
                    }
                    case 3: {
                        this.objXcoord = this.getBits(16);
                        break;
                    }
                    case 4: {
                        this.objYcoord = this.getBits(16);
                        break;
                    }
                    case 5: {
                        this.objHeight = this.getBits(16);
                        break;
                    }
                    case 6: {
                        this.objWidth = this.getBits(16);
                        break;
                    }
                    case 7: {
                        if (bEndColor) {
                            this.objEndColor = this.getBits(32);
                            break;
                        }
                        this.objColor = this.getBits(32);
                        bEndColor = true;
                        break;
                    }
                    case 8: {
                        this.objLineWidth = this.getBits(8);
                        break;
                    }
                    case 12: {
                        this.arrowHead = this.getBits(8);
                        break;
                    }
                    case 9: {
                        this.text = this.getText();
                        break;
                    }
                    case 11: {
                        this.fillPolygonData();
                        break;
                    }
                    case 127: {
                        if (this.objID != -1) {
                            this.drawObject(c);
                        }
                        done = true;
                    }
                }
            }
        }

        private void drawObject(Canvas c) {
            float zoomW = (float)c.getWidth() / (float)MediaPlayer.this.width;
            float zoomH = (float)c.getHeight() / (float)MediaPlayer.this.height;
            Paint paint = new Paint();
            paint.setColor(this.objColor);
            switch (this.objDrawType) {
                case 1: {
                    paint.setStrokeWidth((float)this.objLineWidth);
                    paint.setStyle(Paint.Style.STROKE);
                    float left = this.objXcoord - this.objWidth / 2.0f;
                    float top = this.objYcoord - this.objHeight / 2.0f;
                    float right = left + this.objWidth;
                    float bottom = top + this.objHeight;
                    c.drawRect(left * zoomW, top * zoomH, right * zoomW, bottom * zoomH, paint);
                    break;
                }
                case 8: {
                    paint.setStrokeWidth((float)this.objLineWidth);
                    paint.setStyle(Paint.Style.STROKE);
                    float left = (this.objXcoord - this.objWidth / 2.0f) * zoomW;
                    float top = (this.objYcoord - this.objHeight / 2.0f) * zoomH;
                    float right = left + this.objWidth * zoomW;
                    float bottom = top + this.objHeight * zoomH;
                    c.drawOval(new RectF(left, top, right, bottom), paint);
                    break;
                }
                case 2: 
                case 5: {
                    int i = 0;
                    while (i < this.nPoints) {
                        this.xPoints[i] = this.xPoints[i] * zoomW;
                        this.yPoints[i] = this.yPoints[i] * zoomH;
                        ++i;
                    }
                    if (this.objDrawType == 2) {
                        if (this.objColor < 0 || this.objEndColor < 0) {
                            Log.i((String)"MediaPlayer", (String)("OBJ_DRAW_TYPE_MLINE. nPoints=" + this.nPoints + " color=" + this.objColor));
                            paint.setStyle(Paint.Style.STROKE);
                            paint.setAntiAlias(true);
                            Path path = new Path();
                            path.moveTo(this.xPoints[0], this.yPoints[0]);
                            int i2 = 1;
                            while (i2 < this.nPoints) {
                                path.lineTo(this.xPoints[i2], this.yPoints[i2]);
                                ++i2;
                            }
                            path.lineTo(this.xPoints[0], this.yPoints[0]);
                            path.close();
                            c.drawPath(path, paint);
                        }
                    } else {
                        Log.i((String)"MediaPlayer", (String)("OBJ_DRAW_TYPE_POLYGON. nPoints=" + this.nPoints + " color=" + this.objColor));
                        paint.setStyle(Paint.Style.FILL);
                        paint.setAntiAlias(true);
                        Path path = new Path();
                        path.moveTo(this.xPoints[0], this.yPoints[0]);
                        int i3 = 1;
                        while (i3 < this.nPoints) {
                            path.lineTo(this.xPoints[i3], this.yPoints[i3]);
                            ++i3;
                        }
                        path.lineTo(this.xPoints[0], this.yPoints[0]);
                        path.close();
                        c.drawPath(path, paint);
                    }
                    this.objEndColor = -1;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleMode {
        FillStretch,
        FillProportional,
        OriginalSize;

    }
}

