DROP SCHEMA IF EXISTS toolkit_experimental CASCADE;
-- drop the EVENT TRIGGERs; there's no CREATE OR REPLACE for those
        DROP EVENT TRIGGER IF EXISTS disallow_experimental_deps CASCADE;
DROP EVENT TRIGGER IF EXISTS disallow_experimental_dependencies_on_views CASCADE;
DROP FUNCTION IF EXISTS disallow_experimental_dependencies();
DROP FUNCTION IF EXISTS disallow_experimental_view_dependencies();
DROP FUNCTION IF EXISTS timescaledb_toolkit_probe;
/* <begin connected objects> */
/*
This file is auto generated by pgrx.

The ordering of items is not stable, it is driven by a dependency graph.
*/
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/raw.rs:8
-- bootstrap
-- creates:
--   Type(timescaledb_toolkit::raw::bytea)
--   Type(timescaledb_toolkit::raw::text)
--   Type(timescaledb_toolkit::raw::TimestampTz)
--   Type(timescaledb_toolkit::raw::AnyElement)
--   Type(timescaledb_toolkit::raw::tstzrange)
--   Type(timescaledb_toolkit::raw::Interval)
--   Type(timescaledb_toolkit::raw::regproc)


CREATE SCHEMA toolkit_experimental;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/utilities.rs:91

CREATE OR REPLACE FUNCTION days_in_month(date timestamptz) RETURNS int
SET search_path TO pg_catalog,pg_temp
AS $$
SELECT CAST(EXTRACT('day' FROM ($1 + interval '1 month' - $1)) as INTEGER)
$$ LANGUAGE SQL STRICT IMMUTABLE PARALLEL SAFE;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/utilities.rs:103

CREATE OR REPLACE FUNCTION month_normalize(metric float8, reference_date timestamptz, days float8 DEFAULT 365.25/12) RETURNS float8
SET search_path TO pg_catalog,pg_temp
AS $$
SELECT metric * days / CAST(EXTRACT('day' FROM (reference_date + interval '1 month' - reference_date)) as INTEGER)
$$ LANGUAGE SQL STRICT IMMUTABLE PARALLEL SAFE;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/utilities.rs:115

CREATE OR REPLACE FUNCTION to_epoch(timestamptz) RETURNS DOUBLE PRECISION LANGUAGE SQL IMMUTABLE PARALLEL SAFE
SET search_path TO pg_catalog,pg_temp
AS $$
SELECT EXTRACT(EPOCH FROM $1);
$$;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/range.rs:139

CREATE FUNCTION toolkit_experimental.time_bucket_range( bucket_width interval, ts timestamptz)
RETURNS tstzrange as $$
SELECT tstzrange(time_bucket(bucket_width, ts), time_bucket(bucket_width, ts + bucket_width), '[)');
$$
LANGUAGE SQL IMMUTABLE PARALLEL SAFE;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:51
-- timescaledb_toolkit::accessors::AccessorApproxPercentile

-- extension/src/accessors.rs:51
-- timescaledb_toolkit::accessors::accessorapproxpercentile_in
CREATE OR REPLACE FUNCTION "accessorapproxpercentile_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorApproxPercentile /* core::option::Option<timescaledb_toolkit::accessors::AccessorApproxPercentile> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorapproxpercentile_in_wrapper';

-- extension/src/accessors.rs:51
-- timescaledb_toolkit::accessors::accessorapproxpercentile_out
CREATE OR REPLACE FUNCTION "accessorapproxpercentile_out"(
	"input" AccessorApproxPercentile /* timescaledb_toolkit::accessors::AccessorApproxPercentile */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorapproxpercentile_out_wrapper';

-- extension/src/accessors.rs:51
-- timescaledb_toolkit::accessors::AccessorApproxPercentile

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:55
-- timescaledb_toolkit::accessors::AccessorApproxPercentileRank

-- extension/src/accessors.rs:55
-- timescaledb_toolkit::accessors::accessorapproxpercentilerank_in
CREATE OR REPLACE FUNCTION "accessorapproxpercentilerank_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorApproxPercentileRank /* core::option::Option<timescaledb_toolkit::accessors::AccessorApproxPercentileRank> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorapproxpercentilerank_in_wrapper';

-- extension/src/accessors.rs:55
-- timescaledb_toolkit::accessors::accessorapproxpercentilerank_out
CREATE OR REPLACE FUNCTION "accessorapproxpercentilerank_out"(
	"input" AccessorApproxPercentileRank /* timescaledb_toolkit::accessors::AccessorApproxPercentileRank */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorapproxpercentilerank_out_wrapper';

-- extension/src/accessors.rs:55
-- timescaledb_toolkit::accessors::AccessorApproxPercentileRank

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:64
-- timescaledb_toolkit::accessors::AccessorAverage

-- extension/src/accessors.rs:64
-- timescaledb_toolkit::accessors::accessoraverage_in
CREATE OR REPLACE FUNCTION "accessoraverage_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorAverage /* core::option::Option<timescaledb_toolkit::accessors::AccessorAverage> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoraverage_in_wrapper';

-- extension/src/accessors.rs:64
-- timescaledb_toolkit::accessors::accessoraverage_out
CREATE OR REPLACE FUNCTION "accessoraverage_out"(
	"input" AccessorAverage /* timescaledb_toolkit::accessors::AccessorAverage */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoraverage_out_wrapper';

-- extension/src/accessors.rs:64
-- timescaledb_toolkit::accessors::AccessorAverage

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:65
-- timescaledb_toolkit::accessors::AccessorAverageX

-- extension/src/accessors.rs:65
-- timescaledb_toolkit::accessors::accessoraveragex_in
CREATE OR REPLACE FUNCTION "accessoraveragex_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorAverageX /* core::option::Option<timescaledb_toolkit::accessors::AccessorAverageX> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoraveragex_in_wrapper';

-- extension/src/accessors.rs:65
-- timescaledb_toolkit::accessors::accessoraveragex_out
CREATE OR REPLACE FUNCTION "accessoraveragex_out"(
	"input" AccessorAverageX /* timescaledb_toolkit::accessors::AccessorAverageX */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoraveragex_out_wrapper';

-- extension/src/accessors.rs:65
-- timescaledb_toolkit::accessors::AccessorAverageX

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:66
-- timescaledb_toolkit::accessors::AccessorAverageY

-- extension/src/accessors.rs:66
-- timescaledb_toolkit::accessors::accessoraveragey_in
CREATE OR REPLACE FUNCTION "accessoraveragey_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorAverageY /* core::option::Option<timescaledb_toolkit::accessors::AccessorAverageY> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoraveragey_in_wrapper';

-- extension/src/accessors.rs:66
-- timescaledb_toolkit::accessors::accessoraveragey_out
CREATE OR REPLACE FUNCTION "accessoraveragey_out"(
	"input" AccessorAverageY /* timescaledb_toolkit::accessors::AccessorAverageY */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoraveragey_out_wrapper';

-- extension/src/accessors.rs:66
-- timescaledb_toolkit::accessors::AccessorAverageY

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:93
-- timescaledb_toolkit::accessors::AccessorClose
CREATE TYPE AccessorClose;

-- extension/src/accessors.rs:93
-- timescaledb_toolkit::accessors::accessorclose_in
CREATE FUNCTION "accessorclose_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorClose /* core::option::Option<timescaledb_toolkit::accessors::AccessorClose> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorclose_in_wrapper';

-- extension/src/accessors.rs:93
-- timescaledb_toolkit::accessors::accessorclose_out
CREATE FUNCTION "accessorclose_out"(
	"input" AccessorClose /* timescaledb_toolkit::accessors::AccessorClose */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorclose_out_wrapper';

-- extension/src/accessors.rs:93
-- timescaledb_toolkit::accessors::AccessorClose
CREATE TYPE AccessorClose (
	INTERNALLENGTH = variable,
	INPUT = accessorclose_in, /* timescaledb_toolkit::accessors::accessorclose_in */
	OUTPUT = accessorclose_out, /* timescaledb_toolkit::accessors::accessorclose_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:99
-- timescaledb_toolkit::accessors::AccessorCloseTime
CREATE TYPE AccessorCloseTime;

-- extension/src/accessors.rs:99
-- timescaledb_toolkit::accessors::accessorclosetime_in
CREATE FUNCTION "accessorclosetime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorCloseTime /* core::option::Option<timescaledb_toolkit::accessors::AccessorCloseTime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorclosetime_in_wrapper';

-- extension/src/accessors.rs:99
-- timescaledb_toolkit::accessors::accessorclosetime_out
CREATE FUNCTION "accessorclosetime_out"(
	"input" AccessorCloseTime /* timescaledb_toolkit::accessors::AccessorCloseTime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorclosetime_out_wrapper';

-- extension/src/accessors.rs:99
-- timescaledb_toolkit::accessors::AccessorCloseTime
CREATE TYPE AccessorCloseTime (
	INTERNALLENGTH = variable,
	INPUT = accessorclosetime_in, /* timescaledb_toolkit::accessors::accessorclosetime_in */
	OUTPUT = accessorclosetime_out, /* timescaledb_toolkit::accessors::accessorclosetime_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:71
-- timescaledb_toolkit::accessors::AccessorCorr

-- extension/src/accessors.rs:71
-- timescaledb_toolkit::accessors::accessorcorr_in
CREATE OR REPLACE FUNCTION "accessorcorr_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorCorr /* core::option::Option<timescaledb_toolkit::accessors::AccessorCorr> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorcorr_in_wrapper';

-- extension/src/accessors.rs:71
-- timescaledb_toolkit::accessors::accessorcorr_out
CREATE OR REPLACE FUNCTION "accessorcorr_out"(
	"input" AccessorCorr /* timescaledb_toolkit::accessors::AccessorCorr */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorcorr_out_wrapper';

-- extension/src/accessors.rs:71
-- timescaledb_toolkit::accessors::AccessorCorr

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:87
-- timescaledb_toolkit::accessors::AccessorCounterZeroTime

-- extension/src/accessors.rs:87
-- timescaledb_toolkit::accessors::accessorcounterzerotime_in
CREATE OR REPLACE FUNCTION "accessorcounterzerotime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorCounterZeroTime /* core::option::Option<timescaledb_toolkit::accessors::AccessorCounterZeroTime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorcounterzerotime_in_wrapper';

-- extension/src/accessors.rs:87
-- timescaledb_toolkit::accessors::accessorcounterzerotime_out
CREATE OR REPLACE FUNCTION "accessorcounterzerotime_out"(
	"input" AccessorCounterZeroTime /* timescaledb_toolkit::accessors::AccessorCounterZeroTime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorcounterzerotime_out_wrapper';

-- extension/src/accessors.rs:87
-- timescaledb_toolkit::accessors::AccessorCounterZeroTime

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:416
-- timescaledb_toolkit::accessors::AccessorCovar

-- extension/src/accessors.rs:416
-- timescaledb_toolkit::accessors::accessorcovar_in
CREATE OR REPLACE FUNCTION "accessorcovar_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorCovar /* core::option::Option<timescaledb_toolkit::accessors::AccessorCovar> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorcovar_in_wrapper';

-- extension/src/accessors.rs:416
-- timescaledb_toolkit::accessors::accessorcovar_out
CREATE OR REPLACE FUNCTION "accessorcovar_out"(
	"input" AccessorCovar /* timescaledb_toolkit::accessors::AccessorCovar */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorcovar_out_wrapper';

-- extension/src/accessors.rs:416
-- timescaledb_toolkit::accessors::AccessorCovar

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:101
-- timescaledb_toolkit::accessors::AccessorDeadRanges
CREATE TYPE AccessorDeadRanges;

-- extension/src/accessors.rs:101
-- timescaledb_toolkit::accessors::accessordeadranges_in
CREATE FUNCTION "accessordeadranges_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDeadRanges /* core::option::Option<timescaledb_toolkit::accessors::AccessorDeadRanges> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordeadranges_in_wrapper';

-- extension/src/accessors.rs:101
-- timescaledb_toolkit::accessors::accessordeadranges_out
CREATE FUNCTION "accessordeadranges_out"(
	"input" AccessorDeadRanges /* timescaledb_toolkit::accessors::AccessorDeadRanges */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordeadranges_out_wrapper';

-- extension/src/accessors.rs:101
-- timescaledb_toolkit::accessors::AccessorDeadRanges
CREATE TYPE AccessorDeadRanges (
	INTERNALLENGTH = variable,
	INPUT = accessordeadranges_in, /* timescaledb_toolkit::accessors::accessordeadranges_in */
	OUTPUT = accessordeadranges_out, /* timescaledb_toolkit::accessors::accessordeadranges_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:77
-- timescaledb_toolkit::accessors::AccessorDelta

-- extension/src/accessors.rs:77
-- timescaledb_toolkit::accessors::accessordelta_in
CREATE OR REPLACE FUNCTION "accessordelta_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDelta /* core::option::Option<timescaledb_toolkit::accessors::AccessorDelta> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordelta_in_wrapper';

-- extension/src/accessors.rs:77
-- timescaledb_toolkit::accessors::accessordelta_out
CREATE OR REPLACE FUNCTION "accessordelta_out"(
	"input" AccessorDelta /* timescaledb_toolkit::accessors::AccessorDelta */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordelta_out_wrapper';

-- extension/src/accessors.rs:77
-- timescaledb_toolkit::accessors::AccessorDelta

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:74
-- timescaledb_toolkit::accessors::AccessorDeterminationCoeff

-- extension/src/accessors.rs:74
-- timescaledb_toolkit::accessors::accessordeterminationcoeff_in
CREATE OR REPLACE FUNCTION "accessordeterminationcoeff_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDeterminationCoeff /* core::option::Option<timescaledb_toolkit::accessors::AccessorDeterminationCoeff> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordeterminationcoeff_in_wrapper';

-- extension/src/accessors.rs:74
-- timescaledb_toolkit::accessors::accessordeterminationcoeff_out
CREATE OR REPLACE FUNCTION "accessordeterminationcoeff_out"(
	"input" AccessorDeterminationCoeff /* timescaledb_toolkit::accessors::AccessorDeterminationCoeff */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordeterminationcoeff_out_wrapper';

-- extension/src/accessors.rs:74
-- timescaledb_toolkit::accessors::AccessorDeterminationCoeff

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:75
-- timescaledb_toolkit::accessors::AccessorDistinctCount

-- extension/src/accessors.rs:75
-- timescaledb_toolkit::accessors::accessordistinctcount_in
CREATE OR REPLACE FUNCTION "accessordistinctcount_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDistinctCount /* core::option::Option<timescaledb_toolkit::accessors::AccessorDistinctCount> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordistinctcount_in_wrapper';

-- extension/src/accessors.rs:75
-- timescaledb_toolkit::accessors::accessordistinctcount_out
CREATE OR REPLACE FUNCTION "accessordistinctcount_out"(
	"input" AccessorDistinctCount /* timescaledb_toolkit::accessors::AccessorDistinctCount */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordistinctcount_out_wrapper';

-- extension/src/accessors.rs:75
-- timescaledb_toolkit::accessors::AccessorDistinctCount

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:103
-- timescaledb_toolkit::accessors::AccessorDowntime
CREATE TYPE AccessorDowntime;

-- extension/src/accessors.rs:103
-- timescaledb_toolkit::accessors::accessordowntime_in
CREATE FUNCTION "accessordowntime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDowntime /* core::option::Option<timescaledb_toolkit::accessors::AccessorDowntime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordowntime_in_wrapper';

-- extension/src/accessors.rs:103
-- timescaledb_toolkit::accessors::accessordowntime_out
CREATE FUNCTION "accessordowntime_out"(
	"input" AccessorDowntime /* timescaledb_toolkit::accessors::AccessorDowntime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordowntime_out_wrapper';

-- extension/src/accessors.rs:103
-- timescaledb_toolkit::accessors::AccessorDowntime
CREATE TYPE AccessorDowntime (
	INTERNALLENGTH = variable,
	INPUT = accessordowntime_in, /* timescaledb_toolkit::accessors::accessordowntime_in */
	OUTPUT = accessordowntime_out, /* timescaledb_toolkit::accessors::accessordowntime_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:185
-- timescaledb_toolkit::state_aggregate::accessors::AccessorDurationIn
CREATE TYPE AccessorDurationIn;

-- extension/src/state_aggregate/accessors.rs:185
-- timescaledb_toolkit::state_aggregate::accessors::accessordurationin_in
CREATE FUNCTION "accessordurationin_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDurationIn /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorDurationIn> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordurationin_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:185
-- timescaledb_toolkit::state_aggregate::accessors::accessordurationin_out
CREATE FUNCTION "accessordurationin_out"(
	"input" AccessorDurationIn /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationIn */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordurationin_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:185
-- timescaledb_toolkit::state_aggregate::accessors::AccessorDurationIn
CREATE TYPE AccessorDurationIn (
	INTERNALLENGTH = variable,
	INPUT = accessordurationin_in, /* timescaledb_toolkit::state_aggregate::accessors::accessordurationin_in */
	OUTPUT = accessordurationin_out, /* timescaledb_toolkit::state_aggregate::accessors::accessordurationin_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:192
-- timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInInt
CREATE TYPE AccessorDurationInInt;

-- extension/src/state_aggregate/accessors.rs:192
-- timescaledb_toolkit::state_aggregate::accessors::accessordurationinint_in
CREATE FUNCTION "accessordurationinint_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDurationInInt /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInInt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordurationinint_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:192
-- timescaledb_toolkit::state_aggregate::accessors::accessordurationinint_out
CREATE FUNCTION "accessordurationinint_out"(
	"input" AccessorDurationInInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInInt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordurationinint_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:192
-- timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInInt
CREATE TYPE AccessorDurationInInt (
	INTERNALLENGTH = variable,
	INPUT = accessordurationinint_in, /* timescaledb_toolkit::state_aggregate::accessors::accessordurationinint_in */
	OUTPUT = accessordurationinint_out, /* timescaledb_toolkit::state_aggregate::accessors::accessordurationinint_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:249
-- timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRange
CREATE TYPE AccessorDurationInRange;

-- extension/src/state_aggregate/accessors.rs:249
-- timescaledb_toolkit::state_aggregate::accessors::accessordurationinrange_in
CREATE FUNCTION "accessordurationinrange_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDurationInRange /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRange> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordurationinrange_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:249
-- timescaledb_toolkit::state_aggregate::accessors::accessordurationinrange_out
CREATE FUNCTION "accessordurationinrange_out"(
	"input" AccessorDurationInRange /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRange */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordurationinrange_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:249
-- timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRange
CREATE TYPE AccessorDurationInRange (
	INTERNALLENGTH = variable,
	INPUT = accessordurationinrange_in, /* timescaledb_toolkit::state_aggregate::accessors::accessordurationinrange_in */
	OUTPUT = accessordurationinrange_out, /* timescaledb_toolkit::state_aggregate::accessors::accessordurationinrange_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:259
-- timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRangeInt
CREATE TYPE AccessorDurationInRangeInt;

-- extension/src/state_aggregate/accessors.rs:259
-- timescaledb_toolkit::state_aggregate::accessors::accessordurationinrangeint_in
CREATE FUNCTION "accessordurationinrangeint_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorDurationInRangeInt /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRangeInt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordurationinrangeint_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:259
-- timescaledb_toolkit::state_aggregate::accessors::accessordurationinrangeint_out
CREATE FUNCTION "accessordurationinrangeint_out"(
	"input" AccessorDurationInRangeInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRangeInt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessordurationinrangeint_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:259
-- timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRangeInt
CREATE TYPE AccessorDurationInRangeInt (
	INTERNALLENGTH = variable,
	INPUT = accessordurationinrangeint_in, /* timescaledb_toolkit::state_aggregate::accessors::accessordurationinrangeint_in */
	OUTPUT = accessordurationinrangeint_out, /* timescaledb_toolkit::state_aggregate::accessors::accessordurationinrangeint_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:61
-- timescaledb_toolkit::accessors::AccessorError

-- extension/src/accessors.rs:61
-- timescaledb_toolkit::accessors::accessorerror_in
CREATE OR REPLACE FUNCTION "accessorerror_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorError /* core::option::Option<timescaledb_toolkit::accessors::AccessorError> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorerror_in_wrapper';

-- extension/src/accessors.rs:61
-- timescaledb_toolkit::accessors::accessorerror_out
CREATE OR REPLACE FUNCTION "accessorerror_out"(
	"input" AccessorError /* timescaledb_toolkit::accessors::AccessorError */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorerror_out_wrapper';

-- extension/src/accessors.rs:61
-- timescaledb_toolkit::accessors::AccessorError

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:440
-- timescaledb_toolkit::accessors::AccessorExtrapolatedDelta

-- extension/src/accessors.rs:440
-- timescaledb_toolkit::accessors::accessorextrapolateddelta_in
CREATE OR REPLACE FUNCTION "accessorextrapolateddelta_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorExtrapolatedDelta /* core::option::Option<timescaledb_toolkit::accessors::AccessorExtrapolatedDelta> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorextrapolateddelta_in_wrapper';

-- extension/src/accessors.rs:440
-- timescaledb_toolkit::accessors::accessorextrapolateddelta_out
CREATE OR REPLACE FUNCTION "accessorextrapolateddelta_out"(
	"input" AccessorExtrapolatedDelta /* timescaledb_toolkit::accessors::AccessorExtrapolatedDelta */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorextrapolateddelta_out_wrapper';

-- extension/src/accessors.rs:440
-- timescaledb_toolkit::accessors::AccessorExtrapolatedDelta

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:464
-- timescaledb_toolkit::accessors::AccessorExtrapolatedRate

-- extension/src/accessors.rs:464
-- timescaledb_toolkit::accessors::accessorextrapolatedrate_in
CREATE OR REPLACE FUNCTION "accessorextrapolatedrate_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorExtrapolatedRate /* core::option::Option<timescaledb_toolkit::accessors::AccessorExtrapolatedRate> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorextrapolatedrate_in_wrapper';

-- extension/src/accessors.rs:464
-- timescaledb_toolkit::accessors::accessorextrapolatedrate_out
CREATE OR REPLACE FUNCTION "accessorextrapolatedrate_out"(
	"input" AccessorExtrapolatedRate /* timescaledb_toolkit::accessors::AccessorExtrapolatedRate */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorextrapolatedrate_out_wrapper';

-- extension/src/accessors.rs:464
-- timescaledb_toolkit::accessors::AccessorExtrapolatedRate

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:90
-- timescaledb_toolkit::accessors::AccessorFirstTime
CREATE TYPE AccessorFirstTime;

-- extension/src/accessors.rs:90
-- timescaledb_toolkit::accessors::accessorfirsttime_in
CREATE FUNCTION "accessorfirsttime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorFirstTime /* core::option::Option<timescaledb_toolkit::accessors::AccessorFirstTime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorfirsttime_in_wrapper';

-- extension/src/accessors.rs:90
-- timescaledb_toolkit::accessors::accessorfirsttime_out
CREATE FUNCTION "accessorfirsttime_out"(
	"input" AccessorFirstTime /* timescaledb_toolkit::accessors::AccessorFirstTime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorfirsttime_out_wrapper';

-- extension/src/accessors.rs:90
-- timescaledb_toolkit::accessors::AccessorFirstTime
CREATE TYPE AccessorFirstTime (
	INTERNALLENGTH = variable,
	INPUT = accessorfirsttime_in, /* timescaledb_toolkit::accessors::accessorfirsttime_in */
	OUTPUT = accessorfirsttime_out, /* timescaledb_toolkit::accessors::accessorfirsttime_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:88
-- timescaledb_toolkit::accessors::AccessorFirstVal
CREATE TYPE AccessorFirstVal;

-- extension/src/accessors.rs:88
-- timescaledb_toolkit::accessors::accessorfirstval_in
CREATE FUNCTION "accessorfirstval_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorFirstVal /* core::option::Option<timescaledb_toolkit::accessors::AccessorFirstVal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorfirstval_in_wrapper';

-- extension/src/accessors.rs:88
-- timescaledb_toolkit::accessors::accessorfirstval_out
CREATE FUNCTION "accessorfirstval_out"(
	"input" AccessorFirstVal /* timescaledb_toolkit::accessors::AccessorFirstVal */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorfirstval_out_wrapper';

-- extension/src/accessors.rs:88
-- timescaledb_toolkit::accessors::AccessorFirstVal
CREATE TYPE AccessorFirstVal (
	INTERNALLENGTH = variable,
	INPUT = accessorfirstval_in, /* timescaledb_toolkit::accessors::accessorfirstval_in */
	OUTPUT = accessorfirstval_out, /* timescaledb_toolkit::accessors::accessorfirstval_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:94
-- timescaledb_toolkit::accessors::AccessorHigh
CREATE TYPE AccessorHigh;

-- extension/src/accessors.rs:94
-- timescaledb_toolkit::accessors::accessorhigh_in
CREATE FUNCTION "accessorhigh_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorHigh /* core::option::Option<timescaledb_toolkit::accessors::AccessorHigh> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorhigh_in_wrapper';

-- extension/src/accessors.rs:94
-- timescaledb_toolkit::accessors::accessorhigh_out
CREATE FUNCTION "accessorhigh_out"(
	"input" AccessorHigh /* timescaledb_toolkit::accessors::AccessorHigh */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorhigh_out_wrapper';

-- extension/src/accessors.rs:94
-- timescaledb_toolkit::accessors::AccessorHigh
CREATE TYPE AccessorHigh (
	INTERNALLENGTH = variable,
	INPUT = accessorhigh_in, /* timescaledb_toolkit::accessors::accessorhigh_in */
	OUTPUT = accessorhigh_out, /* timescaledb_toolkit::accessors::accessorhigh_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:97
-- timescaledb_toolkit::accessors::AccessorHighTime
CREATE TYPE AccessorHighTime;

-- extension/src/accessors.rs:97
-- timescaledb_toolkit::accessors::accessorhightime_in
CREATE FUNCTION "accessorhightime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorHighTime /* core::option::Option<timescaledb_toolkit::accessors::AccessorHighTime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorhightime_in_wrapper';

-- extension/src/accessors.rs:97
-- timescaledb_toolkit::accessors::accessorhightime_out
CREATE FUNCTION "accessorhightime_out"(
	"input" AccessorHighTime /* timescaledb_toolkit::accessors::AccessorHighTime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorhightime_out_wrapper';

-- extension/src/accessors.rs:97
-- timescaledb_toolkit::accessors::AccessorHighTime
CREATE TYPE AccessorHighTime (
	INTERNALLENGTH = variable,
	INPUT = accessorhightime_in, /* timescaledb_toolkit::accessors::accessorhightime_in */
	OUTPUT = accessorhightime_out, /* timescaledb_toolkit::accessors::accessorhightime_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:82
-- timescaledb_toolkit::accessors::AccessorIdeltaLeft

-- extension/src/accessors.rs:82
-- timescaledb_toolkit::accessors::accessorideltaleft_in
CREATE OR REPLACE FUNCTION "accessorideltaleft_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIdeltaLeft /* core::option::Option<timescaledb_toolkit::accessors::AccessorIdeltaLeft> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorideltaleft_in_wrapper';

-- extension/src/accessors.rs:82
-- timescaledb_toolkit::accessors::accessorideltaleft_out
CREATE OR REPLACE FUNCTION "accessorideltaleft_out"(
	"input" AccessorIdeltaLeft /* timescaledb_toolkit::accessors::AccessorIdeltaLeft */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorideltaleft_out_wrapper';

-- extension/src/accessors.rs:82
-- timescaledb_toolkit::accessors::AccessorIdeltaLeft

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:83
-- timescaledb_toolkit::accessors::AccessorIdeltaRight

-- extension/src/accessors.rs:83
-- timescaledb_toolkit::accessors::accessorideltaright_in
CREATE OR REPLACE FUNCTION "accessorideltaright_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIdeltaRight /* core::option::Option<timescaledb_toolkit::accessors::AccessorIdeltaRight> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorideltaright_in_wrapper';

-- extension/src/accessors.rs:83
-- timescaledb_toolkit::accessors::accessorideltaright_out
CREATE OR REPLACE FUNCTION "accessorideltaright_out"(
	"input" AccessorIdeltaRight /* timescaledb_toolkit::accessors::AccessorIdeltaRight */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorideltaright_out_wrapper';

-- extension/src/accessors.rs:83
-- timescaledb_toolkit::accessors::AccessorIdeltaRight

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:561
-- timescaledb_toolkit::accessors::AccessorIntegral
CREATE TYPE AccessorIntegral;

-- extension/src/accessors.rs:561
-- timescaledb_toolkit::accessors::accessorintegral_in
CREATE FUNCTION "accessorintegral_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIntegral /* core::option::Option<timescaledb_toolkit::accessors::AccessorIntegral> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintegral_in_wrapper';

-- extension/src/accessors.rs:561
-- timescaledb_toolkit::accessors::accessorintegral_out
CREATE FUNCTION "accessorintegral_out"(
	"input" AccessorIntegral /* timescaledb_toolkit::accessors::AccessorIntegral */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintegral_out_wrapper';

-- extension/src/accessors.rs:561
-- timescaledb_toolkit::accessors::AccessorIntegral
CREATE TYPE AccessorIntegral (
	INTERNALLENGTH = variable,
	INPUT = accessorintegral_in, /* timescaledb_toolkit::accessors::accessorintegral_in */
	OUTPUT = accessorintegral_out, /* timescaledb_toolkit::accessors::accessorintegral_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:72
-- timescaledb_toolkit::accessors::AccessorIntercept

-- extension/src/accessors.rs:72
-- timescaledb_toolkit::accessors::accessorintercept_in
CREATE OR REPLACE FUNCTION "accessorintercept_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIntercept /* core::option::Option<timescaledb_toolkit::accessors::AccessorIntercept> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintercept_in_wrapper';

-- extension/src/accessors.rs:72
-- timescaledb_toolkit::accessors::accessorintercept_out
CREATE OR REPLACE FUNCTION "accessorintercept_out"(
	"input" AccessorIntercept /* timescaledb_toolkit::accessors::AccessorIntercept */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintercept_out_wrapper';

-- extension/src/accessors.rs:72
-- timescaledb_toolkit::accessors::AccessorIntercept

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:60
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationIn
CREATE TYPE AccessorInterpolatedDurationIn;

-- extension/src/state_aggregate/accessors.rs:60
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolateddurationin_in
CREATE FUNCTION "accessorinterpolateddurationin_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorInterpolatedDurationIn /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationIn> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolateddurationin_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:60
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolateddurationin_out
CREATE FUNCTION "accessorinterpolateddurationin_out"(
	"input" AccessorInterpolatedDurationIn /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationIn */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolateddurationin_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:60
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationIn
CREATE TYPE AccessorInterpolatedDurationIn (
	INTERNALLENGTH = variable,
	INPUT = accessorinterpolateddurationin_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolateddurationin_in */
	OUTPUT = accessorinterpolateddurationin_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolateddurationin_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:72
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationInInt
CREATE TYPE AccessorInterpolatedDurationInInt;

-- extension/src/state_aggregate/accessors.rs:72
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolateddurationinint_in
CREATE FUNCTION "accessorinterpolateddurationinint_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorInterpolatedDurationInInt /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationInInt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolateddurationinint_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:72
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolateddurationinint_out
CREATE FUNCTION "accessorinterpolateddurationinint_out"(
	"input" AccessorInterpolatedDurationInInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationInInt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolateddurationinint_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:72
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationInInt
CREATE TYPE AccessorInterpolatedDurationInInt (
	INTERNALLENGTH = variable,
	INPUT = accessorinterpolateddurationinint_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolateddurationinint_in */
	OUTPUT = accessorinterpolateddurationinint_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolateddurationinint_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:33
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateIntTimeline
CREATE TYPE AccessorInterpolatedStateIntTimeline;

-- extension/src/state_aggregate/accessors.rs:33
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateinttimeline_in
CREATE FUNCTION "accessorinterpolatedstateinttimeline_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorInterpolatedStateIntTimeline /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateIntTimeline> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolatedstateinttimeline_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:33
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateinttimeline_out
CREATE FUNCTION "accessorinterpolatedstateinttimeline_out"(
	"input" AccessorInterpolatedStateIntTimeline /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateIntTimeline */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolatedstateinttimeline_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:33
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateIntTimeline
CREATE TYPE AccessorInterpolatedStateIntTimeline (
	INTERNALLENGTH = variable,
	INPUT = accessorinterpolatedstateinttimeline_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateinttimeline_in */
	OUTPUT = accessorinterpolatedstateinttimeline_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateinttimeline_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:123
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriods
CREATE TYPE AccessorInterpolatedStatePeriods;

-- extension/src/state_aggregate/accessors.rs:123
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateperiods_in
CREATE FUNCTION "accessorinterpolatedstateperiods_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorInterpolatedStatePeriods /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriods> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolatedstateperiods_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:123
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateperiods_out
CREATE FUNCTION "accessorinterpolatedstateperiods_out"(
	"input" AccessorInterpolatedStatePeriods /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriods */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolatedstateperiods_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:123
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriods
CREATE TYPE AccessorInterpolatedStatePeriods (
	INTERNALLENGTH = variable,
	INPUT = accessorinterpolatedstateperiods_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateperiods_in */
	OUTPUT = accessorinterpolatedstateperiods_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateperiods_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:135
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriodsInt
CREATE TYPE AccessorInterpolatedStatePeriodsInt;

-- extension/src/state_aggregate/accessors.rs:135
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateperiodsint_in
CREATE FUNCTION "accessorinterpolatedstateperiodsint_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorInterpolatedStatePeriodsInt /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriodsInt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolatedstateperiodsint_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:135
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateperiodsint_out
CREATE FUNCTION "accessorinterpolatedstateperiodsint_out"(
	"input" AccessorInterpolatedStatePeriodsInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriodsInt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolatedstateperiodsint_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:135
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriodsInt
CREATE TYPE AccessorInterpolatedStatePeriodsInt (
	INTERNALLENGTH = variable,
	INPUT = accessorinterpolatedstateperiodsint_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateperiodsint_in */
	OUTPUT = accessorinterpolatedstateperiodsint_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstateperiodsint_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:7
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateTimeline
CREATE TYPE AccessorInterpolatedStateTimeline;

-- extension/src/state_aggregate/accessors.rs:7
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstatetimeline_in
CREATE FUNCTION "accessorinterpolatedstatetimeline_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorInterpolatedStateTimeline /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateTimeline> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolatedstatetimeline_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:7
-- timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstatetimeline_out
CREATE FUNCTION "accessorinterpolatedstatetimeline_out"(
	"input" AccessorInterpolatedStateTimeline /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateTimeline */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorinterpolatedstatetimeline_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:7
-- timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateTimeline
CREATE TYPE AccessorInterpolatedStateTimeline (
	INTERNALLENGTH = variable,
	INPUT = accessorinterpolatedstatetimeline_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstatetimeline_in */
	OUTPUT = accessorinterpolatedstatetimeline_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorinterpolatedstatetimeline_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:105
-- timescaledb_toolkit::accessors::AccessorIntoArray
CREATE TYPE AccessorIntoArray;

-- extension/src/accessors.rs:105
-- timescaledb_toolkit::accessors::accessorintoarray_in
CREATE FUNCTION "accessorintoarray_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIntoArray /* core::option::Option<timescaledb_toolkit::accessors::AccessorIntoArray> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintoarray_in_wrapper';

-- extension/src/accessors.rs:105
-- timescaledb_toolkit::accessors::accessorintoarray_out
CREATE FUNCTION "accessorintoarray_out"(
	"input" AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintoarray_out_wrapper';

-- extension/src/accessors.rs:105
-- timescaledb_toolkit::accessors::AccessorIntoArray
CREATE TYPE AccessorIntoArray (
	INTERNALLENGTH = variable,
	INPUT = accessorintoarray_in, /* timescaledb_toolkit::accessors::accessorintoarray_in */
	OUTPUT = accessorintoarray_out, /* timescaledb_toolkit::accessors::accessorintoarray_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:106
-- timescaledb_toolkit::accessors::AccessorIntoIntValues
CREATE TYPE AccessorIntoIntValues;

-- extension/src/accessors.rs:106
-- timescaledb_toolkit::accessors::accessorintointvalues_in
CREATE FUNCTION "accessorintointvalues_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIntoIntValues /* core::option::Option<timescaledb_toolkit::accessors::AccessorIntoIntValues> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintointvalues_in_wrapper';

-- extension/src/accessors.rs:106
-- timescaledb_toolkit::accessors::accessorintointvalues_out
CREATE FUNCTION "accessorintointvalues_out"(
	"input" AccessorIntoIntValues /* timescaledb_toolkit::accessors::AccessorIntoIntValues */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintointvalues_out_wrapper';

-- extension/src/accessors.rs:106
-- timescaledb_toolkit::accessors::AccessorIntoIntValues
CREATE TYPE AccessorIntoIntValues (
	INTERNALLENGTH = variable,
	INPUT = accessorintointvalues_in, /* timescaledb_toolkit::accessors::accessorintointvalues_in */
	OUTPUT = accessorintointvalues_out, /* timescaledb_toolkit::accessors::accessorintointvalues_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:104
-- timescaledb_toolkit::accessors::AccessorIntoValues
CREATE TYPE AccessorIntoValues;

-- extension/src/accessors.rs:104
-- timescaledb_toolkit::accessors::accessorintovalues_in
CREATE FUNCTION "accessorintovalues_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIntoValues /* core::option::Option<timescaledb_toolkit::accessors::AccessorIntoValues> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintovalues_in_wrapper';

-- extension/src/accessors.rs:104
-- timescaledb_toolkit::accessors::accessorintovalues_out
CREATE FUNCTION "accessorintovalues_out"(
	"input" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorintovalues_out_wrapper';

-- extension/src/accessors.rs:104
-- timescaledb_toolkit::accessors::AccessorIntoValues
CREATE TYPE AccessorIntoValues (
	INTERNALLENGTH = variable,
	INPUT = accessorintovalues_in, /* timescaledb_toolkit::accessors::accessorintovalues_in */
	OUTPUT = accessorintovalues_out, /* timescaledb_toolkit::accessors::accessorintovalues_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:80
-- timescaledb_toolkit::accessors::AccessorIrateLeft

-- extension/src/accessors.rs:80
-- timescaledb_toolkit::accessors::accessorirateleft_in
CREATE OR REPLACE FUNCTION "accessorirateleft_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIrateLeft /* core::option::Option<timescaledb_toolkit::accessors::AccessorIrateLeft> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorirateleft_in_wrapper';

-- extension/src/accessors.rs:80
-- timescaledb_toolkit::accessors::accessorirateleft_out
CREATE OR REPLACE FUNCTION "accessorirateleft_out"(
	"input" AccessorIrateLeft /* timescaledb_toolkit::accessors::AccessorIrateLeft */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorirateleft_out_wrapper';

-- extension/src/accessors.rs:80
-- timescaledb_toolkit::accessors::AccessorIrateLeft

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:81
-- timescaledb_toolkit::accessors::AccessorIrateRight

-- extension/src/accessors.rs:81
-- timescaledb_toolkit::accessors::accessorirateright_in
CREATE OR REPLACE FUNCTION "accessorirateright_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorIrateRight /* core::option::Option<timescaledb_toolkit::accessors::AccessorIrateRight> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorirateright_in_wrapper';

-- extension/src/accessors.rs:81
-- timescaledb_toolkit::accessors::accessorirateright_out
CREATE OR REPLACE FUNCTION "accessorirateright_out"(
	"input" AccessorIrateRight /* timescaledb_toolkit::accessors::AccessorIrateRight */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorirateright_out_wrapper';

-- extension/src/accessors.rs:81
-- timescaledb_toolkit::accessors::AccessorIrateRight

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:347
-- timescaledb_toolkit::accessors::AccessorKurtosis

-- extension/src/accessors.rs:347
-- timescaledb_toolkit::accessors::accessorkurtosis_in
CREATE OR REPLACE FUNCTION "accessorkurtosis_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorKurtosis /* core::option::Option<timescaledb_toolkit::accessors::AccessorKurtosis> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorkurtosis_in_wrapper';

-- extension/src/accessors.rs:347
-- timescaledb_toolkit::accessors::accessorkurtosis_out
CREATE OR REPLACE FUNCTION "accessorkurtosis_out"(
	"input" AccessorKurtosis /* timescaledb_toolkit::accessors::AccessorKurtosis */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorkurtosis_out_wrapper';

-- extension/src/accessors.rs:347
-- timescaledb_toolkit::accessors::AccessorKurtosis

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:370
-- timescaledb_toolkit::accessors::AccessorKurtosisX

-- extension/src/accessors.rs:370
-- timescaledb_toolkit::accessors::accessorkurtosisx_in
CREATE OR REPLACE FUNCTION "accessorkurtosisx_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorKurtosisX /* core::option::Option<timescaledb_toolkit::accessors::AccessorKurtosisX> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorkurtosisx_in_wrapper';

-- extension/src/accessors.rs:370
-- timescaledb_toolkit::accessors::accessorkurtosisx_out
CREATE OR REPLACE FUNCTION "accessorkurtosisx_out"(
	"input" AccessorKurtosisX /* timescaledb_toolkit::accessors::AccessorKurtosisX */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorkurtosisx_out_wrapper';

-- extension/src/accessors.rs:370
-- timescaledb_toolkit::accessors::AccessorKurtosisX

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:393
-- timescaledb_toolkit::accessors::AccessorKurtosisY

-- extension/src/accessors.rs:393
-- timescaledb_toolkit::accessors::accessorkurtosisy_in
CREATE OR REPLACE FUNCTION "accessorkurtosisy_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorKurtosisY /* core::option::Option<timescaledb_toolkit::accessors::AccessorKurtosisY> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorkurtosisy_in_wrapper';

-- extension/src/accessors.rs:393
-- timescaledb_toolkit::accessors::accessorkurtosisy_out
CREATE OR REPLACE FUNCTION "accessorkurtosisy_out"(
	"input" AccessorKurtosisY /* timescaledb_toolkit::accessors::AccessorKurtosisY */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorkurtosisy_out_wrapper';

-- extension/src/accessors.rs:393
-- timescaledb_toolkit::accessors::AccessorKurtosisY

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:91
-- timescaledb_toolkit::accessors::AccessorLastTime
CREATE TYPE AccessorLastTime;

-- extension/src/accessors.rs:91
-- timescaledb_toolkit::accessors::accessorlasttime_in
CREATE FUNCTION "accessorlasttime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorLastTime /* core::option::Option<timescaledb_toolkit::accessors::AccessorLastTime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorlasttime_in_wrapper';

-- extension/src/accessors.rs:91
-- timescaledb_toolkit::accessors::accessorlasttime_out
CREATE FUNCTION "accessorlasttime_out"(
	"input" AccessorLastTime /* timescaledb_toolkit::accessors::AccessorLastTime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorlasttime_out_wrapper';

-- extension/src/accessors.rs:91
-- timescaledb_toolkit::accessors::AccessorLastTime
CREATE TYPE AccessorLastTime (
	INTERNALLENGTH = variable,
	INPUT = accessorlasttime_in, /* timescaledb_toolkit::accessors::accessorlasttime_in */
	OUTPUT = accessorlasttime_out, /* timescaledb_toolkit::accessors::accessorlasttime_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:89
-- timescaledb_toolkit::accessors::AccessorLastVal
CREATE TYPE AccessorLastVal;

-- extension/src/accessors.rs:89
-- timescaledb_toolkit::accessors::accessorlastval_in
CREATE FUNCTION "accessorlastval_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorLastVal /* core::option::Option<timescaledb_toolkit::accessors::AccessorLastVal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorlastval_in_wrapper';

-- extension/src/accessors.rs:89
-- timescaledb_toolkit::accessors::accessorlastval_out
CREATE FUNCTION "accessorlastval_out"(
	"input" AccessorLastVal /* timescaledb_toolkit::accessors::AccessorLastVal */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorlastval_out_wrapper';

-- extension/src/accessors.rs:89
-- timescaledb_toolkit::accessors::AccessorLastVal
CREATE TYPE AccessorLastVal (
	INTERNALLENGTH = variable,
	INPUT = accessorlastval_in, /* timescaledb_toolkit::accessors::accessorlastval_in */
	OUTPUT = accessorlastval_out, /* timescaledb_toolkit::accessors::accessorlastval_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:114
-- timescaledb_toolkit::accessors::AccessorLiveAt
CREATE TYPE AccessorLiveAt;

-- extension/src/accessors.rs:114
-- timescaledb_toolkit::accessors::accessorliveat_in
CREATE FUNCTION "accessorliveat_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorLiveAt /* core::option::Option<timescaledb_toolkit::accessors::AccessorLiveAt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorliveat_in_wrapper';

-- extension/src/accessors.rs:114
-- timescaledb_toolkit::accessors::accessorliveat_out
CREATE FUNCTION "accessorliveat_out"(
	"input" AccessorLiveAt /* timescaledb_toolkit::accessors::AccessorLiveAt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorliveat_out_wrapper';

-- extension/src/accessors.rs:114
-- timescaledb_toolkit::accessors::AccessorLiveAt
CREATE TYPE AccessorLiveAt (
	INTERNALLENGTH = variable,
	INPUT = accessorliveat_in, /* timescaledb_toolkit::accessors::accessorliveat_in */
	OUTPUT = accessorliveat_out, /* timescaledb_toolkit::accessors::accessorliveat_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:100
-- timescaledb_toolkit::accessors::AccessorLiveRanges
CREATE TYPE AccessorLiveRanges;

-- extension/src/accessors.rs:100
-- timescaledb_toolkit::accessors::accessorliveranges_in
CREATE FUNCTION "accessorliveranges_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorLiveRanges /* core::option::Option<timescaledb_toolkit::accessors::AccessorLiveRanges> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorliveranges_in_wrapper';

-- extension/src/accessors.rs:100
-- timescaledb_toolkit::accessors::accessorliveranges_out
CREATE FUNCTION "accessorliveranges_out"(
	"input" AccessorLiveRanges /* timescaledb_toolkit::accessors::AccessorLiveRanges */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorliveranges_out_wrapper';

-- extension/src/accessors.rs:100
-- timescaledb_toolkit::accessors::AccessorLiveRanges
CREATE TYPE AccessorLiveRanges (
	INTERNALLENGTH = variable,
	INPUT = accessorliveranges_in, /* timescaledb_toolkit::accessors::accessorliveranges_in */
	OUTPUT = accessorliveranges_out, /* timescaledb_toolkit::accessors::accessorliveranges_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:95
-- timescaledb_toolkit::accessors::AccessorLow
CREATE TYPE AccessorLow;

-- extension/src/accessors.rs:95
-- timescaledb_toolkit::accessors::accessorlow_in
CREATE FUNCTION "accessorlow_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorLow /* core::option::Option<timescaledb_toolkit::accessors::AccessorLow> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorlow_in_wrapper';

-- extension/src/accessors.rs:95
-- timescaledb_toolkit::accessors::accessorlow_out
CREATE FUNCTION "accessorlow_out"(
	"input" AccessorLow /* timescaledb_toolkit::accessors::AccessorLow */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorlow_out_wrapper';

-- extension/src/accessors.rs:95
-- timescaledb_toolkit::accessors::AccessorLow
CREATE TYPE AccessorLow (
	INTERNALLENGTH = variable,
	INPUT = accessorlow_in, /* timescaledb_toolkit::accessors::accessorlow_in */
	OUTPUT = accessorlow_out, /* timescaledb_toolkit::accessors::accessorlow_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:98
-- timescaledb_toolkit::accessors::AccessorLowTime
CREATE TYPE AccessorLowTime;

-- extension/src/accessors.rs:98
-- timescaledb_toolkit::accessors::accessorlowtime_in
CREATE FUNCTION "accessorlowtime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorLowTime /* core::option::Option<timescaledb_toolkit::accessors::AccessorLowTime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorlowtime_in_wrapper';

-- extension/src/accessors.rs:98
-- timescaledb_toolkit::accessors::accessorlowtime_out
CREATE FUNCTION "accessorlowtime_out"(
	"input" AccessorLowTime /* timescaledb_toolkit::accessors::AccessorLowTime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorlowtime_out_wrapper';

-- extension/src/accessors.rs:98
-- timescaledb_toolkit::accessors::AccessorLowTime
CREATE TYPE AccessorLowTime (
	INTERNALLENGTH = variable,
	INPUT = accessorlowtime_in, /* timescaledb_toolkit::accessors::accessorlowtime_in */
	OUTPUT = accessorlowtime_out, /* timescaledb_toolkit::accessors::accessorlowtime_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:605
-- timescaledb_toolkit::accessors::AccessorMaxFrequencyInt
CREATE TYPE AccessorMaxFrequencyInt;

-- extension/src/accessors.rs:605
-- timescaledb_toolkit::accessors::accessormaxfrequencyint_in
CREATE FUNCTION "accessormaxfrequencyint_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorMaxFrequencyInt /* core::option::Option<timescaledb_toolkit::accessors::AccessorMaxFrequencyInt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessormaxfrequencyint_in_wrapper';

-- extension/src/accessors.rs:605
-- timescaledb_toolkit::accessors::accessormaxfrequencyint_out
CREATE FUNCTION "accessormaxfrequencyint_out"(
	"input" AccessorMaxFrequencyInt /* timescaledb_toolkit::accessors::AccessorMaxFrequencyInt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessormaxfrequencyint_out_wrapper';

-- extension/src/accessors.rs:605
-- timescaledb_toolkit::accessors::AccessorMaxFrequencyInt
CREATE TYPE AccessorMaxFrequencyInt (
	INTERNALLENGTH = variable,
	INPUT = accessormaxfrequencyint_in, /* timescaledb_toolkit::accessors::accessormaxfrequencyint_in */
	OUTPUT = accessormaxfrequencyint_out, /* timescaledb_toolkit::accessors::accessormaxfrequencyint_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:63
-- timescaledb_toolkit::accessors::AccessorMaxVal

-- extension/src/accessors.rs:63
-- timescaledb_toolkit::accessors::accessormaxval_in
CREATE OR REPLACE FUNCTION "accessormaxval_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorMaxVal /* core::option::Option<timescaledb_toolkit::accessors::AccessorMaxVal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessormaxval_in_wrapper';

-- extension/src/accessors.rs:63
-- timescaledb_toolkit::accessors::accessormaxval_out
CREATE OR REPLACE FUNCTION "accessormaxval_out"(
	"input" AccessorMaxVal /* timescaledb_toolkit::accessors::AccessorMaxVal */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessormaxval_out_wrapper';

-- extension/src/accessors.rs:63
-- timescaledb_toolkit::accessors::AccessorMaxVal

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:60
-- timescaledb_toolkit::accessors::AccessorMean

-- extension/src/accessors.rs:60
-- timescaledb_toolkit::accessors::accessormean_in
CREATE OR REPLACE FUNCTION "accessormean_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorMean /* core::option::Option<timescaledb_toolkit::accessors::AccessorMean> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessormean_in_wrapper';

-- extension/src/accessors.rs:60
-- timescaledb_toolkit::accessors::accessormean_out
CREATE OR REPLACE FUNCTION "accessormean_out"(
	"input" AccessorMean /* timescaledb_toolkit::accessors::AccessorMean */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessormean_out_wrapper';

-- extension/src/accessors.rs:60
-- timescaledb_toolkit::accessors::AccessorMean

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:625
-- timescaledb_toolkit::accessors::AccessorMinFrequencyInt
CREATE TYPE AccessorMinFrequencyInt;

-- extension/src/accessors.rs:625
-- timescaledb_toolkit::accessors::accessorminfrequencyint_in
CREATE FUNCTION "accessorminfrequencyint_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorMinFrequencyInt /* core::option::Option<timescaledb_toolkit::accessors::AccessorMinFrequencyInt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorminfrequencyint_in_wrapper';

-- extension/src/accessors.rs:625
-- timescaledb_toolkit::accessors::accessorminfrequencyint_out
CREATE FUNCTION "accessorminfrequencyint_out"(
	"input" AccessorMinFrequencyInt /* timescaledb_toolkit::accessors::AccessorMinFrequencyInt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorminfrequencyint_out_wrapper';

-- extension/src/accessors.rs:625
-- timescaledb_toolkit::accessors::AccessorMinFrequencyInt
CREATE TYPE AccessorMinFrequencyInt (
	INTERNALLENGTH = variable,
	INPUT = accessorminfrequencyint_in, /* timescaledb_toolkit::accessors::accessorminfrequencyint_in */
	OUTPUT = accessorminfrequencyint_out, /* timescaledb_toolkit::accessors::accessorminfrequencyint_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:62
-- timescaledb_toolkit::accessors::AccessorMinVal

-- extension/src/accessors.rs:62
-- timescaledb_toolkit::accessors::accessorminval_in
CREATE OR REPLACE FUNCTION "accessorminval_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorMinVal /* core::option::Option<timescaledb_toolkit::accessors::AccessorMinVal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorminval_in_wrapper';

-- extension/src/accessors.rs:62
-- timescaledb_toolkit::accessors::accessorminval_out
CREATE OR REPLACE FUNCTION "accessorminval_out"(
	"input" AccessorMinVal /* timescaledb_toolkit::accessors::AccessorMinVal */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorminval_out_wrapper';

-- extension/src/accessors.rs:62
-- timescaledb_toolkit::accessors::AccessorMinVal

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:85
-- timescaledb_toolkit::accessors::AccessorNumChanges

-- extension/src/accessors.rs:85
-- timescaledb_toolkit::accessors::accessornumchanges_in
CREATE OR REPLACE FUNCTION "accessornumchanges_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorNumChanges /* core::option::Option<timescaledb_toolkit::accessors::AccessorNumChanges> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumchanges_in_wrapper';

-- extension/src/accessors.rs:85
-- timescaledb_toolkit::accessors::accessornumchanges_out
CREATE OR REPLACE FUNCTION "accessornumchanges_out"(
	"input" AccessorNumChanges /* timescaledb_toolkit::accessors::AccessorNumChanges */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumchanges_out_wrapper';

-- extension/src/accessors.rs:85
-- timescaledb_toolkit::accessors::AccessorNumChanges

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:84
-- timescaledb_toolkit::accessors::AccessorNumElements

-- extension/src/accessors.rs:84
-- timescaledb_toolkit::accessors::accessornumelements_in
CREATE OR REPLACE FUNCTION "accessornumelements_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorNumElements /* core::option::Option<timescaledb_toolkit::accessors::AccessorNumElements> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumelements_in_wrapper';

-- extension/src/accessors.rs:84
-- timescaledb_toolkit::accessors::accessornumelements_out
CREATE OR REPLACE FUNCTION "accessornumelements_out"(
	"input" AccessorNumElements /* timescaledb_toolkit::accessors::AccessorNumElements */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumelements_out_wrapper';

-- extension/src/accessors.rs:84
-- timescaledb_toolkit::accessors::AccessorNumElements

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:110
-- timescaledb_toolkit::accessors::AccessorNumGaps
CREATE TYPE AccessorNumGaps;

-- extension/src/accessors.rs:110
-- timescaledb_toolkit::accessors::accessornumgaps_in
CREATE FUNCTION "accessornumgaps_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorNumGaps /* core::option::Option<timescaledb_toolkit::accessors::AccessorNumGaps> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumgaps_in_wrapper';

-- extension/src/accessors.rs:110
-- timescaledb_toolkit::accessors::accessornumgaps_out
CREATE FUNCTION "accessornumgaps_out"(
	"input" AccessorNumGaps /* timescaledb_toolkit::accessors::AccessorNumGaps */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumgaps_out_wrapper';

-- extension/src/accessors.rs:110
-- timescaledb_toolkit::accessors::AccessorNumGaps
CREATE TYPE AccessorNumGaps (
	INTERNALLENGTH = variable,
	INPUT = accessornumgaps_in, /* timescaledb_toolkit::accessors::accessornumgaps_in */
	OUTPUT = accessornumgaps_out, /* timescaledb_toolkit::accessors::accessornumgaps_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:109
-- timescaledb_toolkit::accessors::AccessorNumLiveRanges
CREATE TYPE AccessorNumLiveRanges;

-- extension/src/accessors.rs:109
-- timescaledb_toolkit::accessors::accessornumliveranges_in
CREATE FUNCTION "accessornumliveranges_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorNumLiveRanges /* core::option::Option<timescaledb_toolkit::accessors::AccessorNumLiveRanges> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumliveranges_in_wrapper';

-- extension/src/accessors.rs:109
-- timescaledb_toolkit::accessors::accessornumliveranges_out
CREATE FUNCTION "accessornumliveranges_out"(
	"input" AccessorNumLiveRanges /* timescaledb_toolkit::accessors::AccessorNumLiveRanges */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumliveranges_out_wrapper';

-- extension/src/accessors.rs:109
-- timescaledb_toolkit::accessors::AccessorNumLiveRanges
CREATE TYPE AccessorNumLiveRanges (
	INTERNALLENGTH = variable,
	INPUT = accessornumliveranges_in, /* timescaledb_toolkit::accessors::accessornumliveranges_in */
	OUTPUT = accessornumliveranges_out, /* timescaledb_toolkit::accessors::accessornumliveranges_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:86
-- timescaledb_toolkit::accessors::AccessorNumResets

-- extension/src/accessors.rs:86
-- timescaledb_toolkit::accessors::accessornumresets_in
CREATE OR REPLACE FUNCTION "accessornumresets_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorNumResets /* core::option::Option<timescaledb_toolkit::accessors::AccessorNumResets> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumresets_in_wrapper';

-- extension/src/accessors.rs:86
-- timescaledb_toolkit::accessors::accessornumresets_out
CREATE OR REPLACE FUNCTION "accessornumresets_out"(
	"input" AccessorNumResets /* timescaledb_toolkit::accessors::AccessorNumResets */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumresets_out_wrapper';

-- extension/src/accessors.rs:86
-- timescaledb_toolkit::accessors::AccessorNumResets

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:59
-- timescaledb_toolkit::accessors::AccessorNumVals

-- extension/src/accessors.rs:59
-- timescaledb_toolkit::accessors::accessornumvals_in
CREATE OR REPLACE FUNCTION "accessornumvals_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorNumVals /* core::option::Option<timescaledb_toolkit::accessors::AccessorNumVals> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumvals_in_wrapper';

-- extension/src/accessors.rs:59
-- timescaledb_toolkit::accessors::accessornumvals_out
CREATE OR REPLACE FUNCTION "accessornumvals_out"(
	"input" AccessorNumVals /* timescaledb_toolkit::accessors::AccessorNumVals */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessornumvals_out_wrapper';

-- extension/src/accessors.rs:59
-- timescaledb_toolkit::accessors::AccessorNumVals

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:92
-- timescaledb_toolkit::accessors::AccessorOpen
CREATE TYPE AccessorOpen;

-- extension/src/accessors.rs:92
-- timescaledb_toolkit::accessors::accessoropen_in
CREATE FUNCTION "accessoropen_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorOpen /* core::option::Option<timescaledb_toolkit::accessors::AccessorOpen> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoropen_in_wrapper';

-- extension/src/accessors.rs:92
-- timescaledb_toolkit::accessors::accessoropen_out
CREATE FUNCTION "accessoropen_out"(
	"input" AccessorOpen /* timescaledb_toolkit::accessors::AccessorOpen */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoropen_out_wrapper';

-- extension/src/accessors.rs:92
-- timescaledb_toolkit::accessors::AccessorOpen
CREATE TYPE AccessorOpen (
	INTERNALLENGTH = variable,
	INPUT = accessoropen_in, /* timescaledb_toolkit::accessors::accessoropen_in */
	OUTPUT = accessoropen_out, /* timescaledb_toolkit::accessors::accessoropen_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:96
-- timescaledb_toolkit::accessors::AccessorOpenTime
CREATE TYPE AccessorOpenTime;

-- extension/src/accessors.rs:96
-- timescaledb_toolkit::accessors::accessoropentime_in
CREATE FUNCTION "accessoropentime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorOpenTime /* core::option::Option<timescaledb_toolkit::accessors::AccessorOpenTime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoropentime_in_wrapper';

-- extension/src/accessors.rs:96
-- timescaledb_toolkit::accessors::accessoropentime_out
CREATE FUNCTION "accessoropentime_out"(
	"input" AccessorOpenTime /* timescaledb_toolkit::accessors::AccessorOpenTime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoropentime_out_wrapper';

-- extension/src/accessors.rs:96
-- timescaledb_toolkit::accessors::AccessorOpenTime
CREATE TYPE AccessorOpenTime (
	INTERNALLENGTH = variable,
	INPUT = accessoropentime_in, /* timescaledb_toolkit::accessors::accessoropentime_in */
	OUTPUT = accessoropentime_out, /* timescaledb_toolkit::accessors::accessoropentime_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:645
-- timescaledb_toolkit::accessors::AccessorPercentileArray
CREATE TYPE AccessorPercentileArray;

-- extension/src/accessors.rs:645
-- timescaledb_toolkit::accessors::accessorpercentilearray_in
CREATE FUNCTION "accessorpercentilearray_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorPercentileArray /* core::option::Option<timescaledb_toolkit::accessors::AccessorPercentileArray> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorpercentilearray_in_wrapper';

-- extension/src/accessors.rs:645
-- timescaledb_toolkit::accessors::accessorpercentilearray_out
CREATE FUNCTION "accessorpercentilearray_out"(
	"input" AccessorPercentileArray /* timescaledb_toolkit::accessors::AccessorPercentileArray */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorpercentilearray_out_wrapper';

-- extension/src/accessors.rs:645
-- timescaledb_toolkit::accessors::AccessorPercentileArray
CREATE TYPE AccessorPercentileArray (
	INTERNALLENGTH = variable,
	INPUT = accessorpercentilearray_in, /* timescaledb_toolkit::accessors::accessorpercentilearray_in */
	OUTPUT = accessorpercentilearray_out, /* timescaledb_toolkit::accessors::accessorpercentilearray_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:79
-- timescaledb_toolkit::accessors::AccessorRate

-- extension/src/accessors.rs:79
-- timescaledb_toolkit::accessors::accessorrate_in
CREATE OR REPLACE FUNCTION "accessorrate_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorRate /* core::option::Option<timescaledb_toolkit::accessors::AccessorRate> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorrate_in_wrapper';

-- extension/src/accessors.rs:79
-- timescaledb_toolkit::accessors::accessorrate_out
CREATE OR REPLACE FUNCTION "accessorrate_out"(
	"input" AccessorRate /* timescaledb_toolkit::accessors::AccessorRate */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorrate_out_wrapper';

-- extension/src/accessors.rs:79
-- timescaledb_toolkit::accessors::AccessorRate

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:278
-- timescaledb_toolkit::accessors::AccessorSkewness

-- extension/src/accessors.rs:278
-- timescaledb_toolkit::accessors::accessorskewness_in
CREATE OR REPLACE FUNCTION "accessorskewness_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorSkewness /* core::option::Option<timescaledb_toolkit::accessors::AccessorSkewness> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorskewness_in_wrapper';

-- extension/src/accessors.rs:278
-- timescaledb_toolkit::accessors::accessorskewness_out
CREATE OR REPLACE FUNCTION "accessorskewness_out"(
	"input" AccessorSkewness /* timescaledb_toolkit::accessors::AccessorSkewness */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorskewness_out_wrapper';

-- extension/src/accessors.rs:278
-- timescaledb_toolkit::accessors::AccessorSkewness

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:301
-- timescaledb_toolkit::accessors::AccessorSkewnessX

-- extension/src/accessors.rs:301
-- timescaledb_toolkit::accessors::accessorskewnessx_in
CREATE OR REPLACE FUNCTION "accessorskewnessx_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorSkewnessX /* core::option::Option<timescaledb_toolkit::accessors::AccessorSkewnessX> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorskewnessx_in_wrapper';

-- extension/src/accessors.rs:301
-- timescaledb_toolkit::accessors::accessorskewnessx_out
CREATE OR REPLACE FUNCTION "accessorskewnessx_out"(
	"input" AccessorSkewnessX /* timescaledb_toolkit::accessors::AccessorSkewnessX */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorskewnessx_out_wrapper';

-- extension/src/accessors.rs:301
-- timescaledb_toolkit::accessors::AccessorSkewnessX

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:324
-- timescaledb_toolkit::accessors::AccessorSkewnessY

-- extension/src/accessors.rs:324
-- timescaledb_toolkit::accessors::accessorskewnessy_in
CREATE OR REPLACE FUNCTION "accessorskewnessy_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorSkewnessY /* core::option::Option<timescaledb_toolkit::accessors::AccessorSkewnessY> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorskewnessy_in_wrapper';

-- extension/src/accessors.rs:324
-- timescaledb_toolkit::accessors::accessorskewnessy_out
CREATE OR REPLACE FUNCTION "accessorskewnessy_out"(
	"input" AccessorSkewnessY /* timescaledb_toolkit::accessors::AccessorSkewnessY */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorskewnessy_out_wrapper';

-- extension/src/accessors.rs:324
-- timescaledb_toolkit::accessors::AccessorSkewnessY

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:70
-- timescaledb_toolkit::accessors::AccessorSlope

-- extension/src/accessors.rs:70
-- timescaledb_toolkit::accessors::accessorslope_in
CREATE OR REPLACE FUNCTION "accessorslope_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorSlope /* core::option::Option<timescaledb_toolkit::accessors::AccessorSlope> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorslope_in_wrapper';

-- extension/src/accessors.rs:70
-- timescaledb_toolkit::accessors::accessorslope_out
CREATE OR REPLACE FUNCTION "accessorslope_out"(
	"input" AccessorSlope /* timescaledb_toolkit::accessors::AccessorSlope */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorslope_out_wrapper';

-- extension/src/accessors.rs:70
-- timescaledb_toolkit::accessors::AccessorSlope

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:305
-- timescaledb_toolkit::state_aggregate::accessors::AccessorStateAt
CREATE TYPE AccessorStateAt;

-- extension/src/state_aggregate/accessors.rs:305
-- timescaledb_toolkit::state_aggregate::accessors::accessorstateat_in
CREATE FUNCTION "accessorstateat_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStateAt /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorStateAt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateat_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:305
-- timescaledb_toolkit::state_aggregate::accessors::accessorstateat_out
CREATE FUNCTION "accessorstateat_out"(
	"input" AccessorStateAt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStateAt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateat_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:305
-- timescaledb_toolkit::state_aggregate::accessors::AccessorStateAt
CREATE TYPE AccessorStateAt (
	INTERNALLENGTH = variable,
	INPUT = accessorstateat_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorstateat_in */
	OUTPUT = accessorstateat_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorstateat_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:321
-- timescaledb_toolkit::state_aggregate::accessors::AccessorStateAtInt
CREATE TYPE AccessorStateAtInt;

-- extension/src/state_aggregate/accessors.rs:321
-- timescaledb_toolkit::state_aggregate::accessors::accessorstateatint_in
CREATE FUNCTION "accessorstateatint_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStateAtInt /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorStateAtInt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateatint_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:321
-- timescaledb_toolkit::state_aggregate::accessors::accessorstateatint_out
CREATE FUNCTION "accessorstateatint_out"(
	"input" AccessorStateAtInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStateAtInt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateatint_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:321
-- timescaledb_toolkit::state_aggregate::accessors::AccessorStateAtInt
CREATE TYPE AccessorStateAtInt (
	INTERNALLENGTH = variable,
	INPUT = accessorstateatint_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorstateatint_in */
	OUTPUT = accessorstateatint_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorstateatint_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:108
-- timescaledb_toolkit::accessors::AccessorStateIntTimeline
CREATE TYPE AccessorStateIntTimeline;

-- extension/src/accessors.rs:108
-- timescaledb_toolkit::accessors::accessorstateinttimeline_in
CREATE FUNCTION "accessorstateinttimeline_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStateIntTimeline /* core::option::Option<timescaledb_toolkit::accessors::AccessorStateIntTimeline> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateinttimeline_in_wrapper';

-- extension/src/accessors.rs:108
-- timescaledb_toolkit::accessors::accessorstateinttimeline_out
CREATE FUNCTION "accessorstateinttimeline_out"(
	"input" AccessorStateIntTimeline /* timescaledb_toolkit::accessors::AccessorStateIntTimeline */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateinttimeline_out_wrapper';

-- extension/src/accessors.rs:108
-- timescaledb_toolkit::accessors::AccessorStateIntTimeline
CREATE TYPE AccessorStateIntTimeline (
	INTERNALLENGTH = variable,
	INPUT = accessorstateinttimeline_in, /* timescaledb_toolkit::accessors::accessorstateinttimeline_in */
	OUTPUT = accessorstateinttimeline_out, /* timescaledb_toolkit::accessors::accessorstateinttimeline_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:217
-- timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriods
CREATE TYPE AccessorStatePeriods;

-- extension/src/state_aggregate/accessors.rs:217
-- timescaledb_toolkit::state_aggregate::accessors::accessorstateperiods_in
CREATE FUNCTION "accessorstateperiods_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStatePeriods /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriods> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateperiods_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:217
-- timescaledb_toolkit::state_aggregate::accessors::accessorstateperiods_out
CREATE FUNCTION "accessorstateperiods_out"(
	"input" AccessorStatePeriods /* timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriods */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateperiods_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:217
-- timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriods
CREATE TYPE AccessorStatePeriods (
	INTERNALLENGTH = variable,
	INPUT = accessorstateperiods_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorstateperiods_in */
	OUTPUT = accessorstateperiods_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorstateperiods_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:224
-- timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriodsInt
CREATE TYPE AccessorStatePeriodsInt;

-- extension/src/state_aggregate/accessors.rs:224
-- timescaledb_toolkit::state_aggregate::accessors::accessorstateperiodsint_in
CREATE FUNCTION "accessorstateperiodsint_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStatePeriodsInt /* core::option::Option<timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriodsInt> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateperiodsint_in_wrapper';

-- extension/src/state_aggregate/accessors.rs:224
-- timescaledb_toolkit::state_aggregate::accessors::accessorstateperiodsint_out
CREATE FUNCTION "accessorstateperiodsint_out"(
	"input" AccessorStatePeriodsInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriodsInt */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstateperiodsint_out_wrapper';

-- extension/src/state_aggregate/accessors.rs:224
-- timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriodsInt
CREATE TYPE AccessorStatePeriodsInt (
	INTERNALLENGTH = variable,
	INPUT = accessorstateperiodsint_in, /* timescaledb_toolkit::state_aggregate::accessors::accessorstateperiodsint_in */
	OUTPUT = accessorstateperiodsint_out, /* timescaledb_toolkit::state_aggregate::accessors::accessorstateperiodsint_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:107
-- timescaledb_toolkit::accessors::AccessorStateTimeline
CREATE TYPE AccessorStateTimeline;

-- extension/src/accessors.rs:107
-- timescaledb_toolkit::accessors::accessorstatetimeline_in
CREATE FUNCTION "accessorstatetimeline_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStateTimeline /* core::option::Option<timescaledb_toolkit::accessors::AccessorStateTimeline> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstatetimeline_in_wrapper';

-- extension/src/accessors.rs:107
-- timescaledb_toolkit::accessors::accessorstatetimeline_out
CREATE FUNCTION "accessorstatetimeline_out"(
	"input" AccessorStateTimeline /* timescaledb_toolkit::accessors::AccessorStateTimeline */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstatetimeline_out_wrapper';

-- extension/src/accessors.rs:107
-- timescaledb_toolkit::accessors::AccessorStateTimeline
CREATE TYPE AccessorStateTimeline (
	INTERNALLENGTH = variable,
	INPUT = accessorstatetimeline_in, /* timescaledb_toolkit::accessors::accessorstatetimeline_in */
	OUTPUT = accessorstatetimeline_out, /* timescaledb_toolkit::accessors::accessorstatetimeline_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:134
-- timescaledb_toolkit::accessors::AccessorStdDev

-- extension/src/accessors.rs:134
-- timescaledb_toolkit::accessors::accessorstddev_in
CREATE OR REPLACE FUNCTION "accessorstddev_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStdDev /* core::option::Option<timescaledb_toolkit::accessors::AccessorStdDev> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstddev_in_wrapper';

-- extension/src/accessors.rs:134
-- timescaledb_toolkit::accessors::accessorstddev_out
CREATE OR REPLACE FUNCTION "accessorstddev_out"(
	"input" AccessorStdDev /* timescaledb_toolkit::accessors::AccessorStdDev */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstddev_out_wrapper';

-- extension/src/accessors.rs:134
-- timescaledb_toolkit::accessors::AccessorStdDev

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:158
-- timescaledb_toolkit::accessors::AccessorStdDevX

-- extension/src/accessors.rs:158
-- timescaledb_toolkit::accessors::accessorstddevx_in
CREATE OR REPLACE FUNCTION "accessorstddevx_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStdDevX /* core::option::Option<timescaledb_toolkit::accessors::AccessorStdDevX> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstddevx_in_wrapper';

-- extension/src/accessors.rs:158
-- timescaledb_toolkit::accessors::accessorstddevx_out
CREATE OR REPLACE FUNCTION "accessorstddevx_out"(
	"input" AccessorStdDevX /* timescaledb_toolkit::accessors::AccessorStdDevX */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstddevx_out_wrapper';

-- extension/src/accessors.rs:158
-- timescaledb_toolkit::accessors::AccessorStdDevX

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:182
-- timescaledb_toolkit::accessors::AccessorStdDevY

-- extension/src/accessors.rs:182
-- timescaledb_toolkit::accessors::accessorstddevy_in
CREATE OR REPLACE FUNCTION "accessorstddevy_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStdDevY /* core::option::Option<timescaledb_toolkit::accessors::AccessorStdDevY> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstddevy_in_wrapper';

-- extension/src/accessors.rs:182
-- timescaledb_toolkit::accessors::accessorstddevy_out
CREATE OR REPLACE FUNCTION "accessorstddevy_out"(
	"input" AccessorStdDevY /* timescaledb_toolkit::accessors::AccessorStdDevY */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstddevy_out_wrapper';

-- extension/src/accessors.rs:182
-- timescaledb_toolkit::accessors::AccessorStdDevY

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:76
-- timescaledb_toolkit::accessors::AccessorStderror

-- extension/src/accessors.rs:76
-- timescaledb_toolkit::accessors::accessorstderror_in
CREATE OR REPLACE FUNCTION "accessorstderror_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorStderror /* core::option::Option<timescaledb_toolkit::accessors::AccessorStderror> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstderror_in_wrapper';

-- extension/src/accessors.rs:76
-- timescaledb_toolkit::accessors::accessorstderror_out
CREATE OR REPLACE FUNCTION "accessorstderror_out"(
	"input" AccessorStderror /* timescaledb_toolkit::accessors::AccessorStderror */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorstderror_out_wrapper';

-- extension/src/accessors.rs:76
-- timescaledb_toolkit::accessors::AccessorStderror

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:67
-- timescaledb_toolkit::accessors::AccessorSum

-- extension/src/accessors.rs:67
-- timescaledb_toolkit::accessors::accessorsum_in
CREATE OR REPLACE FUNCTION "accessorsum_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorSum /* core::option::Option<timescaledb_toolkit::accessors::AccessorSum> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorsum_in_wrapper';

-- extension/src/accessors.rs:67
-- timescaledb_toolkit::accessors::accessorsum_out
CREATE OR REPLACE FUNCTION "accessorsum_out"(
	"input" AccessorSum /* timescaledb_toolkit::accessors::AccessorSum */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorsum_out_wrapper';

-- extension/src/accessors.rs:67
-- timescaledb_toolkit::accessors::AccessorSum

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:68
-- timescaledb_toolkit::accessors::AccessorSumX

-- extension/src/accessors.rs:68
-- timescaledb_toolkit::accessors::accessorsumx_in
CREATE OR REPLACE FUNCTION "accessorsumx_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorSumX /* core::option::Option<timescaledb_toolkit::accessors::AccessorSumX> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorsumx_in_wrapper';

-- extension/src/accessors.rs:68
-- timescaledb_toolkit::accessors::accessorsumx_out
CREATE OR REPLACE FUNCTION "accessorsumx_out"(
	"input" AccessorSumX /* timescaledb_toolkit::accessors::AccessorSumX */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorsumx_out_wrapper';

-- extension/src/accessors.rs:68
-- timescaledb_toolkit::accessors::AccessorSumX

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:69
-- timescaledb_toolkit::accessors::AccessorSumY

-- extension/src/accessors.rs:69
-- timescaledb_toolkit::accessors::accessorsumy_in
CREATE OR REPLACE FUNCTION "accessorsumy_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorSumY /* core::option::Option<timescaledb_toolkit::accessors::AccessorSumY> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorsumy_in_wrapper';

-- extension/src/accessors.rs:69
-- timescaledb_toolkit::accessors::accessorsumy_out
CREATE OR REPLACE FUNCTION "accessorsumy_out"(
	"input" AccessorSumY /* timescaledb_toolkit::accessors::AccessorSumY */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorsumy_out_wrapper';

-- extension/src/accessors.rs:69
-- timescaledb_toolkit::accessors::AccessorSumY

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:78
-- timescaledb_toolkit::accessors::AccessorTimeDelta

-- extension/src/accessors.rs:78
-- timescaledb_toolkit::accessors::accessortimedelta_in
CREATE OR REPLACE FUNCTION "accessortimedelta_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorTimeDelta /* core::option::Option<timescaledb_toolkit::accessors::AccessorTimeDelta> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessortimedelta_in_wrapper';

-- extension/src/accessors.rs:78
-- timescaledb_toolkit::accessors::accessortimedelta_out
CREATE OR REPLACE FUNCTION "accessortimedelta_out"(
	"input" AccessorTimeDelta /* timescaledb_toolkit::accessors::AccessorTimeDelta */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessortimedelta_out_wrapper';

-- extension/src/accessors.rs:78
-- timescaledb_toolkit::accessors::AccessorTimeDelta

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:585
-- timescaledb_toolkit::accessors::AccessorTopNCount
CREATE TYPE AccessorTopNCount;

-- extension/src/accessors.rs:585
-- timescaledb_toolkit::accessors::accessortopncount_in
CREATE FUNCTION "accessortopncount_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorTopNCount /* core::option::Option<timescaledb_toolkit::accessors::AccessorTopNCount> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessortopncount_in_wrapper';

-- extension/src/accessors.rs:585
-- timescaledb_toolkit::accessors::accessortopncount_out
CREATE FUNCTION "accessortopncount_out"(
	"input" AccessorTopNCount /* timescaledb_toolkit::accessors::AccessorTopNCount */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessortopncount_out_wrapper';

-- extension/src/accessors.rs:585
-- timescaledb_toolkit::accessors::AccessorTopNCount
CREATE TYPE AccessorTopNCount (
	INTERNALLENGTH = variable,
	INPUT = accessortopncount_in, /* timescaledb_toolkit::accessors::accessortopncount_in */
	OUTPUT = accessortopncount_out, /* timescaledb_toolkit::accessors::accessortopncount_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:111
-- timescaledb_toolkit::accessors::AccessorTopn
CREATE TYPE AccessorTopn;

-- extension/src/accessors.rs:111
-- timescaledb_toolkit::accessors::accessortopn_in
CREATE FUNCTION "accessortopn_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorTopn /* core::option::Option<timescaledb_toolkit::accessors::AccessorTopn> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessortopn_in_wrapper';

-- extension/src/accessors.rs:111
-- timescaledb_toolkit::accessors::accessortopn_out
CREATE FUNCTION "accessortopn_out"(
	"input" AccessorTopn /* timescaledb_toolkit::accessors::AccessorTopn */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessortopn_out_wrapper';

-- extension/src/accessors.rs:111
-- timescaledb_toolkit::accessors::AccessorTopn
CREATE TYPE AccessorTopn (
	INTERNALLENGTH = variable,
	INPUT = accessortopn_in, /* timescaledb_toolkit::accessors::accessortopn_in */
	OUTPUT = accessortopn_out, /* timescaledb_toolkit::accessors::accessortopn_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:543
-- timescaledb_toolkit::accessors::AccessorUnnest

-- extension/src/accessors.rs:543
-- timescaledb_toolkit::accessors::accessorunnest_in
CREATE OR REPLACE FUNCTION "accessorunnest_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorUnnest /* core::option::Option<timescaledb_toolkit::accessors::AccessorUnnest> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorunnest_in_wrapper';

-- extension/src/accessors.rs:543
-- timescaledb_toolkit::accessors::accessorunnest_out
CREATE OR REPLACE FUNCTION "accessorunnest_out"(
	"input" AccessorUnnest /* timescaledb_toolkit::accessors::AccessorUnnest */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorunnest_out_wrapper';

-- extension/src/accessors.rs:543
-- timescaledb_toolkit::accessors::AccessorUnnest

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:102
-- timescaledb_toolkit::accessors::AccessorUptime
CREATE TYPE AccessorUptime;

-- extension/src/accessors.rs:102
-- timescaledb_toolkit::accessors::accessoruptime_in
CREATE FUNCTION "accessoruptime_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorUptime /* core::option::Option<timescaledb_toolkit::accessors::AccessorUptime> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoruptime_in_wrapper';

-- extension/src/accessors.rs:102
-- timescaledb_toolkit::accessors::accessoruptime_out
CREATE FUNCTION "accessoruptime_out"(
	"input" AccessorUptime /* timescaledb_toolkit::accessors::AccessorUptime */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessoruptime_out_wrapper';

-- extension/src/accessors.rs:102
-- timescaledb_toolkit::accessors::AccessorUptime
CREATE TYPE AccessorUptime (
	INTERNALLENGTH = variable,
	INPUT = accessoruptime_in, /* timescaledb_toolkit::accessors::accessoruptime_in */
	OUTPUT = accessoruptime_out, /* timescaledb_toolkit::accessors::accessoruptime_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:206
-- timescaledb_toolkit::accessors::AccessorVariance

-- extension/src/accessors.rs:206
-- timescaledb_toolkit::accessors::accessorvariance_in
CREATE OR REPLACE FUNCTION "accessorvariance_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorVariance /* core::option::Option<timescaledb_toolkit::accessors::AccessorVariance> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorvariance_in_wrapper';

-- extension/src/accessors.rs:206
-- timescaledb_toolkit::accessors::accessorvariance_out
CREATE OR REPLACE FUNCTION "accessorvariance_out"(
	"input" AccessorVariance /* timescaledb_toolkit::accessors::AccessorVariance */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorvariance_out_wrapper';

-- extension/src/accessors.rs:206
-- timescaledb_toolkit::accessors::AccessorVariance

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:230
-- timescaledb_toolkit::accessors::AccessorVarianceX

-- extension/src/accessors.rs:230
-- timescaledb_toolkit::accessors::accessorvariancex_in
CREATE OR REPLACE FUNCTION "accessorvariancex_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorVarianceX /* core::option::Option<timescaledb_toolkit::accessors::AccessorVarianceX> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorvariancex_in_wrapper';

-- extension/src/accessors.rs:230
-- timescaledb_toolkit::accessors::accessorvariancex_out
CREATE OR REPLACE FUNCTION "accessorvariancex_out"(
	"input" AccessorVarianceX /* timescaledb_toolkit::accessors::AccessorVarianceX */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorvariancex_out_wrapper';

-- extension/src/accessors.rs:230
-- timescaledb_toolkit::accessors::AccessorVarianceX

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:254
-- timescaledb_toolkit::accessors::AccessorVarianceY

-- extension/src/accessors.rs:254
-- timescaledb_toolkit::accessors::accessorvariancey_in
CREATE OR REPLACE FUNCTION "accessorvariancey_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorVarianceY /* core::option::Option<timescaledb_toolkit::accessors::AccessorVarianceY> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorvariancey_in_wrapper';

-- extension/src/accessors.rs:254
-- timescaledb_toolkit::accessors::accessorvariancey_out
CREATE OR REPLACE FUNCTION "accessorvariancey_out"(
	"input" AccessorVarianceY /* timescaledb_toolkit::accessors::AccessorVarianceY */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorvariancey_out_wrapper';

-- extension/src/accessors.rs:254
-- timescaledb_toolkit::accessors::AccessorVarianceY

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:488
-- timescaledb_toolkit::accessors::AccessorWithBounds

-- extension/src/accessors.rs:488
-- timescaledb_toolkit::accessors::accessorwithbounds_in
CREATE OR REPLACE FUNCTION "accessorwithbounds_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorWithBounds /* core::option::Option<timescaledb_toolkit::accessors::AccessorWithBounds> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorwithbounds_in_wrapper';

-- extension/src/accessors.rs:488
-- timescaledb_toolkit::accessors::accessorwithbounds_out
CREATE OR REPLACE FUNCTION "accessorwithbounds_out"(
	"input" AccessorWithBounds /* timescaledb_toolkit::accessors::AccessorWithBounds */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorwithbounds_out_wrapper';

-- extension/src/accessors.rs:488
-- timescaledb_toolkit::accessors::AccessorWithBounds

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:73
-- timescaledb_toolkit::accessors::AccessorXIntercept

-- extension/src/accessors.rs:73
-- timescaledb_toolkit::accessors::accessorxintercept_in
CREATE OR REPLACE FUNCTION "accessorxintercept_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS AccessorXIntercept /* core::option::Option<timescaledb_toolkit::accessors::AccessorXIntercept> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorxintercept_in_wrapper';

-- extension/src/accessors.rs:73
-- timescaledb_toolkit::accessors::accessorxintercept_out
CREATE OR REPLACE FUNCTION "accessorxintercept_out"(
	"input" AccessorXIntercept /* timescaledb_toolkit::accessors::AccessorXIntercept */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorxintercept_out_wrapper';

-- extension/src/accessors.rs:73
-- timescaledb_toolkit::accessors::AccessorXIntercept

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:27
-- timescaledb_toolkit::candlestick::Candlestick
CREATE TYPE Candlestick;

-- extension/src/candlestick.rs:27
-- timescaledb_toolkit::candlestick::candlestick_in
CREATE FUNCTION "candlestick_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'candlestick_in_wrapper';

-- extension/src/candlestick.rs:27
-- timescaledb_toolkit::candlestick::candlestick_out
CREATE FUNCTION "candlestick_out"(
	"input" Candlestick /* timescaledb_toolkit::candlestick::Candlestick */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'candlestick_out_wrapper';

-- extension/src/candlestick.rs:27
-- timescaledb_toolkit::candlestick::Candlestick
CREATE TYPE Candlestick (
	INTERNALLENGTH = variable,
	INPUT = candlestick_in, /* timescaledb_toolkit::candlestick::candlestick_in */
	OUTPUT = candlestick_out, /* timescaledb_toolkit::candlestick::candlestick_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg/accessors.rs:52
-- timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedDeltaAccessor
CREATE TYPE CounterInterpolatedDeltaAccessor;

-- extension/src/counter_agg/accessors.rs:52
-- timescaledb_toolkit::counter_agg::accessors::counterinterpolateddeltaaccessor_in
CREATE FUNCTION "counterinterpolateddeltaaccessor_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS CounterInterpolatedDeltaAccessor /* core::option::Option<timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedDeltaAccessor> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counterinterpolateddeltaaccessor_in_wrapper';

-- extension/src/counter_agg/accessors.rs:52
-- timescaledb_toolkit::counter_agg::accessors::counterinterpolateddeltaaccessor_out
CREATE FUNCTION "counterinterpolateddeltaaccessor_out"(
	"input" CounterInterpolatedDeltaAccessor /* timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedDeltaAccessor */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counterinterpolateddeltaaccessor_out_wrapper';

-- extension/src/counter_agg/accessors.rs:52
-- timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedDeltaAccessor
CREATE TYPE CounterInterpolatedDeltaAccessor (
	INTERNALLENGTH = variable,
	INPUT = counterinterpolateddeltaaccessor_in, /* timescaledb_toolkit::counter_agg::accessors::counterinterpolateddeltaaccessor_in */
	OUTPUT = counterinterpolateddeltaaccessor_out, /* timescaledb_toolkit::counter_agg::accessors::counterinterpolateddeltaaccessor_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg/accessors.rs:11
-- timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedRateAccessor
CREATE TYPE CounterInterpolatedRateAccessor;

-- extension/src/counter_agg/accessors.rs:11
-- timescaledb_toolkit::counter_agg::accessors::counterinterpolatedrateaccessor_in
CREATE FUNCTION "counterinterpolatedrateaccessor_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS CounterInterpolatedRateAccessor /* core::option::Option<timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedRateAccessor> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counterinterpolatedrateaccessor_in_wrapper';

-- extension/src/counter_agg/accessors.rs:11
-- timescaledb_toolkit::counter_agg::accessors::counterinterpolatedrateaccessor_out
CREATE FUNCTION "counterinterpolatedrateaccessor_out"(
	"input" CounterInterpolatedRateAccessor /* timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedRateAccessor */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counterinterpolatedrateaccessor_out_wrapper';

-- extension/src/counter_agg/accessors.rs:11
-- timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedRateAccessor
CREATE TYPE CounterInterpolatedRateAccessor (
	INTERNALLENGTH = variable,
	INPUT = counterinterpolatedrateaccessor_in, /* timescaledb_toolkit::counter_agg::accessors::counterinterpolatedrateaccessor_in */
	OUTPUT = counterinterpolatedrateaccessor_out, /* timescaledb_toolkit::counter_agg::accessors::counterinterpolatedrateaccessor_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:39
-- timescaledb_toolkit::counter_agg::CounterSummary

-- extension/src/counter_agg.rs:39
-- timescaledb_toolkit::counter_agg::countersummary_in
CREATE OR REPLACE FUNCTION "countersummary_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS CounterSummary /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'countersummary_in_wrapper';

-- extension/src/counter_agg.rs:39
-- timescaledb_toolkit::counter_agg::countersummary_out
CREATE OR REPLACE FUNCTION "countersummary_out"(
	"input" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'countersummary_out_wrapper';

-- extension/src/counter_agg.rs:39
-- timescaledb_toolkit::counter_agg::CounterSummary

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:192
-- timescaledb_toolkit::heartbeat_agg::HeartbeatAgg
CREATE TYPE HeartbeatAgg;

-- extension/src/heartbeat_agg.rs:192
-- timescaledb_toolkit::heartbeat_agg::heartbeatagg_in
CREATE FUNCTION "heartbeatagg_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeatagg_in_wrapper';

-- extension/src/heartbeat_agg.rs:192
-- timescaledb_toolkit::heartbeat_agg::heartbeatagg_out
CREATE FUNCTION "heartbeatagg_out"(
	"input" HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeatagg_out_wrapper';

-- extension/src/heartbeat_agg.rs:192
-- timescaledb_toolkit::heartbeat_agg::HeartbeatAgg
CREATE TYPE HeartbeatAgg (
	INTERNALLENGTH = variable,
	INPUT = heartbeatagg_in, /* timescaledb_toolkit::heartbeat_agg::heartbeatagg_in */
	OUTPUT = heartbeatagg_out, /* timescaledb_toolkit::heartbeat_agg::heartbeatagg_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg/accessors.rs:91
-- timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolateAccessor
CREATE TYPE HeartbeatInterpolateAccessor;

-- extension/src/heartbeat_agg/accessors.rs:91
-- timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateaccessor_in
CREATE FUNCTION "heartbeatinterpolateaccessor_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS HeartbeatInterpolateAccessor /* core::option::Option<timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolateAccessor> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeatinterpolateaccessor_in_wrapper';

-- extension/src/heartbeat_agg/accessors.rs:91
-- timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateaccessor_out
CREATE FUNCTION "heartbeatinterpolateaccessor_out"(
	"input" HeartbeatInterpolateAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolateAccessor */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeatinterpolateaccessor_out_wrapper';

-- extension/src/heartbeat_agg/accessors.rs:91
-- timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolateAccessor
CREATE TYPE HeartbeatInterpolateAccessor (
	INTERNALLENGTH = variable,
	INPUT = heartbeatinterpolateaccessor_in, /* timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateaccessor_in */
	OUTPUT = heartbeatinterpolateaccessor_out, /* timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateaccessor_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg/accessors.rs:57
-- timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedDowntimeAccessor
CREATE TYPE HeartbeatInterpolatedDowntimeAccessor;

-- extension/src/heartbeat_agg/accessors.rs:57
-- timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateddowntimeaccessor_in
CREATE FUNCTION "heartbeatinterpolateddowntimeaccessor_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS HeartbeatInterpolatedDowntimeAccessor /* core::option::Option<timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedDowntimeAccessor> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeatinterpolateddowntimeaccessor_in_wrapper';

-- extension/src/heartbeat_agg/accessors.rs:57
-- timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateddowntimeaccessor_out
CREATE FUNCTION "heartbeatinterpolateddowntimeaccessor_out"(
	"input" HeartbeatInterpolatedDowntimeAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedDowntimeAccessor */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeatinterpolateddowntimeaccessor_out_wrapper';

-- extension/src/heartbeat_agg/accessors.rs:57
-- timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedDowntimeAccessor
CREATE TYPE HeartbeatInterpolatedDowntimeAccessor (
	INTERNALLENGTH = variable,
	INPUT = heartbeatinterpolateddowntimeaccessor_in, /* timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateddowntimeaccessor_in */
	OUTPUT = heartbeatinterpolateddowntimeaccessor_out, /* timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateddowntimeaccessor_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg/accessors.rs:23
-- timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedUptimeAccessor
CREATE TYPE HeartbeatInterpolatedUptimeAccessor;

-- extension/src/heartbeat_agg/accessors.rs:23
-- timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateduptimeaccessor_in
CREATE FUNCTION "heartbeatinterpolateduptimeaccessor_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS HeartbeatInterpolatedUptimeAccessor /* core::option::Option<timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedUptimeAccessor> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeatinterpolateduptimeaccessor_in_wrapper';

-- extension/src/heartbeat_agg/accessors.rs:23
-- timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateduptimeaccessor_out
CREATE FUNCTION "heartbeatinterpolateduptimeaccessor_out"(
	"input" HeartbeatInterpolatedUptimeAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedUptimeAccessor */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeatinterpolateduptimeaccessor_out_wrapper';

-- extension/src/heartbeat_agg/accessors.rs:23
-- timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedUptimeAccessor
CREATE TYPE HeartbeatInterpolatedUptimeAccessor (
	INTERNALLENGTH = variable,
	INPUT = heartbeatinterpolateduptimeaccessor_in, /* timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateduptimeaccessor_in */
	OUTPUT = heartbeatinterpolateduptimeaccessor_out, /* timescaledb_toolkit::heartbeat_agg::accessors::heartbeatinterpolateduptimeaccessor_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg/accessors.rs:125
-- timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatTrimToAccessor
CREATE TYPE HeartbeatTrimToAccessor;

-- extension/src/heartbeat_agg/accessors.rs:125
-- timescaledb_toolkit::heartbeat_agg::accessors::heartbeattrimtoaccessor_in
CREATE FUNCTION "heartbeattrimtoaccessor_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS HeartbeatTrimToAccessor /* core::option::Option<timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatTrimToAccessor> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeattrimtoaccessor_in_wrapper';

-- extension/src/heartbeat_agg/accessors.rs:125
-- timescaledb_toolkit::heartbeat_agg::accessors::heartbeattrimtoaccessor_out
CREATE FUNCTION "heartbeattrimtoaccessor_out"(
	"input" HeartbeatTrimToAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatTrimToAccessor */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeattrimtoaccessor_out_wrapper';

-- extension/src/heartbeat_agg/accessors.rs:125
-- timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatTrimToAccessor
CREATE TYPE HeartbeatTrimToAccessor (
	INTERNALLENGTH = variable,
	INPUT = heartbeattrimtoaccessor_in, /* timescaledb_toolkit::heartbeat_agg::accessors::heartbeattrimtoaccessor_in */
	OUTPUT = heartbeattrimtoaccessor_out, /* timescaledb_toolkit::heartbeat_agg::accessors::heartbeattrimtoaccessor_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:170
-- timescaledb_toolkit::hyperloglog::HyperLogLog

-- extension/src/hyperloglog.rs:170
-- timescaledb_toolkit::hyperloglog::hyperloglog_in
CREATE OR REPLACE FUNCTION "hyperloglog_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS HyperLogLog /* core::option::Option<timescaledb_toolkit::hyperloglog::HyperLogLog> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_in_wrapper';

-- extension/src/hyperloglog.rs:170
-- timescaledb_toolkit::hyperloglog::hyperloglog_out
CREATE OR REPLACE FUNCTION "hyperloglog_out"(
	"input" HyperLogLog /* timescaledb_toolkit::hyperloglog::HyperLogLog */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_out_wrapper';

-- extension/src/hyperloglog.rs:170
-- timescaledb_toolkit::hyperloglog::HyperLogLog

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_float.rs:17
-- timescaledb_toolkit::nmost::max_by_float::MaxByFloats
CREATE TYPE MaxByFloats;

-- extension/src/nmost/max_by_float.rs:17
-- timescaledb_toolkit::nmost::max_by_float::maxbyfloats_in
CREATE FUNCTION "maxbyfloats_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MaxByFloats /* core::option::Option<timescaledb_toolkit::nmost::max_by_float::MaxByFloats> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxbyfloats_in_wrapper';

-- extension/src/nmost/max_by_float.rs:17
-- timescaledb_toolkit::nmost::max_by_float::maxbyfloats_out
CREATE FUNCTION "maxbyfloats_out"(
	"input" MaxByFloats /* timescaledb_toolkit::nmost::max_by_float::MaxByFloats */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxbyfloats_out_wrapper';

-- extension/src/nmost/max_by_float.rs:17
-- timescaledb_toolkit::nmost::max_by_float::MaxByFloats
CREATE TYPE MaxByFloats (
	INTERNALLENGTH = variable,
	INPUT = maxbyfloats_in, /* timescaledb_toolkit::nmost::max_by_float::maxbyfloats_in */
	OUTPUT = maxbyfloats_out, /* timescaledb_toolkit::nmost::max_by_float::maxbyfloats_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_int.rs:16
-- timescaledb_toolkit::nmost::max_by_int::MaxByInts
CREATE TYPE MaxByInts;

-- extension/src/nmost/max_by_int.rs:16
-- timescaledb_toolkit::nmost::max_by_int::maxbyints_in
CREATE FUNCTION "maxbyints_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MaxByInts /* core::option::Option<timescaledb_toolkit::nmost::max_by_int::MaxByInts> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxbyints_in_wrapper';

-- extension/src/nmost/max_by_int.rs:16
-- timescaledb_toolkit::nmost::max_by_int::maxbyints_out
CREATE FUNCTION "maxbyints_out"(
	"input" MaxByInts /* timescaledb_toolkit::nmost::max_by_int::MaxByInts */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxbyints_out_wrapper';

-- extension/src/nmost/max_by_int.rs:16
-- timescaledb_toolkit::nmost::max_by_int::MaxByInts
CREATE TYPE MaxByInts (
	INTERNALLENGTH = variable,
	INPUT = maxbyints_in, /* timescaledb_toolkit::nmost::max_by_int::maxbyints_in */
	OUTPUT = maxbyints_out, /* timescaledb_toolkit::nmost::max_by_int::maxbyints_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_time.rs:16
-- timescaledb_toolkit::nmost::max_by_time::MaxByTimes
CREATE TYPE MaxByTimes;

-- extension/src/nmost/max_by_time.rs:16
-- timescaledb_toolkit::nmost::max_by_time::maxbytimes_in
CREATE FUNCTION "maxbytimes_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MaxByTimes /* core::option::Option<timescaledb_toolkit::nmost::max_by_time::MaxByTimes> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxbytimes_in_wrapper';

-- extension/src/nmost/max_by_time.rs:16
-- timescaledb_toolkit::nmost::max_by_time::maxbytimes_out
CREATE FUNCTION "maxbytimes_out"(
	"input" MaxByTimes /* timescaledb_toolkit::nmost::max_by_time::MaxByTimes */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxbytimes_out_wrapper';

-- extension/src/nmost/max_by_time.rs:16
-- timescaledb_toolkit::nmost::max_by_time::MaxByTimes
CREATE TYPE MaxByTimes (
	INTERNALLENGTH = variable,
	INPUT = maxbytimes_in, /* timescaledb_toolkit::nmost::max_by_time::maxbytimes_in */
	OUTPUT = maxbytimes_out, /* timescaledb_toolkit::nmost::max_by_time::maxbytimes_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:19
-- timescaledb_toolkit::nmost::max_float::MaxFloats
CREATE TYPE MaxFloats;

-- extension/src/nmost/max_float.rs:19
-- timescaledb_toolkit::nmost::max_float::maxfloats_in
CREATE FUNCTION "maxfloats_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MaxFloats /* core::option::Option<timescaledb_toolkit::nmost::max_float::MaxFloats> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxfloats_in_wrapper';

-- extension/src/nmost/max_float.rs:19
-- timescaledb_toolkit::nmost::max_float::maxfloats_out
CREATE FUNCTION "maxfloats_out"(
	"input" MaxFloats /* timescaledb_toolkit::nmost::max_float::MaxFloats */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxfloats_out_wrapper';

-- extension/src/nmost/max_float.rs:19
-- timescaledb_toolkit::nmost::max_float::MaxFloats
CREATE TYPE MaxFloats (
	INTERNALLENGTH = variable,
	INPUT = maxfloats_in, /* timescaledb_toolkit::nmost::max_float::maxfloats_in */
	OUTPUT = maxfloats_out, /* timescaledb_toolkit::nmost::max_float::maxfloats_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:18
-- timescaledb_toolkit::nmost::max_int::MaxInts
CREATE TYPE MaxInts;

-- extension/src/nmost/max_int.rs:18
-- timescaledb_toolkit::nmost::max_int::maxints_in
CREATE FUNCTION "maxints_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MaxInts /* core::option::Option<timescaledb_toolkit::nmost::max_int::MaxInts> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxints_in_wrapper';

-- extension/src/nmost/max_int.rs:18
-- timescaledb_toolkit::nmost::max_int::maxints_out
CREATE FUNCTION "maxints_out"(
	"input" MaxInts /* timescaledb_toolkit::nmost::max_int::MaxInts */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxints_out_wrapper';

-- extension/src/nmost/max_int.rs:18
-- timescaledb_toolkit::nmost::max_int::MaxInts
CREATE TYPE MaxInts (
	INTERNALLENGTH = variable,
	INPUT = maxints_in, /* timescaledb_toolkit::nmost::max_int::maxints_in */
	OUTPUT = maxints_out, /* timescaledb_toolkit::nmost::max_int::maxints_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:18
-- timescaledb_toolkit::nmost::max_time::MaxTimes
CREATE TYPE MaxTimes;

-- extension/src/nmost/max_time.rs:18
-- timescaledb_toolkit::nmost::max_time::maxtimes_in
CREATE FUNCTION "maxtimes_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MaxTimes /* core::option::Option<timescaledb_toolkit::nmost::max_time::MaxTimes> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxtimes_in_wrapper';

-- extension/src/nmost/max_time.rs:18
-- timescaledb_toolkit::nmost::max_time::maxtimes_out
CREATE FUNCTION "maxtimes_out"(
	"input" MaxTimes /* timescaledb_toolkit::nmost::max_time::MaxTimes */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'maxtimes_out_wrapper';

-- extension/src/nmost/max_time.rs:18
-- timescaledb_toolkit::nmost::max_time::MaxTimes
CREATE TYPE MaxTimes (
	INTERNALLENGTH = variable,
	INPUT = maxtimes_in, /* timescaledb_toolkit::nmost::max_time::maxtimes_in */
	OUTPUT = maxtimes_out, /* timescaledb_toolkit::nmost::max_time::maxtimes_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_float.rs:16
-- timescaledb_toolkit::nmost::min_by_float::MinByFloats
CREATE TYPE MinByFloats;

-- extension/src/nmost/min_by_float.rs:16
-- timescaledb_toolkit::nmost::min_by_float::minbyfloats_in
CREATE FUNCTION "minbyfloats_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MinByFloats /* core::option::Option<timescaledb_toolkit::nmost::min_by_float::MinByFloats> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minbyfloats_in_wrapper';

-- extension/src/nmost/min_by_float.rs:16
-- timescaledb_toolkit::nmost::min_by_float::minbyfloats_out
CREATE FUNCTION "minbyfloats_out"(
	"input" MinByFloats /* timescaledb_toolkit::nmost::min_by_float::MinByFloats */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minbyfloats_out_wrapper';

-- extension/src/nmost/min_by_float.rs:16
-- timescaledb_toolkit::nmost::min_by_float::MinByFloats
CREATE TYPE MinByFloats (
	INTERNALLENGTH = variable,
	INPUT = minbyfloats_in, /* timescaledb_toolkit::nmost::min_by_float::minbyfloats_in */
	OUTPUT = minbyfloats_out, /* timescaledb_toolkit::nmost::min_by_float::minbyfloats_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_int.rs:14
-- timescaledb_toolkit::nmost::min_by_int::MinByInts
CREATE TYPE MinByInts;

-- extension/src/nmost/min_by_int.rs:14
-- timescaledb_toolkit::nmost::min_by_int::minbyints_in
CREATE FUNCTION "minbyints_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MinByInts /* core::option::Option<timescaledb_toolkit::nmost::min_by_int::MinByInts> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minbyints_in_wrapper';

-- extension/src/nmost/min_by_int.rs:14
-- timescaledb_toolkit::nmost::min_by_int::minbyints_out
CREATE FUNCTION "minbyints_out"(
	"input" MinByInts /* timescaledb_toolkit::nmost::min_by_int::MinByInts */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minbyints_out_wrapper';

-- extension/src/nmost/min_by_int.rs:14
-- timescaledb_toolkit::nmost::min_by_int::MinByInts
CREATE TYPE MinByInts (
	INTERNALLENGTH = variable,
	INPUT = minbyints_in, /* timescaledb_toolkit::nmost::min_by_int::minbyints_in */
	OUTPUT = minbyints_out, /* timescaledb_toolkit::nmost::min_by_int::minbyints_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_time.rs:14
-- timescaledb_toolkit::nmost::min_by_time::MinByTimes
CREATE TYPE MinByTimes;

-- extension/src/nmost/min_by_time.rs:14
-- timescaledb_toolkit::nmost::min_by_time::minbytimes_in
CREATE FUNCTION "minbytimes_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MinByTimes /* core::option::Option<timescaledb_toolkit::nmost::min_by_time::MinByTimes> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minbytimes_in_wrapper';

-- extension/src/nmost/min_by_time.rs:14
-- timescaledb_toolkit::nmost::min_by_time::minbytimes_out
CREATE FUNCTION "minbytimes_out"(
	"input" MinByTimes /* timescaledb_toolkit::nmost::min_by_time::MinByTimes */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minbytimes_out_wrapper';

-- extension/src/nmost/min_by_time.rs:14
-- timescaledb_toolkit::nmost::min_by_time::MinByTimes
CREATE TYPE MinByTimes (
	INTERNALLENGTH = variable,
	INPUT = minbytimes_in, /* timescaledb_toolkit::nmost::min_by_time::minbytimes_in */
	OUTPUT = minbytimes_out, /* timescaledb_toolkit::nmost::min_by_time::minbytimes_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:18
-- timescaledb_toolkit::nmost::min_float::MinFloats
CREATE TYPE MinFloats;

-- extension/src/nmost/min_float.rs:18
-- timescaledb_toolkit::nmost::min_float::minfloats_in
CREATE FUNCTION "minfloats_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MinFloats /* core::option::Option<timescaledb_toolkit::nmost::min_float::MinFloats> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minfloats_in_wrapper';

-- extension/src/nmost/min_float.rs:18
-- timescaledb_toolkit::nmost::min_float::minfloats_out
CREATE FUNCTION "minfloats_out"(
	"input" MinFloats /* timescaledb_toolkit::nmost::min_float::MinFloats */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minfloats_out_wrapper';

-- extension/src/nmost/min_float.rs:18
-- timescaledb_toolkit::nmost::min_float::MinFloats
CREATE TYPE MinFloats (
	INTERNALLENGTH = variable,
	INPUT = minfloats_in, /* timescaledb_toolkit::nmost::min_float::minfloats_in */
	OUTPUT = minfloats_out, /* timescaledb_toolkit::nmost::min_float::minfloats_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:16
-- timescaledb_toolkit::nmost::min_int::MinInts
CREATE TYPE MinInts;

-- extension/src/nmost/min_int.rs:16
-- timescaledb_toolkit::nmost::min_int::minints_in
CREATE FUNCTION "minints_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MinInts /* core::option::Option<timescaledb_toolkit::nmost::min_int::MinInts> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minints_in_wrapper';

-- extension/src/nmost/min_int.rs:16
-- timescaledb_toolkit::nmost::min_int::minints_out
CREATE FUNCTION "minints_out"(
	"input" MinInts /* timescaledb_toolkit::nmost::min_int::MinInts */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'minints_out_wrapper';

-- extension/src/nmost/min_int.rs:16
-- timescaledb_toolkit::nmost::min_int::MinInts
CREATE TYPE MinInts (
	INTERNALLENGTH = variable,
	INPUT = minints_in, /* timescaledb_toolkit::nmost::min_int::minints_in */
	OUTPUT = minints_out, /* timescaledb_toolkit::nmost::min_int::minints_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:16
-- timescaledb_toolkit::nmost::min_time::MinTimes
CREATE TYPE MinTimes;

-- extension/src/nmost/min_time.rs:16
-- timescaledb_toolkit::nmost::min_time::mintimes_in
CREATE FUNCTION "mintimes_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS MinTimes /* core::option::Option<timescaledb_toolkit::nmost::min_time::MinTimes> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'mintimes_in_wrapper';

-- extension/src/nmost/min_time.rs:16
-- timescaledb_toolkit::nmost::min_time::mintimes_out
CREATE FUNCTION "mintimes_out"(
	"input" MinTimes /* timescaledb_toolkit::nmost::min_time::MinTimes */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'mintimes_out_wrapper';

-- extension/src/nmost/min_time.rs:16
-- timescaledb_toolkit::nmost::min_time::MinTimes
CREATE TYPE MinTimes (
	INTERNALLENGTH = variable,
	INPUT = mintimes_in, /* timescaledb_toolkit::nmost::min_time::mintimes_in */
	OUTPUT = mintimes_out, /* timescaledb_toolkit::nmost::min_time::mintimes_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:415
-- timescaledb_toolkit::frequency::SpaceSavingAggregate
CREATE TYPE SpaceSavingAggregate;

-- extension/src/frequency.rs:415
-- timescaledb_toolkit::frequency::spacesavingaggregate_in
CREATE FUNCTION "spacesavingaggregate_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS SpaceSavingAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingAggregate> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'spacesavingaggregate_in_wrapper';

-- extension/src/frequency.rs:415
-- timescaledb_toolkit::frequency::spacesavingaggregate_out
CREATE FUNCTION "spacesavingaggregate_out"(
	"input" SpaceSavingAggregate /* timescaledb_toolkit::frequency::SpaceSavingAggregate */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'spacesavingaggregate_out_wrapper';

-- extension/src/frequency.rs:415
-- timescaledb_toolkit::frequency::SpaceSavingAggregate
CREATE TYPE SpaceSavingAggregate (
	INTERNALLENGTH = variable,
	INPUT = spacesavingaggregate_in, /* timescaledb_toolkit::frequency::spacesavingaggregate_in */
	OUTPUT = spacesavingaggregate_out, /* timescaledb_toolkit::frequency::spacesavingaggregate_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:488
-- timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate
CREATE TYPE SpaceSavingBigIntAggregate;

-- extension/src/frequency.rs:488
-- timescaledb_toolkit::frequency::spacesavingbigintaggregate_in
CREATE FUNCTION "spacesavingbigintaggregate_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS SpaceSavingBigIntAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'spacesavingbigintaggregate_in_wrapper';

-- extension/src/frequency.rs:488
-- timescaledb_toolkit::frequency::spacesavingbigintaggregate_out
CREATE FUNCTION "spacesavingbigintaggregate_out"(
	"input" SpaceSavingBigIntAggregate /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'spacesavingbigintaggregate_out_wrapper';

-- extension/src/frequency.rs:488
-- timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate
CREATE TYPE SpaceSavingBigIntAggregate (
	INTERNALLENGTH = variable,
	INPUT = spacesavingbigintaggregate_in, /* timescaledb_toolkit::frequency::spacesavingbigintaggregate_in */
	OUTPUT = spacesavingbigintaggregate_out, /* timescaledb_toolkit::frequency::spacesavingbigintaggregate_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:565
-- timescaledb_toolkit::frequency::SpaceSavingTextAggregate
CREATE TYPE SpaceSavingTextAggregate;

-- extension/src/frequency.rs:565
-- timescaledb_toolkit::frequency::spacesavingtextaggregate_in
CREATE FUNCTION "spacesavingtextaggregate_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS SpaceSavingTextAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingTextAggregate> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'spacesavingtextaggregate_in_wrapper';

-- extension/src/frequency.rs:565
-- timescaledb_toolkit::frequency::spacesavingtextaggregate_out
CREATE FUNCTION "spacesavingtextaggregate_out"(
	"input" SpaceSavingTextAggregate /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'spacesavingtextaggregate_out_wrapper';

-- extension/src/frequency.rs:565
-- timescaledb_toolkit::frequency::SpaceSavingTextAggregate
CREATE TYPE SpaceSavingTextAggregate (
	INTERNALLENGTH = variable,
	INPUT = spacesavingtextaggregate_in, /* timescaledb_toolkit::frequency::spacesavingtextaggregate_in */
	OUTPUT = spacesavingtextaggregate_out, /* timescaledb_toolkit::frequency::spacesavingtextaggregate_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:417
-- timescaledb_toolkit::state_aggregate::StateAgg
CREATE TYPE StateAgg;

-- extension/src/state_aggregate.rs:417
-- timescaledb_toolkit::state_aggregate::stateagg_in
CREATE FUNCTION "stateagg_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stateagg_in_wrapper';

-- extension/src/state_aggregate.rs:417
-- timescaledb_toolkit::state_aggregate::stateagg_out
CREATE FUNCTION "stateagg_out"(
	"input" StateAgg /* timescaledb_toolkit::state_aggregate::StateAgg */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stateagg_out_wrapper';

-- extension/src/state_aggregate.rs:417
-- timescaledb_toolkit::state_aggregate::StateAgg
CREATE TYPE StateAgg (
	INTERNALLENGTH = variable,
	INPUT = stateagg_in, /* timescaledb_toolkit::state_aggregate::stateagg_in */
	OUTPUT = stateagg_out, /* timescaledb_toolkit::state_aggregate::stateagg_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:29
-- timescaledb_toolkit::stats_agg::StatsSummary1D

-- extension/src/stats_agg.rs:29
-- timescaledb_toolkit::stats_agg::statssummary1d_in
CREATE OR REPLACE FUNCTION "statssummary1d_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS StatsSummary1D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'statssummary1d_in_wrapper';

-- extension/src/stats_agg.rs:29
-- timescaledb_toolkit::stats_agg::statssummary1d_out
CREATE OR REPLACE FUNCTION "statssummary1d_out"(
	"input" StatsSummary1D /* timescaledb_toolkit::stats_agg::StatsSummary1D */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'statssummary1d_out_wrapper';

-- extension/src/stats_agg.rs:29
-- timescaledb_toolkit::stats_agg::StatsSummary1D

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:40
-- timescaledb_toolkit::stats_agg::StatsSummary2D

-- extension/src/stats_agg.rs:40
-- timescaledb_toolkit::stats_agg::statssummary2d_in
CREATE OR REPLACE FUNCTION "statssummary2d_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS StatsSummary2D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'statssummary2d_in_wrapper';

-- extension/src/stats_agg.rs:40
-- timescaledb_toolkit::stats_agg::statssummary2d_out
CREATE OR REPLACE FUNCTION "statssummary2d_out"(
	"input" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'statssummary2d_out_wrapper';

-- extension/src/stats_agg.rs:40
-- timescaledb_toolkit::stats_agg::StatsSummary2D

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:107
-- timescaledb_toolkit::tdigest::TDigest

-- extension/src/tdigest.rs:107
-- timescaledb_toolkit::tdigest::tdigest_in
CREATE OR REPLACE FUNCTION "tdigest_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS TDigest /* core::option::Option<timescaledb_toolkit::tdigest::TDigest> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_in_wrapper';

-- extension/src/tdigest.rs:107
-- timescaledb_toolkit::tdigest::tdigest_out
CREATE OR REPLACE FUNCTION "tdigest_out"(
	"input" TDigest /* timescaledb_toolkit::tdigest::TDigest */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_out_wrapper';

-- extension/src/tdigest.rs:107
-- timescaledb_toolkit::tdigest::TDigest

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average/accessors.rs:12
-- timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedAverageAccessor
CREATE TYPE TimeWeightInterpolatedAverageAccessor;

-- extension/src/time_weighted_average/accessors.rs:12
-- timescaledb_toolkit::time_weighted_average::accessors::timeweightinterpolatedaverageaccessor_in
CREATE FUNCTION "timeweightinterpolatedaverageaccessor_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS TimeWeightInterpolatedAverageAccessor /* core::option::Option<timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedAverageAccessor> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timeweightinterpolatedaverageaccessor_in_wrapper';

-- extension/src/time_weighted_average/accessors.rs:12
-- timescaledb_toolkit::time_weighted_average::accessors::timeweightinterpolatedaverageaccessor_out
CREATE FUNCTION "timeweightinterpolatedaverageaccessor_out"(
	"input" TimeWeightInterpolatedAverageAccessor /* timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedAverageAccessor */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timeweightinterpolatedaverageaccessor_out_wrapper';

-- extension/src/time_weighted_average/accessors.rs:12
-- timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedAverageAccessor
CREATE TYPE TimeWeightInterpolatedAverageAccessor (
	INTERNALLENGTH = variable,
	INPUT = timeweightinterpolatedaverageaccessor_in, /* timescaledb_toolkit::time_weighted_average::accessors::timeweightinterpolatedaverageaccessor_in */
	OUTPUT = timeweightinterpolatedaverageaccessor_out, /* timescaledb_toolkit::time_weighted_average::accessors::timeweightinterpolatedaverageaccessor_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average/accessors.rs:59
-- timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedIntegralAccessor
CREATE TYPE TimeWeightInterpolatedIntegralAccessor;

-- extension/src/time_weighted_average/accessors.rs:59
-- timescaledb_toolkit::time_weighted_average::accessors::timeweightinterpolatedintegralaccessor_in
CREATE FUNCTION "timeweightinterpolatedintegralaccessor_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS TimeWeightInterpolatedIntegralAccessor /* core::option::Option<timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedIntegralAccessor> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timeweightinterpolatedintegralaccessor_in_wrapper';

-- extension/src/time_weighted_average/accessors.rs:59
-- timescaledb_toolkit::time_weighted_average::accessors::timeweightinterpolatedintegralaccessor_out
CREATE FUNCTION "timeweightinterpolatedintegralaccessor_out"(
	"input" TimeWeightInterpolatedIntegralAccessor /* timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedIntegralAccessor */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timeweightinterpolatedintegralaccessor_out_wrapper';

-- extension/src/time_weighted_average/accessors.rs:59
-- timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedIntegralAccessor
CREATE TYPE TimeWeightInterpolatedIntegralAccessor (
	INTERNALLENGTH = variable,
	INPUT = timeweightinterpolatedintegralaccessor_in, /* timescaledb_toolkit::time_weighted_average::accessors::timeweightinterpolatedintegralaccessor_in */
	OUTPUT = timeweightinterpolatedintegralaccessor_out, /* timescaledb_toolkit::time_weighted_average::accessors::timeweightinterpolatedintegralaccessor_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:30
-- timescaledb_toolkit::time_weighted_average::TimeWeightSummary

-- extension/src/time_weighted_average.rs:30
-- timescaledb_toolkit::time_weighted_average::timeweightsummary_in
CREATE OR REPLACE FUNCTION "timeweightsummary_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS TimeWeightSummary /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timeweightsummary_in_wrapper';

-- extension/src/time_weighted_average.rs:30
-- timescaledb_toolkit::time_weighted_average::timeweightsummary_out
CREATE OR REPLACE FUNCTION "timeweightsummary_out"(
	"input" TimeWeightSummary /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timeweightsummary_out_wrapper';

-- extension/src/time_weighted_average.rs:30
-- timescaledb_toolkit::time_weighted_average::TimeWeightSummary

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:31
-- timescaledb_toolkit::time_vector::Timevector_TSTZ_F64

-- extension/src/time_vector.rs:31
-- timescaledb_toolkit::time_vector::timevector_tstz_f64_in
CREATE OR REPLACE FUNCTION "timevector_tstz_f64_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS Timevector_TSTZ_F64 /* core::option::Option<timescaledb_toolkit::time_vector::Timevector_TSTZ_F64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timevector_tstz_f64_in_wrapper';

-- extension/src/time_vector.rs:31
-- timescaledb_toolkit::time_vector::timevector_tstz_f64_out
CREATE OR REPLACE FUNCTION "timevector_tstz_f64_out"(
	"input" Timevector_TSTZ_F64 /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timevector_tstz_f64_out_wrapper';

-- extension/src/time_vector.rs:31
-- timescaledb_toolkit::time_vector::Timevector_TSTZ_F64

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:181
-- timescaledb_toolkit::uddsketch::UddSketch

-- extension/src/uddsketch.rs:181
-- timescaledb_toolkit::uddsketch::uddsketch_in
CREATE OR REPLACE FUNCTION "uddsketch_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS UddSketch /* core::option::Option<timescaledb_toolkit::uddsketch::UddSketch> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_in_wrapper';

-- extension/src/uddsketch.rs:181
-- timescaledb_toolkit::uddsketch::uddsketch_out
CREATE OR REPLACE FUNCTION "uddsketch_out"(
	"input" UddSketch /* timescaledb_toolkit::uddsketch::UddSketch */
) RETURNS cstring /* alloc::ffi::c_str::CString */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_out_wrapper';

-- extension/src/uddsketch.rs:181
-- timescaledb_toolkit::uddsketch::UddSketch

/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:61
-- timescaledb_toolkit::hyperloglog::approx_count_distinct_trans
CREATE FUNCTION "approx_count_distinct_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" AnyElement /* core::option::Option<timescaledb_toolkit::raw::AnyElement> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'approx_count_distinct_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:51
-- timescaledb_toolkit::accessors::approx_percentile
CREATE OR REPLACE FUNCTION "approx_percentile"(
	"percentile" double precision /* f64 */
) RETURNS AccessorApproxPercentile /* timescaledb_toolkit::accessors::AccessorApproxPercentile */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_approx_percentile_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:344
-- timescaledb_toolkit::tdigest::approx_percentile
CREATE OR REPLACE FUNCTION "approx_percentile"(
	"quantile" double precision, /* f64 */
	"digest" TDigest /* timescaledb_toolkit::tdigest::TDigest */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_quantile_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:573
-- timescaledb_toolkit::uddsketch::approx_percentile
CREATE OR REPLACE FUNCTION "approx_percentile"(
	"percentile" double precision, /* f64 */
	"sketch" UddSketch /* timescaledb_toolkit::uddsketch::UddSketch */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_approx_percentile_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:594
-- timescaledb_toolkit::uddsketch::approx_percentile_array
CREATE OR REPLACE FUNCTION "approx_percentile_array"(
	"percentiles" double precision[], /* alloc::vec::Vec<f64> */
	"sketch" UddSketch /* timescaledb_toolkit::uddsketch::UddSketch */
) RETURNS double precision[] /* alloc::vec::Vec<f64> */

IMMUTABLE STRICT 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_approx_percentile_array_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:55
-- timescaledb_toolkit::accessors::approx_percentile_rank
CREATE OR REPLACE FUNCTION "approx_percentile_rank"(
	"value" double precision /* f64 */
) RETURNS AccessorApproxPercentileRank /* timescaledb_toolkit::accessors::AccessorApproxPercentileRank */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_approx_percentile_rank_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:359
-- timescaledb_toolkit::tdigest::approx_percentile_rank
CREATE OR REPLACE FUNCTION "approx_percentile_rank"(
	"value" double precision, /* f64 */
	"digest" TDigest /* timescaledb_toolkit::tdigest::TDigest */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_quantile_at_value_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:629
-- timescaledb_toolkit::uddsketch::approx_percentile_rank
CREATE OR REPLACE FUNCTION "approx_percentile_rank"(
	"value" double precision, /* f64 */
	"sketch" UddSketch /* timescaledb_toolkit::uddsketch::UddSketch */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_approx_percentile_rank_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:654
-- timescaledb_toolkit::accessors::approx_percentiles
CREATE OR REPLACE FUNCTION "approx_percentiles"(
	"unit" double precision[] /* alloc::vec::Vec<f64> */
) RETURNS AccessorPercentileArray /* timescaledb_toolkit::accessors::AccessorPercentileArray */

IMMUTABLE STRICT 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_percentiles_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:438
-- timescaledb_toolkit::candlestick::arrow_close
CREATE FUNCTION "arrow_close"(
	"candlestick" Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
	"_accessor" AccessorClose /* timescaledb_toolkit::accessors::AccessorClose */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_close_wrapper';

-- extension/src/candlestick.rs:438
-- timescaledb_toolkit::candlestick::arrow_close
CREATE OPERATOR -> (
    PROCEDURE="arrow_close",
    LEFTARG=Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
    RIGHTARG=AccessorClose /* timescaledb_toolkit::accessors::AccessorClose */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:494
-- timescaledb_toolkit::candlestick::arrow_close_time
CREATE FUNCTION "arrow_close_time"(
	"candlestick" Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
	"_accessor" AccessorCloseTime /* timescaledb_toolkit::accessors::AccessorCloseTime */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_close_time_wrapper';

-- extension/src/candlestick.rs:494
-- timescaledb_toolkit::candlestick::arrow_close_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_close_time",
    LEFTARG=Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
    RIGHTARG=AccessorCloseTime /* timescaledb_toolkit::accessors::AccessorCloseTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:798
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_corr
CREATE OR REPLACE FUNCTION "arrow_counter_agg_corr"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorCorr /* timescaledb_toolkit::accessors::AccessorCorr */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_corr_wrapper';

-- extension/src/counter_agg.rs:798
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_corr
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:472
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_delta
CREATE OR REPLACE FUNCTION "arrow_counter_agg_delta"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorDelta /* timescaledb_toolkit::accessors::AccessorDelta */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_delta_wrapper';

-- extension/src/counter_agg.rs:472
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_delta
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:606
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_extrapolated_delta
CREATE OR REPLACE FUNCTION "arrow_counter_agg_extrapolated_delta"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"accessor" AccessorExtrapolatedDelta /* timescaledb_toolkit::accessors::AccessorExtrapolatedDelta */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_extrapolated_delta_wrapper';

-- extension/src/counter_agg.rs:606
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_extrapolated_delta
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:667
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_extrapolated_rate
CREATE OR REPLACE FUNCTION "arrow_counter_agg_extrapolated_rate"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"accessor" AccessorExtrapolatedRate /* timescaledb_toolkit::accessors::AccessorExtrapolatedRate */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_extrapolated_rate_wrapper';

-- extension/src/counter_agg.rs:667
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_extrapolated_rate
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:856
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_first_time
CREATE FUNCTION "arrow_counter_agg_first_time"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorFirstTime /* timescaledb_toolkit::accessors::AccessorFirstTime */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_first_time_wrapper';

-- extension/src/counter_agg.rs:856
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_first_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_counter_agg_first_time",
    LEFTARG=CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
    RIGHTARG=AccessorFirstTime /* timescaledb_toolkit::accessors::AccessorFirstTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:828
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_first_val
CREATE FUNCTION "arrow_counter_agg_first_val"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorFirstVal /* timescaledb_toolkit::accessors::AccessorFirstVal */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_first_val_wrapper';

-- extension/src/counter_agg.rs:828
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_first_val
CREATE OPERATOR -> (
    PROCEDURE="arrow_counter_agg_first_val",
    LEFTARG=CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
    RIGHTARG=AccessorFirstVal /* timescaledb_toolkit::accessors::AccessorFirstVal */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:542
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_idelta_left
CREATE OR REPLACE FUNCTION "arrow_counter_agg_idelta_left"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorIdeltaLeft /* timescaledb_toolkit::accessors::AccessorIdeltaLeft */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_idelta_left_wrapper';

-- extension/src/counter_agg.rs:542
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_idelta_left
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:556
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_idelta_right
CREATE OR REPLACE FUNCTION "arrow_counter_agg_idelta_right"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorIdeltaRight /* timescaledb_toolkit::accessors::AccessorIdeltaRight */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_idelta_right_wrapper';

-- extension/src/counter_agg.rs:556
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_idelta_right
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:784
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_intercept
CREATE OR REPLACE FUNCTION "arrow_counter_agg_intercept"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorIntercept /* timescaledb_toolkit::accessors::AccessorIntercept */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_intercept_wrapper';

-- extension/src/counter_agg.rs:784
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_intercept
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:514
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_irate_left
CREATE OR REPLACE FUNCTION "arrow_counter_agg_irate_left"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorIrateLeft /* timescaledb_toolkit::accessors::AccessorIrateLeft */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_irate_left_wrapper';

-- extension/src/counter_agg.rs:514
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_irate_left
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:528
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_irate_right
CREATE OR REPLACE FUNCTION "arrow_counter_agg_irate_right"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorIrateRight /* timescaledb_toolkit::accessors::AccessorIrateRight */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_irate_right_wrapper';

-- extension/src/counter_agg.rs:528
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_irate_right
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:870
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_last_time
CREATE FUNCTION "arrow_counter_agg_last_time"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorLastTime /* timescaledb_toolkit::accessors::AccessorLastTime */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_last_time_wrapper';

-- extension/src/counter_agg.rs:870
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_last_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_counter_agg_last_time",
    LEFTARG=CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
    RIGHTARG=AccessorLastTime /* timescaledb_toolkit::accessors::AccessorLastTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:842
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_last_val
CREATE FUNCTION "arrow_counter_agg_last_val"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorLastVal /* timescaledb_toolkit::accessors::AccessorLastVal */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_last_val_wrapper';

-- extension/src/counter_agg.rs:842
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_last_val
CREATE OPERATOR -> (
    PROCEDURE="arrow_counter_agg_last_val",
    LEFTARG=CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
    RIGHTARG=AccessorLastVal /* timescaledb_toolkit::accessors::AccessorLastVal */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:742
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_num_changes
CREATE OR REPLACE FUNCTION "arrow_counter_agg_num_changes"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorNumChanges /* timescaledb_toolkit::accessors::AccessorNumChanges */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_num_changes_wrapper';

-- extension/src/counter_agg.rs:742
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_num_changes
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:728
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_num_elements
CREATE OR REPLACE FUNCTION "arrow_counter_agg_num_elements"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorNumElements /* timescaledb_toolkit::accessors::AccessorNumElements */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_num_elements_wrapper';

-- extension/src/counter_agg.rs:728
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_num_elements
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:756
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_num_resets
CREATE OR REPLACE FUNCTION "arrow_counter_agg_num_resets"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorNumResets /* timescaledb_toolkit::accessors::AccessorNumResets */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_num_resets_wrapper';

-- extension/src/counter_agg.rs:756
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_num_resets
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:486
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_rate
CREATE OR REPLACE FUNCTION "arrow_counter_agg_rate"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorRate /* timescaledb_toolkit::accessors::AccessorRate */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_rate_wrapper';

-- extension/src/counter_agg.rs:486
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_rate
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:770
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_slope
CREATE OR REPLACE FUNCTION "arrow_counter_agg_slope"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorSlope /* timescaledb_toolkit::accessors::AccessorSlope */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_slope_wrapper';

-- extension/src/counter_agg.rs:770
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_slope
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:500
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_time_delta
CREATE OR REPLACE FUNCTION "arrow_counter_agg_time_delta"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorTimeDelta /* timescaledb_toolkit::accessors::AccessorTimeDelta */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_time_delta_wrapper';

-- extension/src/counter_agg.rs:500
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_time_delta
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:570
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_with_bounds
CREATE OR REPLACE FUNCTION "arrow_counter_agg_with_bounds"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"accessor" AccessorWithBounds /* timescaledb_toolkit::accessors::AccessorWithBounds */
) RETURNS CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_with_bounds_wrapper';

-- extension/src/counter_agg.rs:570
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_with_bounds
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:812
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_zero_time
CREATE OR REPLACE FUNCTION "arrow_counter_agg_zero_time"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"_accessor" AccessorCounterZeroTime /* timescaledb_toolkit::accessors::AccessorCounterZeroTime */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_agg_zero_time_wrapper';

-- extension/src/counter_agg.rs:812
-- timescaledb_toolkit::counter_agg::arrow_counter_agg_zero_time
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:641
-- timescaledb_toolkit::counter_agg::arrow_counter_interpolated_delta
CREATE FUNCTION "arrow_counter_interpolated_delta"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"accessor" CounterInterpolatedDeltaAccessor /* timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedDeltaAccessor */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_interpolated_delta_wrapper';

-- extension/src/counter_agg.rs:641
-- timescaledb_toolkit::counter_agg::arrow_counter_interpolated_delta
CREATE OPERATOR -> (
    PROCEDURE="arrow_counter_interpolated_delta",
    LEFTARG=CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
    RIGHTARG=CounterInterpolatedDeltaAccessor /* timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedDeltaAccessor */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:702
-- timescaledb_toolkit::counter_agg::arrow_counter_interpolated_rate
CREATE FUNCTION "arrow_counter_interpolated_rate"(
	"sketch" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"accessor" CounterInterpolatedRateAccessor /* timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedRateAccessor */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_counter_interpolated_rate_wrapper';

-- extension/src/counter_agg.rs:702
-- timescaledb_toolkit::counter_agg::arrow_counter_interpolated_rate
CREATE OPERATOR -> (
    PROCEDURE="arrow_counter_interpolated_rate",
    LEFTARG=CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
    RIGHTARG=CounterInterpolatedRateAccessor /* timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedRateAccessor */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1482
-- timescaledb_toolkit::frequency::arrow_default_topn_bigint
CREATE FUNCTION "arrow_default_topn_bigint"(
	"agg" SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
	"_accessor" AccessorTopn /* timescaledb_toolkit::accessors::AccessorTopn */
) RETURNS SETOF bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_default_topn_bigint_wrapper';

-- extension/src/frequency.rs:1482
-- timescaledb_toolkit::frequency::arrow_default_topn_bigint
CREATE OPERATOR -> (
    PROCEDURE="arrow_default_topn_bigint",
    LEFTARG=SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
    RIGHTARG=AccessorTopn /* timescaledb_toolkit::accessors::AccessorTopn */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1532
-- timescaledb_toolkit::frequency::arrow_default_topn_text
CREATE FUNCTION "arrow_default_topn_text"(
	"agg" SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
	"_accessor" AccessorTopn /* timescaledb_toolkit::accessors::AccessorTopn */
) RETURNS SETOF TEXT /* alloc::string::String */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_default_topn_text_wrapper';

-- extension/src/frequency.rs:1532
-- timescaledb_toolkit::frequency::arrow_default_topn_text
CREATE OPERATOR -> (
    PROCEDURE="arrow_default_topn_text",
    LEFTARG=SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
    RIGHTARG=AccessorTopn /* timescaledb_toolkit::accessors::AccessorTopn */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1312
-- timescaledb_toolkit::frequency::arrow_freq_bigint_iter
CREATE FUNCTION "arrow_freq_bigint_iter"(
	"agg" SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS TABLE (

	"value" bigint,  /* i64 */
	"min_freq" double precision,  /* f64 */
	"max_freq" double precision  /* f64 */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_freq_bigint_iter_wrapper';

-- extension/src/frequency.rs:1312
-- timescaledb_toolkit::frequency::arrow_freq_bigint_iter
CREATE OPERATOR -> (
    PROCEDURE="arrow_freq_bigint_iter",
    LEFTARG=SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1351
-- timescaledb_toolkit::frequency::arrow_freq_text_iter
CREATE FUNCTION "arrow_freq_text_iter"(
	"agg" SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS TABLE (

	"value" TEXT,  /* alloc::string::String */
	"min_freq" double precision,  /* f64 */
	"max_freq" double precision  /* f64 */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_freq_text_iter_wrapper';

-- extension/src/frequency.rs:1351
-- timescaledb_toolkit::frequency::arrow_freq_text_iter
CREATE OPERATOR -> (
    PROCEDURE="arrow_freq_text_iter",
    LEFTARG=SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:384
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_dead_ranges
CREATE FUNCTION "arrow_heartbeat_agg_dead_ranges"(
	"sketch" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"_accessor" AccessorDeadRanges /* timescaledb_toolkit::accessors::AccessorDeadRanges */
) RETURNS TABLE (

	"start" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_dead_ranges_wrapper';

-- extension/src/heartbeat_agg.rs:384
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_dead_ranges
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_dead_ranges",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=AccessorDeadRanges /* timescaledb_toolkit::accessors::AccessorDeadRanges */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:429
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_downtime
CREATE FUNCTION "arrow_heartbeat_agg_downtime"(
	"sketch" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"_accessor" AccessorDowntime /* timescaledb_toolkit::accessors::AccessorDowntime */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_downtime_wrapper';

-- extension/src/heartbeat_agg.rs:429
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_downtime
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_downtime",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=AccessorDowntime /* timescaledb_toolkit::accessors::AccessorDowntime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:505
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_interpolate
CREATE FUNCTION "arrow_heartbeat_agg_interpolate"(
	"sketch" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"accessor" HeartbeatInterpolateAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolateAccessor */
) RETURNS HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_interpolate_wrapper';

-- extension/src/heartbeat_agg.rs:505
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_interpolate
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_interpolate",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=HeartbeatInterpolateAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolateAccessor */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:446
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_interpolated_downtime
CREATE FUNCTION "arrow_heartbeat_agg_interpolated_downtime"(
	"sketch" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"accessor" HeartbeatInterpolatedDowntimeAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedDowntimeAccessor */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_interpolated_downtime_wrapper';

-- extension/src/heartbeat_agg.rs:446
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_interpolated_downtime
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_interpolated_downtime",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=HeartbeatInterpolatedDowntimeAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedDowntimeAccessor */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:415
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_interpolated_uptime
CREATE FUNCTION "arrow_heartbeat_agg_interpolated_uptime"(
	"sketch" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"accessor" HeartbeatInterpolatedUptimeAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedUptimeAccessor */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_interpolated_uptime_wrapper';

-- extension/src/heartbeat_agg.rs:415
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_interpolated_uptime
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_interpolated_uptime",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=HeartbeatInterpolatedUptimeAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedUptimeAccessor */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:483
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_live_at
CREATE FUNCTION "arrow_heartbeat_agg_live_at"(
	"sketch" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"accessor" AccessorLiveAt /* timescaledb_toolkit::accessors::AccessorLiveAt */
) RETURNS bool /* bool */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_live_at_wrapper';

-- extension/src/heartbeat_agg.rs:483
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_live_at
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_live_at",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=AccessorLiveAt /* timescaledb_toolkit::accessors::AccessorLiveAt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:338
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_live_ranges
CREATE FUNCTION "arrow_heartbeat_agg_live_ranges"(
	"sketch" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"_accessor" AccessorLiveRanges /* timescaledb_toolkit::accessors::AccessorLiveRanges */
) RETURNS TABLE (

	"start" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_live_ranges_wrapper';

-- extension/src/heartbeat_agg.rs:338
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_live_ranges
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_live_ranges",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=AccessorLiveRanges /* timescaledb_toolkit::accessors::AccessorLiveRanges */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:543
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_num_gaps
CREATE FUNCTION "arrow_heartbeat_agg_num_gaps"(
	"agg" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"_accessor" AccessorNumGaps /* timescaledb_toolkit::accessors::AccessorNumGaps */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_num_gaps_wrapper';

-- extension/src/heartbeat_agg.rs:543
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_num_gaps
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_num_gaps",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=AccessorNumGaps /* timescaledb_toolkit::accessors::AccessorNumGaps */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:519
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_num_live_ranges
CREATE FUNCTION "arrow_heartbeat_agg_num_live_ranges"(
	"agg" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"_accessor" AccessorNumLiveRanges /* timescaledb_toolkit::accessors::AccessorNumLiveRanges */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_num_live_ranges_wrapper';

-- extension/src/heartbeat_agg.rs:519
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_num_live_ranges
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_num_live_ranges",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=AccessorNumLiveRanges /* timescaledb_toolkit::accessors::AccessorNumLiveRanges */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:569
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_trim_to
CREATE FUNCTION "arrow_heartbeat_agg_trim_to"(
	"agg" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"accessor" HeartbeatTrimToAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatTrimToAccessor */
) RETURNS HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_trim_to_wrapper';

-- extension/src/heartbeat_agg.rs:569
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_trim_to
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_trim_to",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=HeartbeatTrimToAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatTrimToAccessor */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:398
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_uptime
CREATE FUNCTION "arrow_heartbeat_agg_uptime"(
	"sketch" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"_accessor" AccessorUptime /* timescaledb_toolkit::accessors::AccessorUptime */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_heartbeat_agg_uptime_wrapper';

-- extension/src/heartbeat_agg.rs:398
-- timescaledb_toolkit::heartbeat_agg::arrow_heartbeat_agg_uptime
CREATE OPERATOR -> (
    PROCEDURE="arrow_heartbeat_agg_uptime",
    LEFTARG=HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
    RIGHTARG=AccessorUptime /* timescaledb_toolkit::accessors::AccessorUptime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:413
-- timescaledb_toolkit::candlestick::arrow_high
CREATE FUNCTION "arrow_high"(
	"candlestick" Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
	"_accessor" AccessorHigh /* timescaledb_toolkit::accessors::AccessorHigh */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_high_wrapper';

-- extension/src/candlestick.rs:413
-- timescaledb_toolkit::candlestick::arrow_high
CREATE OPERATOR -> (
    PROCEDURE="arrow_high",
    LEFTARG=Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
    RIGHTARG=AccessorHigh /* timescaledb_toolkit::accessors::AccessorHigh */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:466
-- timescaledb_toolkit::candlestick::arrow_high_time
CREATE FUNCTION "arrow_high_time"(
	"candlestick" Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
	"_accessor" AccessorHighTime /* timescaledb_toolkit::accessors::AccessorHighTime */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_high_time_wrapper';

-- extension/src/candlestick.rs:466
-- timescaledb_toolkit::candlestick::arrow_high_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_high_time",
    LEFTARG=Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
    RIGHTARG=AccessorHighTime /* timescaledb_toolkit::accessors::AccessorHighTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:340
-- timescaledb_toolkit::hyperloglog::arrow_hyperloglog_count
CREATE OR REPLACE FUNCTION "arrow_hyperloglog_count"(
	"sketch" HyperLogLog, /* timescaledb_toolkit::hyperloglog::HyperLogLog */
	"_accessor" AccessorDistinctCount /* timescaledb_toolkit::accessors::AccessorDistinctCount */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_hyperloglog_count_wrapper';

-- extension/src/hyperloglog.rs:340
-- timescaledb_toolkit::hyperloglog::arrow_hyperloglog_count
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:373
-- timescaledb_toolkit::hyperloglog::arrow_hyperloglog_error
CREATE OR REPLACE FUNCTION "arrow_hyperloglog_error"(
	"sketch" HyperLogLog, /* timescaledb_toolkit::hyperloglog::HyperLogLog */
	"_accessor" AccessorStderror /* timescaledb_toolkit::accessors::AccessorStderror */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_hyperloglog_error_wrapper';

-- extension/src/hyperloglog.rs:373
-- timescaledb_toolkit::hyperloglog::arrow_hyperloglog_error
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:427
-- timescaledb_toolkit::candlestick::arrow_low
CREATE FUNCTION "arrow_low"(
	"candlestick" Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
	"_accessor" AccessorLow /* timescaledb_toolkit::accessors::AccessorLow */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_low_wrapper';

-- extension/src/candlestick.rs:427
-- timescaledb_toolkit::candlestick::arrow_low
CREATE OPERATOR -> (
    PROCEDURE="arrow_low",
    LEFTARG=Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
    RIGHTARG=AccessorLow /* timescaledb_toolkit::accessors::AccessorLow */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:480
-- timescaledb_toolkit::candlestick::arrow_low_time
CREATE FUNCTION "arrow_low_time"(
	"candlestick" Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
	"_accessor" AccessorLowTime /* timescaledb_toolkit::accessors::AccessorLowTime */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_low_time_wrapper';

-- extension/src/candlestick.rs:480
-- timescaledb_toolkit::candlestick::arrow_low_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_low_time",
    LEFTARG=Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
    RIGHTARG=AccessorLowTime /* timescaledb_toolkit::accessors::AccessorLowTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1577
-- timescaledb_toolkit::frequency::arrow_max_bigint_frequency
CREATE FUNCTION "arrow_max_bigint_frequency"(
	"agg" SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
	"accessor" AccessorMaxFrequencyInt /* timescaledb_toolkit::accessors::AccessorMaxFrequencyInt */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_max_bigint_frequency_wrapper';

-- extension/src/frequency.rs:1577
-- timescaledb_toolkit::frequency::arrow_max_bigint_frequency
CREATE OPERATOR -> (
    PROCEDURE="arrow_max_bigint_frequency",
    LEFTARG=SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
    RIGHTARG=AccessorMaxFrequencyInt /* timescaledb_toolkit::accessors::AccessorMaxFrequencyInt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:133
-- timescaledb_toolkit::nmost::max_float::arrow_max_float_into_array
CREATE FUNCTION "arrow_max_float_into_array"(
	"agg" MaxFloats, /* timescaledb_toolkit::nmost::max_float::MaxFloats */
	"_accessor" AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
) RETURNS double precision[] /* alloc::vec::Vec<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_max_float_into_array_wrapper';

-- extension/src/nmost/max_float.rs:133
-- timescaledb_toolkit::nmost::max_float::arrow_max_float_into_array
CREATE OPERATOR -> (
    PROCEDURE="arrow_max_float_into_array",
    LEFTARG=MaxFloats, /* timescaledb_toolkit::nmost::max_float::MaxFloats */
    RIGHTARG=AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:125
-- timescaledb_toolkit::nmost::max_float::arrow_max_float_into_values
CREATE FUNCTION "arrow_max_float_into_values"(
	"agg" MaxFloats, /* timescaledb_toolkit::nmost::max_float::MaxFloats */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS SETOF double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_max_float_into_values_wrapper';

-- extension/src/nmost/max_float.rs:125
-- timescaledb_toolkit::nmost::max_float::arrow_max_float_into_values
CREATE OPERATOR -> (
    PROCEDURE="arrow_max_float_into_values",
    LEFTARG=MaxFloats, /* timescaledb_toolkit::nmost::max_float::MaxFloats */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:127
-- timescaledb_toolkit::nmost::max_int::arrow_max_int_into_array
CREATE FUNCTION "arrow_max_int_into_array"(
	"agg" MaxInts, /* timescaledb_toolkit::nmost::max_int::MaxInts */
	"_accessor" AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
) RETURNS bigint[] /* alloc::vec::Vec<i64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_max_int_into_array_wrapper';

-- extension/src/nmost/max_int.rs:127
-- timescaledb_toolkit::nmost::max_int::arrow_max_int_into_array
CREATE OPERATOR -> (
    PROCEDURE="arrow_max_int_into_array",
    LEFTARG=MaxInts, /* timescaledb_toolkit::nmost::max_int::MaxInts */
    RIGHTARG=AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:119
-- timescaledb_toolkit::nmost::max_int::arrow_max_int_into_values
CREATE FUNCTION "arrow_max_int_into_values"(
	"agg" MaxInts, /* timescaledb_toolkit::nmost::max_int::MaxInts */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS SETOF bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_max_int_into_values_wrapper';

-- extension/src/nmost/max_int.rs:119
-- timescaledb_toolkit::nmost::max_int::arrow_max_int_into_values
CREATE OPERATOR -> (
    PROCEDURE="arrow_max_int_into_values",
    LEFTARG=MaxInts, /* timescaledb_toolkit::nmost::max_int::MaxInts */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:137
-- timescaledb_toolkit::nmost::max_time::arrow_max_time_into_array
CREATE FUNCTION "arrow_max_time_into_array"(
	"agg" MaxTimes, /* timescaledb_toolkit::nmost::max_time::MaxTimes */
	"_accessor" AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
) RETURNS TimestampTz[] /* alloc::vec::Vec<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_max_time_into_array_wrapper';

-- extension/src/nmost/max_time.rs:137
-- timescaledb_toolkit::nmost::max_time::arrow_max_time_into_array
CREATE OPERATOR -> (
    PROCEDURE="arrow_max_time_into_array",
    LEFTARG=MaxTimes, /* timescaledb_toolkit::nmost::max_time::MaxTimes */
    RIGHTARG=AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:129
-- timescaledb_toolkit::nmost::max_time::arrow_max_time_into_values
CREATE FUNCTION "arrow_max_time_into_values"(
	"agg" MaxTimes, /* timescaledb_toolkit::nmost::max_time::MaxTimes */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS SETOF TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_max_time_into_values_wrapper';

-- extension/src/nmost/max_time.rs:129
-- timescaledb_toolkit::nmost::max_time::arrow_max_time_into_values
CREATE OPERATOR -> (
    PROCEDURE="arrow_max_time_into_values",
    LEFTARG=MaxTimes, /* timescaledb_toolkit::nmost::max_time::MaxTimes */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1596
-- timescaledb_toolkit::frequency::arrow_min_bigint_frequency
CREATE FUNCTION "arrow_min_bigint_frequency"(
	"agg" SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
	"accessor" AccessorMinFrequencyInt /* timescaledb_toolkit::accessors::AccessorMinFrequencyInt */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_min_bigint_frequency_wrapper';

-- extension/src/frequency.rs:1596
-- timescaledb_toolkit::frequency::arrow_min_bigint_frequency
CREATE OPERATOR -> (
    PROCEDURE="arrow_min_bigint_frequency",
    LEFTARG=SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
    RIGHTARG=AccessorMinFrequencyInt /* timescaledb_toolkit::accessors::AccessorMinFrequencyInt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:132
-- timescaledb_toolkit::nmost::min_float::arrow_min_float_into_array
CREATE FUNCTION "arrow_min_float_into_array"(
	"agg" MinFloats, /* timescaledb_toolkit::nmost::min_float::MinFloats */
	"_accessor" AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
) RETURNS double precision[] /* alloc::vec::Vec<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_min_float_into_array_wrapper';

-- extension/src/nmost/min_float.rs:132
-- timescaledb_toolkit::nmost::min_float::arrow_min_float_into_array
CREATE OPERATOR -> (
    PROCEDURE="arrow_min_float_into_array",
    LEFTARG=MinFloats, /* timescaledb_toolkit::nmost::min_float::MinFloats */
    RIGHTARG=AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:124
-- timescaledb_toolkit::nmost::min_float::arrow_min_float_into_values
CREATE FUNCTION "arrow_min_float_into_values"(
	"agg" MinFloats, /* timescaledb_toolkit::nmost::min_float::MinFloats */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS SETOF double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_min_float_into_values_wrapper';

-- extension/src/nmost/min_float.rs:124
-- timescaledb_toolkit::nmost::min_float::arrow_min_float_into_values
CREATE OPERATOR -> (
    PROCEDURE="arrow_min_float_into_values",
    LEFTARG=MinFloats, /* timescaledb_toolkit::nmost::min_float::MinFloats */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:119
-- timescaledb_toolkit::nmost::min_int::arrow_min_int_into_array
CREATE FUNCTION "arrow_min_int_into_array"(
	"agg" MinInts, /* timescaledb_toolkit::nmost::min_int::MinInts */
	"_accessor" AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
) RETURNS bigint[] /* alloc::vec::Vec<i64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_min_int_into_array_wrapper';

-- extension/src/nmost/min_int.rs:119
-- timescaledb_toolkit::nmost::min_int::arrow_min_int_into_array
CREATE OPERATOR -> (
    PROCEDURE="arrow_min_int_into_array",
    LEFTARG=MinInts, /* timescaledb_toolkit::nmost::min_int::MinInts */
    RIGHTARG=AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:111
-- timescaledb_toolkit::nmost::min_int::arrow_min_int_into_values
CREATE FUNCTION "arrow_min_int_into_values"(
	"agg" MinInts, /* timescaledb_toolkit::nmost::min_int::MinInts */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS SETOF bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_min_int_into_values_wrapper';

-- extension/src/nmost/min_int.rs:111
-- timescaledb_toolkit::nmost::min_int::arrow_min_int_into_values
CREATE OPERATOR -> (
    PROCEDURE="arrow_min_int_into_values",
    LEFTARG=MinInts, /* timescaledb_toolkit::nmost::min_int::MinInts */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:128
-- timescaledb_toolkit::nmost::min_time::arrow_min_time_into_array
CREATE FUNCTION "arrow_min_time_into_array"(
	"agg" MinTimes, /* timescaledb_toolkit::nmost::min_time::MinTimes */
	"_accessor" AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
) RETURNS TimestampTz[] /* alloc::vec::Vec<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_min_time_into_array_wrapper';

-- extension/src/nmost/min_time.rs:128
-- timescaledb_toolkit::nmost::min_time::arrow_min_time_into_array
CREATE OPERATOR -> (
    PROCEDURE="arrow_min_time_into_array",
    LEFTARG=MinTimes, /* timescaledb_toolkit::nmost::min_time::MinTimes */
    RIGHTARG=AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:120
-- timescaledb_toolkit::nmost::min_time::arrow_min_time_into_values
CREATE FUNCTION "arrow_min_time_into_values"(
	"agg" MinTimes, /* timescaledb_toolkit::nmost::min_time::MinTimes */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS SETOF TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_min_time_into_values_wrapper';

-- extension/src/nmost/min_time.rs:120
-- timescaledb_toolkit::nmost::min_time::arrow_min_time_into_values
CREATE OPERATOR -> (
    PROCEDURE="arrow_min_time_into_values",
    LEFTARG=MinTimes, /* timescaledb_toolkit::nmost::min_time::MinTimes */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:399
-- timescaledb_toolkit::candlestick::arrow_open
CREATE FUNCTION "arrow_open"(
	"candlestick" Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
	"_accessor" AccessorOpen /* timescaledb_toolkit::accessors::AccessorOpen */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_open_wrapper';

-- extension/src/candlestick.rs:399
-- timescaledb_toolkit::candlestick::arrow_open
CREATE OPERATOR -> (
    PROCEDURE="arrow_open",
    LEFTARG=Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
    RIGHTARG=AccessorOpen /* timescaledb_toolkit::accessors::AccessorOpen */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:452
-- timescaledb_toolkit::candlestick::arrow_open_time
CREATE FUNCTION "arrow_open_time"(
	"candlestick" Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
	"_accessor" AccessorOpenTime /* timescaledb_toolkit::accessors::AccessorOpenTime */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_open_time_wrapper';

-- extension/src/candlestick.rs:452
-- timescaledb_toolkit::candlestick::arrow_open_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_open_time",
    LEFTARG=Candlestick, /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
    RIGHTARG=AccessorOpenTime /* timescaledb_toolkit::accessors::AccessorOpenTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:861
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_duration_in_int
CREATE FUNCTION "arrow_state_agg_duration_in_int"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"accessor" AccessorDurationInInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInInt */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_duration_in_int_wrapper';

-- extension/src/state_aggregate.rs:861
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_duration_in_int
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_duration_in_int",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorDurationInInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInInt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:938
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_duration_in_range_int
CREATE FUNCTION "arrow_state_agg_duration_in_range_int"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"accessor" AccessorDurationInRangeInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRangeInt */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_duration_in_range_int_wrapper';

-- extension/src/state_aggregate.rs:938
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_duration_in_range_int
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_duration_in_range_int",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorDurationInRangeInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRangeInt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:923
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_duration_in_range_string
CREATE FUNCTION "arrow_state_agg_duration_in_range_string"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"accessor" AccessorDurationInRange /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRange */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_duration_in_range_string_wrapper';

-- extension/src/state_aggregate.rs:923
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_duration_in_range_string
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_duration_in_range_string",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorDurationInRange /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRange */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:850
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_duration_in_string
CREATE FUNCTION "arrow_state_agg_duration_in_string"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"accessor" AccessorDurationIn /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationIn */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_duration_in_string_wrapper';

-- extension/src/state_aggregate.rs:850
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_duration_in_string
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_duration_in_string",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorDurationIn /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationIn */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1095
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_duration_in_int
CREATE FUNCTION "arrow_state_agg_interpolated_duration_in_int"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"accessor" AccessorInterpolatedDurationInInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationInInt */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_interpolated_duration_in_int_wrapper';

-- extension/src/state_aggregate.rs:1095
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_duration_in_int
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_interpolated_duration_in_int",
    LEFTARG=StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
    RIGHTARG=AccessorInterpolatedDurationInInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationInInt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1074
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_duration_in_string
CREATE FUNCTION "arrow_state_agg_interpolated_duration_in_string"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"accessor" AccessorInterpolatedDurationIn /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationIn */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_interpolated_duration_in_string_wrapper';

-- extension/src/state_aggregate.rs:1074
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_duration_in_string
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_interpolated_duration_in_string",
    LEFTARG=StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
    RIGHTARG=AccessorInterpolatedDurationIn /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationIn */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1482
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_state_int_timeline
CREATE FUNCTION "arrow_state_agg_interpolated_state_int_timeline"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"accessor" AccessorInterpolatedStateIntTimeline /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateIntTimeline */
) RETURNS TABLE (

	"state" bigint,  /* i64 */
	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_interpolated_state_int_timeline_wrapper';

-- extension/src/state_aggregate.rs:1482
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_state_int_timeline
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_interpolated_state_int_timeline",
    LEFTARG=StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
    RIGHTARG=AccessorInterpolatedStateIntTimeline /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateIntTimeline */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1708
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_state_periods_int
CREATE FUNCTION "arrow_state_agg_interpolated_state_periods_int"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"accessor" AccessorInterpolatedStatePeriodsInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriodsInt */
) RETURNS TABLE (

	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_interpolated_state_periods_int_wrapper';

-- extension/src/state_aggregate.rs:1708
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_state_periods_int
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_interpolated_state_periods_int",
    LEFTARG=StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
    RIGHTARG=AccessorInterpolatedStatePeriodsInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriodsInt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1681
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_state_periods_string
CREATE FUNCTION "arrow_state_agg_interpolated_state_periods_string"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"accessor" AccessorInterpolatedStatePeriods /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriods */
) RETURNS TABLE (

	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_interpolated_state_periods_string_wrapper';

-- extension/src/state_aggregate.rs:1681
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_state_periods_string
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_interpolated_state_periods_string",
    LEFTARG=StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
    RIGHTARG=AccessorInterpolatedStatePeriods /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriods */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1458
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_state_timeline
CREATE FUNCTION "arrow_state_agg_interpolated_state_timeline"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"accessor" AccessorInterpolatedStateTimeline /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateTimeline */
) RETURNS TABLE (

	"state" TEXT,  /* alloc::string::String */
	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_interpolated_state_timeline_wrapper';

-- extension/src/state_aggregate.rs:1458
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_interpolated_state_timeline
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_interpolated_state_timeline",
    LEFTARG=StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
    RIGHTARG=AccessorInterpolatedStateTimeline /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateTimeline */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1229
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_into_int_values
CREATE FUNCTION "arrow_state_agg_into_int_values"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"_accessor" AccessorIntoIntValues /* timescaledb_toolkit::accessors::AccessorIntoIntValues */
) RETURNS TABLE (

	"state" bigint,  /* i64 */
	"duration" Interval  /* timescaledb_toolkit::raw::Interval */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_into_int_values_wrapper';

-- extension/src/state_aggregate.rs:1229
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_into_int_values
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_into_int_values",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorIntoIntValues /* timescaledb_toolkit::accessors::AccessorIntoIntValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1215
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_into_values
CREATE FUNCTION "arrow_state_agg_into_values"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"_accessor" AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
) RETURNS TABLE (

	"state" TEXT,  /* alloc::string::String */
	"duration" Interval  /* timescaledb_toolkit::raw::Interval */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_into_values_wrapper';

-- extension/src/state_aggregate.rs:1215
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_into_values
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_into_values",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1773
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_at_int
CREATE FUNCTION "arrow_state_agg_state_at_int"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"accessor" AccessorStateAtInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStateAtInt */
) RETURNS bigint /* core::option::Option<i64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_state_at_int_wrapper';

-- extension/src/state_aggregate.rs:1773
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_at_int
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_state_at_int",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorStateAtInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStateAtInt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1764
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_at_string
CREATE FUNCTION "arrow_state_agg_state_at_string"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"accessor" AccessorStateAt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStateAt */
) RETURNS TEXT /* core::option::Option<alloc::string::String> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_state_at_string_wrapper';

-- extension/src/state_aggregate.rs:1764
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_at_string
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_state_at_string",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorStateAt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStateAt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1346
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_int_timeline
CREATE FUNCTION "arrow_state_agg_state_int_timeline"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"_accessor" AccessorStateIntTimeline /* timescaledb_toolkit::accessors::AccessorStateIntTimeline */
) RETURNS TABLE (

	"state" bigint,  /* i64 */
	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_state_int_timeline_wrapper';

-- extension/src/state_aggregate.rs:1346
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_int_timeline
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_state_int_timeline",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorStateIntTimeline /* timescaledb_toolkit::accessors::AccessorStateIntTimeline */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1589
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_periods_int
CREATE FUNCTION "arrow_state_agg_state_periods_int"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"accessor" AccessorStatePeriodsInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriodsInt */
) RETURNS TABLE (

	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_state_periods_int_wrapper';

-- extension/src/state_aggregate.rs:1589
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_periods_int
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_state_periods_int",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorStatePeriodsInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriodsInt */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1572
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_periods_string
CREATE FUNCTION "arrow_state_agg_state_periods_string"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"accessor" AccessorStatePeriods /* timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriods */
) RETURNS TABLE (

	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_state_periods_string_wrapper';

-- extension/src/state_aggregate.rs:1572
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_periods_string
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_state_periods_string",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorStatePeriods /* timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriods */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1331
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_timeline
CREATE FUNCTION "arrow_state_agg_state_timeline"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"_accessor" AccessorStateTimeline /* timescaledb_toolkit::accessors::AccessorStateTimeline */
) RETURNS TABLE (

	"state" TEXT,  /* alloc::string::String */
	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_state_agg_state_timeline_wrapper';

-- extension/src/state_aggregate.rs:1331
-- timescaledb_toolkit::state_aggregate::arrow_state_agg_state_timeline
CREATE OPERATOR -> (
    PROCEDURE="arrow_state_agg_state_timeline",
    LEFTARG=StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
    RIGHTARG=AccessorStateTimeline /* timescaledb_toolkit::accessors::AccessorStateTimeline */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:937
-- timescaledb_toolkit::stats_agg::arrow_stats1d_average
CREATE OR REPLACE FUNCTION "arrow_stats1d_average"(
	"sketch" StatsSummary1D, /* timescaledb_toolkit::stats_agg::StatsSummary1D */
	"_accessor" AccessorAverage /* timescaledb_toolkit::accessors::AccessorAverage */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats1d_average_wrapper';

-- extension/src/stats_agg.rs:937
-- timescaledb_toolkit::stats_agg::arrow_stats1d_average
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1028
-- timescaledb_toolkit::stats_agg::arrow_stats1d_kurtosis
CREATE OR REPLACE FUNCTION "arrow_stats1d_kurtosis"(
	"sketch" StatsSummary1D, /* timescaledb_toolkit::stats_agg::StatsSummary1D */
	"accessor" AccessorKurtosis /* timescaledb_toolkit::accessors::AccessorKurtosis */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats1d_kurtosis_wrapper';

-- extension/src/stats_agg.rs:1028
-- timescaledb_toolkit::stats_agg::arrow_stats1d_kurtosis
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1049
-- timescaledb_toolkit::stats_agg::arrow_stats1d_num_vals
CREATE OR REPLACE FUNCTION "arrow_stats1d_num_vals"(
	"sketch" StatsSummary1D, /* timescaledb_toolkit::stats_agg::StatsSummary1D */
	"_accessor" AccessorNumVals /* timescaledb_toolkit::accessors::AccessorNumVals */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats1d_num_vals_wrapper';

-- extension/src/stats_agg.rs:1049
-- timescaledb_toolkit::stats_agg::arrow_stats1d_num_vals
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1007
-- timescaledb_toolkit::stats_agg::arrow_stats1d_skewness
CREATE OR REPLACE FUNCTION "arrow_stats1d_skewness"(
	"sketch" StatsSummary1D, /* timescaledb_toolkit::stats_agg::StatsSummary1D */
	"accessor" AccessorSkewness /* timescaledb_toolkit::accessors::AccessorSkewness */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats1d_skewness_wrapper';

-- extension/src/stats_agg.rs:1007
-- timescaledb_toolkit::stats_agg::arrow_stats1d_skewness
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:965
-- timescaledb_toolkit::stats_agg::arrow_stats1d_stddev
CREATE OR REPLACE FUNCTION "arrow_stats1d_stddev"(
	"sketch" StatsSummary1D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */
	"accessor" AccessorStdDev /* timescaledb_toolkit::accessors::AccessorStdDev */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats1d_stddev_wrapper';

-- extension/src/stats_agg.rs:965
-- timescaledb_toolkit::stats_agg::arrow_stats1d_stddev
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:951
-- timescaledb_toolkit::stats_agg::arrow_stats1d_sum
CREATE OR REPLACE FUNCTION "arrow_stats1d_sum"(
	"sketch" StatsSummary1D, /* timescaledb_toolkit::stats_agg::StatsSummary1D */
	"_accessor" AccessorSum /* timescaledb_toolkit::accessors::AccessorSum */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats1d_sum_wrapper';

-- extension/src/stats_agg.rs:951
-- timescaledb_toolkit::stats_agg::arrow_stats1d_sum
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:986
-- timescaledb_toolkit::stats_agg::arrow_stats1d_variance
CREATE OR REPLACE FUNCTION "arrow_stats1d_variance"(
	"sketch" StatsSummary1D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */
	"accessor" AccessorVariance /* timescaledb_toolkit::accessors::AccessorVariance */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats1d_variance_wrapper';

-- extension/src/stats_agg.rs:986
-- timescaledb_toolkit::stats_agg::arrow_stats1d_variance
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1063
-- timescaledb_toolkit::stats_agg::arrow_stats2d_average_x
CREATE OR REPLACE FUNCTION "arrow_stats2d_average_x"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorAverageX /* timescaledb_toolkit::accessors::AccessorAverageX */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_average_x_wrapper';

-- extension/src/stats_agg.rs:1063
-- timescaledb_toolkit::stats_agg::arrow_stats2d_average_x
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1077
-- timescaledb_toolkit::stats_agg::arrow_stats2d_average_y
CREATE OR REPLACE FUNCTION "arrow_stats2d_average_y"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorAverageY /* timescaledb_toolkit::accessors::AccessorAverageY */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_average_y_wrapper';

-- extension/src/stats_agg.rs:1077
-- timescaledb_toolkit::stats_agg::arrow_stats2d_average_y
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1315
-- timescaledb_toolkit::stats_agg::arrow_stats2d_corr
CREATE OR REPLACE FUNCTION "arrow_stats2d_corr"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorCorr /* timescaledb_toolkit::accessors::AccessorCorr */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_corr_wrapper';

-- extension/src/stats_agg.rs:1315
-- timescaledb_toolkit::stats_agg::arrow_stats2d_corr
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1371
-- timescaledb_toolkit::stats_agg::arrow_stats2d_covar
CREATE OR REPLACE FUNCTION "arrow_stats2d_covar"(
	"sketch" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"accessor" AccessorCovar /* timescaledb_toolkit::accessors::AccessorCovar */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_covar_wrapper';

-- extension/src/stats_agg.rs:1371
-- timescaledb_toolkit::stats_agg::arrow_stats2d_covar
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1357
-- timescaledb_toolkit::stats_agg::arrow_stats2d_determination_coeff
CREATE OR REPLACE FUNCTION "arrow_stats2d_determination_coeff"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorDeterminationCoeff /* timescaledb_toolkit::accessors::AccessorDeterminationCoeff */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_determination_coeff_wrapper';

-- extension/src/stats_agg.rs:1357
-- timescaledb_toolkit::stats_agg::arrow_stats2d_determination_coeff
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1329
-- timescaledb_toolkit::stats_agg::arrow_stats2d_intercept
CREATE OR REPLACE FUNCTION "arrow_stats2d_intercept"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorIntercept /* timescaledb_toolkit::accessors::AccessorIntercept */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_intercept_wrapper';

-- extension/src/stats_agg.rs:1329
-- timescaledb_toolkit::stats_agg::arrow_stats2d_intercept
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1245
-- timescaledb_toolkit::stats_agg::arrow_stats2d_kurtosis_x
CREATE OR REPLACE FUNCTION "arrow_stats2d_kurtosis_x"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"accessor" AccessorKurtosisX /* timescaledb_toolkit::accessors::AccessorKurtosisX */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_kurtosis_x_wrapper';

-- extension/src/stats_agg.rs:1245
-- timescaledb_toolkit::stats_agg::arrow_stats2d_kurtosis_x
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1266
-- timescaledb_toolkit::stats_agg::arrow_stats2d_kurtosis_y
CREATE OR REPLACE FUNCTION "arrow_stats2d_kurtosis_y"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"accessor" AccessorKurtosisY /* timescaledb_toolkit::accessors::AccessorKurtosisY */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_kurtosis_y_wrapper';

-- extension/src/stats_agg.rs:1266
-- timescaledb_toolkit::stats_agg::arrow_stats2d_kurtosis_y
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1287
-- timescaledb_toolkit::stats_agg::arrow_stats2d_num_vals
CREATE OR REPLACE FUNCTION "arrow_stats2d_num_vals"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorNumVals /* timescaledb_toolkit::accessors::AccessorNumVals */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_num_vals_wrapper';

-- extension/src/stats_agg.rs:1287
-- timescaledb_toolkit::stats_agg::arrow_stats2d_num_vals
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1203
-- timescaledb_toolkit::stats_agg::arrow_stats2d_skewness_x
CREATE OR REPLACE FUNCTION "arrow_stats2d_skewness_x"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"accessor" AccessorSkewnessX /* timescaledb_toolkit::accessors::AccessorSkewnessX */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_skewness_x_wrapper';

-- extension/src/stats_agg.rs:1203
-- timescaledb_toolkit::stats_agg::arrow_stats2d_skewness_x
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1224
-- timescaledb_toolkit::stats_agg::arrow_stats2d_skewness_y
CREATE OR REPLACE FUNCTION "arrow_stats2d_skewness_y"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"accessor" AccessorSkewnessY /* timescaledb_toolkit::accessors::AccessorSkewnessY */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_skewness_y_wrapper';

-- extension/src/stats_agg.rs:1224
-- timescaledb_toolkit::stats_agg::arrow_stats2d_skewness_y
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1301
-- timescaledb_toolkit::stats_agg::arrow_stats2d_slope
CREATE OR REPLACE FUNCTION "arrow_stats2d_slope"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorSlope /* timescaledb_toolkit::accessors::AccessorSlope */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_slope_wrapper';

-- extension/src/stats_agg.rs:1301
-- timescaledb_toolkit::stats_agg::arrow_stats2d_slope
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1119
-- timescaledb_toolkit::stats_agg::arrow_stats2d_stdddev_x
CREATE OR REPLACE FUNCTION "arrow_stats2d_stdddev_x"(
	"sketch" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"accessor" AccessorStdDevX /* timescaledb_toolkit::accessors::AccessorStdDevX */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_stdddev_x_wrapper';

-- extension/src/stats_agg.rs:1119
-- timescaledb_toolkit::stats_agg::arrow_stats2d_stdddev_x
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1140
-- timescaledb_toolkit::stats_agg::arrow_stats2d_stdddev_y
CREATE OR REPLACE FUNCTION "arrow_stats2d_stdddev_y"(
	"sketch" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"accessor" AccessorStdDevY /* timescaledb_toolkit::accessors::AccessorStdDevY */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_stdddev_y_wrapper';

-- extension/src/stats_agg.rs:1140
-- timescaledb_toolkit::stats_agg::arrow_stats2d_stdddev_y
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1091
-- timescaledb_toolkit::stats_agg::arrow_stats2d_sum_x
CREATE OR REPLACE FUNCTION "arrow_stats2d_sum_x"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorSumX /* timescaledb_toolkit::accessors::AccessorSumX */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_sum_x_wrapper';

-- extension/src/stats_agg.rs:1091
-- timescaledb_toolkit::stats_agg::arrow_stats2d_sum_x
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1105
-- timescaledb_toolkit::stats_agg::arrow_stats2d_sum_y
CREATE OR REPLACE FUNCTION "arrow_stats2d_sum_y"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorSumY /* timescaledb_toolkit::accessors::AccessorSumY */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_sum_y_wrapper';

-- extension/src/stats_agg.rs:1105
-- timescaledb_toolkit::stats_agg::arrow_stats2d_sum_y
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1161
-- timescaledb_toolkit::stats_agg::arrow_stats2d_variance_x
CREATE OR REPLACE FUNCTION "arrow_stats2d_variance_x"(
	"sketch" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"accessor" AccessorVarianceX /* timescaledb_toolkit::accessors::AccessorVarianceX */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_variance_x_wrapper';

-- extension/src/stats_agg.rs:1161
-- timescaledb_toolkit::stats_agg::arrow_stats2d_variance_x
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1182
-- timescaledb_toolkit::stats_agg::arrow_stats2d_variance_y
CREATE OR REPLACE FUNCTION "arrow_stats2d_variance_y"(
	"sketch" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"accessor" AccessorVarianceY /* timescaledb_toolkit::accessors::AccessorVarianceY */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_variance_y_wrapper';

-- extension/src/stats_agg.rs:1182
-- timescaledb_toolkit::stats_agg::arrow_stats2d_variance_y
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1343
-- timescaledb_toolkit::stats_agg::arrow_stats2d_x_intercept
CREATE OR REPLACE FUNCTION "arrow_stats2d_x_intercept"(
	"sketch" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"_accessor" AccessorXIntercept /* timescaledb_toolkit::accessors::AccessorXIntercept */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_stats2d_x_intercept_wrapper';

-- extension/src/stats_agg.rs:1343
-- timescaledb_toolkit::stats_agg::arrow_stats2d_x_intercept
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:334
-- timescaledb_toolkit::tdigest::arrow_tdigest_approx_percentile
CREATE OR REPLACE FUNCTION "arrow_tdigest_approx_percentile"(
	"sketch" TDigest, /* timescaledb_toolkit::tdigest::TDigest */
	"accessor" AccessorApproxPercentile /* timescaledb_toolkit::accessors::AccessorApproxPercentile */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_tdigest_approx_percentile_wrapper';

-- extension/src/tdigest.rs:334
-- timescaledb_toolkit::tdigest::arrow_tdigest_approx_percentile
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:349
-- timescaledb_toolkit::tdigest::arrow_tdigest_approx_rank
CREATE OR REPLACE FUNCTION "arrow_tdigest_approx_rank"(
	"sketch" TDigest, /* timescaledb_toolkit::tdigest::TDigest */
	"accessor" AccessorApproxPercentileRank /* timescaledb_toolkit::accessors::AccessorApproxPercentileRank */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_tdigest_approx_rank_wrapper';

-- extension/src/tdigest.rs:349
-- timescaledb_toolkit::tdigest::arrow_tdigest_approx_rank
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:390
-- timescaledb_toolkit::tdigest::arrow_tdigest_max
CREATE OR REPLACE FUNCTION "arrow_tdigest_max"(
	"sketch" TDigest, /* timescaledb_toolkit::tdigest::TDigest */
	"_accessor" AccessorMaxVal /* timescaledb_toolkit::accessors::AccessorMaxVal */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_tdigest_max_wrapper';

-- extension/src/tdigest.rs:390
-- timescaledb_toolkit::tdigest::arrow_tdigest_max
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:402
-- timescaledb_toolkit::tdigest::arrow_tdigest_mean
CREATE OR REPLACE FUNCTION "arrow_tdigest_mean"(
	"sketch" TDigest, /* timescaledb_toolkit::tdigest::TDigest */
	"_accessor" AccessorMean /* timescaledb_toolkit::accessors::AccessorMean */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_tdigest_mean_wrapper';

-- extension/src/tdigest.rs:402
-- timescaledb_toolkit::tdigest::arrow_tdigest_mean
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:378
-- timescaledb_toolkit::tdigest::arrow_tdigest_min
CREATE OR REPLACE FUNCTION "arrow_tdigest_min"(
	"sketch" TDigest, /* timescaledb_toolkit::tdigest::TDigest */
	"_accessor" AccessorMinVal /* timescaledb_toolkit::accessors::AccessorMinVal */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_tdigest_min_wrapper';

-- extension/src/tdigest.rs:378
-- timescaledb_toolkit::tdigest::arrow_tdigest_min
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:366
-- timescaledb_toolkit::tdigest::arrow_tdigest_num_vals
CREATE OR REPLACE FUNCTION "arrow_tdigest_num_vals"(
	"sketch" TDigest, /* timescaledb_toolkit::tdigest::TDigest */
	"_accessor" AccessorNumVals /* timescaledb_toolkit::accessors::AccessorNumVals */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_tdigest_num_vals_wrapper';

-- extension/src/tdigest.rs:366
-- timescaledb_toolkit::tdigest::arrow_tdigest_num_vals
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:364
-- timescaledb_toolkit::time_weighted_average::arrow_time_weight_first_time
CREATE FUNCTION "arrow_time_weight_first_time"(
	"sketch" TimeWeightSummary, /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
	"_accessor" AccessorFirstTime /* timescaledb_toolkit::accessors::AccessorFirstTime */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_weight_first_time_wrapper';

-- extension/src/time_weighted_average.rs:364
-- timescaledb_toolkit::time_weighted_average::arrow_time_weight_first_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_time_weight_first_time",
    LEFTARG=TimeWeightSummary, /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
    RIGHTARG=AccessorFirstTime /* timescaledb_toolkit::accessors::AccessorFirstTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:336
-- timescaledb_toolkit::time_weighted_average::arrow_time_weight_first_val
CREATE FUNCTION "arrow_time_weight_first_val"(
	"sketch" TimeWeightSummary, /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
	"_accessor" AccessorFirstVal /* timescaledb_toolkit::accessors::AccessorFirstVal */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_weight_first_val_wrapper';

-- extension/src/time_weighted_average.rs:336
-- timescaledb_toolkit::time_weighted_average::arrow_time_weight_first_val
CREATE OPERATOR -> (
    PROCEDURE="arrow_time_weight_first_val",
    LEFTARG=TimeWeightSummary, /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
    RIGHTARG=AccessorFirstVal /* timescaledb_toolkit::accessors::AccessorFirstVal */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:378
-- timescaledb_toolkit::time_weighted_average::arrow_time_weight_last_time
CREATE FUNCTION "arrow_time_weight_last_time"(
	"sketch" TimeWeightSummary, /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
	"_accessor" AccessorLastTime /* timescaledb_toolkit::accessors::AccessorLastTime */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_weight_last_time_wrapper';

-- extension/src/time_weighted_average.rs:378
-- timescaledb_toolkit::time_weighted_average::arrow_time_weight_last_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_time_weight_last_time",
    LEFTARG=TimeWeightSummary, /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
    RIGHTARG=AccessorLastTime /* timescaledb_toolkit::accessors::AccessorLastTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:350
-- timescaledb_toolkit::time_weighted_average::arrow_time_weight_last_val
CREATE FUNCTION "arrow_time_weight_last_val"(
	"sketch" TimeWeightSummary, /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
	"_accessor" AccessorLastVal /* timescaledb_toolkit::accessors::AccessorLastVal */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_weight_last_val_wrapper';

-- extension/src/time_weighted_average.rs:350
-- timescaledb_toolkit::time_weighted_average::arrow_time_weight_last_val
CREATE OPERATOR -> (
    PROCEDURE="arrow_time_weight_last_val",
    LEFTARG=TimeWeightSummary, /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
    RIGHTARG=AccessorLastVal /* timescaledb_toolkit::accessors::AccessorLastVal */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:427
-- timescaledb_toolkit::time_weighted_average::arrow_time_weighted_average_average
CREATE OR REPLACE FUNCTION "arrow_time_weighted_average_average"(
	"sketch" TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"_accessor" AccessorAverage /* timescaledb_toolkit::accessors::AccessorAverage */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_weighted_average_average_wrapper';

-- extension/src/time_weighted_average.rs:427
-- timescaledb_toolkit::time_weighted_average::arrow_time_weighted_average_average
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:436
-- timescaledb_toolkit::time_weighted_average::arrow_time_weighted_average_integral
CREATE FUNCTION "arrow_time_weighted_average_integral"(
	"tws" TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"accessor" AccessorIntegral /* timescaledb_toolkit::accessors::AccessorIntegral */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_weighted_average_integral_wrapper';

-- extension/src/time_weighted_average.rs:436
-- timescaledb_toolkit::time_weighted_average::arrow_time_weighted_average_integral
CREATE OPERATOR -> (
    PROCEDURE="arrow_time_weighted_average_integral",
    LEFTARG=TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
    RIGHTARG=AccessorIntegral /* timescaledb_toolkit::accessors::AccessorIntegral */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:510
-- timescaledb_toolkit::time_weighted_average::arrow_time_weighted_average_interpolated_average
CREATE FUNCTION "arrow_time_weighted_average_interpolated_average"(
	"tws" TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"accessor" TimeWeightInterpolatedAverageAccessor /* timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedAverageAccessor */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_weighted_average_interpolated_average_wrapper';

-- extension/src/time_weighted_average.rs:510
-- timescaledb_toolkit::time_weighted_average::arrow_time_weighted_average_interpolated_average
CREATE OPERATOR -> (
    PROCEDURE="arrow_time_weighted_average_interpolated_average",
    LEFTARG=TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
    RIGHTARG=TimeWeightInterpolatedAverageAccessor /* timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedAverageAccessor */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:549
-- timescaledb_toolkit::time_weighted_average::arrow_time_weighted_average_interpolated_integral
CREATE FUNCTION "arrow_time_weighted_average_interpolated_integral"(
	"tws" TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"accessor" TimeWeightInterpolatedIntegralAccessor /* timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedIntegralAccessor */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_weighted_average_interpolated_integral_wrapper';

-- extension/src/time_weighted_average.rs:549
-- timescaledb_toolkit::time_weighted_average::arrow_time_weighted_average_interpolated_integral
CREATE OPERATOR -> (
    PROCEDURE="arrow_time_weighted_average_interpolated_integral",
    LEFTARG=TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
    RIGHTARG=TimeWeightInterpolatedIntegralAccessor /* timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedIntegralAccessor */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:181
-- timescaledb_toolkit::time_vector::arrow_timevector_unnest
CREATE OR REPLACE FUNCTION "arrow_timevector_unnest"(
	"series" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"_accessor" AccessorUnnest /* timescaledb_toolkit::accessors::AccessorUnnest */
) RETURNS TABLE (

	"time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision  /* f64 */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_timevector_unnest_wrapper';

-- extension/src/time_vector.rs:181
-- timescaledb_toolkit::time_vector::arrow_timevector_unnest
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1464
-- timescaledb_toolkit::frequency::arrow_topn_bigint
CREATE FUNCTION "arrow_topn_bigint"(
	"agg" SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
	"accessor" AccessorTopNCount /* timescaledb_toolkit::accessors::AccessorTopNCount */
) RETURNS SETOF bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_topn_bigint_wrapper';

-- extension/src/frequency.rs:1464
-- timescaledb_toolkit::frequency::arrow_topn_bigint
CREATE OPERATOR -> (
    PROCEDURE="arrow_topn_bigint",
    LEFTARG=SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
    RIGHTARG=AccessorTopNCount /* timescaledb_toolkit::accessors::AccessorTopNCount */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1514
-- timescaledb_toolkit::frequency::arrow_topn_text
CREATE FUNCTION "arrow_topn_text"(
	"agg" SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
	"accessor" AccessorTopNCount /* timescaledb_toolkit::accessors::AccessorTopNCount */
) RETURNS SETOF TEXT /* alloc::string::String */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_topn_text_wrapper';

-- extension/src/frequency.rs:1514
-- timescaledb_toolkit::frequency::arrow_topn_text
CREATE OPERATOR -> (
    PROCEDURE="arrow_topn_text",
    LEFTARG=SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
    RIGHTARG=AccessorTopNCount /* timescaledb_toolkit::accessors::AccessorTopNCount */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:563
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_approx_percentile
CREATE OR REPLACE FUNCTION "arrow_uddsketch_approx_percentile"(
	"sketch" UddSketch, /* timescaledb_toolkit::uddsketch::UddSketch */
	"accessor" AccessorApproxPercentile /* timescaledb_toolkit::accessors::AccessorApproxPercentile */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_uddsketch_approx_percentile_wrapper';

-- extension/src/uddsketch.rs:563
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_approx_percentile
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:584
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_approx_percentile_array
CREATE FUNCTION "arrow_uddsketch_approx_percentile_array"(
	"sketch" UddSketch, /* timescaledb_toolkit::uddsketch::UddSketch */
	"percentiles" AccessorPercentileArray /* timescaledb_toolkit::accessors::AccessorPercentileArray */
) RETURNS double precision[] /* alloc::vec::Vec<f64> */

IMMUTABLE STRICT
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_uddsketch_approx_percentile_array_wrapper';

-- extension/src/uddsketch.rs:584
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_approx_percentile_array
CREATE OPERATOR -> (
    PROCEDURE="arrow_uddsketch_approx_percentile_array",
    LEFTARG=UddSketch, /* timescaledb_toolkit::uddsketch::UddSketch */
    RIGHTARG=AccessorPercentileArray /* timescaledb_toolkit::accessors::AccessorPercentileArray */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:619
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_approx_rank
CREATE OR REPLACE FUNCTION "arrow_uddsketch_approx_rank"(
	"sketch" UddSketch, /* timescaledb_toolkit::uddsketch::UddSketch */
	"accessor" AccessorApproxPercentileRank /* timescaledb_toolkit::accessors::AccessorApproxPercentileRank */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_uddsketch_approx_rank_wrapper';

-- extension/src/uddsketch.rs:619
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_approx_rank
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:668
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_error
CREATE OR REPLACE FUNCTION "arrow_uddsketch_error"(
	"sketch" UddSketch, /* timescaledb_toolkit::uddsketch::UddSketch */
	"_accessor" AccessorError /* timescaledb_toolkit::accessors::AccessorError */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_uddsketch_error_wrapper';

-- extension/src/uddsketch.rs:668
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_error
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:651
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_mean
CREATE OR REPLACE FUNCTION "arrow_uddsketch_mean"(
	"sketch" UddSketch, /* timescaledb_toolkit::uddsketch::UddSketch */
	"_accessor" AccessorMean /* timescaledb_toolkit::accessors::AccessorMean */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_uddsketch_mean_wrapper';

-- extension/src/uddsketch.rs:651
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_mean
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:639
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_num_vals
CREATE OR REPLACE FUNCTION "arrow_uddsketch_num_vals"(
	"sketch" UddSketch, /* timescaledb_toolkit::uddsketch::UddSketch */
	"_accessor" AccessorNumVals /* timescaledb_toolkit::accessors::AccessorNumVals */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_uddsketch_num_vals_wrapper';

-- extension/src/uddsketch.rs:639
-- timescaledb_toolkit::uddsketch::arrow_uddsketch_num_vals
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/asap.rs:76
-- timescaledb_toolkit::asap::asap_final
CREATE FUNCTION "asap_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS Timevector_TSTZ_F64 /* core::option::Option<timescaledb_toolkit::time_vector::Timevector_TSTZ_F64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'asap_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/asap.rs:135
-- timescaledb_toolkit::asap::asap_smooth
CREATE OR REPLACE FUNCTION "asap_smooth"(
	"series" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"resolution" INT /* i32 */
) RETURNS Timevector_TSTZ_F64 /* core::option::Option<timescaledb_toolkit::time_vector::Timevector_TSTZ_F64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'asap_on_timevector_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/asap.rs:22
-- timescaledb_toolkit::asap::asap_trans
CREATE OR REPLACE FUNCTION "asap_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"val" double precision, /* core::option::Option<f64> */
	"resolution" INT /* i32 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'asap_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/asap.rs:182
-- requires:
--   asap_trans
--   asap_final


CREATE OR REPLACE AGGREGATE asap_smooth(ts TIMESTAMPTZ, value DOUBLE PRECISION, resolution INT)
(
sfunc = asap_trans,
stype = internal,
finalfunc = asap_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:64
-- timescaledb_toolkit::accessors::average
CREATE OR REPLACE FUNCTION "average"() RETURNS AccessorAverage /* timescaledb_toolkit::accessors::AccessorAverage */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_average_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:946
-- timescaledb_toolkit::stats_agg::average
CREATE OR REPLACE FUNCTION "average"(
	"summary" StatsSummary1D /* timescaledb_toolkit::stats_agg::StatsSummary1D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_average_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:448
-- timescaledb_toolkit::time_weighted_average::average
CREATE OR REPLACE FUNCTION "average"(
	"tws" TimeWeightSummary /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weighted_average_average_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:65
-- timescaledb_toolkit::accessors::average_x
CREATE OR REPLACE FUNCTION "average_x"() RETURNS AccessorAverageX /* timescaledb_toolkit::accessors::AccessorAverageX */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_average_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1072
-- timescaledb_toolkit::stats_agg::average_x
CREATE OR REPLACE FUNCTION "average_x"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_average_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:66
-- timescaledb_toolkit::accessors::average_y
CREATE OR REPLACE FUNCTION "average_y"() RETURNS AccessorAverageY /* timescaledb_toolkit::accessors::AccessorAverageY */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_average_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1086
-- timescaledb_toolkit::stats_agg::average_y
CREATE OR REPLACE FUNCTION "average_y"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_average_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:186
-- timescaledb_toolkit::candlestick::candlestick
CREATE OR REPLACE FUNCTION "candlestick"(
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"open" double precision, /* core::option::Option<f64> */
	"high" double precision, /* core::option::Option<f64> */
	"low" double precision, /* core::option::Option<f64> */
	"close" double precision, /* core::option::Option<f64> */
	"volume" double precision /* core::option::Option<f64> */
) RETURNS Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'candlestick_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:306
-- timescaledb_toolkit::candlestick::candlestick_combine
CREATE FUNCTION "candlestick_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'candlestick_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:340
-- timescaledb_toolkit::candlestick::candlestick_deserialize
CREATE FUNCTION "candlestick_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'candlestick_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:283
-- timescaledb_toolkit::candlestick::candlestick_final
CREATE FUNCTION "candlestick_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'candlestick_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:256
-- timescaledb_toolkit::candlestick::candlestick_rollup_trans
CREATE FUNCTION "candlestick_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'candlestick_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:333
-- timescaledb_toolkit::candlestick::candlestick_serialize
CREATE FUNCTION "candlestick_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'candlestick_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:377
-- requires:
--   candlestick_rollup_trans
--   candlestick_final
--   candlestick_combine
--   candlestick_serialize
--   candlestick_deserialize


CREATE AGGREGATE rollup( candlestick Candlestick)
(
sfunc = candlestick_rollup_trans,
stype = internal,
finalfunc = candlestick_final,
combinefunc = candlestick_combine,
serialfunc = candlestick_serialize,
deserialfunc = candlestick_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:93
-- timescaledb_toolkit::accessors::close
CREATE FUNCTION "close"() RETURNS AccessorClose /* timescaledb_toolkit::accessors::AccessorClose */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_close_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:447
-- timescaledb_toolkit::candlestick::close
CREATE FUNCTION "close"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'close_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:99
-- timescaledb_toolkit::accessors::close_time
CREATE FUNCTION "close_time"() RETURNS AccessorCloseTime /* timescaledb_toolkit::accessors::AccessorCloseTime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_close_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:503
-- timescaledb_toolkit::candlestick::close_time
CREATE FUNCTION "close_time"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'close_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:71
-- timescaledb_toolkit::accessors::corr
CREATE OR REPLACE FUNCTION "corr"() RETURNS AccessorCorr /* timescaledb_toolkit::accessors::AccessorCorr */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_corr_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:807
-- timescaledb_toolkit::counter_agg::corr
CREATE OR REPLACE FUNCTION "corr"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_corr_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1324
-- timescaledb_toolkit::stats_agg::corr
CREATE OR REPLACE FUNCTION "corr"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_corr_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:330
-- timescaledb_toolkit::counter_agg::counter_agg_combine
CREATE OR REPLACE FUNCTION "counter_agg_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:370
-- timescaledb_toolkit::counter_agg::counter_agg_final
CREATE OR REPLACE FUNCTION "counter_agg_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS CounterSummary /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:297
-- timescaledb_toolkit::counter_agg::counter_agg_summary_trans
CREATE OR REPLACE FUNCTION "counter_agg_summary_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" CounterSummary /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_summary_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:245
-- timescaledb_toolkit::counter_agg::counter_agg_trans
CREATE OR REPLACE FUNCTION "counter_agg_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"val" double precision, /* core::option::Option<f64> */
	"bounds" tstzrange /* core::option::Option<timescaledb_toolkit::raw::tstzrange> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:287
-- timescaledb_toolkit::counter_agg::counter_agg_trans_no_bounds
CREATE OR REPLACE FUNCTION "counter_agg_trans_no_bounds"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"val" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_trans_no_bounds_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:236
-- timescaledb_toolkit::counter_agg::counter_summary_trans_deserialize
CREATE OR REPLACE FUNCTION "counter_summary_trans_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_summary_trans_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:229
-- timescaledb_toolkit::counter_agg::counter_summary_trans_serialize
CREATE OR REPLACE FUNCTION "counter_summary_trans_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_summary_trans_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:403
-- requires:
--   counter_agg_trans
--   counter_agg_final
--   counter_agg_combine
--   counter_summary_trans_serialize
--   counter_summary_trans_deserialize


CREATE OR REPLACE AGGREGATE counter_agg( ts timestamptz, value DOUBLE PRECISION, bounds tstzrange )
(
sfunc = counter_agg_trans,
stype = internal,
finalfunc = counter_agg_final,
combinefunc = counter_agg_combine,
serialfunc = counter_summary_trans_serialize,
deserialfunc = counter_summary_trans_deserialize,
parallel = restricted
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:426
-- requires:
--   counter_agg_trans_no_bounds
--   counter_agg_final
--   counter_agg_combine
--   counter_summary_trans_serialize
--   counter_summary_trans_deserialize


CREATE OR REPLACE AGGREGATE counter_agg( ts timestamptz, value DOUBLE PRECISION )
(
sfunc = counter_agg_trans_no_bounds,
stype = internal,
finalfunc = counter_agg_final,
combinefunc = counter_agg_combine,
serialfunc = counter_summary_trans_serialize,
deserialfunc = counter_summary_trans_deserialize,
parallel = restricted
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:449
-- requires:
--   counter_agg_summary_trans
--   counter_agg_final
--   counter_agg_combine
--   counter_summary_trans_serialize
--   counter_summary_trans_deserialize


CREATE OR REPLACE AGGREGATE rollup(cs CounterSummary)
(
sfunc = counter_agg_summary_trans,
stype = internal,
finalfunc = counter_agg_final,
combinefunc = counter_agg_combine,
serialfunc = counter_summary_trans_serialize,
deserialfunc = counter_summary_trans_deserialize,
parallel = restricted
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:87
-- timescaledb_toolkit::accessors::counter_zero_time
CREATE OR REPLACE FUNCTION "counter_zero_time"() RETURNS AccessorCounterZeroTime /* timescaledb_toolkit::accessors::AccessorCounterZeroTime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_counter_zero_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:821
-- timescaledb_toolkit::counter_agg::counter_zero_time
CREATE OR REPLACE FUNCTION "counter_zero_time"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_counter_zero_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:427
-- timescaledb_toolkit::accessors::covariance
CREATE OR REPLACE FUNCTION "covariance"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorCovar /* timescaledb_toolkit::accessors::AccessorCovar */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_covar_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1381
-- timescaledb_toolkit::stats_agg::covariance
CREATE OR REPLACE FUNCTION "covariance"(
	"summary" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_covar_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:101
-- timescaledb_toolkit::accessors::dead_ranges
CREATE FUNCTION "dead_ranges"() RETURNS AccessorDeadRanges /* timescaledb_toolkit::accessors::AccessorDeadRanges */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_dead_ranges_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:347
-- timescaledb_toolkit::heartbeat_agg::dead_ranges
CREATE FUNCTION "dead_ranges"(
	"agg" HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
) RETURNS TABLE (

	"start" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
STRICT
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'dead_ranges_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:77
-- timescaledb_toolkit::accessors::delta
CREATE OR REPLACE FUNCTION "delta"() RETURNS AccessorDelta /* timescaledb_toolkit::accessors::AccessorDelta */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:481
-- timescaledb_toolkit::counter_agg::delta
CREATE OR REPLACE FUNCTION "delta"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:74
-- timescaledb_toolkit::accessors::determination_coeff
CREATE OR REPLACE FUNCTION "determination_coeff"() RETURNS AccessorDeterminationCoeff /* timescaledb_toolkit::accessors::AccessorDeterminationCoeff */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_determination_coeff_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1366
-- timescaledb_toolkit::stats_agg::determination_coeff
CREATE OR REPLACE FUNCTION "determination_coeff"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_determination_coeff_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:75
-- timescaledb_toolkit::accessors::distinct_count
CREATE OR REPLACE FUNCTION "distinct_count"() RETURNS AccessorDistinctCount /* timescaledb_toolkit::accessors::AccessorDistinctCount */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_distinct_count_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:349
-- timescaledb_toolkit::hyperloglog::distinct_count
CREATE OR REPLACE FUNCTION "distinct_count"(
	"hyperloglog" HyperLogLog /* timescaledb_toolkit::hyperloglog::HyperLogLog */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_count_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:103
-- timescaledb_toolkit::accessors::downtime
CREATE FUNCTION "downtime"() RETURNS AccessorDowntime /* timescaledb_toolkit::accessors::AccessorDowntime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_downtime_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:424
-- timescaledb_toolkit::heartbeat_agg::downtime
CREATE FUNCTION "downtime"(
	"agg" HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

STRICT
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'downtime_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:199
-- timescaledb_toolkit::state_aggregate::accessors::duration_in
CREATE FUNCTION "duration_in"(
	"state" TEXT /* alloc::string::String */
) RETURNS AccessorDurationIn /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationIn */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_duration_in_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:208
-- timescaledb_toolkit::state_aggregate::accessors::duration_in
CREATE FUNCTION "duration_in"(
	"state" bigint /* i64 */
) RETURNS AccessorDurationInInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInInt */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_duration_in_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:268
-- timescaledb_toolkit::state_aggregate::accessors::duration_in
CREATE OR REPLACE FUNCTION "duration_in"(
	"state" TEXT, /* alloc::string::String */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval DEFAULT NULL /* core::option::Option<timescaledb_toolkit::raw::Interval> */
) RETURNS AccessorDurationInRange /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRange */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_duration_in_range_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:287
-- timescaledb_toolkit::state_aggregate::accessors::duration_in
CREATE OR REPLACE FUNCTION "duration_in"(
	"state" bigint, /* i64 */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval DEFAULT NULL /* core::option::Option<timescaledb_toolkit::raw::Interval> */
) RETURNS AccessorDurationInRangeInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorDurationInRangeInt */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_duration_in_range_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:871
-- timescaledb_toolkit::state_aggregate::duration_in
CREATE OR REPLACE FUNCTION "duration_in"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"state" TEXT, /* alloc::string::String */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval DEFAULT NULL /* core::option::Option<timescaledb_toolkit::raw::Interval> */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'duration_in_range_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:891
-- timescaledb_toolkit::state_aggregate::duration_in
CREATE OR REPLACE FUNCTION "duration_in"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"state" bigint, /* i64 */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval DEFAULT NULL /* core::option::Option<timescaledb_toolkit::raw::Interval> */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'duration_in_range_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:831
-- timescaledb_toolkit::state_aggregate::duration_in
CREATE FUNCTION "duration_in"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"state" TEXT /* alloc::string::String */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'duration_in_tl_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:839
-- timescaledb_toolkit::state_aggregate::duration_in
CREATE FUNCTION "duration_in"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"state" bigint /* i64 */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'duration_in_tl_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:61
-- timescaledb_toolkit::accessors::error
CREATE OR REPLACE FUNCTION "error"() RETURNS AccessorError /* timescaledb_toolkit::accessors::AccessorError */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_error_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:675
-- timescaledb_toolkit::uddsketch::error
CREATE OR REPLACE FUNCTION "error"(
	"sketch" UddSketch /* timescaledb_toolkit::uddsketch::UddSketch */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_error_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:451
-- timescaledb_toolkit::accessors::extrapolated_delta
CREATE OR REPLACE FUNCTION "extrapolated_delta"(
	"method" TEXT /* &str */
) RETURNS AccessorExtrapolatedDelta /* timescaledb_toolkit::accessors::AccessorExtrapolatedDelta */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_extrapolated_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:616
-- timescaledb_toolkit::counter_agg::extrapolated_delta
CREATE OR REPLACE FUNCTION "extrapolated_delta"(
	"summary" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"method" TEXT /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_extrapolated_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:475
-- timescaledb_toolkit::accessors::extrapolated_rate
CREATE OR REPLACE FUNCTION "extrapolated_rate"(
	"method" TEXT /* &str */
) RETURNS AccessorExtrapolatedRate /* timescaledb_toolkit::accessors::AccessorExtrapolatedRate */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_extrapolated_rate_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:677
-- timescaledb_toolkit::counter_agg::extrapolated_rate
CREATE OR REPLACE FUNCTION "extrapolated_rate"(
	"summary" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"method" TEXT /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_extrapolated_rate_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:90
-- timescaledb_toolkit::accessors::first_time
CREATE FUNCTION "first_time"() RETURNS AccessorFirstTime /* timescaledb_toolkit::accessors::AccessorFirstTime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_first_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:865
-- timescaledb_toolkit::counter_agg::first_time
CREATE FUNCTION "first_time"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_first_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:373
-- timescaledb_toolkit::time_weighted_average::first_time
CREATE FUNCTION "first_time"(
	"summary" TimeWeightSummary /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_first_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:88
-- timescaledb_toolkit::accessors::first_val
CREATE FUNCTION "first_val"() RETURNS AccessorFirstVal /* timescaledb_toolkit::accessors::AccessorFirstVal */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_first_val_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:837
-- timescaledb_toolkit::counter_agg::first_val
CREATE FUNCTION "first_val"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_first_val_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:345
-- timescaledb_toolkit::time_weighted_average::first_val
CREATE FUNCTION "first_val"(
	"summary" TimeWeightSummary /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_first_val_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:641
-- timescaledb_toolkit::heartbeat_agg::heartbeat_final
CREATE FUNCTION "heartbeat_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeat_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:680
-- timescaledb_toolkit::heartbeat_agg::heartbeat_rollup_trans
CREATE FUNCTION "heartbeat_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeat_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:722
-- requires:
--   heartbeat_rollup_trans
--   heartbeat_final


CREATE OR REPLACE AGGREGATE rollup(
HeartbeatAgg
) (

sfunc = heartbeat_rollup_trans,
stype = internal,
finalfunc = heartbeat_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:600
-- timescaledb_toolkit::heartbeat_agg::heartbeat_trans
CREATE OR REPLACE FUNCTION "heartbeat_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"heartbeat" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"length" Interval, /* timescaledb_toolkit::raw::Interval */
	"liveness_duration" Interval /* timescaledb_toolkit::raw::Interval */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeat_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:705
-- requires:
--   heartbeat_trans
--   heartbeat_final


CREATE OR REPLACE AGGREGATE heartbeat_agg(
heartbeat TIMESTAMPTZ, agg_start TIMESTAMPTZ, agg_duration INTERVAL, heartbeat_liveness INTERVAL
) (

sfunc = heartbeat_trans,
stype = internal,
finalfunc = heartbeat_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:94
-- timescaledb_toolkit::accessors::high
CREATE FUNCTION "high"() RETURNS AccessorHigh /* timescaledb_toolkit::accessors::AccessorHigh */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_high_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:422
-- timescaledb_toolkit::candlestick::high
CREATE FUNCTION "high"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'high_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:97
-- timescaledb_toolkit::accessors::high_time
CREATE FUNCTION "high_time"() RETURNS AccessorHighTime /* timescaledb_toolkit::accessors::AccessorHighTime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_high_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:475
-- timescaledb_toolkit::candlestick::high_time
CREATE FUNCTION "high_time"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'high_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:125
-- timescaledb_toolkit::hyperloglog::hyperloglog_combine
CREATE OR REPLACE FUNCTION "hyperloglog_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:161
-- timescaledb_toolkit::hyperloglog::hyperloglog_deserialize
CREATE OR REPLACE FUNCTION "hyperloglog_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:207
-- timescaledb_toolkit::hyperloglog::hyperloglog_final
CREATE OR REPLACE FUNCTION "hyperloglog_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS HyperLogLog /* core::option::Option<timescaledb_toolkit::hyperloglog::HyperLogLog> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:154
-- timescaledb_toolkit::hyperloglog::hyperloglog_serialize
CREATE OR REPLACE FUNCTION "hyperloglog_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:253
-- requires:
--   approx_count_distinct_trans
--   hyperloglog_final
--   hyperloglog_combine
--   hyperloglog_serialize
--   hyperloglog_deserialize


CREATE AGGREGATE approx_count_distinct(value AnyElement)
(
stype = internal,
sfunc = approx_count_distinct_trans,
finalfunc = hyperloglog_final,
combinefunc = hyperloglog_combine,
serialfunc = hyperloglog_serialize,
deserialfunc = hyperloglog_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:43
-- timescaledb_toolkit::hyperloglog::hyperloglog_trans
CREATE OR REPLACE FUNCTION "hyperloglog_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"size" INT, /* i32 */
	"value" AnyElement /* core::option::Option<timescaledb_toolkit::raw::AnyElement> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:230
-- requires:
--   hyperloglog_trans
--   hyperloglog_final
--   hyperloglog_combine
--   hyperloglog_serialize
--   hyperloglog_deserialize


CREATE OR REPLACE AGGREGATE hyperloglog(size integer, value AnyElement)
(
stype = internal,
sfunc = hyperloglog_trans,
finalfunc = hyperloglog_final,
combinefunc = hyperloglog_combine,
serialfunc = hyperloglog_serialize,
deserialfunc = hyperloglog_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:276
-- timescaledb_toolkit::hyperloglog::hyperloglog_union
CREATE OR REPLACE FUNCTION "hyperloglog_union"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"other" HyperLogLog /* core::option::Option<timescaledb_toolkit::hyperloglog::HyperLogLog> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_union_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:317
-- requires:
--   hyperloglog_union
--   hyperloglog_final
--   hyperloglog_combine
--   hyperloglog_serialize
--   hyperloglog_deserialize


CREATE OR REPLACE AGGREGATE rollup(hyperloglog Hyperloglog)
(
stype = internal,
sfunc = hyperloglog_union,
finalfunc = hyperloglog_final,
combinefunc = hyperloglog_combine,
serialfunc = hyperloglog_serialize,
deserialfunc = hyperloglog_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:82
-- timescaledb_toolkit::accessors::idelta_left
CREATE OR REPLACE FUNCTION "idelta_left"() RETURNS AccessorIdeltaLeft /* timescaledb_toolkit::accessors::AccessorIdeltaLeft */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_idelta_left_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:551
-- timescaledb_toolkit::counter_agg::idelta_left
CREATE OR REPLACE FUNCTION "idelta_left"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_idelta_left_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:83
-- timescaledb_toolkit::accessors::idelta_right
CREATE OR REPLACE FUNCTION "idelta_right"() RETURNS AccessorIdeltaRight /* timescaledb_toolkit::accessors::AccessorIdeltaRight */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_idelta_right_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:565
-- timescaledb_toolkit::counter_agg::idelta_right
CREATE OR REPLACE FUNCTION "idelta_right"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_idelta_right_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:572
-- timescaledb_toolkit::accessors::integral
CREATE OR REPLACE FUNCTION "integral"(
	"unit" TEXT DEFAULT 'second' /* &str */
) RETURNS AccessorIntegral /* timescaledb_toolkit::accessors::AccessorIntegral */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_integral_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:466
-- timescaledb_toolkit::time_weighted_average::integral
CREATE OR REPLACE FUNCTION "integral"(
	"tws" TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"unit" TEXT DEFAULT 'second' /* alloc::string::String */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weighted_average_integral_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:72
-- timescaledb_toolkit::accessors::intercept
CREATE OR REPLACE FUNCTION "intercept"() RETURNS AccessorIntercept /* timescaledb_toolkit::accessors::AccessorIntercept */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_intercept_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:793
-- timescaledb_toolkit::counter_agg::intercept
CREATE OR REPLACE FUNCTION "intercept"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_intercept_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1338
-- timescaledb_toolkit::stats_agg::intercept
CREATE OR REPLACE FUNCTION "intercept"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_intercept_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg/accessors.rs:100
-- timescaledb_toolkit::heartbeat_agg::accessors::interpolate
CREATE FUNCTION "interpolate"(
	"prev" HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */
) RETURNS HeartbeatInterpolateAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolateAccessor */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeat_agg_interpolate_accessor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:493
-- timescaledb_toolkit::heartbeat_agg::interpolate
CREATE FUNCTION "interpolate"(
	"agg" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"pred" HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */
) RETURNS HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */


LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolate_heartbeat_agg_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average/accessors.rs:25
-- timescaledb_toolkit::time_weighted_average::accessors::interpolated_average
CREATE OR REPLACE FUNCTION "interpolated_average"(
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"duration" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" TimeWeightSummary DEFAULT NULL, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"next" TimeWeightSummary DEFAULT NULL /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
) RETURNS TimeWeightInterpolatedAverageAccessor /* timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedAverageAccessor */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_interpolated_average_accessor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:498
-- timescaledb_toolkit::time_weighted_average::interpolated_average
CREATE OR REPLACE FUNCTION "interpolated_average"(
	"tws" TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"duration" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" TimeWeightSummary DEFAULT NULL, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"next" TimeWeightSummary DEFAULT NULL /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weighted_average_interpolated_average_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:626
-- timescaledb_toolkit::counter_agg::interpolated_delta
CREATE OR REPLACE FUNCTION "interpolated_delta"(
	"summary" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"duration" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" CounterSummary, /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
	"next" CounterSummary /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
) RETURNS double precision /* f64 */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_interpolated_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg/accessors.rs:64
-- timescaledb_toolkit::counter_agg::accessors::interpolated_delta
CREATE OR REPLACE FUNCTION "interpolated_delta"(
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"duration" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" CounterSummary, /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
	"next" CounterSummary /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
) RETURNS CounterInterpolatedDeltaAccessor /* timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedDeltaAccessor */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_interpolated_delta_accessor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg/accessors.rs:66
-- timescaledb_toolkit::heartbeat_agg::accessors::interpolated_downtime
CREATE FUNCTION "interpolated_downtime"(
	"prev" HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */
) RETURNS HeartbeatInterpolatedDowntimeAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedDowntimeAccessor */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeat_agg_interpolated_downtime_accessor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:438
-- timescaledb_toolkit::heartbeat_agg::interpolated_downtime
CREATE FUNCTION "interpolated_downtime"(
	"agg" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"pred" HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_downtime_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:84
-- timescaledb_toolkit::state_aggregate::accessors::interpolated_duration_in
CREATE OR REPLACE FUNCTION "interpolated_duration_in"(
	"state" TEXT, /* alloc::string::String */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS AccessorInterpolatedDurationIn /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationIn */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_interpolated_interpolated_duration_in_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:103
-- timescaledb_toolkit::state_aggregate::accessors::interpolated_duration_in
CREATE OR REPLACE FUNCTION "interpolated_duration_in"(
	"state" bigint, /* i64 */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS AccessorInterpolatedDurationInInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedDurationInInt */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_interpolated_interpolated_duration_in_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1009
-- timescaledb_toolkit::state_aggregate::interpolated_duration_in
CREATE OR REPLACE FUNCTION "interpolated_duration_in"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"state" TEXT, /* alloc::string::String */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_duration_in_tl_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1055
-- timescaledb_toolkit::state_aggregate::interpolated_duration_in
CREATE OR REPLACE FUNCTION "interpolated_duration_in"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"state" bigint, /* i64 */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_duration_in_tl_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average/accessors.rs:74
-- timescaledb_toolkit::time_weighted_average::accessors::interpolated_integral
CREATE OR REPLACE FUNCTION "interpolated_integral"(
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" TimeWeightSummary DEFAULT NULL, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"next" TimeWeightSummary DEFAULT NULL, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"unit" TEXT DEFAULT 'second' /* alloc::string::String */
) RETURNS TimeWeightInterpolatedIntegralAccessor /* timescaledb_toolkit::time_weighted_average::accessors::TimeWeightInterpolatedIntegralAccessor */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_interpolated_integral_accessor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:536
-- timescaledb_toolkit::time_weighted_average::interpolated_integral
CREATE OR REPLACE FUNCTION "interpolated_integral"(
	"tws" TimeWeightSummary, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" TimeWeightSummary DEFAULT NULL, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"next" TimeWeightSummary DEFAULT NULL, /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
	"unit" TEXT DEFAULT 'second' /* alloc::string::String */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weighted_average_interpolated_integral_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:687
-- timescaledb_toolkit::counter_agg::interpolated_rate
CREATE OR REPLACE FUNCTION "interpolated_rate"(
	"summary" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"duration" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" CounterSummary, /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
	"next" CounterSummary /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_interpolated_rate_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg/accessors.rs:23
-- timescaledb_toolkit::counter_agg::accessors::interpolated_rate
CREATE OR REPLACE FUNCTION "interpolated_rate"(
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"duration" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" CounterSummary, /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
	"next" CounterSummary /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */
) RETURNS CounterInterpolatedRateAccessor /* timescaledb_toolkit::counter_agg::accessors::CounterInterpolatedRateAccessor */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_interpolated_rate_accessor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:43
-- timescaledb_toolkit::state_aggregate::accessors::interpolated_state_int_timeline
CREATE OR REPLACE FUNCTION "interpolated_state_int_timeline"(
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS AccessorInterpolatedStateIntTimeline /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateIntTimeline */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_interpolated_interpolated_state_int_timeline_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1441
-- timescaledb_toolkit::state_aggregate::interpolated_state_int_timeline
CREATE OR REPLACE FUNCTION "interpolated_state_int_timeline"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS TABLE (

	"state" bigint,  /* i64 */
	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_state_int_timeline_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:147
-- timescaledb_toolkit::state_aggregate::accessors::interpolated_state_periods
CREATE OR REPLACE FUNCTION "interpolated_state_periods"(
	"state" TEXT, /* alloc::string::String */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS AccessorInterpolatedStatePeriods /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriods */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_interpolated_interpolated_state_periods_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:166
-- timescaledb_toolkit::state_aggregate::accessors::interpolated_state_periods
CREATE OR REPLACE FUNCTION "interpolated_state_periods"(
	"state" bigint, /* i64 */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS AccessorInterpolatedStatePeriodsInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStatePeriodsInt */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_interpolated_interpolated_state_periods_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1629
-- timescaledb_toolkit::state_aggregate::interpolated_state_periods
CREATE OR REPLACE FUNCTION "interpolated_state_periods"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"state" TEXT, /* alloc::string::String */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS TABLE (

	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_state_periods_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1655
-- timescaledb_toolkit::state_aggregate::interpolated_state_periods
CREATE OR REPLACE FUNCTION "interpolated_state_periods"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"state" bigint, /* i64 */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS TABLE (

	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_state_periods_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:17
-- timescaledb_toolkit::state_aggregate::accessors::interpolated_state_timeline
CREATE OR REPLACE FUNCTION "interpolated_state_timeline"(
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS AccessorInterpolatedStateTimeline /* timescaledb_toolkit::state_aggregate::accessors::AccessorInterpolatedStateTimeline */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_interpolated_interpolated_state_timeline_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1424
-- timescaledb_toolkit::state_aggregate::interpolated_state_timeline
CREATE OR REPLACE FUNCTION "interpolated_state_timeline"(
	"agg" StateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS TABLE (

	"state" TEXT,  /* alloc::string::String */
	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_state_timeline_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg/accessors.rs:32
-- timescaledb_toolkit::heartbeat_agg::accessors::interpolated_uptime
CREATE FUNCTION "interpolated_uptime"(
	"prev" HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */
) RETURNS HeartbeatInterpolatedUptimeAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatInterpolatedUptimeAccessor */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeat_agg_interpolated_uptime_accessor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:407
-- timescaledb_toolkit::heartbeat_agg::interpolated_uptime
CREATE FUNCTION "interpolated_uptime"(
	"agg" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"pred" HeartbeatAgg /* core::option::Option<timescaledb_toolkit::heartbeat_agg::HeartbeatAgg> */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_uptime_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:105
-- timescaledb_toolkit::accessors::into_array
CREATE FUNCTION "into_array"() RETURNS AccessorIntoArray /* timescaledb_toolkit::accessors::AccessorIntoArray */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_into_array_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:115
-- timescaledb_toolkit::nmost::max_float::into_array
CREATE FUNCTION "into_array"(
	"agg" MaxFloats /* timescaledb_toolkit::nmost::max_float::MaxFloats */
) RETURNS double precision[] /* alloc::vec::Vec<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_float_to_array_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:109
-- timescaledb_toolkit::nmost::max_int::into_array
CREATE FUNCTION "into_array"(
	"agg" MaxInts /* timescaledb_toolkit::nmost::max_int::MaxInts */
) RETURNS bigint[] /* alloc::vec::Vec<i64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_int_to_array_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:110
-- timescaledb_toolkit::nmost::max_time::into_array
CREATE FUNCTION "into_array"(
	"agg" MaxTimes /* timescaledb_toolkit::nmost::max_time::MaxTimes */
) RETURNS TimestampTz[] /* alloc::vec::Vec<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_time_to_array_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:114
-- timescaledb_toolkit::nmost::min_float::into_array
CREATE FUNCTION "into_array"(
	"agg" MinFloats /* timescaledb_toolkit::nmost::min_float::MinFloats */
) RETURNS double precision[] /* alloc::vec::Vec<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_float_to_array_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:101
-- timescaledb_toolkit::nmost::min_int::into_array
CREATE FUNCTION "into_array"(
	"agg" MinInts /* timescaledb_toolkit::nmost::min_int::MinInts */
) RETURNS bigint[] /* alloc::vec::Vec<i64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_int_to_array_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:101
-- timescaledb_toolkit::nmost::min_time::into_array
CREATE FUNCTION "into_array"(
	"agg" MinTimes /* timescaledb_toolkit::nmost::min_time::MinTimes */
) RETURNS TimestampTz[] /* alloc::vec::Vec<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_time_to_array_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:106
-- timescaledb_toolkit::accessors::into_int_values
CREATE FUNCTION "into_int_values"() RETURNS AccessorIntoIntValues /* timescaledb_toolkit::accessors::AccessorIntoIntValues */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_into_int_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1202
-- timescaledb_toolkit::state_aggregate::into_int_values
CREATE FUNCTION "into_int_values"(
	"agg" StateAgg /* timescaledb_toolkit::state_aggregate::StateAgg */
) RETURNS TABLE (

	"state" bigint,  /* i64 */
	"duration" Interval  /* timescaledb_toolkit::raw::Interval */
)
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'into_values_tl_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:104
-- timescaledb_toolkit::accessors::into_values
CREATE FUNCTION "into_values"() RETURNS AccessorIntoValues /* timescaledb_toolkit::accessors::AccessorIntoValues */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_into_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1290
-- timescaledb_toolkit::frequency::into_values
CREATE FUNCTION "into_values"(
	"agg" SpaceSavingBigIntAggregate /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
) RETURNS TABLE (

	"value" bigint,  /* i64 */
	"min_freq" double precision,  /* f64 */
	"max_freq" double precision  /* f64 */
)
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'freq_bigint_iter_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1259
-- timescaledb_toolkit::frequency::into_values
CREATE FUNCTION "into_values"(
	"agg" SpaceSavingAggregate, /* timescaledb_toolkit::frequency::SpaceSavingAggregate */
	"ty" anyelement /* pgrx::datum::anyelement::AnyElement */
) RETURNS TABLE (

	"value" anyelement,  /* pgrx::datum::anyelement::AnyElement */
	"min_freq" double precision,  /* f64 */
	"max_freq" double precision  /* f64 */
)
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'freq_iter_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1328
-- timescaledb_toolkit::frequency::into_values
CREATE FUNCTION "into_values"(
	"agg" SpaceSavingTextAggregate /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
) RETURNS TABLE (

	"value" TEXT,  /* alloc::string::String */
	"min_freq" double precision,  /* f64 */
	"max_freq" double precision  /* f64 */
)
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'freq_text_iter_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1189
-- timescaledb_toolkit::state_aggregate::into_values
CREATE FUNCTION "into_values"(
	"agg" StateAgg /* timescaledb_toolkit::state_aggregate::StateAgg */
) RETURNS TABLE (

	"state" TEXT,  /* alloc::string::String */
	"duration" Interval  /* timescaledb_toolkit::raw::Interval */
)
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'into_values_tl_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_float.rs:93
-- timescaledb_toolkit::nmost::max_by_float::into_values
CREATE FUNCTION "into_values"(
	"agg" MaxByFloats, /* timescaledb_toolkit::nmost::max_by_float::MaxByFloats */
	"_dummy" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS TABLE (

	"value" double precision,  /* f64 */
	"data" anyelement  /* pgrx::datum::anyelement::AnyElement */
)
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_float_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_int.rs:92
-- timescaledb_toolkit::nmost::max_by_int::into_values
CREATE FUNCTION "into_values"(
	"agg" MaxByInts, /* timescaledb_toolkit::nmost::max_by_int::MaxByInts */
	"_dummy" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS TABLE (

	"value" bigint,  /* i64 */
	"data" anyelement  /* pgrx::datum::anyelement::AnyElement */
)
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_int_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_time.rs:92
-- timescaledb_toolkit::nmost::max_by_time::into_values
CREATE FUNCTION "into_values"(
	"agg" MaxByTimes, /* timescaledb_toolkit::nmost::max_by_time::MaxByTimes */
	"_dummy" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS TABLE (

	"value" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"data" anyelement  /* pgrx::datum::anyelement::AnyElement */
)
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_time_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:120
-- timescaledb_toolkit::nmost::max_float::into_values
CREATE FUNCTION "into_values"(
	"agg" MaxFloats /* timescaledb_toolkit::nmost::max_float::MaxFloats */
) RETURNS SETOF double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_float_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:114
-- timescaledb_toolkit::nmost::max_int::into_values
CREATE FUNCTION "into_values"(
	"agg" MaxInts /* timescaledb_toolkit::nmost::max_int::MaxInts */
) RETURNS SETOF bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_int_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:119
-- timescaledb_toolkit::nmost::max_time::into_values
CREATE FUNCTION "into_values"(
	"agg" MaxTimes /* timescaledb_toolkit::nmost::max_time::MaxTimes */
) RETURNS SETOF TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_time_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_float.rs:92
-- timescaledb_toolkit::nmost::min_by_float::into_values
CREATE FUNCTION "into_values"(
	"agg" MinByFloats, /* timescaledb_toolkit::nmost::min_by_float::MinByFloats */
	"_dummy" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS TABLE (

	"value" double precision,  /* f64 */
	"data" anyelement  /* pgrx::datum::anyelement::AnyElement */
)
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_float_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_int.rs:79
-- timescaledb_toolkit::nmost::min_by_int::into_values
CREATE FUNCTION "into_values"(
	"agg" MinByInts, /* timescaledb_toolkit::nmost::min_by_int::MinByInts */
	"_dummy" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS TABLE (

	"value" bigint,  /* i64 */
	"data" anyelement  /* pgrx::datum::anyelement::AnyElement */
)
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_int_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_time.rs:79
-- timescaledb_toolkit::nmost::min_by_time::into_values
CREATE FUNCTION "into_values"(
	"agg" MinByTimes, /* timescaledb_toolkit::nmost::min_by_time::MinByTimes */
	"_dummy" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS TABLE (

	"value" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"data" anyelement  /* pgrx::datum::anyelement::AnyElement */
)
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_time_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:119
-- timescaledb_toolkit::nmost::min_float::into_values
CREATE FUNCTION "into_values"(
	"agg" MinFloats /* timescaledb_toolkit::nmost::min_float::MinFloats */
) RETURNS SETOF double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_float_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:106
-- timescaledb_toolkit::nmost::min_int::into_values
CREATE FUNCTION "into_values"(
	"agg" MinInts /* timescaledb_toolkit::nmost::min_int::MinInts */
) RETURNS SETOF bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_int_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:110
-- timescaledb_toolkit::nmost::min_time::into_values
CREATE FUNCTION "into_values"(
	"agg" MinTimes /* timescaledb_toolkit::nmost::min_time::MinTimes */
) RETURNS SETOF TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_time_to_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:80
-- timescaledb_toolkit::accessors::irate_left
CREATE OR REPLACE FUNCTION "irate_left"() RETURNS AccessorIrateLeft /* timescaledb_toolkit::accessors::AccessorIrateLeft */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_irate_left_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:523
-- timescaledb_toolkit::counter_agg::irate_left
CREATE OR REPLACE FUNCTION "irate_left"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_irate_left_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:81
-- timescaledb_toolkit::accessors::irate_right
CREATE OR REPLACE FUNCTION "irate_right"() RETURNS AccessorIrateRight /* timescaledb_toolkit::accessors::AccessorIrateRight */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_irate_right_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:537
-- timescaledb_toolkit::counter_agg::irate_right
CREATE OR REPLACE FUNCTION "irate_right"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_irate_right_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:357
-- timescaledb_toolkit::accessors::kurtosis
CREATE OR REPLACE FUNCTION "kurtosis"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorKurtosis /* timescaledb_toolkit::accessors::AccessorKurtosis */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_kurtosis_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1038
-- timescaledb_toolkit::stats_agg::kurtosis
CREATE OR REPLACE FUNCTION "kurtosis"(
	"summary" StatsSummary1D, /* timescaledb_toolkit::stats_agg::StatsSummary1D */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_kurtosis_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:380
-- timescaledb_toolkit::accessors::kurtosis_x
CREATE OR REPLACE FUNCTION "kurtosis_x"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorKurtosisX /* timescaledb_toolkit::accessors::AccessorKurtosisX */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_kurtosis_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1255
-- timescaledb_toolkit::stats_agg::kurtosis_x
CREATE OR REPLACE FUNCTION "kurtosis_x"(
	"summary" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_kurtosis_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:403
-- timescaledb_toolkit::accessors::kurtosis_y
CREATE OR REPLACE FUNCTION "kurtosis_y"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorKurtosisY /* timescaledb_toolkit::accessors::AccessorKurtosisY */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_kurtosis_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1276
-- timescaledb_toolkit::stats_agg::kurtosis_y
CREATE OR REPLACE FUNCTION "kurtosis_y"(
	"summary" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_kurtosis_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:91
-- timescaledb_toolkit::accessors::last_time
CREATE FUNCTION "last_time"() RETURNS AccessorLastTime /* timescaledb_toolkit::accessors::AccessorLastTime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_last_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:879
-- timescaledb_toolkit::counter_agg::last_time
CREATE FUNCTION "last_time"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_last_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:387
-- timescaledb_toolkit::time_weighted_average::last_time
CREATE FUNCTION "last_time"(
	"summary" TimeWeightSummary /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_last_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:89
-- timescaledb_toolkit::accessors::last_val
CREATE FUNCTION "last_val"() RETURNS AccessorLastVal /* timescaledb_toolkit::accessors::AccessorLastVal */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_last_val_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:851
-- timescaledb_toolkit::counter_agg::last_val
CREATE FUNCTION "last_val"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_last_val_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:359
-- timescaledb_toolkit::time_weighted_average::last_val
CREATE FUNCTION "last_val"(
	"summary" TimeWeightSummary /* timescaledb_toolkit::time_weighted_average::TimeWeightSummary */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_last_val_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:123
-- timescaledb_toolkit::accessors::live_at
CREATE OR REPLACE FUNCTION "live_at"(
	"ts" TimestampTz /* timescaledb_toolkit::raw::TimestampTz */
) RETURNS AccessorLiveAt /* timescaledb_toolkit::accessors::AccessorLiveAt */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_live_at_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:455
-- timescaledb_toolkit::heartbeat_agg::live_at
CREATE OR REPLACE FUNCTION "live_at"(
	"agg" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"test" TimestampTz /* timescaledb_toolkit::raw::TimestampTz */
) RETURNS bool /* bool */

STRICT
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'live_at_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:100
-- timescaledb_toolkit::accessors::live_ranges
CREATE FUNCTION "live_ranges"() RETURNS AccessorLiveRanges /* timescaledb_toolkit::accessors::AccessorLiveRanges */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_live_ranges_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:324
-- timescaledb_toolkit::heartbeat_agg::live_ranges
CREATE FUNCTION "live_ranges"(
	"agg" HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
) RETURNS TABLE (

	"start" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
STRICT
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'live_ranges_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:95
-- timescaledb_toolkit::accessors::low
CREATE FUNCTION "low"() RETURNS AccessorLow /* timescaledb_toolkit::accessors::AccessorLow */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_low_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:433
-- timescaledb_toolkit::candlestick::low
CREATE FUNCTION "low"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'low_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:98
-- timescaledb_toolkit::accessors::low_time
CREATE FUNCTION "low_time"() RETURNS AccessorLowTime /* timescaledb_toolkit::accessors::AccessorLowTime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_low_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:489
-- timescaledb_toolkit::candlestick::low_time
CREATE FUNCTION "low_time"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'low_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lttb.rs:333
-- timescaledb_toolkit::lttb::lttb
CREATE OR REPLACE FUNCTION "lttb"(
	"series" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"threshold" INT /* i32 */
) RETURNS Timevector_TSTZ_F64 /* core::option::Option<timescaledb_toolkit::time_vector::Timevector_TSTZ_F64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'lttb_on_timevector_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lttb.rs:68
-- timescaledb_toolkit::lttb::lttb_final
CREATE OR REPLACE FUNCTION "lttb_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS Timevector_TSTZ_F64 /* core::option::Option<timescaledb_toolkit::time_vector::Timevector_TSTZ_F64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'lttb_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lttb.rs:21
-- timescaledb_toolkit::lttb::lttb_trans
CREATE OR REPLACE FUNCTION "lttb_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"time" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"val" double precision, /* core::option::Option<f64> */
	"resolution" INT /* i32 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'lttb_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lttb.rs:224
-- requires:
--   lttb_trans
--   lttb_final


CREATE OR REPLACE AGGREGATE lttb(ts TIMESTAMPTZ, value DOUBLE PRECISION, resolution integer) (
sfunc = lttb_trans,
stype = internal,
finalfunc = lttb_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:614
-- timescaledb_toolkit::accessors::max_frequency
CREATE FUNCTION "max_frequency"(
	"value" bigint /* i64 */
) RETURNS AccessorMaxFrequencyInt /* timescaledb_toolkit::accessors::AccessorMaxFrequencyInt */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_max_frequency_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1569
-- timescaledb_toolkit::frequency::max_frequency
CREATE FUNCTION "max_frequency"(
	"agg" SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
	"value" bigint /* i64 */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_bigint_frequency_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1541
-- timescaledb_toolkit::frequency::max_frequency
CREATE FUNCTION "max_frequency"(
	"agg" SpaceSavingAggregate, /* timescaledb_toolkit::frequency::SpaceSavingAggregate */
	"value" anyelement /* pgrx::datum::anyelement::AnyElement */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_frequency_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1606
-- timescaledb_toolkit::frequency::max_frequency
CREATE FUNCTION "max_frequency"(
	"agg" SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
	"value" text /* timescaledb_toolkit::raw::text */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_text_frequency_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_float.rs:88
-- timescaledb_toolkit::nmost::max_by_float::max_n_by_float_final
CREATE FUNCTION "max_n_by_float_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MaxByFloats /* timescaledb_toolkit::nmost::max_by_float::MaxByFloats */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_float_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_float.rs:65
-- timescaledb_toolkit::nmost::max_by_float::max_n_by_float_rollup_trans
CREATE FUNCTION "max_n_by_float_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MaxByFloats /* timescaledb_toolkit::nmost::max_by_float::MaxByFloats */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_float_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_float.rs:47
-- timescaledb_toolkit::nmost::max_by_float::max_n_by_float_trans
CREATE FUNCTION "max_n_by_float_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" double precision, /* f64 */
	"data" anyelement, /* pgrx::datum::anyelement::AnyElement */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_float_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_float.rs:107
-- requires:
--   max_n_by_float_trans
--   max_n_by_float_final


CREATE AGGREGATE max_n_by(
value double precision, data AnyElement, capacity bigint
) (

sfunc = max_n_by_float_trans,
stype = internal,
finalfunc = max_n_by_float_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_int.rs:87
-- timescaledb_toolkit::nmost::max_by_int::max_n_by_int_final
CREATE FUNCTION "max_n_by_int_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MaxByInts /* timescaledb_toolkit::nmost::max_by_int::MaxByInts */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_int_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_int.rs:64
-- timescaledb_toolkit::nmost::max_by_int::max_n_by_int_rollup_trans
CREATE FUNCTION "max_n_by_int_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MaxByInts /* timescaledb_toolkit::nmost::max_by_int::MaxByInts */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_int_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_int.rs:46
-- timescaledb_toolkit::nmost::max_by_int::max_n_by_int_trans
CREATE FUNCTION "max_n_by_int_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" bigint, /* i64 */
	"data" anyelement, /* pgrx::datum::anyelement::AnyElement */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_int_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_int.rs:106
-- requires:
--   max_n_by_int_trans
--   max_n_by_int_final


CREATE AGGREGATE max_n_by(
value bigint, data AnyElement, capacity bigint
) (

sfunc = max_n_by_int_trans,
stype = internal,
finalfunc = max_n_by_int_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_time.rs:87
-- timescaledb_toolkit::nmost::max_by_time::max_n_by_time_final
CREATE FUNCTION "max_n_by_time_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MaxByTimes /* timescaledb_toolkit::nmost::max_by_time::MaxByTimes */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_time_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_time.rs:64
-- timescaledb_toolkit::nmost::max_by_time::max_n_by_time_rollup_trans
CREATE FUNCTION "max_n_by_time_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MaxByTimes /* timescaledb_toolkit::nmost::max_by_time::MaxByTimes */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_time_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_time.rs:46
-- timescaledb_toolkit::nmost::max_by_time::max_n_by_time_trans
CREATE OR REPLACE FUNCTION "max_n_by_time_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"data" anyelement, /* pgrx::datum::anyelement::AnyElement */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_by_time_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_time.rs:113
-- requires:
--   max_n_by_time_trans
--   max_n_by_time_final


CREATE OR REPLACE AGGREGATE max_n_by(
value timestamptz, data AnyElement, capacity bigint
) (

sfunc = max_n_by_time_trans,
stype = internal,
finalfunc = max_n_by_time_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:84
-- timescaledb_toolkit::nmost::max_float::max_n_float_combine
CREATE FUNCTION "max_n_float_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_float_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:104
-- timescaledb_toolkit::nmost::max_float::max_n_float_deserialize
CREATE FUNCTION "max_n_float_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_float_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:110
-- timescaledb_toolkit::nmost::max_float::max_n_float_final
CREATE FUNCTION "max_n_float_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MaxFloats /* timescaledb_toolkit::nmost::max_float::MaxFloats */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_float_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:63
-- timescaledb_toolkit::nmost::max_float::max_n_float_rollup_trans
CREATE FUNCTION "max_n_float_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MaxFloats /* timescaledb_toolkit::nmost::max_float::MaxFloats */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_float_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:98
-- timescaledb_toolkit::nmost::max_float::max_n_float_serialize
CREATE FUNCTION "max_n_float_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_float_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:166
-- requires:
--   max_n_float_rollup_trans
--   max_n_float_final
--   max_n_float_combine
--   max_n_float_serialize
--   max_n_float_deserialize


CREATE AGGREGATE rollup(
value MaxFloats
) (

sfunc = max_n_float_rollup_trans,
stype = internal,
combinefunc = max_n_float_combine,
parallel = safe,
serialfunc = max_n_float_serialize,
deserialfunc = max_n_float_deserialize,
finalfunc = max_n_float_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:47
-- timescaledb_toolkit::nmost::max_float::max_n_float_trans
CREATE FUNCTION "max_n_float_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" double precision, /* f64 */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_float_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_float.rs:142
-- requires:
--   max_n_float_trans
--   max_n_float_final
--   max_n_float_combine
--   max_n_float_serialize
--   max_n_float_deserialize


CREATE AGGREGATE max_n(
value double precision, capacity bigint
) (

sfunc = max_n_float_trans,
stype = internal,
combinefunc = max_n_float_combine,
parallel = safe,
serialfunc = max_n_float_serialize,
deserialfunc = max_n_float_deserialize,
finalfunc = max_n_float_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:78
-- timescaledb_toolkit::nmost::max_int::max_n_int_combine
CREATE FUNCTION "max_n_int_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_int_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:98
-- timescaledb_toolkit::nmost::max_int::max_n_int_deserialize
CREATE FUNCTION "max_n_int_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_int_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:104
-- timescaledb_toolkit::nmost::max_int::max_n_int_final
CREATE FUNCTION "max_n_int_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MaxInts /* timescaledb_toolkit::nmost::max_int::MaxInts */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_int_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:62
-- timescaledb_toolkit::nmost::max_int::max_n_int_rollup_trans
CREATE FUNCTION "max_n_int_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MaxInts /* timescaledb_toolkit::nmost::max_int::MaxInts */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_int_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:92
-- timescaledb_toolkit::nmost::max_int::max_n_int_serialize
CREATE FUNCTION "max_n_int_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_int_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:160
-- requires:
--   max_n_int_rollup_trans
--   max_n_int_final
--   max_n_int_combine
--   max_n_int_serialize
--   max_n_int_deserialize


CREATE AGGREGATE rollup(
value MaxInts
) (

sfunc = max_n_int_rollup_trans,
stype = internal,
combinefunc = max_n_int_combine,
parallel = safe,
serialfunc = max_n_int_serialize,
deserialfunc = max_n_int_deserialize,
finalfunc = max_n_int_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:46
-- timescaledb_toolkit::nmost::max_int::max_n_int_trans
CREATE FUNCTION "max_n_int_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" bigint, /* i64 */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_int_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_int.rs:136
-- requires:
--   max_n_int_trans
--   max_n_int_final
--   max_n_int_combine
--   max_n_int_serialize
--   max_n_int_deserialize


CREATE AGGREGATE max_n(
value bigint, capacity bigint
) (

sfunc = max_n_int_trans,
stype = internal,
combinefunc = max_n_int_combine,
parallel = safe,
serialfunc = max_n_int_serialize,
deserialfunc = max_n_int_deserialize,
finalfunc = max_n_int_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:79
-- timescaledb_toolkit::nmost::max_time::max_n_time_combine
CREATE FUNCTION "max_n_time_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_time_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:99
-- timescaledb_toolkit::nmost::max_time::max_n_time_deserialize
CREATE FUNCTION "max_n_time_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_time_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:105
-- timescaledb_toolkit::nmost::max_time::max_n_time_final
CREATE FUNCTION "max_n_time_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MaxTimes /* timescaledb_toolkit::nmost::max_time::MaxTimes */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_time_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:62
-- timescaledb_toolkit::nmost::max_time::max_n_time_rollup_trans
CREATE FUNCTION "max_n_time_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MaxTimes /* timescaledb_toolkit::nmost::max_time::MaxTimes */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_time_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:93
-- timescaledb_toolkit::nmost::max_time::max_n_time_serialize
CREATE FUNCTION "max_n_time_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_time_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:170
-- requires:
--   max_n_time_rollup_trans
--   max_n_time_final
--   max_n_time_combine
--   max_n_time_serialize
--   max_n_time_deserialize


CREATE AGGREGATE rollup(
value MaxTimes
) (

sfunc = max_n_time_rollup_trans,
stype = internal,
combinefunc = max_n_time_combine,
parallel = safe,
serialfunc = max_n_time_serialize,
deserialfunc = max_n_time_deserialize,
finalfunc = max_n_time_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:46
-- timescaledb_toolkit::nmost::max_time::max_n_time_trans
CREATE OR REPLACE FUNCTION "max_n_time_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'max_n_time_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_time.rs:146
-- requires:
--   max_n_time_trans
--   max_n_time_final
--   max_n_time_combine
--   max_n_time_serialize
--   max_n_time_deserialize


CREATE OR REPLACE AGGREGATE max_n(
value timestamptz, capacity bigint
) (

sfunc = max_n_time_trans,
stype = internal,
combinefunc = max_n_time_combine,
parallel = safe,
serialfunc = max_n_time_serialize,
deserialfunc = max_n_time_deserialize,
finalfunc = max_n_time_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:63
-- timescaledb_toolkit::accessors::max_val
CREATE OR REPLACE FUNCTION "max_val"() RETURNS AccessorMaxVal /* timescaledb_toolkit::accessors::AccessorMaxVal */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_max_val_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:397
-- timescaledb_toolkit::tdigest::max_val
CREATE OR REPLACE FUNCTION "max_val"(
	"digest" TDigest /* timescaledb_toolkit::tdigest::TDigest */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_max_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:644
-- timescaledb_toolkit::frequency::mcv_agg_bigint_trans
CREATE OR REPLACE FUNCTION "mcv_agg_bigint_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"n" INT, /* i32 */
	"value" bigint /* core::option::Option<i64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'mcv_agg_bigint_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:654
-- timescaledb_toolkit::frequency::mcv_agg_text_trans
CREATE OR REPLACE FUNCTION "mcv_agg_text_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"n" INT, /* i32 */
	"value" text /* core::option::Option<timescaledb_toolkit::raw::text> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'mcv_agg_text_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:634
-- timescaledb_toolkit::frequency::mcv_agg_trans
CREATE OR REPLACE FUNCTION "mcv_agg_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"n" INT, /* i32 */
	"value" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'mcv_agg_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:683
-- timescaledb_toolkit::frequency::mcv_agg_with_skew_bigint_trans
CREATE OR REPLACE FUNCTION "mcv_agg_with_skew_bigint_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"n" INT, /* i32 */
	"skew" double precision, /* f64 */
	"value" bigint /* core::option::Option<i64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'mcv_agg_with_skew_bigint_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:709
-- timescaledb_toolkit::frequency::mcv_agg_with_skew_text_trans
CREATE OR REPLACE FUNCTION "mcv_agg_with_skew_text_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"n" INT, /* i32 */
	"skew" double precision, /* f64 */
	"value" text /* core::option::Option<timescaledb_toolkit::raw::text> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'mcv_agg_with_skew_text_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:664
-- timescaledb_toolkit::frequency::mcv_agg_with_skew_trans
CREATE OR REPLACE FUNCTION "mcv_agg_with_skew_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"n" INT, /* i32 */
	"skew" double precision, /* f64 */
	"value" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'mcv_agg_with_skew_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:60
-- timescaledb_toolkit::accessors::mean
CREATE OR REPLACE FUNCTION "mean"() RETURNS AccessorMean /* timescaledb_toolkit::accessors::AccessorMean */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_mean_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:410
-- timescaledb_toolkit::tdigest::mean
CREATE OR REPLACE FUNCTION "mean"(
	"digest" TDigest /* timescaledb_toolkit::tdigest::TDigest */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_mean_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:659
-- timescaledb_toolkit::uddsketch::mean
CREATE OR REPLACE FUNCTION "mean"(
	"sketch" UddSketch /* timescaledb_toolkit::uddsketch::UddSketch */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_mean_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:634
-- timescaledb_toolkit::accessors::min_frequency
CREATE FUNCTION "min_frequency"(
	"value" bigint /* i64 */
) RETURNS AccessorMinFrequencyInt /* timescaledb_toolkit::accessors::AccessorMinFrequencyInt */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_min_frequency_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1586
-- timescaledb_toolkit::frequency::min_frequency
CREATE FUNCTION "min_frequency"(
	"agg" SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
	"value" bigint /* i64 */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_bigint_frequency_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1554
-- timescaledb_toolkit::frequency::min_frequency
CREATE FUNCTION "min_frequency"(
	"agg" SpaceSavingAggregate, /* timescaledb_toolkit::frequency::SpaceSavingAggregate */
	"value" anyelement /* pgrx::datum::anyelement::AnyElement */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_frequency_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1620
-- timescaledb_toolkit::frequency::min_frequency
CREATE FUNCTION "min_frequency"(
	"agg" SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
	"value" text /* timescaledb_toolkit::raw::text */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_text_frequency_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_float.rs:87
-- timescaledb_toolkit::nmost::min_by_float::min_n_by_float_final
CREATE FUNCTION "min_n_by_float_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MinByFloats /* timescaledb_toolkit::nmost::min_by_float::MinByFloats */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_float_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_float.rs:121
-- requires:
--   max_n_by_float_rollup_trans
--   min_n_by_float_final


CREATE OR REPLACE AGGREGATE rollup(
MaxByFloats
) (

sfunc = max_n_by_float_rollup_trans,
stype = internal,
finalfunc = max_n_by_float_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_float.rs:64
-- timescaledb_toolkit::nmost::min_by_float::min_n_by_float_rollup_trans
CREATE FUNCTION "min_n_by_float_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MinByFloats /* timescaledb_toolkit::nmost::min_by_float::MinByFloats */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_float_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_float.rs:120
-- requires:
--   min_n_by_float_rollup_trans
--   min_n_by_float_final


CREATE OR REPLACE AGGREGATE rollup(
MinByFloats
) (

sfunc = min_n_by_float_rollup_trans,
stype = internal,
finalfunc = min_n_by_float_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_float.rs:46
-- timescaledb_toolkit::nmost::min_by_float::min_n_by_float_trans
CREATE FUNCTION "min_n_by_float_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" double precision, /* f64 */
	"data" anyelement, /* pgrx::datum::anyelement::AnyElement */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_float_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_float.rs:106
-- requires:
--   min_n_by_float_trans
--   min_n_by_float_final


CREATE AGGREGATE min_n_by(
value double precision, data AnyElement, capacity bigint
) (

sfunc = min_n_by_float_trans,
stype = internal,
finalfunc = min_n_by_float_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_int.rs:74
-- timescaledb_toolkit::nmost::min_by_int::min_n_by_int_final
CREATE FUNCTION "min_n_by_int_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MinByInts /* timescaledb_toolkit::nmost::min_by_int::MinByInts */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_int_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_int.rs:120
-- requires:
--   max_n_by_int_rollup_trans
--   min_n_by_int_final


CREATE OR REPLACE AGGREGATE rollup(
MaxByInts
) (

sfunc = max_n_by_int_rollup_trans,
stype = internal,
finalfunc = max_n_by_int_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_int.rs:58
-- timescaledb_toolkit::nmost::min_by_int::min_n_by_int_rollup_trans
CREATE FUNCTION "min_n_by_int_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MinByInts /* timescaledb_toolkit::nmost::min_by_int::MinByInts */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_int_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_int.rs:107
-- requires:
--   min_n_by_int_rollup_trans
--   min_n_by_int_final


CREATE OR REPLACE AGGREGATE rollup(
MinByInts
) (

sfunc = min_n_by_int_rollup_trans,
stype = internal,
finalfunc = min_n_by_int_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_int.rs:40
-- timescaledb_toolkit::nmost::min_by_int::min_n_by_int_trans
CREATE FUNCTION "min_n_by_int_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" bigint, /* i64 */
	"data" anyelement, /* pgrx::datum::anyelement::AnyElement */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_int_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_int.rs:93
-- requires:
--   min_n_by_int_trans
--   min_n_by_int_final


CREATE AGGREGATE min_n_by(
value bigint, data AnyElement, capacity bigint
) (

sfunc = min_n_by_int_trans,
stype = internal,
finalfunc = min_n_by_int_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_time.rs:74
-- timescaledb_toolkit::nmost::min_by_time::min_n_by_time_final
CREATE FUNCTION "min_n_by_time_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MinByTimes /* timescaledb_toolkit::nmost::min_by_time::MinByTimes */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_time_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/max_by_time.rs:127
-- requires:
--   max_n_by_time_rollup_trans
--   min_n_by_time_final


CREATE OR REPLACE AGGREGATE rollup(
MaxByTimes
) (

sfunc = max_n_by_time_rollup_trans,
stype = internal,
finalfunc = max_n_by_time_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_time.rs:58
-- timescaledb_toolkit::nmost::min_by_time::min_n_by_time_rollup_trans
CREATE FUNCTION "min_n_by_time_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MinByTimes /* timescaledb_toolkit::nmost::min_by_time::MinByTimes */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_time_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_time.rs:114
-- requires:
--   min_n_by_time_rollup_trans
--   min_n_by_time_final


CREATE OR REPLACE AGGREGATE rollup(
MinByTimes
) (

sfunc = min_n_by_time_rollup_trans,
stype = internal,
finalfunc = min_n_by_time_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_time.rs:40
-- timescaledb_toolkit::nmost::min_by_time::min_n_by_time_trans
CREATE OR REPLACE FUNCTION "min_n_by_time_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"data" anyelement, /* pgrx::datum::anyelement::AnyElement */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_by_time_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_by_time.rs:100
-- requires:
--   min_n_by_time_trans
--   min_n_by_time_final


CREATE OR REPLACE AGGREGATE min_n_by(
value timestamptz, data AnyElement, capacity bigint
) (

sfunc = min_n_by_time_trans,
stype = internal,
finalfunc = min_n_by_time_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:83
-- timescaledb_toolkit::nmost::min_float::min_n_float_combine
CREATE FUNCTION "min_n_float_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_float_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:103
-- timescaledb_toolkit::nmost::min_float::min_n_float_deserialize
CREATE FUNCTION "min_n_float_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_float_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:109
-- timescaledb_toolkit::nmost::min_float::min_n_float_final
CREATE FUNCTION "min_n_float_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MinFloats /* timescaledb_toolkit::nmost::min_float::MinFloats */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_float_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:62
-- timescaledb_toolkit::nmost::min_float::min_n_float_rollup_trans
CREATE FUNCTION "min_n_float_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MinFloats /* timescaledb_toolkit::nmost::min_float::MinFloats */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_float_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:97
-- timescaledb_toolkit::nmost::min_float::min_n_float_serialize
CREATE FUNCTION "min_n_float_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_float_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:165
-- requires:
--   min_n_float_rollup_trans
--   min_n_float_final
--   min_n_float_combine
--   min_n_float_serialize
--   min_n_float_deserialize


CREATE AGGREGATE rollup(
value MinFloats
) (

sfunc = min_n_float_rollup_trans,
stype = internal,
combinefunc = min_n_float_combine,
parallel = safe,
serialfunc = min_n_float_serialize,
deserialfunc = min_n_float_deserialize,
finalfunc = min_n_float_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:46
-- timescaledb_toolkit::nmost::min_float::min_n_float_trans
CREATE FUNCTION "min_n_float_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" double precision, /* f64 */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_float_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_float.rs:141
-- requires:
--   min_n_float_trans
--   min_n_float_final
--   min_n_float_combine
--   min_n_float_serialize
--   min_n_float_deserialize


CREATE AGGREGATE min_n(
value double precision, capacity bigint
) (

sfunc = min_n_float_trans,
stype = internal,
combinefunc = min_n_float_combine,
parallel = safe,
serialfunc = min_n_float_serialize,
deserialfunc = min_n_float_deserialize,
finalfunc = min_n_float_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:70
-- timescaledb_toolkit::nmost::min_int::min_n_int_combine
CREATE FUNCTION "min_n_int_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_int_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:90
-- timescaledb_toolkit::nmost::min_int::min_n_int_deserialize
CREATE FUNCTION "min_n_int_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_int_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:96
-- timescaledb_toolkit::nmost::min_int::min_n_int_final
CREATE FUNCTION "min_n_int_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MinInts /* timescaledb_toolkit::nmost::min_int::MinInts */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_int_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:55
-- timescaledb_toolkit::nmost::min_int::min_n_int_rollup_trans
CREATE FUNCTION "min_n_int_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MinInts /* timescaledb_toolkit::nmost::min_int::MinInts */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_int_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:84
-- timescaledb_toolkit::nmost::min_int::min_n_int_serialize
CREATE FUNCTION "min_n_int_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_int_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:152
-- requires:
--   min_n_int_rollup_trans
--   min_n_int_final
--   min_n_int_combine
--   min_n_int_serialize
--   min_n_int_deserialize


CREATE AGGREGATE rollup(
value MinInts
) (

sfunc = min_n_int_rollup_trans,
stype = internal,
combinefunc = min_n_int_combine,
parallel = safe,
serialfunc = min_n_int_serialize,
deserialfunc = min_n_int_deserialize,
finalfunc = min_n_int_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:39
-- timescaledb_toolkit::nmost::min_int::min_n_int_trans
CREATE FUNCTION "min_n_int_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" bigint, /* i64 */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_int_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_int.rs:128
-- requires:
--   min_n_int_trans
--   min_n_int_final
--   min_n_int_combine
--   min_n_int_serialize
--   min_n_int_deserialize


CREATE AGGREGATE min_n(
value bigint, capacity bigint
) (

sfunc = min_n_int_trans,
stype = internal,
combinefunc = min_n_int_combine,
parallel = safe,
serialfunc = min_n_int_serialize,
deserialfunc = min_n_int_deserialize,
finalfunc = min_n_int_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:70
-- timescaledb_toolkit::nmost::min_time::min_n_time_combine
CREATE FUNCTION "min_n_time_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_time_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:90
-- timescaledb_toolkit::nmost::min_time::min_n_time_deserialize
CREATE FUNCTION "min_n_time_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_time_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:96
-- timescaledb_toolkit::nmost::min_time::min_n_time_final
CREATE FUNCTION "min_n_time_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS MinTimes /* timescaledb_toolkit::nmost::min_time::MinTimes */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_time_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:55
-- timescaledb_toolkit::nmost::min_time::min_n_time_rollup_trans
CREATE FUNCTION "min_n_time_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" MinTimes /* timescaledb_toolkit::nmost::min_time::MinTimes */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_time_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:84
-- timescaledb_toolkit::nmost::min_time::min_n_time_serialize
CREATE FUNCTION "min_n_time_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_time_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:161
-- requires:
--   min_n_time_rollup_trans
--   min_n_time_final
--   min_n_time_combine
--   min_n_time_serialize
--   min_n_time_deserialize


CREATE AGGREGATE rollup(
value MinTimes
) (

sfunc = min_n_time_rollup_trans,
stype = internal,
combinefunc = min_n_time_combine,
parallel = safe,
serialfunc = min_n_time_serialize,
deserialfunc = min_n_time_deserialize,
finalfunc = min_n_time_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:39
-- timescaledb_toolkit::nmost::min_time::min_n_time_trans
CREATE OR REPLACE FUNCTION "min_n_time_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"capacity" bigint /* i64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'min_n_time_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/nmost/min_time.rs:137
-- requires:
--   min_n_time_trans
--   min_n_time_final
--   min_n_time_combine
--   min_n_time_serialize
--   min_n_time_deserialize


CREATE OR REPLACE AGGREGATE min_n(
value timestamptz, capacity bigint
) (

sfunc = min_n_time_trans,
stype = internal,
combinefunc = min_n_time_combine,
parallel = safe,
serialfunc = min_n_time_serialize,
deserialfunc = min_n_time_deserialize,
finalfunc = min_n_time_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:62
-- timescaledb_toolkit::accessors::min_val
CREATE OR REPLACE FUNCTION "min_val"() RETURNS AccessorMinVal /* timescaledb_toolkit::accessors::AccessorMinVal */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_min_val_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:385
-- timescaledb_toolkit::tdigest::min_val
CREATE OR REPLACE FUNCTION "min_val"(
	"digest" TDigest /* timescaledb_toolkit::tdigest::TDigest */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_min_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:85
-- timescaledb_toolkit::accessors::num_changes
CREATE OR REPLACE FUNCTION "num_changes"() RETURNS AccessorNumChanges /* timescaledb_toolkit::accessors::AccessorNumChanges */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_num_changes_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:751
-- timescaledb_toolkit::counter_agg::num_changes
CREATE OR REPLACE FUNCTION "num_changes"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_num_changes_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:84
-- timescaledb_toolkit::accessors::num_elements
CREATE OR REPLACE FUNCTION "num_elements"() RETURNS AccessorNumElements /* timescaledb_toolkit::accessors::AccessorNumElements */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_num_elements_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:737
-- timescaledb_toolkit::counter_agg::num_elements
CREATE OR REPLACE FUNCTION "num_elements"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_num_elements_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:110
-- timescaledb_toolkit::accessors::num_gaps
CREATE FUNCTION "num_gaps"() RETURNS AccessorNumGaps /* timescaledb_toolkit::accessors::AccessorNumGaps */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_num_gaps_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:528
-- timescaledb_toolkit::heartbeat_agg::num_gaps
CREATE FUNCTION "num_gaps"(
	"agg" HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
) RETURNS bigint /* i64 */

STRICT
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'num_gaps_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:109
-- timescaledb_toolkit::accessors::num_live_ranges
CREATE FUNCTION "num_live_ranges"() RETURNS AccessorNumLiveRanges /* timescaledb_toolkit::accessors::AccessorNumLiveRanges */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_num_live_ranges_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:514
-- timescaledb_toolkit::heartbeat_agg::num_live_ranges
CREATE FUNCTION "num_live_ranges"(
	"agg" HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
) RETURNS bigint /* i64 */

STRICT
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'num_live_ranges_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:86
-- timescaledb_toolkit::accessors::num_resets
CREATE OR REPLACE FUNCTION "num_resets"() RETURNS AccessorNumResets /* timescaledb_toolkit::accessors::AccessorNumResets */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_num_resets_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:765
-- timescaledb_toolkit::counter_agg::num_resets
CREATE OR REPLACE FUNCTION "num_resets"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_num_resets_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:59
-- timescaledb_toolkit::accessors::num_vals
CREATE OR REPLACE FUNCTION "num_vals"() RETURNS AccessorNumVals /* timescaledb_toolkit::accessors::AccessorNumVals */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_num_vals_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1058
-- timescaledb_toolkit::stats_agg::num_vals
CREATE OR REPLACE FUNCTION "num_vals"(
	"summary" StatsSummary1D /* timescaledb_toolkit::stats_agg::StatsSummary1D */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_num_vals_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1296
-- timescaledb_toolkit::stats_agg::num_vals
CREATE OR REPLACE FUNCTION "num_vals"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_num_vals_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:373
-- timescaledb_toolkit::tdigest::num_vals
CREATE OR REPLACE FUNCTION "num_vals"(
	"digest" TDigest /* timescaledb_toolkit::tdigest::TDigest */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_count_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:646
-- timescaledb_toolkit::uddsketch::num_vals
CREATE OR REPLACE FUNCTION "num_vals"(
	"sketch" UddSketch /* timescaledb_toolkit::uddsketch::UddSketch */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_num_vals_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:92
-- timescaledb_toolkit::accessors::open
CREATE FUNCTION "open"() RETURNS AccessorOpen /* timescaledb_toolkit::accessors::AccessorOpen */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_open_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:408
-- timescaledb_toolkit::candlestick::open
CREATE FUNCTION "open"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'open_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:96
-- timescaledb_toolkit::accessors::open_time
CREATE FUNCTION "open_time"() RETURNS AccessorOpenTime /* timescaledb_toolkit::accessors::AccessorOpenTime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_open_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:461
-- timescaledb_toolkit::candlestick::open_time
CREATE FUNCTION "open_time"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'open_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:59
-- timescaledb_toolkit::uddsketch::percentile_agg_trans
CREATE OR REPLACE FUNCTION "percentile_agg_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'percentile_agg_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:79
-- timescaledb_toolkit::accessors::rate
CREATE OR REPLACE FUNCTION "rate"() RETURNS AccessorRate /* timescaledb_toolkit::accessors::AccessorRate */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_rate_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:495
-- timescaledb_toolkit::counter_agg::rate
CREATE OR REPLACE FUNCTION "rate"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_rate_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:849
-- timescaledb_toolkit::frequency::rollup_agg_bigint_trans
CREATE FUNCTION "rollup_agg_bigint_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" SpaceSavingBigIntAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'rollup_agg_bigint_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:879
-- timescaledb_toolkit::frequency::rollup_agg_text_trans
CREATE FUNCTION "rollup_agg_text_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" SpaceSavingTextAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingTextAggregate> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'rollup_agg_text_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:819
-- timescaledb_toolkit::frequency::rollup_agg_trans
CREATE FUNCTION "rollup_agg_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" SpaceSavingAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingAggregate> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'rollup_agg_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:288
-- timescaledb_toolkit::accessors::skewness
CREATE OR REPLACE FUNCTION "skewness"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorSkewness /* timescaledb_toolkit::accessors::AccessorSkewness */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_skewness_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1017
-- timescaledb_toolkit::stats_agg::skewness
CREATE OR REPLACE FUNCTION "skewness"(
	"summary" StatsSummary1D, /* timescaledb_toolkit::stats_agg::StatsSummary1D */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_skewness_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:311
-- timescaledb_toolkit::accessors::skewness_x
CREATE OR REPLACE FUNCTION "skewness_x"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorSkewnessX /* timescaledb_toolkit::accessors::AccessorSkewnessX */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_skewness_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1213
-- timescaledb_toolkit::stats_agg::skewness_x
CREATE OR REPLACE FUNCTION "skewness_x"(
	"summary" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_skewness_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:334
-- timescaledb_toolkit::accessors::skewness_y
CREATE OR REPLACE FUNCTION "skewness_y"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorSkewnessY /* timescaledb_toolkit::accessors::AccessorSkewnessY */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_skewness_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1234
-- timescaledb_toolkit::stats_agg::skewness_y
CREATE OR REPLACE FUNCTION "skewness_y"(
	"summary" StatsSummary2D, /* timescaledb_toolkit::stats_agg::StatsSummary2D */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_skewness_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:70
-- timescaledb_toolkit::accessors::slope
CREATE OR REPLACE FUNCTION "slope"() RETURNS AccessorSlope /* timescaledb_toolkit::accessors::AccessorSlope */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_slope_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:779
-- timescaledb_toolkit::counter_agg::slope
CREATE OR REPLACE FUNCTION "slope"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_slope_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1310
-- timescaledb_toolkit::stats_agg::slope
CREATE OR REPLACE FUNCTION "slope"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_slope_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:941
-- timescaledb_toolkit::frequency::space_saving_bigint_final
CREATE FUNCTION "space_saving_bigint_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS SpaceSavingBigIntAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'space_saving_bigint_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:909
-- timescaledb_toolkit::frequency::space_saving_combine
CREATE FUNCTION "space_saving_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'space_saving_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:965
-- timescaledb_toolkit::frequency::space_saving_deserialize
CREATE FUNCTION "space_saving_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'space_saving_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:932
-- timescaledb_toolkit::frequency::space_saving_final
CREATE FUNCTION "space_saving_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS SpaceSavingAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingAggregate> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'space_saving_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:959
-- timescaledb_toolkit::frequency::space_saving_serialize
CREATE FUNCTION "space_saving_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'space_saving_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1067
-- requires:
--   mcv_agg_bigint_trans
--   space_saving_bigint_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE OR REPLACE AGGREGATE mcv_agg(
count integer, value INT8
) (

sfunc = mcv_agg_bigint_trans,
stype = internal,
finalfunc = space_saving_bigint_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1115
-- requires:
--   mcv_agg_with_skew_trans
--   space_saving_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE raw_mcv_agg(
count integer, skew double precision, value AnyElement
) (

sfunc = mcv_agg_with_skew_trans,
stype = internal,
finalfunc = space_saving_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1187
-- requires:
--   rollup_agg_trans
--   space_saving_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE rollup(
agg SpaceSavingAggregate
) (

sfunc = rollup_agg_trans,
stype = internal,
finalfunc = space_saving_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1211
-- requires:
--   rollup_agg_bigint_trans
--   space_saving_bigint_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE rollup(
agg SpaceSavingBigIntAggregate
) (

sfunc = rollup_agg_bigint_trans,
stype = internal,
finalfunc = space_saving_bigint_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1139
-- requires:
--   mcv_agg_with_skew_bigint_trans
--   space_saving_bigint_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE OR REPLACE AGGREGATE mcv_agg(
count integer, skew double precision, value int8
) (

sfunc = mcv_agg_with_skew_bigint_trans,
stype = internal,
finalfunc = space_saving_bigint_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1043
-- requires:
--   mcv_agg_trans
--   space_saving_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE raw_mcv_agg(
count integer, value AnyElement
) (

sfunc = mcv_agg_trans,
stype = internal,
finalfunc = space_saving_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:950
-- timescaledb_toolkit::frequency::space_saving_text_final
CREATE FUNCTION "space_saving_text_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS SpaceSavingTextAggregate /* core::option::Option<timescaledb_toolkit::frequency::SpaceSavingTextAggregate> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'space_saving_text_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1091
-- requires:
--   mcv_agg_text_trans
--   space_saving_text_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE mcv_agg(
count integer, value TEXT
) (

sfunc = mcv_agg_text_trans,
stype = internal,
finalfunc = space_saving_text_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1235
-- requires:
--   rollup_agg_text_trans
--   space_saving_text_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE rollup(
agg SpaceSavingTextAggregate
) (

sfunc = rollup_agg_text_trans,
stype = internal,
finalfunc = space_saving_text_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1163
-- requires:
--   mcv_agg_with_skew_text_trans
--   space_saving_text_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE mcv_agg(
count integer, skew double precision, value text
) (

sfunc = mcv_agg_with_skew_text_trans,
stype = internal,
finalfunc = space_saving_text_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:574
-- timescaledb_toolkit::state_aggregate::state_agg::state_agg_combine_fn_outer
CREATE FUNCTION "state_agg_combine_fn_outer"(
	"a" internal, /* pgrx::datum::internal::Internal */
	"b" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_combine_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:574
-- timescaledb_toolkit::state_aggregate::state_agg::state_agg_deserialize_fn_outer
CREATE FUNCTION "state_agg_deserialize_fn_outer"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_deserialize_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:574
-- timescaledb_toolkit::state_aggregate::state_agg::state_agg_finally_fn_outer
CREATE FUNCTION "state_agg_finally_fn_outer"(
	"__internal" internal /* pgrx::datum::internal::Internal */
) RETURNS StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_finally_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:667
-- timescaledb_toolkit::state_aggregate::state_agg_int_trans
CREATE OR REPLACE FUNCTION "state_agg_int_trans"(
	"__inner" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" bigint /* core::option::Option<i64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_int_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:394
-- timescaledb_toolkit::state_aggregate::rollup::state_agg_rollup_combine
CREATE FUNCTION "state_agg_rollup_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_rollup_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:385
-- timescaledb_toolkit::state_aggregate::rollup::state_agg_rollup_deserialize
CREATE FUNCTION "state_agg_rollup_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_rollup_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:352
-- timescaledb_toolkit::state_aggregate::rollup::state_agg_rollup_final
CREATE FUNCTION "state_agg_rollup_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_rollup_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:378
-- timescaledb_toolkit::state_aggregate::rollup::state_agg_rollup_serialize
CREATE FUNCTION "state_agg_rollup_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_rollup_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:312
-- timescaledb_toolkit::state_aggregate::rollup::state_agg_rollup_trans
CREATE FUNCTION "state_agg_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"next" StateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::StateAgg> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:30
-- requires:
--   state_agg_rollup_trans
--   state_agg_rollup_final
--   state_agg_rollup_combine
--   state_agg_rollup_serialize
--   state_agg_rollup_deserialize
--   StateAgg

CREATE AGGREGATE rollup(
        value StateAgg
    ) (

        sfunc = state_agg_rollup_trans,
        stype = internal,
        finalfunc = state_agg_rollup_final,
        combinefunc = state_agg_rollup_combine,
        serialfunc = state_agg_rollup_serialize,
        deserialfunc = state_agg_rollup_deserialize,
        parallel = restricted
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:574
-- timescaledb_toolkit::state_aggregate::state_agg::state_agg_serialize_fn_outer
CREATE FUNCTION "state_agg_serialize_fn_outer"(
	"__internal" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_serialize_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:645
-- requires:
--   state_agg_int_trans
--   state_agg_finally_fn_outer
--   state_agg_serialize_fn_outer
--   state_agg_deserialize_fn_outer
--   state_agg_combine_fn_outer

CREATE OR REPLACE AGGREGATE state_agg(
        ts timestamptz,
        value bigint
    ) (

        stype = internal,
        sfunc = state_agg_int_trans,
        finalfunc = state_agg_finally_fn_outer,
        parallel = safe,
        serialfunc = state_agg_serialize_fn_outer,
        deserialfunc = state_agg_deserialize_fn_outer,
        combinefunc = state_agg_combine_fn_outer
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:574
-- timescaledb_toolkit::state_aggregate::state_agg::state_agg_transition_fn_outer
CREATE OR REPLACE FUNCTION "state_agg_transition_fn_outer"(
	"__inner" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" TEXT /* core::option::Option<alloc::string::String> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_agg_transition_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:574
-- requires:
--   state_agg_transition_fn_outer
--   state_agg_finally_fn_outer
--   state_agg_serialize_fn_outer
--   state_agg_deserialize_fn_outer
--   state_agg_combine_fn_outer


CREATE OR REPLACE AGGREGATE state_agg (ts timestamptz, value text) (
    stype = internal,
    sfunc = state_agg_transition_fn_outer,
    finalfunc = state_agg_finally_fn_outer,
    parallel = safe,
    serialfunc = state_agg_serialize_fn_outer,
    deserialfunc = state_agg_deserialize_fn_outer,
    combinefunc = state_agg_combine_fn_outer
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:312
-- timescaledb_toolkit::state_aggregate::accessors::state_at
CREATE OR REPLACE FUNCTION "state_at"(
	"time" TimestampTz /* timescaledb_toolkit::raw::TimestampTz */
) RETURNS AccessorStateAt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStateAt */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_state_at_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1752
-- timescaledb_toolkit::state_aggregate::state_at
CREATE OR REPLACE FUNCTION "state_at"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"point" TimestampTz /* timescaledb_toolkit::raw::TimestampTz */
) RETURNS TEXT /* core::option::Option<alloc::string::String> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_at_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:328
-- timescaledb_toolkit::state_aggregate::accessors::state_at_int
CREATE OR REPLACE FUNCTION "state_at_int"(
	"time" TimestampTz /* timescaledb_toolkit::raw::TimestampTz */
) RETURNS AccessorStateAtInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStateAtInt */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_state_at_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1758
-- timescaledb_toolkit::state_aggregate::state_at_int
CREATE OR REPLACE FUNCTION "state_at_int"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"point" TimestampTz /* timescaledb_toolkit::raw::TimestampTz */
) RETURNS bigint /* core::option::Option<i64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_at_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:108
-- timescaledb_toolkit::accessors::state_int_timeline
CREATE FUNCTION "state_int_timeline"() RETURNS AccessorStateIntTimeline /* timescaledb_toolkit::accessors::AccessorStateIntTimeline */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_int_timeline_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1316
-- timescaledb_toolkit::state_aggregate::state_int_timeline
CREATE FUNCTION "state_int_timeline"(
	"agg" StateAgg /* timescaledb_toolkit::state_aggregate::StateAgg */
) RETURNS TABLE (

	"state" bigint,  /* i64 */
	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_int_timeline_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:231
-- timescaledb_toolkit::state_aggregate::accessors::state_periods
CREATE FUNCTION "state_periods"(
	"state" TEXT /* alloc::string::String */
) RETURNS AccessorStatePeriods /* timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriods */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_state_periods_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/accessors.rs:240
-- timescaledb_toolkit::state_aggregate::accessors::state_periods
CREATE FUNCTION "state_periods"(
	"state" bigint /* i64 */
) RETURNS AccessorStatePeriodsInt /* timescaledb_toolkit::state_aggregate::accessors::AccessorStatePeriodsInt */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_agg_state_periods_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1554
-- timescaledb_toolkit::state_aggregate::state_periods
CREATE FUNCTION "state_periods"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"state" bigint /* i64 */
) RETURNS TABLE (

	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_int_periods_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1539
-- timescaledb_toolkit::state_aggregate::state_periods
CREATE FUNCTION "state_periods"(
	"agg" StateAgg, /* timescaledb_toolkit::state_aggregate::StateAgg */
	"state" TEXT /* alloc::string::String */
) RETURNS TABLE (

	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_periods_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:107
-- timescaledb_toolkit::accessors::state_timeline
CREATE FUNCTION "state_timeline"() RETURNS AccessorStateTimeline /* timescaledb_toolkit::accessors::AccessorStateTimeline */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_state_timeline_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1302
-- timescaledb_toolkit::state_aggregate::state_timeline
CREATE FUNCTION "state_timeline"(
	"agg" StateAgg /* timescaledb_toolkit::state_aggregate::StateAgg */
) RETURNS TABLE (

	"state" TEXT,  /* alloc::string::String */
	"start_time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"end_time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'state_timeline_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:540
-- timescaledb_toolkit::stats_agg::stats1d_combine
CREATE OR REPLACE FUNCTION "stats1d_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:608
-- timescaledb_toolkit::stats_agg::stats1d_final
CREATE OR REPLACE FUNCTION "stats1d_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS StatsSummary1D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:305
-- timescaledb_toolkit::stats_agg::stats1d_inv_trans
CREATE OR REPLACE FUNCTION "stats1d_inv_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"val" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_inv_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:486
-- timescaledb_toolkit::stats_agg::stats1d_summary_inv_trans
CREATE OR REPLACE FUNCTION "stats1d_summary_inv_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" StatsSummary1D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_summary_inv_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:430
-- timescaledb_toolkit::stats_agg::stats1d_summary_trans
CREATE OR REPLACE FUNCTION "stats1d_summary_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" StatsSummary1D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_summary_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:624
-- timescaledb_toolkit::stats_agg::stats1d_tf_final
CREATE FUNCTION "stats1d_tf_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS StatsSummary1D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_tf_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:331
-- timescaledb_toolkit::stats_agg::stats1d_tf_inv_trans
CREATE FUNCTION "stats1d_tf_inv_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"val" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_tf_inv_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:151
-- timescaledb_toolkit::stats_agg::stats1d_tf_trans
CREATE FUNCTION "stats1d_tf_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"val" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_tf_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:709
-- requires:
--   stats1d_tf_trans
--   stats1d_tf_final
--   stats1d_tf_trans
--   stats1d_tf_inv_trans
--   stats1d_tf_final

CREATE AGGREGATE toolkit_experimental.stats_agg_tf( value DOUBLE PRECISION )
(
sfunc = stats1d_tf_trans,
stype = internal,
finalfunc = stats1d_tf_final,
msfunc = stats1d_tf_trans,
minvfunc = stats1d_tf_inv_trans,
mstype = internal,
mfinalfunc = stats1d_tf_final,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:143
-- timescaledb_toolkit::stats_agg::stats1d_trans
CREATE OR REPLACE FUNCTION "stats1d_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"val" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:118
-- timescaledb_toolkit::stats_agg::stats1d_trans_deserialize
CREATE OR REPLACE FUNCTION "stats1d_trans_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_trans_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:111
-- timescaledb_toolkit::stats_agg::stats1d_trans_serialize
CREATE OR REPLACE FUNCTION "stats1d_trans_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_trans_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:831
-- requires:
--   stats1d_summary_trans
--   stats1d_final
--   stats1d_combine
--   stats1d_trans_serialize
--   stats1d_trans_deserialize


CREATE OR REPLACE AGGREGATE rollup(ss statssummary1d)
(
sfunc = stats1d_summary_trans,
stype = internal,
finalfunc = stats1d_final,
combinefunc = stats1d_combine,
serialfunc = stats1d_trans_serialize,
deserialfunc = stats1d_trans_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:679
-- requires:
--   stats1d_trans
--   stats1d_final
--   stats1d_combine
--   stats1d_trans_serialize
--   stats1d_trans_deserialize
--   stats1d_trans
--   stats1d_inv_trans
--   stats1d_final


CREATE OR REPLACE AGGREGATE stats_agg( value DOUBLE PRECISION )
(
sfunc = stats1d_trans,
stype = internal,
finalfunc = stats1d_final,
combinefunc = stats1d_combine,
serialfunc = stats1d_trans_serialize,
deserialfunc = stats1d_trans_deserialize,
msfunc = stats1d_tf_trans,
minvfunc = stats1d_tf_inv_trans,
mstype = internal,
mfinalfunc = stats1d_tf_final,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:855
-- requires:
--   stats1d_summary_trans
--   stats1d_final
--   stats1d_combine
--   stats1d_trans_serialize
--   stats1d_trans_deserialize
--   stats1d_summary_inv_trans


CREATE OR REPLACE AGGREGATE rolling(ss statssummary1d)
(
sfunc = stats1d_summary_trans,
stype = internal,
finalfunc = stats1d_final,
combinefunc = stats1d_combine,
serialfunc = stats1d_trans_serialize,
deserialfunc = stats1d_trans_deserialize,
msfunc = stats1d_summary_trans,
minvfunc = stats1d_summary_inv_trans,
mstype = internal,
mfinalfunc = stats1d_final,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:732
-- requires:
--   stats1d_trans
--   stats1d_final
--   stats1d_combine
--   stats1d_trans_serialize
--   stats1d_trans_deserialize


CREATE OR REPLACE AGGREGATE stats_agg_no_inv( value DOUBLE PRECISION )
(
sfunc = stats1d_trans,
stype = internal,
finalfunc = stats1d_final,
combinefunc = stats1d_combine,
serialfunc = stats1d_trans_serialize,
deserialfunc = stats1d_trans_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:574
-- timescaledb_toolkit::stats_agg::stats2d_combine
CREATE OR REPLACE FUNCTION "stats2d_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:644
-- timescaledb_toolkit::stats_agg::stats2d_final
CREATE OR REPLACE FUNCTION "stats2d_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS StatsSummary2D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:357
-- timescaledb_toolkit::stats_agg::stats2d_inv_trans
CREATE OR REPLACE FUNCTION "stats2d_inv_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"y" double precision, /* core::option::Option<f64> */
	"x" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_inv_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:513
-- timescaledb_toolkit::stats_agg::stats2d_summary_inv_trans
CREATE OR REPLACE FUNCTION "stats2d_summary_inv_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" StatsSummary2D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_summary_inv_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:458
-- timescaledb_toolkit::stats_agg::stats2d_summary_trans
CREATE OR REPLACE FUNCTION "stats2d_summary_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" StatsSummary2D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_summary_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:660
-- timescaledb_toolkit::stats_agg::stats2d_tf_final
CREATE FUNCTION "stats2d_tf_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS StatsSummary2D /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_tf_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:392
-- timescaledb_toolkit::stats_agg::stats2d_tf_inv_trans
CREATE FUNCTION "stats2d_tf_inv_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"y" double precision, /* core::option::Option<f64> */
	"x" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_tf_inv_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:258
-- timescaledb_toolkit::stats_agg::stats2d_tf_trans
CREATE FUNCTION "stats2d_tf_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"y" double precision, /* core::option::Option<f64> */
	"x" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_tf_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:786
-- requires:
--   stats2d_tf_trans
--   stats2d_tf_inv_trans
--   stats2d_tf_final


CREATE AGGREGATE toolkit_experimental.stats_agg_tf( y DOUBLE PRECISION, x DOUBLE PRECISION )
(
sfunc = stats2d_tf_trans,
stype = internal,
finalfunc = stats2d_tf_final,
msfunc = stats2d_tf_trans,
minvfunc = stats2d_tf_inv_trans,
mstype = internal,
mfinalfunc = stats2d_tf_final,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:214
-- timescaledb_toolkit::stats_agg::stats2d_trans
CREATE OR REPLACE FUNCTION "stats2d_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"y" double precision, /* core::option::Option<f64> */
	"x" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:134
-- timescaledb_toolkit::stats_agg::stats2d_trans_deserialize
CREATE OR REPLACE FUNCTION "stats2d_trans_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_trans_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:127
-- timescaledb_toolkit::stats_agg::stats2d_trans_serialize
CREATE OR REPLACE FUNCTION "stats2d_trans_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_trans_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:805
-- requires:
--   stats2d_trans
--   stats2d_final
--   stats2d_combine
--   stats2d_trans_serialize
--   stats2d_trans_deserialize


CREATE OR REPLACE AGGREGATE stats_agg_no_inv( y DOUBLE PRECISION, x DOUBLE PRECISION )
(
sfunc = stats2d_trans,
stype = internal,
finalfunc = stats2d_final,
combinefunc = stats2d_combine,
serialfunc = stats2d_trans_serialize,
deserialfunc = stats2d_trans_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:885
-- requires:
--   stats2d_summary_trans
--   stats2d_final
--   stats2d_combine
--   stats2d_trans_serialize
--   stats2d_trans_deserialize


CREATE OR REPLACE AGGREGATE rollup(ss statssummary2d)
(
sfunc = stats2d_summary_trans,
stype = internal,
finalfunc = stats2d_final,
combinefunc = stats2d_combine,
serialfunc = stats2d_trans_serialize,
deserialfunc = stats2d_trans_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:909
-- requires:
--   stats2d_summary_trans
--   stats2d_final
--   stats2d_combine
--   stats2d_trans_serialize
--   stats2d_trans_deserialize
--   stats2d_summary_inv_trans


CREATE OR REPLACE AGGREGATE rolling(ss statssummary2d)
(
sfunc = stats2d_summary_trans,
stype = internal,
finalfunc = stats2d_final,
combinefunc = stats2d_combine,
serialfunc = stats2d_trans_serialize,
deserialfunc = stats2d_trans_deserialize,
msfunc = stats2d_summary_trans,
minvfunc = stats2d_summary_inv_trans,
mstype = internal,
mfinalfunc = stats2d_final,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:756
-- requires:
--   stats2d_trans
--   stats2d_final
--   stats2d_combine
--   stats2d_trans_serialize
--   stats2d_trans_deserialize
--   stats2d_tf_trans
--   stats2d_tf_inv_trans
--   stats2d_tf_final


CREATE OR REPLACE AGGREGATE stats_agg( y DOUBLE PRECISION, x DOUBLE PRECISION )
(
sfunc = stats2d_trans,
stype = internal,
finalfunc = stats2d_final,
combinefunc = stats2d_combine,
serialfunc = stats2d_trans_serialize,
deserialfunc = stats2d_trans_deserialize,
msfunc = stats2d_tf_trans,
minvfunc = stats2d_tf_inv_trans,
mstype = internal,
mfinalfunc = stats2d_tf_final,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:145
-- timescaledb_toolkit::accessors::stddev
CREATE OR REPLACE FUNCTION "stddev"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorStdDev /* timescaledb_toolkit::accessors::AccessorStdDev */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_stddev_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:975
-- timescaledb_toolkit::stats_agg::stddev
CREATE OR REPLACE FUNCTION "stddev"(
	"summary" StatsSummary1D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_stddev_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:169
-- timescaledb_toolkit::accessors::stddev_x
CREATE OR REPLACE FUNCTION "stddev_x"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorStdDevX /* timescaledb_toolkit::accessors::AccessorStdDevX */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_stddev_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1129
-- timescaledb_toolkit::stats_agg::stddev_x
CREATE OR REPLACE FUNCTION "stddev_x"(
	"summary" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_stddev_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:193
-- timescaledb_toolkit::accessors::stddev_y
CREATE OR REPLACE FUNCTION "stddev_y"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorStdDevY /* timescaledb_toolkit::accessors::AccessorStdDevY */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_stddev_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1150
-- timescaledb_toolkit::stats_agg::stddev_y
CREATE OR REPLACE FUNCTION "stddev_y"(
	"summary" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_stddev_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:76
-- timescaledb_toolkit::accessors::stderror
CREATE OR REPLACE FUNCTION "stderror"() RETURNS AccessorStderror /* timescaledb_toolkit::accessors::AccessorStderror */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_stderror_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/hyperloglog.rs:382
-- timescaledb_toolkit::hyperloglog::stderror
CREATE OR REPLACE FUNCTION "stderror"(
	"hyperloglog" HyperLogLog /* timescaledb_toolkit::hyperloglog::HyperLogLog */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'hyperloglog_error_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:67
-- timescaledb_toolkit::accessors::sum
CREATE OR REPLACE FUNCTION "sum"() RETURNS AccessorSum /* timescaledb_toolkit::accessors::AccessorSum */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_sum_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:960
-- timescaledb_toolkit::stats_agg::sum
CREATE OR REPLACE FUNCTION "sum"(
	"summary" StatsSummary1D /* timescaledb_toolkit::stats_agg::StatsSummary1D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_sum_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:68
-- timescaledb_toolkit::accessors::sum_x
CREATE OR REPLACE FUNCTION "sum_x"() RETURNS AccessorSumX /* timescaledb_toolkit::accessors::AccessorSumX */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_sum_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1100
-- timescaledb_toolkit::stats_agg::sum_x
CREATE OR REPLACE FUNCTION "sum_x"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_sum_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:69
-- timescaledb_toolkit::accessors::sum_y
CREATE OR REPLACE FUNCTION "sum_y"() RETURNS AccessorSumY /* timescaledb_toolkit::accessors::AccessorSumY */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_sum_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1114
-- timescaledb_toolkit::stats_agg::sum_y
CREATE OR REPLACE FUNCTION "sum_y"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_sum_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:59
-- timescaledb_toolkit::tdigest::tdigest_combine
CREATE OR REPLACE FUNCTION "tdigest_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:252
-- timescaledb_toolkit::tdigest::tdigest_compound_combine
CREATE OR REPLACE FUNCTION "tdigest_compound_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_compound_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:302
-- timescaledb_toolkit::tdigest::tdigest_compound_deserialize
CREATE OR REPLACE FUNCTION "tdigest_compound_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_compound_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:287
-- timescaledb_toolkit::tdigest::tdigest_compound_final
CREATE OR REPLACE FUNCTION "tdigest_compound_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS TDigest /* core::option::Option<timescaledb_toolkit::tdigest::TDigest> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_compound_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:296
-- timescaledb_toolkit::tdigest::tdigest_compound_serialize
CREATE OR REPLACE FUNCTION "tdigest_compound_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_compound_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:220
-- timescaledb_toolkit::tdigest::tdigest_compound_trans
CREATE OR REPLACE FUNCTION "tdigest_compound_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" TDigest /* core::option::Option<timescaledb_toolkit::tdigest::TDigest> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_compound_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:308
-- requires:
--   tdigest_compound_trans
--   tdigest_compound_final
--   tdigest_compound_combine
--   tdigest_compound_serialize
--   tdigest_compound_deserialize


CREATE OR REPLACE AGGREGATE rollup(
tdigest
) (

sfunc = tdigest_compound_trans,
stype = internal,
finalfunc = tdigest_compound_final,
combinefunc = tdigest_compound_combine,
serialfunc = tdigest_compound_serialize,
deserialfunc = tdigest_compound_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:98
-- timescaledb_toolkit::tdigest::tdigest_deserialize
CREATE OR REPLACE FUNCTION "tdigest_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:184
-- timescaledb_toolkit::tdigest::tdigest_final
CREATE OR REPLACE FUNCTION "tdigest_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS TDigest /* core::option::Option<timescaledb_toolkit::tdigest::TDigest> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:89
-- timescaledb_toolkit::tdigest::tdigest_serialize
CREATE OR REPLACE FUNCTION "tdigest_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:20
-- timescaledb_toolkit::tdigest::tdigest_trans
CREATE OR REPLACE FUNCTION "tdigest_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"size" INT, /* i32 */
	"value" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tdigest_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/tdigest.rs:197
-- requires:
--   tdigest_trans
--   tdigest_final
--   tdigest_combine
--   tdigest_serialize
--   tdigest_deserialize


CREATE OR REPLACE AGGREGATE tdigest(size integer, value DOUBLE PRECISION)
(
sfunc = tdigest_trans,
stype = internal,
finalfunc = tdigest_final,
combinefunc = tdigest_combine,
serialfunc = tdigest_serialize,
deserialfunc = tdigest_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:208
-- timescaledb_toolkit::candlestick::tick_data_no_vol_transition
CREATE OR REPLACE FUNCTION "tick_data_no_vol_transition"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"price" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tick_data_no_vol_transition_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:218
-- timescaledb_toolkit::candlestick::tick_data_transition
CREATE OR REPLACE FUNCTION "tick_data_transition"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"price" double precision, /* core::option::Option<f64> */
	"volume" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'tick_data_transition_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:351
-- requires:
--   tick_data_transition
--   candlestick_final
--   candlestick_combine
--   candlestick_serialize
--   candlestick_deserialize


CREATE OR REPLACE AGGREGATE candlestick_agg( 
ts TIMESTAMPTZ,
price DOUBLE PRECISION,
volume DOUBLE PRECISION
)

(
sfunc = tick_data_transition,
stype = internal,
finalfunc = candlestick_final,
combinefunc = candlestick_combine,
serialfunc = candlestick_serialize,
deserialfunc = candlestick_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:78
-- timescaledb_toolkit::accessors::time_delta
CREATE OR REPLACE FUNCTION "time_delta"() RETURNS AccessorTimeDelta /* timescaledb_toolkit::accessors::AccessorTimeDelta */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_time_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:509
-- timescaledb_toolkit::counter_agg::time_delta
CREATE OR REPLACE FUNCTION "time_delta"(
	"summary" CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_time_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:263
-- timescaledb_toolkit::time_weighted_average::time_weight_combine
CREATE OR REPLACE FUNCTION "time_weight_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:304
-- timescaledb_toolkit::time_weighted_average::time_weight_final
CREATE OR REPLACE FUNCTION "time_weight_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS TimeWeightSummary /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:224
-- timescaledb_toolkit::time_weighted_average::time_weight_summary_trans
CREATE OR REPLACE FUNCTION "time_weight_summary_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"next" TimeWeightSummary /* core::option::Option<timescaledb_toolkit::time_weighted_average::TimeWeightSummary> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_summary_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:174
-- timescaledb_toolkit::time_weighted_average::time_weight_trans
CREATE OR REPLACE FUNCTION "time_weight_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"method" TEXT, /* alloc::string::String */
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"val" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:164
-- timescaledb_toolkit::time_weighted_average::time_weight_trans_deserialize
CREATE OR REPLACE FUNCTION "time_weight_trans_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_trans_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:157
-- timescaledb_toolkit::time_weighted_average::time_weight_trans_serialize
CREATE OR REPLACE FUNCTION "time_weight_trans_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_weight_trans_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_weighted_average.rs:392
-- requires:
--   time_weight_trans
--   time_weight_final
--   time_weight_combine
--   time_weight_trans_serialize
--   time_weight_trans_deserialize
--   time_weight_summary_trans


CREATE OR REPLACE AGGREGATE time_weight(method text, ts timestamptz, value DOUBLE PRECISION)
(
sfunc = time_weight_trans,
stype = internal,
finalfunc = time_weight_final,
combinefunc = time_weight_combine,
serialfunc = time_weight_trans_serialize,
deserialfunc = time_weight_trans_deserialize,
parallel = restricted
);

CREATE OR REPLACE AGGREGATE rollup(tws TimeWeightSummary)
(
sfunc = time_weight_summary_trans,
stype = internal,
finalfunc = time_weight_final,
combinefunc = time_weight_combine,
serialfunc = time_weight_trans_serialize,
deserialfunc = time_weight_trans_deserialize,
parallel = restricted
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:290
-- timescaledb_toolkit::time_vector::timevector_combine
CREATE OR REPLACE FUNCTION "timevector_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timevector_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:197
-- timescaledb_toolkit::time_vector::timevector_deserialize
CREATE OR REPLACE FUNCTION "timevector_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timevector_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:365
-- timescaledb_toolkit::time_vector::timevector_final
CREATE OR REPLACE FUNCTION "timevector_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS Timevector_TSTZ_F64 /* core::option::Option<timescaledb_toolkit::time_vector::Timevector_TSTZ_F64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timevector_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:190
-- timescaledb_toolkit::time_vector::timevector_serialize
CREATE OR REPLACE FUNCTION "timevector_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timevector_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:263
-- timescaledb_toolkit::time_vector::timevector_tstz_f64_compound_trans
CREATE OR REPLACE FUNCTION "timevector_tstz_f64_compound_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"series" Timevector_TSTZ_F64 /* core::option::Option<timescaledb_toolkit::time_vector::Timevector_TSTZ_F64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timevector_tstz_f64_compound_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:410
-- requires:
--   timevector_tstz_f64_compound_trans
--   timevector_final
--   timevector_combine
--   timevector_serialize
--   timevector_deserialize


CREATE OR REPLACE AGGREGATE rollup(
timevector_tstz_f64
) (

sfunc = timevector_tstz_f64_compound_trans,
stype = internal,
finalfunc = timevector_final,
combinefunc = timevector_combine,
serialfunc = timevector_serialize,
deserialfunc = timevector_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:203
-- timescaledb_toolkit::time_vector::timevector_tstz_f64_trans
CREATE OR REPLACE FUNCTION "timevector_tstz_f64_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"time" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"value" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'timevector_tstz_f64_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:388
-- requires:
--   timevector_tstz_f64_trans
--   timevector_final
--   timevector_combine
--   timevector_serialize
--   timevector_deserialize


CREATE OR REPLACE AGGREGATE timevector(ts TIMESTAMPTZ, value DOUBLE PRECISION) (
sfunc = timevector_tstz_f64_trans,
stype = internal,
finalfunc = timevector_final,
combinefunc = timevector_combine,
serialfunc = timevector_serialize,
deserialfunc = timevector_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:111
-- timescaledb_toolkit::accessors::topn
CREATE FUNCTION "topn"() RETURNS AccessorTopn /* timescaledb_toolkit::accessors::AccessorTopn */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_topn_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:594
-- timescaledb_toolkit::accessors::topn
CREATE FUNCTION "topn"(
	"count" bigint /* i64 */
) RETURNS AccessorTopNCount /* timescaledb_toolkit::accessors::AccessorTopNCount */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_topn_count_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1432
-- timescaledb_toolkit::frequency::topn
CREATE FUNCTION "topn"(
	"agg" SpaceSavingAggregate, /* timescaledb_toolkit::frequency::SpaceSavingAggregate */
	"ty" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS SETOF anyelement /* pgrx::datum::anyelement::AnyElement */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'default_topn_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1473
-- timescaledb_toolkit::frequency::topn
CREATE FUNCTION "topn"(
	"agg" SpaceSavingBigIntAggregate /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
) RETURNS SETOF bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'default_topn_bigint_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1523
-- timescaledb_toolkit::frequency::topn
CREATE FUNCTION "topn"(
	"agg" SpaceSavingTextAggregate /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
) RETURNS SETOF TEXT /* alloc::string::String */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'default_topn_text_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1396
-- timescaledb_toolkit::frequency::topn
CREATE OR REPLACE FUNCTION "topn"(
	"agg" SpaceSavingAggregate, /* timescaledb_toolkit::frequency::SpaceSavingAggregate */
	"n" INT, /* i32 */
	"ty" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS SETOF anyelement /* pgrx::datum::anyelement::AnyElement */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'topn_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1444
-- timescaledb_toolkit::frequency::topn
CREATE OR REPLACE FUNCTION "topn"(
	"agg" SpaceSavingBigIntAggregate, /* timescaledb_toolkit::frequency::SpaceSavingBigIntAggregate */
	"n" INT /* i32 */
) RETURNS SETOF bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'topn_bigint_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1491
-- timescaledb_toolkit::frequency::topn
CREATE OR REPLACE FUNCTION "topn"(
	"agg" SpaceSavingTextAggregate, /* timescaledb_toolkit::frequency::SpaceSavingTextAggregate */
	"n" INT /* i32 */
) RETURNS SETOF TEXT /* alloc::string::String */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'topn_text_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg/accessors.rs:137
-- timescaledb_toolkit::heartbeat_agg::accessors::trim_to
CREATE OR REPLACE FUNCTION "trim_to"(
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"duration" Interval DEFAULT NULL /* core::option::Option<timescaledb_toolkit::raw::Interval> */
) RETURNS HeartbeatTrimToAccessor /* timescaledb_toolkit::heartbeat_agg::accessors::HeartbeatTrimToAccessor */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'heartbeat_agg_trim_to_accessor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:552
-- timescaledb_toolkit::heartbeat_agg::trim_to
CREATE OR REPLACE FUNCTION "trim_to"(
	"agg" HeartbeatAgg, /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
	"start" TimestampTz DEFAULT NULL, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"duration" Interval DEFAULT NULL /* core::option::Option<timescaledb_toolkit::raw::Interval> */
) RETURNS HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */

LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'trim_to_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:78
-- timescaledb_toolkit::uddsketch::uddsketch_combine
CREATE OR REPLACE FUNCTION "uddsketch_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:508
-- timescaledb_toolkit::uddsketch::uddsketch_compound_trans
CREATE OR REPLACE FUNCTION "uddsketch_compound_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" UddSketch /* core::option::Option<timescaledb_toolkit::uddsketch::UddSketch> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_compound_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:113
-- timescaledb_toolkit::uddsketch::uddsketch_deserialize
CREATE OR REPLACE FUNCTION "uddsketch_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:366
-- timescaledb_toolkit::uddsketch::uddsketch_final
CREATE OR REPLACE FUNCTION "uddsketch_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS UddSketch /* core::option::Option<timescaledb_toolkit::uddsketch::UddSketch> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:107
-- timescaledb_toolkit::uddsketch::uddsketch_serialize
CREATE OR REPLACE FUNCTION "uddsketch_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:485
-- requires:
--   percentile_agg_trans
--   uddsketch_final
--   uddsketch_combine
--   uddsketch_serialize
--   uddsketch_deserialize


CREATE OR REPLACE AGGREGATE percentile_agg(value DOUBLE PRECISION)
(
sfunc = percentile_agg_trans,
stype = internal,
finalfunc = uddsketch_final,
combinefunc = uddsketch_combine,
serialfunc = uddsketch_serialize,
deserialfunc = uddsketch_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:537
-- requires:
--   uddsketch_compound_trans
--   uddsketch_final
--   uddsketch_combine
--   uddsketch_serialize
--   uddsketch_deserialize


CREATE OR REPLACE AGGREGATE rollup(
sketch uddsketch
) (

sfunc = uddsketch_compound_trans,
stype = internal,
finalfunc = uddsketch_final,
combinefunc = uddsketch_combine,
serialfunc = uddsketch_serialize,
deserialfunc = uddsketch_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:20
-- timescaledb_toolkit::uddsketch::uddsketch_trans
CREATE OR REPLACE FUNCTION "uddsketch_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"size" INT, /* i32 */
	"max_error" double precision, /* f64 */
	"value" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uddsketch_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/uddsketch.rs:461
-- requires:
--   uddsketch_trans
--   uddsketch_final
--   uddsketch_combine
--   uddsketch_serialize
--   uddsketch_deserialize


CREATE OR REPLACE AGGREGATE uddsketch(
size integer, max_error DOUBLE PRECISION, value DOUBLE PRECISION
) (

sfunc = uddsketch_trans,
stype = internal,
finalfunc = uddsketch_final,
combinefunc = uddsketch_combine,
serialfunc = uddsketch_serialize,
deserialfunc = uddsketch_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:553
-- timescaledb_toolkit::accessors::unnest
CREATE OR REPLACE FUNCTION "unnest"() RETURNS AccessorUnnest /* timescaledb_toolkit::accessors::AccessorUnnest */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_unnest_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:111
-- timescaledb_toolkit::time_vector::unnest
CREATE OR REPLACE FUNCTION "unnest"(
	"series" Timevector_TSTZ_F64 /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
) RETURNS TABLE (

	"time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision  /* f64 */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'unnest_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:102
-- timescaledb_toolkit::accessors::uptime
CREATE FUNCTION "uptime"() RETURNS AccessorUptime /* timescaledb_toolkit::accessors::AccessorUptime */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_uptime_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/heartbeat_agg.rs:393
-- timescaledb_toolkit::heartbeat_agg::uptime
CREATE FUNCTION "uptime"(
	"agg" HeartbeatAgg /* timescaledb_toolkit::heartbeat_agg::HeartbeatAgg */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */

STRICT
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'uptime_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:217
-- timescaledb_toolkit::accessors::variance
CREATE OR REPLACE FUNCTION "variance"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorVariance /* timescaledb_toolkit::accessors::AccessorVariance */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_variance_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:996
-- timescaledb_toolkit::stats_agg::variance
CREATE OR REPLACE FUNCTION "variance"(
	"summary" StatsSummary1D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary1D> */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats1d_variance_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:241
-- timescaledb_toolkit::accessors::variance_x
CREATE OR REPLACE FUNCTION "variance_x"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorVarianceX /* timescaledb_toolkit::accessors::AccessorVarianceX */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_variance_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1171
-- timescaledb_toolkit::stats_agg::variance_x
CREATE OR REPLACE FUNCTION "variance_x"(
	"summary" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_variance_x_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:265
-- timescaledb_toolkit::accessors::variance_y
CREATE OR REPLACE FUNCTION "variance_y"(
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS AccessorVarianceY /* timescaledb_toolkit::accessors::AccessorVarianceY */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_variance_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1192
-- timescaledb_toolkit::stats_agg::variance_y
CREATE OR REPLACE FUNCTION "variance_y"(
	"summary" StatsSummary2D, /* core::option::Option<timescaledb_toolkit::stats_agg::StatsSummary2D> */
	"method" TEXT DEFAULT 'sample' /* &str */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_variance_y_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:508
-- timescaledb_toolkit::candlestick::volume
CREATE FUNCTION "volume"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'volume_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/candlestick.rs:516
-- timescaledb_toolkit::candlestick::vwap
CREATE FUNCTION "vwap"(
	"candlestick" Candlestick /* core::option::Option<timescaledb_toolkit::candlestick::Candlestick> */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'vwap_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:501
-- timescaledb_toolkit::accessors::with_bounds
CREATE OR REPLACE FUNCTION "with_bounds"(
	"bounds" tstzrange /* timescaledb_toolkit::raw::tstzrange */
) RETURNS AccessorWithBounds /* timescaledb_toolkit::accessors::AccessorWithBounds */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_with_bounds_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/counter_agg.rs:581
-- timescaledb_toolkit::counter_agg::with_bounds
CREATE OR REPLACE FUNCTION "with_bounds"(
	"summary" CounterSummary, /* timescaledb_toolkit::counter_agg::CounterSummary */
	"bounds" tstzrange /* timescaledb_toolkit::raw::tstzrange */
) RETURNS CounterSummary /* timescaledb_toolkit::counter_agg::CounterSummary */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'counter_agg_with_bounds_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/accessors.rs:73
-- timescaledb_toolkit::accessors::x_intercept
CREATE OR REPLACE FUNCTION "x_intercept"() RETURNS AccessorXIntercept /* timescaledb_toolkit::accessors::AccessorXIntercept */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_x_intercept_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/stats_agg.rs:1352
-- timescaledb_toolkit::stats_agg::x_intercept
CREATE OR REPLACE FUNCTION "x_intercept"(
	"summary" StatsSummary2D /* timescaledb_toolkit::stats_agg::StatsSummary2D */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'stats2d_x_intercept_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:14
CREATE SCHEMA IF NOT EXISTS toolkit_experimental; /* timescaledb_toolkit::countminsketch::toolkit_experimental */
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:18
-- timescaledb_toolkit::countminsketch::toolkit_experimental::CountMinSketch
CREATE TYPE toolkit_experimental.CountMinSketch;

-- extension/src/countminsketch.rs:18
-- timescaledb_toolkit::countminsketch::toolkit_experimental::countminsketch_in
CREATE FUNCTION toolkit_experimental."countminsketch_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.CountMinSketch /* core::option::Option<timescaledb_toolkit::countminsketch::toolkit_experimental::CountMinSketch> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'countminsketch_in_wrapper';

-- extension/src/countminsketch.rs:18
-- timescaledb_toolkit::countminsketch::toolkit_experimental::countminsketch_out
CREATE FUNCTION toolkit_experimental."countminsketch_out"(
	"input" toolkit_experimental.CountMinSketch /* timescaledb_toolkit::countminsketch::toolkit_experimental::CountMinSketch */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'countminsketch_out_wrapper';

-- extension/src/countminsketch.rs:18
-- timescaledb_toolkit::countminsketch::toolkit_experimental::CountMinSketch
CREATE TYPE toolkit_experimental.CountMinSketch (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.countminsketch_in, /* timescaledb_toolkit::countminsketch::toolkit_experimental::countminsketch_in */
	OUTPUT = toolkit_experimental.countminsketch_out, /* timescaledb_toolkit::countminsketch::toolkit_experimental::countminsketch_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:434
CREATE SCHEMA IF NOT EXISTS toolkit_experimental; /* timescaledb_toolkit::time_vector::toolkit_experimental */
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:486
-- timescaledb_toolkit::time_vector::toolkit_experimental::AccessorAsof
CREATE TYPE toolkit_experimental.AccessorAsof;

-- extension/src/time_vector.rs:486
-- timescaledb_toolkit::time_vector::toolkit_experimental::accessorasof_in
CREATE FUNCTION toolkit_experimental."accessorasof_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.AccessorAsof /* core::option::Option<timescaledb_toolkit::time_vector::toolkit_experimental::AccessorAsof> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorasof_in_wrapper';

-- extension/src/time_vector.rs:486
-- timescaledb_toolkit::time_vector::toolkit_experimental::accessorasof_out
CREATE FUNCTION toolkit_experimental."accessorasof_out"(
	"input" toolkit_experimental.AccessorAsof /* timescaledb_toolkit::time_vector::toolkit_experimental::AccessorAsof */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessorasof_out_wrapper';

-- extension/src/time_vector.rs:486
-- timescaledb_toolkit::time_vector::toolkit_experimental::AccessorAsof
CREATE TYPE toolkit_experimental.AccessorAsof (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.accessorasof_in, /* timescaledb_toolkit::time_vector::toolkit_experimental::accessorasof_in */
	OUTPUT = toolkit_experimental.accessorasof_out, /* timescaledb_toolkit::time_vector::toolkit_experimental::accessorasof_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:507
-- timescaledb_toolkit::time_vector::arrow_timevector_asof
CREATE OR REPLACE FUNCTION "arrow_timevector_asof"(
	"series" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"accessor" toolkit_experimental.AccessorAsof /* timescaledb_toolkit::time_vector::toolkit_experimental::AccessorAsof */
) RETURNS TABLE (

	"value1" double precision,  /* core::option::Option<f64> */
	"value2" double precision,  /* f64 */
	"time" TimestampTz  /* timescaledb_toolkit::raw::TimestampTz */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_timevector_asof_wrapper';

-- extension/src/time_vector.rs:507
-- timescaledb_toolkit::time_vector::arrow_timevector_asof
CREATE OPERATOR -> (
    PROCEDURE="arrow_timevector_asof",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.AccessorAsof /* timescaledb_toolkit::time_vector::toolkit_experimental::AccessorAsof */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:495
-- timescaledb_toolkit::time_vector::toolkit_experimental::asof
CREATE FUNCTION toolkit_experimental."asof"(
	"tv" Timevector_TSTZ_F64 /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
) RETURNS toolkit_experimental.AccessorAsof /* timescaledb_toolkit::time_vector::toolkit_experimental::AccessorAsof */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'accessor_asof_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:14
CREATE SCHEMA IF NOT EXISTS toolkit_experimental; /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental */
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:18
-- timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest
CREATE TYPE toolkit_experimental.PipelineThenUnnest;

-- extension/src/time_vector/pipeline/expansion.rs:18
-- timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::pipelinethenunnest_in
CREATE FUNCTION toolkit_experimental."pipelinethenunnest_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineThenUnnest /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenunnest_in_wrapper';

-- extension/src/time_vector/pipeline/expansion.rs:18
-- timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::pipelinethenunnest_out
CREATE FUNCTION toolkit_experimental."pipelinethenunnest_out"(
	"input" toolkit_experimental.PipelineThenUnnest /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenunnest_out_wrapper';

-- extension/src/time_vector/pipeline/expansion.rs:18
-- timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest
CREATE TYPE toolkit_experimental.PipelineThenUnnest (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelinethenunnest_in, /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::pipelinethenunnest_in */
	OUTPUT = toolkit_experimental.pipelinethenunnest_out, /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::pipelinethenunnest_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:82
-- timescaledb_toolkit::time_vector::pipeline::expansion::arrow_run_pipeline_then_unnest
CREATE OR REPLACE FUNCTION "arrow_run_pipeline_then_unnest"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineThenUnnest /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest */
) RETURNS TABLE (

	"time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision  /* f64 */
)
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_run_pipeline_then_unnest_wrapper';

-- extension/src/time_vector/pipeline/expansion.rs:82
-- timescaledb_toolkit::time_vector::pipeline::expansion::arrow_run_pipeline_then_unnest
CREATE OPERATOR -> (
    PROCEDURE="arrow_run_pipeline_then_unnest",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineThenUnnest /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:28
-- timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize
CREATE TYPE toolkit_experimental.PipelineForceMaterialize;

-- extension/src/time_vector/pipeline/expansion.rs:28
-- timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::pipelineforcematerialize_in
CREATE FUNCTION toolkit_experimental."pipelineforcematerialize_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineForceMaterialize /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelineforcematerialize_in_wrapper';

-- extension/src/time_vector/pipeline/expansion.rs:28
-- timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::pipelineforcematerialize_out
CREATE FUNCTION toolkit_experimental."pipelineforcematerialize_out"(
	"input" toolkit_experimental.PipelineForceMaterialize /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelineforcematerialize_out_wrapper';

-- extension/src/time_vector/pipeline/expansion.rs:28
-- timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize
CREATE TYPE toolkit_experimental.PipelineForceMaterialize (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelineforcematerialize_in, /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::pipelineforcematerialize_in */
	OUTPUT = toolkit_experimental.pipelineforcematerialize_out, /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::pipelineforcematerialize_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:137
-- timescaledb_toolkit::time_vector::pipeline::expansion::arrow_run_pipeline_then_materialize
CREATE OR REPLACE FUNCTION "arrow_run_pipeline_then_materialize"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineForceMaterialize /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize */
) RETURNS Timevector_TSTZ_F64 /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_run_pipeline_then_materialize_wrapper';

-- extension/src/time_vector/pipeline/expansion.rs:137
-- timescaledb_toolkit::time_vector::pipeline::expansion::arrow_run_pipeline_then_materialize
CREATE OPERATOR -> (
    PROCEDURE="arrow_run_pipeline_then_materialize",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineForceMaterialize /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline.rs:27
CREATE SCHEMA IF NOT EXISTS toolkit_experimental; /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental */
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline.rs:35
-- timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline
CREATE TYPE toolkit_experimental.UnstableTimevectorPipeline;

-- extension/src/time_vector/pipeline.rs:35
-- timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::unstabletimevectorpipeline_in
CREATE FUNCTION toolkit_experimental."unstabletimevectorpipeline_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'unstabletimevectorpipeline_in_wrapper';

-- extension/src/time_vector/pipeline.rs:35
-- timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::unstabletimevectorpipeline_out
CREATE FUNCTION toolkit_experimental."unstabletimevectorpipeline_out"(
	"input" toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'unstabletimevectorpipeline_out_wrapper';

-- extension/src/time_vector/pipeline.rs:35
-- timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline
CREATE TYPE toolkit_experimental.UnstableTimevectorPipeline (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.unstabletimevectorpipeline_in, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::unstabletimevectorpipeline_in */
	OUTPUT = toolkit_experimental.unstabletimevectorpipeline_out, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::unstabletimevectorpipeline_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline.rs:113
-- timescaledb_toolkit::time_vector::pipeline::arrow_run_pipeline
CREATE OR REPLACE FUNCTION "arrow_run_pipeline"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
) RETURNS Timevector_TSTZ_F64 /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_run_pipeline_wrapper';

-- extension/src/time_vector/pipeline.rs:113
-- timescaledb_toolkit::time_vector::pipeline::arrow_run_pipeline
CREATE OPERATOR -> (
    PROCEDURE="arrow_run_pipeline",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:54
-- timescaledb_toolkit::time_vector::pipeline::expansion::arrow_finalize_with_unnest
CREATE OR REPLACE FUNCTION "arrow_finalize_with_unnest"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_stats_agg" toolkit_experimental.PipelineThenUnnest /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest */
) RETURNS toolkit_experimental.PipelineThenUnnest /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_finalize_with_unnest_wrapper';

-- extension/src/time_vector/pipeline/expansion.rs:54
-- timescaledb_toolkit::time_vector::pipeline::expansion::arrow_finalize_with_unnest
CREATE OPERATOR -> (
    PROCEDURE="arrow_finalize_with_unnest",
    LEFTARG=toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
    RIGHTARG=toolkit_experimental.PipelineThenUnnest /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:109
-- timescaledb_toolkit::time_vector::pipeline::expansion::arrow_force_materialize
CREATE OR REPLACE FUNCTION "arrow_force_materialize"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_stats_agg" toolkit_experimental.PipelineForceMaterialize /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize */
) RETURNS toolkit_experimental.PipelineForceMaterialize /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_force_materialize_wrapper';

-- extension/src/time_vector/pipeline/expansion.rs:109
-- timescaledb_toolkit::time_vector::pipeline::expansion::arrow_force_materialize
CREATE OPERATOR -> (
    PROCEDURE="arrow_force_materialize",
    LEFTARG=toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
    RIGHTARG=toolkit_experimental.PipelineForceMaterialize /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline.rs:150
-- timescaledb_toolkit::time_vector::pipeline::arrow_add_unstable_element
CREATE OR REPLACE FUNCTION "arrow_add_unstable_element"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"element" toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_add_unstable_element_wrapper';

-- extension/src/time_vector/pipeline.rs:150
-- timescaledb_toolkit::time_vector::pipeline::arrow_add_unstable_element
CREATE OPERATOR -> (
    PROCEDURE="arrow_add_unstable_element",
    LEFTARG=toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
    RIGHTARG=toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:27
CREATE SCHEMA IF NOT EXISTS toolkit_experimental; /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental */
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:42
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum
CREATE TYPE toolkit_experimental.PipelineThenSum;

-- extension/src/time_vector/pipeline/aggregation.rs:42
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethensum_in
CREATE FUNCTION toolkit_experimental."pipelinethensum_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineThenSum /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethensum_in_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:42
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethensum_out
CREATE FUNCTION toolkit_experimental."pipelinethensum_out"(
	"input" toolkit_experimental.PipelineThenSum /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethensum_out_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:42
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum
CREATE TYPE toolkit_experimental.PipelineThenSum (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelinethensum_in, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethensum_in */
	OUTPUT = toolkit_experimental.pipelinethensum_out, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethensum_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:214
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_pipeline_then_sum
CREATE OR REPLACE FUNCTION "arrow_pipeline_then_sum"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineThenSum /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_pipeline_then_sum_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:214
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_pipeline_then_sum
CREATE OPERATOR -> (
    PROCEDURE="arrow_pipeline_then_sum",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineThenSum /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:231
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_sum
CREATE OR REPLACE FUNCTION "finalize_with_sum"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_stats_agg" toolkit_experimental.PipelineThenSum /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum */
) RETURNS toolkit_experimental.PipelineThenSum /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'finalize_with_sum_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:231
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_sum
CREATE OPERATOR -> (
    PROCEDURE="finalize_with_sum",
    LEFTARG=toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
    RIGHTARG=toolkit_experimental.PipelineThenSum /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:32
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg
CREATE TYPE toolkit_experimental.PipelineThenStatsAgg;

-- extension/src/time_vector/pipeline/aggregation.rs:32
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenstatsagg_in
CREATE FUNCTION toolkit_experimental."pipelinethenstatsagg_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineThenStatsAgg /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenstatsagg_in_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:32
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenstatsagg_out
CREATE FUNCTION toolkit_experimental."pipelinethenstatsagg_out"(
	"input" toolkit_experimental.PipelineThenStatsAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenstatsagg_out_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:32
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg
CREATE TYPE toolkit_experimental.PipelineThenStatsAgg (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelinethenstatsagg_in, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenstatsagg_in */
	OUTPUT = toolkit_experimental.pipelinethenstatsagg_out, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenstatsagg_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:104
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_run_pipeline_then_stats_agg
CREATE OR REPLACE FUNCTION "arrow_run_pipeline_then_stats_agg"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineThenStatsAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg */
) RETURNS StatsSummary1D /* timescaledb_toolkit::stats_agg::StatsSummary1D */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_run_pipeline_then_stats_agg_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:104
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_run_pipeline_then_stats_agg
CREATE OPERATOR -> (
    PROCEDURE="arrow_run_pipeline_then_stats_agg",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineThenStatsAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:62
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals
CREATE TYPE toolkit_experimental.PipelineThenNumVals;

-- extension/src/time_vector/pipeline/aggregation.rs:62
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethennumvals_in
CREATE FUNCTION toolkit_experimental."pipelinethennumvals_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineThenNumVals /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethennumvals_in_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:62
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethennumvals_out
CREATE FUNCTION toolkit_experimental."pipelinethennumvals_out"(
	"input" toolkit_experimental.PipelineThenNumVals /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethennumvals_out_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:62
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals
CREATE TYPE toolkit_experimental.PipelineThenNumVals (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelinethennumvals_in, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethennumvals_in */
	OUTPUT = toolkit_experimental.pipelinethennumvals_out, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethennumvals_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:403
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_pipeline_then_num_vals
CREATE OR REPLACE FUNCTION "arrow_pipeline_then_num_vals"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineThenNumVals /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_pipeline_then_num_vals_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:403
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_pipeline_then_num_vals
CREATE OPERATOR -> (
    PROCEDURE="arrow_pipeline_then_num_vals",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineThenNumVals /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:412
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_num_vals
CREATE OR REPLACE FUNCTION "finalize_with_num_vals"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_stats_agg" toolkit_experimental.PipelineThenNumVals /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals */
) RETURNS toolkit_experimental.PipelineThenNumVals /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'finalize_with_num_vals_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:412
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_num_vals
CREATE OPERATOR -> (
    PROCEDURE="finalize_with_num_vals",
    LEFTARG=toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
    RIGHTARG=toolkit_experimental.PipelineThenNumVals /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:52
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage
CREATE TYPE toolkit_experimental.PipelineThenAverage;

-- extension/src/time_vector/pipeline/aggregation.rs:52
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenaverage_in
CREATE FUNCTION toolkit_experimental."pipelinethenaverage_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineThenAverage /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenaverage_in_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:52
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenaverage_out
CREATE FUNCTION toolkit_experimental."pipelinethenaverage_out"(
	"input" toolkit_experimental.PipelineThenAverage /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenaverage_out_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:52
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage
CREATE TYPE toolkit_experimental.PipelineThenAverage (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelinethenaverage_in, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenaverage_in */
	OUTPUT = toolkit_experimental.pipelinethenaverage_out, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenaverage_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:323
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_average
CREATE OR REPLACE FUNCTION "finalize_with_average"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_stats_agg" toolkit_experimental.PipelineThenAverage /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage */
) RETURNS toolkit_experimental.PipelineThenAverage /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'finalize_with_average_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:323
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_average
CREATE OPERATOR -> (
    PROCEDURE="finalize_with_average",
    LEFTARG=toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
    RIGHTARG=toolkit_experimental.PipelineThenAverage /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:306
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_pipeline_then_average
CREATE OR REPLACE FUNCTION "arrow_pipeline_then_average"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineThenAverage /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_pipeline_then_average_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:306
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_pipeline_then_average
CREATE OPERATOR -> (
    PROCEDURE="arrow_pipeline_then_average",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineThenAverage /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:82
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog
CREATE TYPE toolkit_experimental.PipelineThenHyperLogLog;

-- extension/src/time_vector/pipeline/aggregation.rs:82
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenhyperloglog_in
CREATE FUNCTION toolkit_experimental."pipelinethenhyperloglog_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineThenHyperLogLog /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenhyperloglog_in_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:82
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenhyperloglog_out
CREATE FUNCTION toolkit_experimental."pipelinethenhyperloglog_out"(
	"input" toolkit_experimental.PipelineThenHyperLogLog /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenhyperloglog_out_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:82
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog
CREATE TYPE toolkit_experimental.PipelineThenHyperLogLog (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelinethenhyperloglog_in, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenhyperloglog_in */
	OUTPUT = toolkit_experimental.pipelinethenhyperloglog_out, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenhyperloglog_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:551
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_run_pipeline_then_hyperloglog
CREATE OR REPLACE FUNCTION "arrow_run_pipeline_then_hyperloglog"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineThenHyperLogLog /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog */
) RETURNS HyperLogLog /* timescaledb_toolkit::hyperloglog::HyperLogLog */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_run_pipeline_then_hyperloglog_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:551
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_run_pipeline_then_hyperloglog
CREATE OPERATOR -> (
    PROCEDURE="arrow_run_pipeline_then_hyperloglog",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineThenHyperLogLog /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:93
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg
CREATE TYPE toolkit_experimental.PipelineThenPercentileAgg;

-- extension/src/time_vector/pipeline/aggregation.rs:93
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenpercentileagg_in
CREATE FUNCTION toolkit_experimental."pipelinethenpercentileagg_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineThenPercentileAgg /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenpercentileagg_in_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:93
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenpercentileagg_out
CREATE FUNCTION toolkit_experimental."pipelinethenpercentileagg_out"(
	"input" toolkit_experimental.PipelineThenPercentileAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethenpercentileagg_out_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:93
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg
CREATE TYPE toolkit_experimental.PipelineThenPercentileAgg (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelinethenpercentileagg_in, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenpercentileagg_in */
	OUTPUT = toolkit_experimental.pipelinethenpercentileagg_out, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethenpercentileagg_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:639
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_run_pipeline_then_percentile_agg
CREATE OR REPLACE FUNCTION "arrow_run_pipeline_then_percentile_agg"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineThenPercentileAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg */
) RETURNS UddSketch /* timescaledb_toolkit::uddsketch::UddSketch */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_run_pipeline_then_percentile_agg_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:639
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_run_pipeline_then_percentile_agg
CREATE OPERATOR -> (
    PROCEDURE="arrow_run_pipeline_then_percentile_agg",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineThenPercentileAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:72
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg
CREATE TYPE toolkit_experimental.PipelineThenCounterAgg;

-- extension/src/time_vector/pipeline/aggregation.rs:72
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethencounteragg_in
CREATE FUNCTION toolkit_experimental."pipelinethencounteragg_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.PipelineThenCounterAgg /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethencounteragg_in_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:72
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethencounteragg_out
CREATE FUNCTION toolkit_experimental."pipelinethencounteragg_out"(
	"input" toolkit_experimental.PipelineThenCounterAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipelinethencounteragg_out_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:72
-- timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg
CREATE TYPE toolkit_experimental.PipelineThenCounterAgg (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.pipelinethencounteragg_in, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethencounteragg_in */
	OUTPUT = toolkit_experimental.pipelinethencounteragg_out, /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::pipelinethencounteragg_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:461
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_run_pipeline_then_counter_agg
CREATE OR REPLACE FUNCTION "arrow_run_pipeline_then_counter_agg"(
	"timevector" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"pipeline" toolkit_experimental.PipelineThenCounterAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg */
) RETURNS CounterSummary /* core::option::Option<timescaledb_toolkit::counter_agg::CounterSummary> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_run_pipeline_then_counter_agg_wrapper';

-- extension/src/time_vector/pipeline/aggregation.rs:461
-- timescaledb_toolkit::time_vector::pipeline::aggregation::arrow_run_pipeline_then_counter_agg
CREATE OPERATOR -> (
    PROCEDURE="arrow_run_pipeline_then_counter_agg",
    LEFTARG=Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
    RIGHTARG=toolkit_experimental.PipelineThenCounterAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:41
CREATE SCHEMA IF NOT EXISTS toolkit_experimental; /* timescaledb_toolkit::gauge_agg::toolkit_experimental */
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:45
-- timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary
CREATE TYPE toolkit_experimental.GaugeSummary;

-- extension/src/gauge_agg.rs:45
-- timescaledb_toolkit::gauge_agg::toolkit_experimental::gaugesummary_in
CREATE FUNCTION toolkit_experimental."gaugesummary_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.GaugeSummary /* core::option::Option<timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gaugesummary_in_wrapper';

-- extension/src/gauge_agg.rs:45
-- timescaledb_toolkit::gauge_agg::toolkit_experimental::gaugesummary_out
CREATE FUNCTION toolkit_experimental."gaugesummary_out"(
	"input" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gaugesummary_out_wrapper';

-- extension/src/gauge_agg.rs:45
-- timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary
CREATE TYPE toolkit_experimental.GaugeSummary (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.gaugesummary_in, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::gaugesummary_in */
	OUTPUT = toolkit_experimental.gaugesummary_out, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::gaugesummary_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:639
-- timescaledb_toolkit::gauge_agg::arrow_zero_time
CREATE OR REPLACE FUNCTION "arrow_zero_time"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"__accessor" AccessorCounterZeroTime /* timescaledb_toolkit::accessors::AccessorCounterZeroTime */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_zero_time_wrapper';

-- extension/src/gauge_agg.rs:639
-- timescaledb_toolkit::gauge_agg::arrow_zero_time
CREATE OPERATOR -> (
    PROCEDURE="arrow_zero_time",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorCounterZeroTime /* timescaledb_toolkit::accessors::AccessorCounterZeroTime */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:441
-- timescaledb_toolkit::gauge_agg::arrow_gauge_agg_rate
CREATE OR REPLACE FUNCTION "arrow_gauge_agg_rate"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorRate /* timescaledb_toolkit::accessors::AccessorRate */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_gauge_agg_rate_wrapper';

-- extension/src/gauge_agg.rs:441
-- timescaledb_toolkit::gauge_agg::arrow_gauge_agg_rate
CREATE OPERATOR -> (
    PROCEDURE="arrow_gauge_agg_rate",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorRate /* timescaledb_toolkit::accessors::AccessorRate */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:474
-- timescaledb_toolkit::gauge_agg::arrow_irate_right
CREATE OR REPLACE FUNCTION "arrow_irate_right"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorIrateRight /* timescaledb_toolkit::accessors::AccessorIrateRight */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_irate_right_wrapper';

-- extension/src/gauge_agg.rs:474
-- timescaledb_toolkit::gauge_agg::arrow_irate_right
CREATE OPERATOR -> (
    PROCEDURE="arrow_irate_right",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorIrateRight /* timescaledb_toolkit::accessors::AccessorIrateRight */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:617
-- timescaledb_toolkit::gauge_agg::arrow_intercept
CREATE OR REPLACE FUNCTION "arrow_intercept"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorIntercept /* timescaledb_toolkit::accessors::AccessorIntercept */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_intercept_wrapper';

-- extension/src/gauge_agg.rs:617
-- timescaledb_toolkit::gauge_agg::arrow_intercept
CREATE OPERATOR -> (
    PROCEDURE="arrow_intercept",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorIntercept /* timescaledb_toolkit::accessors::AccessorIntercept */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:532
-- timescaledb_toolkit::gauge_agg::arrow_extrapolated_delta
CREATE OR REPLACE FUNCTION "arrow_extrapolated_delta"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorExtrapolatedDelta /* timescaledb_toolkit::accessors::AccessorExtrapolatedDelta */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_extrapolated_delta_wrapper';

-- extension/src/gauge_agg.rs:532
-- timescaledb_toolkit::gauge_agg::arrow_extrapolated_delta
CREATE OPERATOR -> (
    PROCEDURE="arrow_extrapolated_delta",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorExtrapolatedDelta /* timescaledb_toolkit::accessors::AccessorExtrapolatedDelta */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:584
-- timescaledb_toolkit::gauge_agg::arrow_num_elements
CREATE OR REPLACE FUNCTION "arrow_num_elements"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorNumElements /* timescaledb_toolkit::accessors::AccessorNumElements */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_num_elements_wrapper';

-- extension/src/gauge_agg.rs:584
-- timescaledb_toolkit::gauge_agg::arrow_num_elements
CREATE OPERATOR -> (
    PROCEDURE="arrow_num_elements",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorNumElements /* timescaledb_toolkit::accessors::AccessorNumElements */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:558
-- timescaledb_toolkit::gauge_agg::arrow_extrapolated_rate
CREATE OR REPLACE FUNCTION "arrow_extrapolated_rate"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorExtrapolatedRate /* timescaledb_toolkit::accessors::AccessorExtrapolatedRate */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_extrapolated_rate_wrapper';

-- extension/src/gauge_agg.rs:558
-- timescaledb_toolkit::gauge_agg::arrow_extrapolated_rate
CREATE OPERATOR -> (
    PROCEDURE="arrow_extrapolated_rate",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorExtrapolatedRate /* timescaledb_toolkit::accessors::AccessorExtrapolatedRate */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:452
-- timescaledb_toolkit::gauge_agg::arrow_time_delta
CREATE OR REPLACE FUNCTION "arrow_time_delta"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorTimeDelta /* timescaledb_toolkit::accessors::AccessorTimeDelta */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_time_delta_wrapper';

-- extension/src/gauge_agg.rs:452
-- timescaledb_toolkit::gauge_agg::arrow_time_delta
CREATE OPERATOR -> (
    PROCEDURE="arrow_time_delta",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorTimeDelta /* timescaledb_toolkit::accessors::AccessorTimeDelta */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:499
-- timescaledb_toolkit::gauge_agg::arrow_idelta_right
CREATE OR REPLACE FUNCTION "arrow_idelta_right"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorIdeltaRight /* timescaledb_toolkit::accessors::AccessorIdeltaRight */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_idelta_right_wrapper';

-- extension/src/gauge_agg.rs:499
-- timescaledb_toolkit::gauge_agg::arrow_idelta_right
CREATE OPERATOR -> (
    PROCEDURE="arrow_idelta_right",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorIdeltaRight /* timescaledb_toolkit::accessors::AccessorIdeltaRight */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:628
-- timescaledb_toolkit::gauge_agg::arrow_corr
CREATE OR REPLACE FUNCTION "arrow_corr"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorCorr /* timescaledb_toolkit::accessors::AccessorCorr */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_corr_wrapper';

-- extension/src/gauge_agg.rs:628
-- timescaledb_toolkit::gauge_agg::arrow_corr
CREATE OPERATOR -> (
    PROCEDURE="arrow_corr",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorCorr /* timescaledb_toolkit::accessors::AccessorCorr */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:606
-- timescaledb_toolkit::gauge_agg::arrow_slope
CREATE OR REPLACE FUNCTION "arrow_slope"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorSlope /* timescaledb_toolkit::accessors::AccessorSlope */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_slope_wrapper';

-- extension/src/gauge_agg.rs:606
-- timescaledb_toolkit::gauge_agg::arrow_slope
CREATE OPERATOR -> (
    PROCEDURE="arrow_slope",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorSlope /* timescaledb_toolkit::accessors::AccessorSlope */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:488
-- timescaledb_toolkit::gauge_agg::arrow_idelta_left
CREATE OR REPLACE FUNCTION "arrow_idelta_left"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorIdeltaLeft /* timescaledb_toolkit::accessors::AccessorIdeltaLeft */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_idelta_left_wrapper';

-- extension/src/gauge_agg.rs:488
-- timescaledb_toolkit::gauge_agg::arrow_idelta_left
CREATE OPERATOR -> (
    PROCEDURE="arrow_idelta_left",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorIdeltaLeft /* timescaledb_toolkit::accessors::AccessorIdeltaLeft */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:430
-- timescaledb_toolkit::gauge_agg::arrow_delta
CREATE OR REPLACE FUNCTION "arrow_delta"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorDelta /* timescaledb_toolkit::accessors::AccessorDelta */
) RETURNS double precision /* f64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_delta_wrapper';

-- extension/src/gauge_agg.rs:430
-- timescaledb_toolkit::gauge_agg::arrow_delta
CREATE OPERATOR -> (
    PROCEDURE="arrow_delta",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorDelta /* timescaledb_toolkit::accessors::AccessorDelta */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:510
-- timescaledb_toolkit::gauge_agg::arrow_with_bounds
CREATE OR REPLACE FUNCTION "arrow_with_bounds"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"accessor" AccessorWithBounds /* timescaledb_toolkit::accessors::AccessorWithBounds */
) RETURNS toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_with_bounds_wrapper';

-- extension/src/gauge_agg.rs:510
-- timescaledb_toolkit::gauge_agg::arrow_with_bounds
CREATE OPERATOR -> (
    PROCEDURE="arrow_with_bounds",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorWithBounds /* timescaledb_toolkit::accessors::AccessorWithBounds */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:463
-- timescaledb_toolkit::gauge_agg::arrow_irate_left
CREATE OR REPLACE FUNCTION "arrow_irate_left"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorIrateLeft /* timescaledb_toolkit::accessors::AccessorIrateLeft */
) RETURNS double precision /* core::option::Option<f64> */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_irate_left_wrapper';

-- extension/src/gauge_agg.rs:463
-- timescaledb_toolkit::gauge_agg::arrow_irate_left
CREATE OPERATOR -> (
    PROCEDURE="arrow_irate_left",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorIrateLeft /* timescaledb_toolkit::accessors::AccessorIrateLeft */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:595
-- timescaledb_toolkit::gauge_agg::arrow_num_changes
CREATE OR REPLACE FUNCTION "arrow_num_changes"(
	"sketch" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"_accessor" AccessorNumChanges /* timescaledb_toolkit::accessors::AccessorNumChanges */
) RETURNS bigint /* i64 */

IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'arrow_num_changes_wrapper';

-- extension/src/gauge_agg.rs:595
-- timescaledb_toolkit::gauge_agg::arrow_num_changes
CREATE OPERATOR -> (
    PROCEDURE="arrow_num_changes",
    LEFTARG=toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
    RIGHTARG=AccessorNumChanges /* timescaledb_toolkit::accessors::AccessorNumChanges */
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:142
CREATE SCHEMA IF NOT EXISTS toolkit_experimental; /* timescaledb_toolkit::state_aggregate::toolkit_experimental */
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:146
-- timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg
CREATE TYPE toolkit_experimental.CompactStateAgg;

-- extension/src/state_aggregate.rs:146
-- timescaledb_toolkit::state_aggregate::toolkit_experimental::compactstateagg_in
CREATE FUNCTION toolkit_experimental."compactstateagg_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.CompactStateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compactstateagg_in_wrapper';

-- extension/src/state_aggregate.rs:146
-- timescaledb_toolkit::state_aggregate::toolkit_experimental::compactstateagg_out
CREATE FUNCTION toolkit_experimental."compactstateagg_out"(
	"input" toolkit_experimental.CompactStateAgg /* timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compactstateagg_out_wrapper';

-- extension/src/state_aggregate.rs:146
-- timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg
CREATE TYPE toolkit_experimental.CompactStateAgg (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.compactstateagg_in, /* timescaledb_toolkit::state_aggregate::toolkit_experimental::compactstateagg_in */
	OUTPUT = toolkit_experimental.compactstateagg_out, /* timescaledb_toolkit::state_aggregate::toolkit_experimental::compactstateagg_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/lambda.rs:17
CREATE SCHEMA IF NOT EXISTS toolkit_experimental; /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental */
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/lambda.rs:25
-- timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda
CREATE TYPE toolkit_experimental.Lambda;

-- extension/src/time_vector/pipeline/lambda.rs:25
-- timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::lambda_in
CREATE FUNCTION toolkit_experimental."lambda_in"(
	"input" cstring /* core::option::Option<&core::ffi::c_str::CStr> */
) RETURNS toolkit_experimental.Lambda /* core::option::Option<timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda> */
IMMUTABLE PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'lambda_in_wrapper';

-- extension/src/time_vector/pipeline/lambda.rs:25
-- timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::lambda_out
CREATE FUNCTION toolkit_experimental."lambda_out"(
	"input" toolkit_experimental.Lambda /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
) RETURNS cstring /* alloc::ffi::c_str::CString */
IMMUTABLE STRICT PARALLEL SAFE
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'lambda_out_wrapper';

-- extension/src/time_vector/pipeline/lambda.rs:25
-- timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda
CREATE TYPE toolkit_experimental.Lambda (
	INTERNALLENGTH = variable,
	INPUT = toolkit_experimental.lambda_in, /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::lambda_in */
	OUTPUT = toolkit_experimental.lambda_out, /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::lambda_out */
	STORAGE = extended
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:78
-- timescaledb_toolkit::countminsketch::count_min_sketch::count_min_sketch_serialize_fn_outer
CREATE FUNCTION toolkit_experimental."count_min_sketch_serialize_fn_outer"(
	"__internal" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'count_min_sketch_serialize_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:247
-- timescaledb_toolkit::gauge_agg::gauge_agg_trans_no_bounds
CREATE FUNCTION toolkit_experimental."gauge_agg_trans_no_bounds"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"val" double precision /* core::option::Option<f64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gauge_agg_trans_no_bounds_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/saturation.rs:30
-- timescaledb_toolkit::saturation::saturating_sub_pos
CREATE FUNCTION toolkit_experimental."saturating_sub_pos"(
	"x" INT, /* i32 */
	"y" INT /* i32 */
) RETURNS INT /* i32 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'saturating_sub_pos_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/lambda.rs:154
-- timescaledb_toolkit::time_vector::pipeline::lambda::trace_lambda
CREATE FUNCTION toolkit_experimental."trace_lambda"(
	"lambda" toolkit_experimental.Lambda, /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
	"time" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision /* f64 */
) RETURNS SETOF TEXT /* alloc::string::String */
STRICT STABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'trace_lambda_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/saturation.rs:40
-- timescaledb_toolkit::saturation::saturating_mul
CREATE FUNCTION toolkit_experimental."saturating_mul"(
	"x" INT, /* i32 */
	"y" INT /* i32 */
) RETURNS INT /* i32 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'saturating_mul_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/fill_to.rs:52
-- timescaledb_toolkit::time_vector::pipeline::fill_to::fill_to
CREATE FUNCTION toolkit_experimental."fill_to"(
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"fill_method" TEXT /* alloc::string::String */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'fillto_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:110
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::mod
CREATE FUNCTION toolkit_experimental."mod"(
	"rhs" double precision /* f64 */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_mod_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:90
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::mul
CREATE FUNCTION toolkit_experimental."mul"(
	"rhs" double precision /* f64 */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_mul_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:691
-- timescaledb_toolkit::time_vector::pipeline::aggregation::pipeline_percentile_agg_support
CREATE FUNCTION toolkit_experimental."pipeline_percentile_agg_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_percentile_agg_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:709
-- requires:
--   pipeline_percentile_agg_support


ALTER FUNCTION "arrow_run_pipeline_then_percentile_agg" SUPPORT toolkit_experimental.pipeline_percentile_agg_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:153
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::abs
CREATE FUNCTION toolkit_experimental."abs"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_abs_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/saturation.rs:24
-- timescaledb_toolkit::saturation::saturating_sub
CREATE FUNCTION toolkit_experimental."saturating_sub"(
	"x" INT, /* i32 */
	"y" INT /* i32 */
) RETURNS INT /* i32 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'saturating_sub_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:772
-- timescaledb_toolkit::frequency::freq_agg_text_trans
CREATE FUNCTION toolkit_experimental."freq_agg_text_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"freq" double precision, /* f64 */
	"value" text /* core::option::Option<timescaledb_toolkit::raw::text> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'freq_agg_text_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:1019
-- requires:
--   freq_agg_text_trans
--   space_saving_text_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE toolkit_experimental.freq_agg(
frequency double precision, value TEXT
) (
sfunc = toolkit_experimental.freq_agg_text_trans,
stype = internal,
finalfunc = space_saving_text_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:232
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::round
CREATE FUNCTION toolkit_experimental."round"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_round_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:78
-- timescaledb_toolkit::countminsketch::count_min_sketch::count_min_sketch_combine_fn_outer
CREATE FUNCTION toolkit_experimental."count_min_sketch_combine_fn_outer"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'count_min_sketch_combine_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/map.rs:83
-- timescaledb_toolkit::time_vector::pipeline::map::map_series
CREATE FUNCTION toolkit_experimental."map_series"(
	"function" regproc /* timescaledb_toolkit::raw::regproc */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
STRICT STABLE PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'map_series_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1135
-- timescaledb_toolkit::state_aggregate::duration_in
CREATE FUNCTION toolkit_experimental."duration_in"(
	"agg" toolkit_experimental.CompactStateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
	"state" bigint, /* i64 */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval /* timescaledb_toolkit::raw::Interval */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */
IMMUTABLE PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'duration_in_int_bad_args_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:279
-- timescaledb_toolkit::time_vector::pipeline::aggregation::average_pipeline_element
CREATE FUNCTION toolkit_experimental."average_pipeline_element"(
	"accessor" AccessorAverage /* timescaledb_toolkit::accessors::AccessorAverage */
) RETURNS toolkit_experimental.PipelineThenAverage /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenAverage */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'average_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:292
-- requires:
--   AccessorAverage
--   PipelineThenAverage
--   average_pipeline_element


CREATE CAST (AccessorAverage AS toolkit_experimental.PipelineThenAverage)
        WITH FUNCTION toolkit_experimental.average_pipeline_element
        AS IMPLICIT;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/filter.rs:6
-- timescaledb_toolkit::time_vector::pipeline::filter::filter
CREATE FUNCTION toolkit_experimental."filter"(
	"lambda" toolkit_experimental.Lambda /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'filter_lambda_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/lambda.rs:75
-- timescaledb_toolkit::time_vector::pipeline::lambda::bool_lambda
CREATE FUNCTION toolkit_experimental."bool_lambda"(
	"lambda" toolkit_experimental.Lambda, /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
	"time" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision /* f64 */
) RETURNS bool /* bool */
STRICT STABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'bool_lambda_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/sort.rs:6
-- timescaledb_toolkit::time_vector::pipeline::sort::sort
CREATE FUNCTION toolkit_experimental."sort"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'sort_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/lambda.rs:135
-- timescaledb_toolkit::time_vector::pipeline::lambda::point_lambda
CREATE FUNCTION toolkit_experimental."point_lambda"(
	"lambda" toolkit_experimental.Lambda, /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
	"time" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision /* f64 */
) RETURNS TABLE (
	"time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision  /* f64 */
)
STRICT STABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'point_lambda_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:80
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::sub
CREATE FUNCTION toolkit_experimental."sub"(
	"rhs" double precision /* f64 */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_sub_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:469
-- timescaledb_toolkit::state_aggregate::compact_state_agg::compact_state_agg_transition_fn_outer
CREATE FUNCTION toolkit_experimental."compact_state_agg_transition_fn_outer"(
	"__inner" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" TEXT /* core::option::Option<alloc::string::String> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compact_state_agg_transition_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lttb.rs:129
-- timescaledb_toolkit::lttb::gp_lttb_final
CREATE FUNCTION toolkit_experimental."gp_lttb_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS Timevector_TSTZ_F64 /* core::option::Option<timescaledb_toolkit::time_vector::Timevector_TSTZ_F64> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gp_lttb_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lttb.rs:236
-- requires:
--   lttb_trans
--   gp_lttb_final


CREATE AGGREGATE toolkit_experimental.gp_lttb(ts TIMESTAMPTZ, value DOUBLE PRECISION, resolution integer) (
sfunc = lttb_trans,
stype = internal,
finalfunc = toolkit_experimental.gp_lttb_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:436
-- timescaledb_toolkit::gauge_agg::delta
CREATE FUNCTION toolkit_experimental."delta"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* f64 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:218
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::log10
CREATE FUNCTION toolkit_experimental."log10"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_log10_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline.rs:161
-- timescaledb_toolkit::time_vector::pipeline::toolkit_pipeline_support
CREATE FUNCTION toolkit_experimental."toolkit_pipeline_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline.rs:292
-- requires:
--   pipeline_support


ALTER FUNCTION "arrow_run_pipeline" SUPPORT toolkit_experimental.toolkit_pipeline_support;
ALTER FUNCTION "arrow_add_unstable_element" SUPPORT toolkit_experimental.toolkit_pipeline_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:469
-- timescaledb_toolkit::state_aggregate::compact_state_agg::compact_state_agg_combine_fn_outer
CREATE FUNCTION toolkit_experimental."compact_state_agg_combine_fn_outer"(
	"a" internal, /* pgrx::datum::internal::Internal */
	"b" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compact_state_agg_combine_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:623
-- timescaledb_toolkit::gauge_agg::intercept
CREATE FUNCTION toolkit_experimental."intercept"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'intercept_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:326
-- timescaledb_toolkit::state_aggregate::rollup::compact_state_agg_rollup_final
CREATE FUNCTION toolkit_experimental."compact_state_agg_rollup_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS toolkit_experimental.CompactStateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compact_state_agg_rollup_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/lambda.rs:121
-- timescaledb_toolkit::time_vector::pipeline::lambda::interval_lambda
CREATE FUNCTION toolkit_experimental."interval_lambda"(
	"lambda" toolkit_experimental.Lambda, /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
	"time" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision /* f64 */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */
STRICT STABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interval_lambda_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:257
-- timescaledb_toolkit::gauge_agg::gauge_agg_summary_trans
CREATE FUNCTION toolkit_experimental."gauge_agg_summary_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"value" toolkit_experimental.GaugeSummary /* core::option::Option<timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gauge_agg_summary_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:469
-- timescaledb_toolkit::state_aggregate::compact_state_agg::compact_state_agg_deserialize_fn_outer
CREATE FUNCTION toolkit_experimental."compact_state_agg_deserialize_fn_outer"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compact_state_agg_deserialize_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:186
-- timescaledb_toolkit::time_vector::pipeline::aggregation::sum_cast
CREATE FUNCTION toolkit_experimental."sum_cast"(
	"accessor" AccessorSum /* timescaledb_toolkit::accessors::AccessorSum */
) RETURNS toolkit_experimental.PipelineThenSum /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenSum */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'sum_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:204
-- requires:
--   AccessorSum
--   PipelineThenSum
--   sum_pipeline_element


CREATE CAST (AccessorSum AS toolkit_experimental.PipelineThenSum)
        WITH FUNCTION toolkit_experimental.sum_cast
        AS IMPLICIT;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:567
-- timescaledb_toolkit::gauge_agg::extrapolated_rate
CREATE FUNCTION toolkit_experimental."extrapolated_rate"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'extrapolated_rate_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:260
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::sqrt
CREATE FUNCTION toolkit_experimental."sqrt"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_sqrt_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1169
-- timescaledb_toolkit::state_aggregate::into_int_values
CREATE FUNCTION toolkit_experimental."into_int_values"(
	"agg" toolkit_experimental.CompactStateAgg /* timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg */
) RETURNS TABLE (
	"state" bigint,  /* i64 */
	"duration" Interval  /* timescaledb_toolkit::raw::Interval */
)
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'into_int_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:809
-- timescaledb_toolkit::state_aggregate::duration_in
CREATE FUNCTION toolkit_experimental."duration_in"(
	"agg" toolkit_experimental.CompactStateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
	"state" TEXT /* alloc::string::String */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'duration_in_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/lambda.rs:92
-- timescaledb_toolkit::time_vector::pipeline::lambda::f64_lambda
CREATE FUNCTION toolkit_experimental."f64_lambda"(
	"lambda" toolkit_experimental.Lambda, /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
	"time" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision /* f64 */
) RETURNS double precision /* f64 */
STRICT STABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'f64_lambda_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:521
-- timescaledb_toolkit::gauge_agg::with_bounds
CREATE FUNCTION toolkit_experimental."with_bounds"(
	"summary" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"bounds" tstzrange /* timescaledb_toolkit::raw::tstzrange */
) RETURNS toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'with_bounds_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lttb.rs:99
-- timescaledb_toolkit::lttb::gp_lttb_trans
CREATE FUNCTION toolkit_experimental."gp_lttb_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"time" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"val" double precision, /* core::option::Option<f64> */
	"gap" Interval, /* timescaledb_toolkit::raw::Interval */
	"resolution" INT /* i32 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gp_lttb_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lttb.rs:247
-- requires:
--   gp_lttb_trans
--   gp_lttb_final


CREATE AGGREGATE toolkit_experimental.gp_lttb(ts TIMESTAMPTZ, value DOUBLE PRECISION, gapsize INTERVAL, resolution integer) (
sfunc = toolkit_experimental.gp_lttb_trans,
stype = internal,
finalfunc = toolkit_experimental.gp_lttb_final
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:469
-- timescaledb_toolkit::state_aggregate::compact_state_agg::compact_state_agg_serialize_fn_outer
CREATE FUNCTION toolkit_experimental."compact_state_agg_serialize_fn_outer"(
	"__internal" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compact_state_agg_serialize_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:818
-- timescaledb_toolkit::state_aggregate::duration_in
CREATE FUNCTION toolkit_experimental."duration_in"(
	"agg" toolkit_experimental.CompactStateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
	"state" bigint /* i64 */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */
IMMUTABLE PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'duration_in_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:148
-- timescaledb_toolkit::time_vector::pipeline::aggregation::stats_agg
CREATE FUNCTION toolkit_experimental."stats_agg"() RETURNS toolkit_experimental.PipelineThenStatsAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_stats_agg_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:78
-- timescaledb_toolkit::countminsketch::count_min_sketch::count_min_sketch_transition_fn_outer
CREATE FUNCTION toolkit_experimental."count_min_sketch_transition_fn_outer"(
	"__inner" internal, /* pgrx::datum::internal::Internal */
	"value" TEXT, /* core::option::Option<alloc::string::String> */
	"error" double precision, /* f64 */
	"probability" double precision /* f64 */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'count_min_sketch_transition_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:286
-- timescaledb_toolkit::gauge_agg::gauge_agg_combine
CREATE FUNCTION toolkit_experimental."gauge_agg_combine"(
	"state1" internal, /* pgrx::datum::internal::Internal */
	"state2" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gauge_agg_combine_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:612
-- timescaledb_toolkit::gauge_agg::slope
CREATE FUNCTION toolkit_experimental."slope"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'slope_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:181
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::ceil
CREATE FUNCTION toolkit_experimental."ceil"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_ceil_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/utilities.rs:4
-- timescaledb_toolkit::utilities::generate_periodic_normal_series
CREATE FUNCTION toolkit_experimental."generate_periodic_normal_series"(
	"series_start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"rng_seed" bigint /* core::option::Option<i64> */
) RETURNS TABLE (
	"time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision  /* f64 */
)
 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'default_generate_periodic_normal_series_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:326
-- timescaledb_toolkit::gauge_agg::gauge_agg_final
CREATE FUNCTION toolkit_experimental."gauge_agg_final"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS toolkit_experimental.GaugeSummary /* core::option::Option<timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gauge_agg_final_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:601
-- timescaledb_toolkit::gauge_agg::num_changes
CREATE FUNCTION toolkit_experimental."num_changes"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS bigint /* i64 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'num_changes_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:209
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::ln
CREATE FUNCTION toolkit_experimental."ln"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_ln_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:469
-- timescaledb_toolkit::state_aggregate::compact_state_agg::compact_state_agg_finally_fn_outer
CREATE FUNCTION toolkit_experimental."compact_state_agg_finally_fn_outer"(
	"__internal" internal /* pgrx::datum::internal::Internal */
) RETURNS toolkit_experimental.CompactStateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compact_state_agg_finally_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:469
-- requires:
--   compact_state_agg_transition_fn_outer
--   compact_state_agg_finally_fn_outer
--   compact_state_agg_serialize_fn_outer
--   compact_state_agg_deserialize_fn_outer
--   compact_state_agg_combine_fn_outer


CREATE AGGREGATE toolkit_experimental.compact_state_agg (ts timestamptz, value text) (
    stype = internal,
    sfunc = toolkit_experimental.compact_state_agg_transition_fn_outer,
    finalfunc = toolkit_experimental.compact_state_agg_finally_fn_outer,
    parallel = safe,
    serialfunc = toolkit_experimental.compact_state_agg_serialize_fn_outer,
    deserialfunc = toolkit_experimental.compact_state_agg_deserialize_fn_outer,
    combinefunc = toolkit_experimental.compact_state_agg_combine_fn_outer
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:541
-- timescaledb_toolkit::state_aggregate::compact_state_agg_int_trans
CREATE FUNCTION toolkit_experimental."compact_state_agg_int_trans"(
	"__inner" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" bigint /* core::option::Option<i64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compact_state_agg_int_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:519
-- requires:
--   compact_state_agg_int_trans
--   compact_state_agg_finally_fn_outer
--   compact_state_agg_serialize_fn_outer
--   compact_state_agg_deserialize_fn_outer
--   compact_state_agg_combine_fn_outer

CREATE AGGREGATE toolkit_experimental.compact_state_agg(
        ts timestamptz,
        value bigint
    ) (
        stype = internal,
        sfunc = toolkit_experimental.compact_state_agg_int_trans,
        finalfunc = toolkit_experimental.compact_state_agg_finally_fn_outer,
        parallel = safe,
        serialfunc = toolkit_experimental.compact_state_agg_serialize_fn_outer,
        deserialfunc = toolkit_experimental.compact_state_agg_deserialize_fn_outer,
        combinefunc = toolkit_experimental.compact_state_agg_combine_fn_outer
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:39
-- timescaledb_toolkit::time_vector::pipeline::expansion::unnest
CREATE FUNCTION toolkit_experimental."unnest"() RETURNS toolkit_experimental.PipelineThenUnnest /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineThenUnnest */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_unnest_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/saturation.rs:12
-- timescaledb_toolkit::saturation::saturating_add_pos
CREATE FUNCTION toolkit_experimental."saturating_add_pos"(
	"x" INT, /* i32 */
	"y" INT /* i32 */
) RETURNS INT /* i32 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'saturating_add_pos_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:447
-- timescaledb_toolkit::gauge_agg::rate
CREATE FUNCTION toolkit_experimental."rate"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'rate_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:572
-- timescaledb_toolkit::gauge_agg::interpolated_rate
CREATE FUNCTION toolkit_experimental."interpolated_rate"(
	"summary" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" toolkit_experimental.GaugeSummary, /* core::option::Option<timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary> */
	"next" toolkit_experimental.GaugeSummary /* core::option::Option<timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary> */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_rate_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:469
-- timescaledb_toolkit::gauge_agg::irate_left
CREATE FUNCTION toolkit_experimental."irate_left"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'irate_left_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:510
-- timescaledb_toolkit::time_vector::pipeline::aggregation::counter_agg
CREATE FUNCTION toolkit_experimental."counter_agg"() RETURNS toolkit_experimental.PipelineThenCounterAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_counter_agg_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:676
-- timescaledb_toolkit::time_vector::pipeline::aggregation::percentile_agg
CREATE FUNCTION toolkit_experimental."percentile_agg"() RETURNS toolkit_experimental.PipelineThenPercentileAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_percentile_agg_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:121
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_stats_agg
CREATE FUNCTION toolkit_experimental."finalize_with_stats_agg"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_stats_agg" toolkit_experimental.PipelineThenStatsAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg */
) RETURNS toolkit_experimental.PipelineThenStatsAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenStatsAgg */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'finalize_with_stats_agg_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:568
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_hyperloglog
CREATE FUNCTION toolkit_experimental."finalize_with_hyperloglog"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_hyperloglog" toolkit_experimental.PipelineThenHyperLogLog /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog */
) RETURNS toolkit_experimental.PipelineThenHyperLogLog /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'finalize_with_hyperloglog_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:649
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_percentile_agg
CREATE FUNCTION toolkit_experimental."finalize_with_percentile_agg"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_hyperloglog" toolkit_experimental.PipelineThenPercentileAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg */
) RETURNS toolkit_experimental.PipelineThenPercentileAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenPercentileAgg */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'finalize_with_percentile_agg_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:541
-- timescaledb_toolkit::gauge_agg::extrapolated_delta
CREATE FUNCTION toolkit_experimental."extrapolated_delta"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'extrapolated_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:100
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::div
CREATE FUNCTION toolkit_experimental."div"(
	"rhs" double precision /* f64 */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_div_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:129
-- timescaledb_toolkit::countminsketch::approx_count
CREATE FUNCTION toolkit_experimental."approx_count"(
	"item" TEXT, /* alloc::string::String */
	"aggregate" toolkit_experimental.CountMinSketch /* core::option::Option<timescaledb_toolkit::countminsketch::toolkit_experimental::CountMinSketch> */
) RETURNS bigint /* core::option::Option<i64> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'approx_count_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:505
-- timescaledb_toolkit::gauge_agg::idelta_right
CREATE FUNCTION toolkit_experimental."idelta_right"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* f64 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'idelta_right_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:189
-- timescaledb_toolkit::gauge_agg::gauge_summary_trans_serialize
CREATE FUNCTION toolkit_experimental."gauge_summary_trans_serialize"(
	"state" internal /* pgrx::datum::internal::Internal */
) RETURNS bytea /* timescaledb_toolkit::raw::bytea */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gauge_summary_trans_serialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:756
-- timescaledb_toolkit::frequency::freq_agg_bigint_trans
CREATE FUNCTION toolkit_experimental."freq_agg_bigint_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"freq" double precision, /* f64 */
	"value" bigint /* core::option::Option<i64> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'freq_agg_bigint_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:995
-- requires:
--   freq_agg_bigint_trans
--   space_saving_bigint_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE toolkit_experimental.freq_agg(
frequency double precision, value INT8
) (
sfunc = toolkit_experimental.freq_agg_bigint_trans,
stype = internal,
finalfunc = space_saving_bigint_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/utilities.rs:39
-- timescaledb_toolkit::utilities::generate_periodic_normal_series
CREATE FUNCTION toolkit_experimental."generate_periodic_normal_series"(
	"series_start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"series_len" bigint, /* core::option::Option<i64> */
	"sample_interval" bigint, /* core::option::Option<i64> */
	"base_value" double precision, /* core::option::Option<f64> */
	"period" bigint, /* core::option::Option<i64> */
	"periodic_magnitude" double precision, /* core::option::Option<f64> */
	"standard_deviation" double precision, /* core::option::Option<f64> */
	"rng_seed" bigint /* core::option::Option<i64> */
) RETURNS TABLE (
	"time" TimestampTz,  /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision  /* f64 */
)

LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'generate_periodic_normal_series_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:440
-- timescaledb_toolkit::time_vector::pipeline::aggregation::pipeline_num_vals_support
CREATE FUNCTION toolkit_experimental."pipeline_num_vals_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_num_vals_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:452
-- requires:
--   pipeline_num_vals_support


ALTER FUNCTION "arrow_pipeline_then_num_vals" SUPPORT toolkit_experimental.pipeline_num_vals_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:458
-- timescaledb_toolkit::gauge_agg::time_delta
CREATE FUNCTION toolkit_experimental."time_delta"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* f64 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'time_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:274
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::trunc
CREATE FUNCTION toolkit_experimental."trunc"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_trunc_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:483
-- timescaledb_toolkit::time_vector::pipeline::aggregation::finalize_with_counter_agg
CREATE FUNCTION toolkit_experimental."finalize_with_counter_agg"(
	"pipeline" toolkit_experimental.UnstableTimevectorPipeline, /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
	"then_counter_agg" toolkit_experimental.PipelineThenCounterAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg */
) RETURNS toolkit_experimental.PipelineThenCounterAgg /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenCounterAgg */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'finalize_with_counter_agg_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:613
-- timescaledb_toolkit::time_vector::pipeline::aggregation::pipeline_hyperloglog_support
CREATE FUNCTION toolkit_experimental."pipeline_hyperloglog_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_hyperloglog_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:631
-- requires:
--   pipeline_hyperloglog_support


ALTER FUNCTION "arrow_run_pipeline_then_hyperloglog" SUPPORT toolkit_experimental.pipeline_hyperloglog_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:135
-- timescaledb_toolkit::time_vector::to_text
CREATE FUNCTION toolkit_experimental."to_text"(
	"series" Timevector_TSTZ_F64, /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
	"format_string" TEXT /* alloc::string::String */
) RETURNS TEXT /* alloc::string::String */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'to_text_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:195
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::floor
CREATE FUNCTION toolkit_experimental."floor"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_floor_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:78
-- timescaledb_toolkit::countminsketch::count_min_sketch::count_min_sketch_finally_fn_outer
CREATE FUNCTION toolkit_experimental."count_min_sketch_finally_fn_outer"(
	"__internal" internal /* pgrx::datum::internal::Internal */
) RETURNS toolkit_experimental.CountMinSketch /* core::option::Option<timescaledb_toolkit::countminsketch::toolkit_experimental::CountMinSketch> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'count_min_sketch_finally_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:163
-- timescaledb_toolkit::time_vector::pipeline::aggregation::pipeline_stats_agg_support
CREATE FUNCTION toolkit_experimental."pipeline_stats_agg_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_stats_agg_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:178
-- requires:
--   pipeline_stats_agg_support


ALTER FUNCTION "arrow_run_pipeline_then_stats_agg" SUPPORT toolkit_experimental.pipeline_stats_agg_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/map.rs:148
-- timescaledb_toolkit::time_vector::pipeline::map::map_data
CREATE FUNCTION toolkit_experimental."map_data"(
	"function" regproc /* timescaledb_toolkit::raw::regproc */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
STRICT STABLE PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'map_data_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:648
-- timescaledb_toolkit::gauge_agg::gauge_zero_time
CREATE FUNCTION toolkit_experimental."gauge_zero_time"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS TimestampTz /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gauge_zero_time_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:167
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::cbrt
CREATE FUNCTION toolkit_experimental."cbrt"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_cbrt_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:525
-- timescaledb_toolkit::time_vector::pipeline::aggregation::pipeline_counter_agg_support
CREATE FUNCTION toolkit_experimental."pipeline_counter_agg_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_counter_agg_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:543
-- requires:
--   pipeline_counter_agg_support


ALTER FUNCTION "arrow_run_pipeline_then_counter_agg" SUPPORT toolkit_experimental.pipeline_counter_agg_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:351
-- timescaledb_toolkit::time_vector::pipeline::aggregation::pipeline_average_support
CREATE FUNCTION toolkit_experimental."pipeline_average_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_average_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:363
-- requires:
--   pipeline_average_support


ALTER FUNCTION "arrow_pipeline_then_average" SUPPORT toolkit_experimental.pipeline_average_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/delta.rs:8
-- timescaledb_toolkit::time_vector::pipeline::delta::delta_cast
CREATE FUNCTION toolkit_experimental."delta_cast"(
	"accessor" AccessorDelta /* timescaledb_toolkit::accessors::AccessorDelta */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'delta_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/delta.rs:21
-- requires:
--   delta_pipeline_element


CREATE CAST (AccessorDelta AS toolkit_experimental.UnstableTimevectorPipeline)
        WITH FUNCTION toolkit_experimental.delta_cast
        AS IMPLICIT;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:494
-- timescaledb_toolkit::gauge_agg::idelta_left
CREATE FUNCTION toolkit_experimental."idelta_left"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* f64 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'idelta_left_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:120
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::power
CREATE FUNCTION toolkit_experimental."power"(
	"rhs" double precision /* f64 */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_power_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1150
-- timescaledb_toolkit::state_aggregate::into_values
CREATE FUNCTION toolkit_experimental."into_values"(
	"agg" toolkit_experimental.CompactStateAgg /* timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg */
) RETURNS TABLE (
	"state" TEXT,  /* alloc::string::String */
	"duration" Interval  /* timescaledb_toolkit::raw::Interval */
)
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'into_values_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:597
-- timescaledb_toolkit::time_vector::pipeline::aggregation::hyperloglog
CREATE FUNCTION toolkit_experimental."hyperloglog"(
	"size" INT /* i32 */
) RETURNS toolkit_experimental.PipelineThenHyperLogLog /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenHyperLogLog */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_hyperloglog_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:196
-- timescaledb_toolkit::gauge_agg::gauge_summary_trans_deserialize
CREATE FUNCTION toolkit_experimental."gauge_summary_trans_deserialize"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gauge_summary_trans_deserialize_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:382
-- requires:
--   gauge_agg_trans_no_bounds
--   gauge_agg_final
--   gauge_agg_combine
--   gauge_summary_trans_serialize
--   gauge_summary_trans_deserialize


CREATE AGGREGATE toolkit_experimental.gauge_agg( ts timestamptz, value DOUBLE PRECISION )
(
sfunc = toolkit_experimental.gauge_agg_trans_no_bounds,
stype = internal,
finalfunc = toolkit_experimental.gauge_agg_final,
combinefunc = toolkit_experimental.gauge_agg_combine,
serialfunc = toolkit_experimental.gauge_summary_trans_serialize,
deserialfunc = toolkit_experimental.gauge_summary_trans_deserialize,
parallel = restricted
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:405
-- requires:
--   gauge_agg_summary_trans
--   gauge_agg_final
--   gauge_agg_combine
--   gauge_summary_trans_serialize
--   gauge_summary_trans_deserialize


CREATE AGGREGATE toolkit_experimental.rollup(gs toolkit_experimental.GaugeSummary)
(
sfunc = toolkit_experimental.gauge_agg_summary_trans,
stype = internal,
finalfunc = toolkit_experimental.gauge_agg_final,
combinefunc = toolkit_experimental.gauge_agg_combine,
serialfunc = toolkit_experimental.gauge_summary_trans_serialize,
deserialfunc = toolkit_experimental.gauge_summary_trans_deserialize,
parallel = restricted
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:590
-- timescaledb_toolkit::gauge_agg::num_elements
CREATE FUNCTION toolkit_experimental."num_elements"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS bigint /* i64 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'num_elements_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:634
-- timescaledb_toolkit::gauge_agg::corr
CREATE FUNCTION toolkit_experimental."corr"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'corr_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline.rs:302
-- timescaledb_toolkit::time_vector::pipeline::lttb
CREATE FUNCTION toolkit_experimental."lttb"(
	"resolution" INT /* i32 */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'lttb_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/map.rs:13
-- timescaledb_toolkit::time_vector::pipeline::map::map
CREATE FUNCTION toolkit_experimental."map"(
	"lambda" toolkit_experimental.Lambda /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'map_lambda_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:279
-- timescaledb_toolkit::state_aggregate::rollup::compact_state_agg_rollup_trans
CREATE FUNCTION toolkit_experimental."compact_state_agg_rollup_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"next" toolkit_experimental.CompactStateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'compact_state_agg_rollup_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate/rollup.rs:8
-- requires:
--   compact_state_agg_rollup_trans
--   compact_state_agg_rollup_final
--   state_agg_rollup_combine
--   state_agg_rollup_serialize
--   state_agg_rollup_deserialize
--   CompactStateAgg

CREATE AGGREGATE toolkit_experimental.rollup(
        value toolkit_experimental.CompactStateAgg
    ) (
        sfunc = toolkit_experimental.compact_state_agg_rollup_trans,
        stype = internal,
        finalfunc = toolkit_experimental.compact_state_agg_rollup_final,
        combinefunc = state_agg_rollup_combine,
        serialfunc = state_agg_rollup_serialize,
        deserialfunc = state_agg_rollup_deserialize,
        parallel = restricted
    );
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:94
-- timescaledb_toolkit::time_vector::pipeline::expansion::materialize
CREATE FUNCTION toolkit_experimental."materialize"() RETURNS toolkit_experimental.PipelineForceMaterialize /* timescaledb_toolkit::time_vector::pipeline::expansion::toolkit_experimental::PipelineForceMaterialize */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_series_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/lambda.rs:106
-- timescaledb_toolkit::time_vector::pipeline::lambda::ttz_lambda
CREATE FUNCTION toolkit_experimental."ttz_lambda"(
	"lambda" toolkit_experimental.Lambda, /* timescaledb_toolkit::time_vector::pipeline::lambda::toolkit_experimental::Lambda */
	"time" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"value" double precision /* f64 */
) RETURNS TimestampTz /* timescaledb_toolkit::raw::TimestampTz */
STRICT STABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'ttz_lambda_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:736
-- timescaledb_toolkit::frequency::freq_agg_trans
CREATE FUNCTION toolkit_experimental."freq_agg_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"freq" double precision, /* f64 */
	"value" anyelement /* core::option::Option<pgrx::datum::anyelement::AnyElement> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'freq_agg_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/frequency.rs:971
-- requires:
--   freq_agg_trans
--   space_saving_final
--   space_saving_combine
--   space_saving_serialize
--   space_saving_deserialize


CREATE AGGREGATE toolkit_experimental.raw_freq_agg(
frequency double precision, value AnyElement
) (
sfunc = toolkit_experimental.freq_agg_trans,
stype = internal,
finalfunc = space_saving_final,
combinefunc = space_saving_combine,
serialfunc = space_saving_serialize,
deserialfunc = space_saving_deserialize,
parallel = safe
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:546
-- timescaledb_toolkit::gauge_agg::interpolated_delta
CREATE FUNCTION toolkit_experimental."interpolated_delta"(
	"summary" toolkit_experimental.GaugeSummary, /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" toolkit_experimental.GaugeSummary, /* core::option::Option<timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary> */
	"next" toolkit_experimental.GaugeSummary /* core::option::Option<timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary> */
) RETURNS double precision /* f64 */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_delta_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector.rs:130
-- timescaledb_toolkit::time_vector::to_plotly
CREATE FUNCTION toolkit_experimental."to_plotly"(
	"series" Timevector_TSTZ_F64 /* timescaledb_toolkit::time_vector::Timevector_TSTZ_F64 */
) RETURNS TEXT /* alloc::string::String */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'to_plotly_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:483
-- timescaledb_toolkit::gauge_agg::irate_right
CREATE FUNCTION toolkit_experimental."irate_right"(
	"summary" toolkit_experimental.GaugeSummary /* timescaledb_toolkit::gauge_agg::toolkit_experimental::GaugeSummary */
) RETURNS double precision /* core::option::Option<f64> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'irate_right_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:988
-- timescaledb_toolkit::state_aggregate::interpolated_duration_in
CREATE FUNCTION toolkit_experimental."interpolated_duration_in"(
	"agg" toolkit_experimental.CompactStateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
	"state" TEXT, /* alloc::string::String */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" toolkit_experimental.CompactStateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_duration_in_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:259
-- timescaledb_toolkit::time_vector::pipeline::aggregation::pipeline_sum_support
CREATE FUNCTION toolkit_experimental."pipeline_sum_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_sum_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:271
-- requires:
--   pipeline_sum_support


ALTER FUNCTION "arrow_pipeline_then_sum" SUPPORT toolkit_experimental.pipeline_sum_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:70
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::add
CREATE FUNCTION toolkit_experimental."add"(
	"rhs" double precision /* f64 */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_add_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:246
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::sign
CREATE FUNCTION toolkit_experimental."sign"() RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_sign_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/arithmetic.rs:135
-- timescaledb_toolkit::time_vector::pipeline::arithmetic::logn
CREATE FUNCTION toolkit_experimental."logn"(
	"rhs" double precision /* f64 */
) RETURNS toolkit_experimental.UnstableTimevectorPipeline /* timescaledb_toolkit::time_vector::pipeline::toolkit_experimental::UnstableTimevectorPipeline */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_log_n_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1120
-- timescaledb_toolkit::state_aggregate::duration_in
CREATE FUNCTION toolkit_experimental."duration_in"(
	"agg" toolkit_experimental.CompactStateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
	"state" TEXT, /* alloc::string::String */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval /* timescaledb_toolkit::raw::Interval */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */
IMMUTABLE PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'duration_in_bad_args_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:146
-- timescaledb_toolkit::time_vector::pipeline::expansion::pipeline_materialize_support
CREATE FUNCTION toolkit_experimental."pipeline_materialize_support"(
	"input" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* pgrx::datum::internal::Internal */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'pipeline_materialize_support_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/expansion.rs:161
-- requires:
--   pipeline_materialize_support


ALTER FUNCTION "arrow_run_pipeline_then_materialize" SUPPORT toolkit_experimental.pipeline_materialize_support;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:205
-- timescaledb_toolkit::gauge_agg::gauge_agg_trans
CREATE FUNCTION toolkit_experimental."gauge_agg_trans"(
	"state" internal, /* pgrx::datum::internal::Internal */
	"ts" TimestampTz, /* core::option::Option<timescaledb_toolkit::raw::TimestampTz> */
	"val" double precision, /* core::option::Option<f64> */
	"bounds" tstzrange /* core::option::Option<timescaledb_toolkit::raw::tstzrange> */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'gauge_agg_trans_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/gauge_agg.rs:359
-- requires:
--   gauge_agg_trans
--   gauge_agg_final
--   gauge_agg_combine
--   gauge_summary_trans_serialize
--   gauge_summary_trans_deserialize


CREATE AGGREGATE toolkit_experimental.gauge_agg( ts timestamptz, value DOUBLE PRECISION, bounds tstzrange )
(
sfunc = toolkit_experimental.gauge_agg_trans,
stype = internal,
finalfunc = toolkit_experimental.gauge_agg_final,
combinefunc = toolkit_experimental.gauge_agg_combine,
serialfunc = toolkit_experimental.gauge_summary_trans_serialize,
deserialfunc = toolkit_experimental.gauge_summary_trans_deserialize,
parallel = restricted
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/state_aggregate.rs:1029
-- timescaledb_toolkit::state_aggregate::interpolated_duration_in
CREATE FUNCTION toolkit_experimental."interpolated_duration_in"(
	"agg" toolkit_experimental.CompactStateAgg, /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
	"state" bigint, /* i64 */
	"start" TimestampTz, /* timescaledb_toolkit::raw::TimestampTz */
	"interval" Interval, /* timescaledb_toolkit::raw::Interval */
	"prev" toolkit_experimental.CompactStateAgg /* core::option::Option<timescaledb_toolkit::state_aggregate::toolkit_experimental::CompactStateAgg> */
) RETURNS Interval /* timescaledb_toolkit::raw::Interval */
IMMUTABLE PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'interpolated_duration_in_int_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/saturation.rs:6
-- timescaledb_toolkit::saturation::saturating_add
CREATE FUNCTION toolkit_experimental."saturating_add"(
	"x" INT, /* i32 */
	"y" INT /* i32 */
) RETURNS INT /* i32 */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'saturating_add_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:371
-- timescaledb_toolkit::time_vector::pipeline::aggregation::num_vals_cast
CREATE FUNCTION toolkit_experimental."num_vals_cast"(
	"accessor" AccessorNumVals /* timescaledb_toolkit::accessors::AccessorNumVals */
) RETURNS toolkit_experimental.PipelineThenNumVals /* timescaledb_toolkit::time_vector::pipeline::aggregation::toolkit_experimental::PipelineThenNumVals */
IMMUTABLE STRICT PARALLEL SAFE  
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'num_vals_pipeline_element_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/time_vector/pipeline/aggregation.rs:389
-- requires:
--   AccessorNumVals
--   PipelineThenNumVals
--   num_vals_pipeline_element


CREATE CAST (AccessorNumVals AS toolkit_experimental.PipelineThenNumVals)
        WITH FUNCTION toolkit_experimental.num_vals_cast
        AS IMPLICIT;
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:78
-- timescaledb_toolkit::countminsketch::count_min_sketch::count_min_sketch_deserialize_fn_outer
CREATE FUNCTION toolkit_experimental."count_min_sketch_deserialize_fn_outer"(
	"bytes" bytea, /* timescaledb_toolkit::raw::bytea */
	"_internal" internal /* pgrx::datum::internal::Internal */
) RETURNS internal /* core::option::Option<pgrx::datum::internal::Internal> */
IMMUTABLE STRICT PARALLEL SAFE 
LANGUAGE c /* Rust */
AS '$libdir/timescaledb_toolkit-1.19.0', 'count_min_sketch_deserialize_fn_outer_wrapper';
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/countminsketch.rs:78
-- requires:
--   count_min_sketch_transition_fn_outer
--   count_min_sketch_finally_fn_outer
--   count_min_sketch_serialize_fn_outer
--   count_min_sketch_deserialize_fn_outer
--   count_min_sketch_combine_fn_outer


CREATE AGGREGATE toolkit_experimental.count_min_sketch (value text, error float, probability float) (
    stype = internal,
    sfunc = toolkit_experimental.count_min_sketch_transition_fn_outer,
    finalfunc = toolkit_experimental.count_min_sketch_finally_fn_outer,
    parallel = safe,
    serialfunc = toolkit_experimental.count_min_sketch_serialize_fn_outer,
    deserialfunc = toolkit_experimental.count_min_sketch_deserialize_fn_outer,
    combinefunc = toolkit_experimental.count_min_sketch_combine_fn_outer
);
/* </end connected objects> */

/* <begin connected objects> */
-- extension/src/lib.rs:62
-- finalize
GRANT USAGE ON SCHEMA toolkit_experimental TO PUBLIC;
/* </end connected objects> */

