SET search_path TO apl;

CREATE OR REPLACE FUNCTION el_merge_witnesses(integer, uuid, uuid[]) RETURNS SETOF el_object_info
    LANGUAGE plpgsql
    AS $_$
DECLARE
   event_id         ALIAS FOR $1;
   obj_id           ALIAS FOR $2;
   witnesses_       ALIAS FOR $3;
   witnesses        uuid[];
   merged_witnesses text[];
   result           EL_Object_Info;
BEGIN

-- postgres 8.1.x requires this
IF witnesses_ IS NULL THEN
   witnesses = ARRAY[obj_id];
ELSE
   witnesses = witnesses_;
END IF;

merged_witnesses := (SELECT COALESCE(
                              string_to_array(replace(val, ' ', ''), ','), -- just for case removing spaces between comas
                              CAST(ARRAY[obj_id] as text[]) -- if previous expression is NULL keep array of original obj_id.
                            ) || CAST(witnesses AS text[]) || CAST(ARRAY[obj_id] as text[]) -- adding objid of event to witnesses too
                    FROM _obj_attr
                    WHERE obj=obj_id AND attr='ASSOCIATE');

UPDATE event set witness = (SELECT array_agg(DISTINCT witness) FROM (
   (SELECT unnest(merged_witnesses::uuid[]) witness) UNION (SELECT unnest(witness) witness FROM event where eventid = event_id)
) as wit_array) where eventid = event_id;

IF FOUND THEN

  FOR result in
      SELECT o.obj, o.name, o.type, o.otype, o.subtype, COALESCE(a1.val, 'UTC') as tz, 0, '0' as vl_rate
        FROM (SELECT eventid, unnest(witness) objid FROM event) w
       INNER JOIN _objs o ON o.obj = w.objid
        LEFT OUTER JOIN _obj_attr a1 ON a1.obj=o.obj AND a1.attr='TIME_ZONE'
       WHERE w.eventid = event_id
  LOOP
     RETURN NEXT result;
  END LOOP;
END IF;

RETURN;

END
$_$;

