SET search_path TO confdb;

-------------------------------------------------------------------
----- watchlist_types

CREATE TABLE vae_configs ( 
    obj_id              UUID    REFERENCES _objs(obj),
    vae_config_name     VARCHAR,
    vae_config_descr    VARCHAR NOT NULL,
    engine              VARCHAR NOT NULL,
    config              JSON    NOT NULL,
    updated_at          TIMESTAMP WITHOUT TIME ZONE DEFAULT (now() AT TIME ZONE 'UTC'),
    PRIMARY KEY (obj_id, vae_config_name)
);

REVOKE ALL ON TABLE vae_configs FROM PUBLIC;
GRANT SELECT,INSERT,UPDATE,DELETE ON TABLE vae_configs TO apl;

-------------------------------------------------------------------
----- public interface

SET search_path TO apl;

CREATE OR REPLACE VIEW vae_configs AS SELECT * FROM confdb.vae_configs;
REVOKE ALL ON TABLE vae_configs FROM PUBLIC;
GRANT SELECT,INSERT,UPDATE,DELETE ON TABLE vae_configs TO apl;
