SET search_path = confdb, pg_catalog;

--
-- Data for Name: objtype; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('D', 'C', 'Camera', 'camera', true, 'All Cameras');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('D', 'R', 'Relay', 'relay', true, 'All Relays');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('D', 'S', 'Sensor', 'sensor_skm', true, 'All Sensors');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('D', 'A', 'Audio Source', 'audio', true, 'All Audio');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('D', 'V', 'vMX Monitor', 'monitor', true, 'All vMX Monitors');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('D', 'W', 'vMX Wall', 'wall', true, 'All vMX Walls');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('D', 'E', 'External device', 'external', true, 'All External devices');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('D', 'N', 'Node', 'node', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('G', '*', 'GUI', 'gui', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('G', 'C', 'Matrix configuration', 'configuration', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('G', 'L', 'vMX layout', 'vmxlayout', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('M', '3', '3D model', 'model3d', true, 'All 3D models');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('M', 'L', 'Layer model', 'modellayer', true, 'All layer models');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('S', '*', 'Set', 'set', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('R', '*', 'Role', 'role', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('U', '*', 'User', 'user', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('X', 'G', 'Gateway', 'gateway', true, 'All Gateways');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('X', 'S', 'Access Control Sensor', 'sensor_acsg', true, 'All vAC Sensors');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('X', 'D', 'Door', 'door', true, 'All vAC Doors');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('X', 'P', 'Perimeter', 'perimeter', true, 'All vAC Perimeters');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('X', 'A', 'Area', 'area', true, 'All vAC Areas');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('X', 'R', 'RFID', 'rfid', true, 'All RFIDs');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('T', 'P', 'Posture', 'posture', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('T', 'T', 'Timecard', 'timecard', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('T', 'S', 'Schedule', 'schedule', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('G', 'V', 'Matrix GUI view', 'view', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('M', 'V', 'Viewpoint location', 'location', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('V', '*', 'Avatar', 'avatar', true, 'All Avatars');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('E', '*', 'Realm', 'realm', false, '');
INSERT INTO objtype(otype, subtype, name, type, issystemset, setname) VALUES ('P', '*', 'Storage pool', 'storagepool', false, '');


--
-- Data for Name: _cred_types; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO _cred_types VALUES ('S', 'camera', 'Setup', 'Device Setup Settings');
INSERT INTO _cred_types VALUES ('L', 'camera', 'Live', 'Live Access');
INSERT INTO _cred_types VALUES ('A', 'camera', 'Archive', 'Archive Access');
INSERT INTO _cred_types VALUES ('C', 'camera', 'Control', 'Control Device');
INSERT INTO _cred_types VALUES ('P', 'camera', 'PTZ:Mng', 'Camera PTZ: Manage');
INSERT INTO _cred_types VALUES ('p', 'camera', 'PTZ:Use', 'Camera PTZ: Control');
INSERT INTO _cred_types VALUES ('v', 'camera', 'EL:View', 'Event Log: View/Query');
INSERT INTO _cred_types VALUES ('a', 'camera', 'EL:Add', 'Event Log: Add Record');
INSERT INTO _cred_types VALUES ('e', 'camera', 'EL:Edit', 'Event Log: Edit Record');
INSERT INTO _cred_types VALUES ('I', 'camera', 'Email', 'Email on Event');
INSERT INTO _cred_types VALUES ('F', 'camera', 'Device management', 'Full device management');
INSERT INTO _cred_types VALUES ('f', 'camera', 'Device settings', 'Device settings management');
INSERT INTO _cred_types VALUES ('R', 'camera', 'Device policy', 'Device policy management');
INSERT INTO _cred_types VALUES ('E', 'camera', 'Camera analytics', 'Camera analytics management');
INSERT INTO _cred_types VALUES ('D', 'camera', 'Download', 'Download AVI clip');
INSERT INTO _cred_types VALUES ('s', 'gui', 'Setup', 'GUI Setup Settings');
INSERT INTO _cred_types VALUES ('V', 'gui', 'View', 'Open GUI for View');
INSERT INTO _cred_types VALUES ('M', 'monitor', 'vMX:Mon', 'Manipulate vMX Monitors');
INSERT INTO _cred_types VALUES ('m', 'wall', 'vMX:MngCfg', 'Manage saved vMX configs');
INSERT INTO _cred_types VALUES ('r', 'wall', 'vMX:Recall', 'Recall saved vMX configs');
INSERT INTO _cred_types VALUES ('C', 'gateway', 'Control', 'Control Device');
INSERT INTO _cred_types VALUES ('v', 'sensor_acsg', 'EL:View', 'Event Log: View/Query');
INSERT INTO _cred_types VALUES ('a', 'sensor_acsg', 'EL:Add', 'Event Log: Add Record');
INSERT INTO _cred_types VALUES ('e', 'sensor_acsg', 'EL:Edit', 'Event Log: Edit Record');
INSERT INTO _cred_types VALUES ('I', 'gateway', 'Email', 'Email on Event');
INSERT INTO _cred_types VALUES ('x', 'avatar', 'Avatar Profile', 'Change Avatar Profile');
INSERT INTO _cred_types VALUES ('z', 'avatar', 'Avatar Profile', 'Change current Avatar Profile');
INSERT INTO _cred_types VALUES ('u', 'user', 'User management', 'Manage Users');
INSERT INTO _cred_types VALUES ('U', 'user', 'Access management', 'Manage Roles/Sets/Users');
INSERT INTO _cred_types VALUES ('U', 'role', 'Access management', 'Manage Roles/Sets/Users');
INSERT INTO _cred_types VALUES ('U', 'set', 'Access management', 'Manage Roles/Sets/Users');

--
-- Data for Name: _link_types; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO _link_types VALUES ('camera2set', 'camera', 'set', 'Camera to Set');
INSERT INTO _link_types VALUES ('set2role', 'set', 'role', 'Set to Role');
INSERT INTO _link_types VALUES ('user2role', 'user', 'role', 'User to Role');
INSERT INTO _link_types VALUES ('model3d2set', 'model3d', 'set', 'Model to Set');
INSERT INTO _link_types VALUES ('avatar2set', 'avatar', 'set', 'Avatar to Set');


--
-- Data for Name: _objs; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000054', 'realm', 'Default Realm', 'Default realm', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000005', 'set', 'vMX Walls', 'All vMX Walls', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000001', 'set', 'All Relays', 'All Relays', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000008', 'set', 'vAC Sensors', 'All vAC Sensors', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000003', 'set', 'All Audio', 'All Audio', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000009', 'set', 'vAC Doors', 'All vAC Doors', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000010', 'set', 'vAC Perimeters', 'All vAC Perimeters', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000006', 'set', 'All External devices', 'All External devices', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000011', 'set', 'vAC Areas', 'All vAC Areas', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000007', 'set', 'All Gateways', 'All Gateways', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000002', 'set', 'All Sensors', 'All Sensors', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000017', 'set', 'Mobile cameras', 'All mobile cameras', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000014', 'set', 'All Cameras', 'All Cameras', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000018', 'set', 'All Avatars', 'All Avatars', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000015', 'set', 'All 3D models', 'All 3D models', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000016', 'set', 'All layer models', 'All layer models', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000099', 'set', 'my set', 'Default set', 0);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000019', 'set', 'All RFIDs', 'All RFIDs', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000021', 'user', 'admin', 'Administrator', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000022', 'user', 'realmadmin', 'Realm administrator', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000023', 'user', 'system', 'internal', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000031', 'role', 'Admin role', 'Admin role', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000032', 'role', 'Viewer role', 'Viewer role', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000033', 'role', 'Operator role', 'Operator role', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000034', 'role', 'Manager role', 'Manager role', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000035', 'role', 'Realm admin role', 'Realm admin role', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000053', 'gui', 'Identity', 'System attributes', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000004', 'set', 'vMX Monitors', 'All vMX Monitors', 1);
INSERT INTO _objs(realm, obj, type, name, description, protected) VALUES ('00000000-0000-0000-0000-000000000054', '00000000-0000-0000-0000-000000000055', 'storagepool', 'Default Pool', 'Default storage pool', 1);

--
-- Data for Name: permission_type; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO permission_type VALUES ('V', 'LVv', 'View');
INSERT INTO permission_type VALUES ('M', 'LVvApaeDMrCSPsmx', 'Manage');
INSERT INTO permission_type VALUES ('C', 'LVvApaeDMrCz', 'Control');


--
-- Data for Name: _links; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000001', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000002', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000003', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000004', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000005', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000006', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000007', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000008', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000009', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000010', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000011', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000014', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000015', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000016', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000099', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 0);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000099', '00000000-0000-0000-0000-000000000032', 'S2R', 'V', '', 0);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000099', '00000000-0000-0000-0000-000000000033', 'S2R', 'C', '', 0);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000099', '00000000-0000-0000-0000-000000000034', 'S2R', 'M', '', 0);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000021', '00000000-0000-0000-0000-000000000031', 'U2R', NULL, '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000022', '00000000-0000-0000-0000-000000000035', 'U2R', NULL, '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000023', '00000000-0000-0000-0000-000000000031', 'U2R', NULL, '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000017', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000018', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);
INSERT INTO _links VALUES ('00000000-0000-0000-0000-000000000019', '00000000-0000-0000-0000-000000000031', 'S2R', 'M', '', 1);

--
-- Data for Name: _obj_attr; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000001', 'NAME', 'All Relays');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000001', 'DESCRIPTION', 'All Relays');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000003', 'NAME', 'All Audio');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000003', 'DESCRIPTION', 'All Audio');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000006', 'NAME', 'All External devices');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000006', 'DESCRIPTION', 'All External devices');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000007', 'NAME', 'All Gateways');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000007', 'DESCRIPTION', 'All Gateways');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000014', 'NAME', 'All Cameras');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000014', 'DESCRIPTION', 'All Cameras');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000015', 'NAME', 'All 3D models');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000015', 'DESCRIPTION', 'All 3D models');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000016', 'NAME', 'All layer models');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000016', 'DESCRIPTION', 'All layer models');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000099', 'NAME', 'my set');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000099', 'DESCRIPTION', 'Default set');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'NAME', 'admin');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'DESCRIPTION', 'Administrator');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'DEFAULT_ROLE', '00000000-0000-0000-0000-000000000031');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'LANGUAGE', 'en_US');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'EMAIL', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'EMAIL_INTERVAL', '1');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'WARN_VIDEO_PLAYERS', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'MAX_VIDEO_PLAYERS', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'PASSWORD', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000021', 'PKI_DN', 'C=US');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'NAME', 'realmadmin');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'DESCRIPTION', 'Realm administrator');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'DEFAULT_ROLE', '00000000-0000-0000-0000-000000000035');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'LANGUAGE', 'en_US');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'EMAIL', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'EMAIL_INTERVAL', '1');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'WARN_VIDEO_PLAYERS', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'MAX_VIDEO_PLAYERS', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000022', 'PASSWORD', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000031', 'NAME', 'Admin role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000031', 'DESCRIPTION', 'Admin role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000031', 'PTZ_PRIORITY', '9');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000031', 'IS_ADMIN_ROLE', '1');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000032', 'NAME', 'Viewer Role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000032', 'DESCRIPTION', 'Viewer role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000032', 'PTZ_PRIORITY', '3');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000032', 'IS_ADMIN_ROLE', '0');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000033', 'NAME', 'Operator Role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000033', 'DESCRIPTION', 'Operator role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000033', 'PTZ_PRIORITY', '5');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000033', 'IS_ADMIN_ROLE', '0');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000034', 'NAME', 'Manager Role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000034', 'DESCRIPTION', 'Manager role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000034', 'PTZ_PRIORITY', '7');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000034', 'IS_ADMIN_ROLE', '0');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000035', 'NAME', 'Realm admin role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000035', 'DESCRIPTION', 'Realm admin role');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000035', 'PTZ_PRIORITY', '9');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000035', 'IS_ADMIN_ROLE', '1');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000035', 'IS_REALM_ADMIN_ROLE', '1');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000053', 'URL', '/sdi/admin/#identity');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000004', 'NAME', 'vMX Monitors');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000004', 'DESCRIPTION', 'All vMX Monitors');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000005', 'NAME', 'vMX Walls');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000005', 'DESCRIPTION', 'All vMX Walls');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000008', 'NAME', 'vAC Sensors');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000008', 'DESCRIPTION', 'All vAC Sensors');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000009', 'NAME', 'vAC Doors');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000009', 'DESCRIPTION', 'All vAC Doors');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000010', 'NAME', 'vAC Perimeters');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000010', 'DESCRIPTION', 'All vAC Perimeters');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000011', 'NAME', 'vAC Areas');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000011', 'DESCRIPTION', 'All vAC Areas');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000002', 'NAME', 'All Sensors');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000002', 'DESCRIPTION', 'All Sensors');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000017', 'NAME', 'Mobile cameras');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000017', 'DESCRIPTION', 'All mobile cameras');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000018', 'NAME', 'All Avatars');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000018', 'DESCRIPTION', 'All Avatars');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000019', 'NAME', 'All RFIDs');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000019', 'DESCRIPTION', 'All RFIDs');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000054', 'NAME', 'Realm');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000054', 'DESCRIPTION', 'Default realm');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000054', 'OWNER', '00000000-0000-0000-0000-000000000021');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000055', 'NAME', 'Default Pool');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000055', 'DESCRIPTION', 'Default storage pool');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000055', 'FEATURES', '{"storage-gb":"99999", "stream-gb":"99999"}');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000055', 'TTL', '24');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000055', 'STORAGE_BUCKET', '');
INSERT INTO _obj_attr VALUES ('00000000-0000-0000-0000-000000000054', 'ENTITLEMENT', '{
    "type": "Realm entitlement",
    "version": "1.0",
    "subscription": {
        "status": "active",
        "expireWarn": "2017-03-10"
    },
    "overcast": {
        "support": 1.25,
        "features": [
            { "feature": "vae-ov5", "unitsSubscribed": 99 },
            { "feature": "vmx-channels", "unitsSubscribed": 99 },
            { "feature": "vmx-monitors", "unitsSubscribed": 99 },
            { "feature": "vae-vca", "unitsSubscribed": 99 },
            { "feature": "vae-facial1", "unitsSubscribed": 99 },
            { "feature": "avatars", "unitsSubscribed": 99 }
        ],
        "storagePools": [
            {
                "displayName": "Default pool",
                "id": "00000000-0000-0000-0000-000000000055",
                "ttlHrs": 720,
                "inboundRatio": 0.10,
                "outboundRatio": 0.05,
                "features": [
                    { "feature": "camera", "unitsSubscribed": 9999 },
                    { "feature": "storage-gb", "unitsSubscribed": 9999 },
                    { "feature": "stream-gb", "unitsSubscribed": 9999 },
                    { "feature": "mobile-cams", "unitsSubscribed": 9999 }
                ]
            }
        ]
  }
}');


--
-- Data for Name: eventlifespan; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventlifespan VALUES (0, 'Transient', '');
INSERT INTO eventlifespan VALUES (1, 'Persisted', '');


--
-- Data for Name: eventpolicy; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventpolicy VALUES (1, 'Default policy', '', true);
INSERT INTO eventpolicy VALUES (2, 'Default policy for mobile devices', '', true);


--
-- Data for Name: eventsource; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventsource VALUES (1, 'Motion detector', '');
INSERT INTO eventsource VALUES (2, 'Camera Motion detector', '');
INSERT INTO eventsource VALUES (3, 'Sensor', '');
INSERT INTO eventsource VALUES (4, 'User', '');
INSERT INTO eventsource VALUES (5, 'Access Control System', '');
INSERT INTO eventsource VALUES (6, 'Analytics', '');
INSERT INTO eventsource VALUES (7, 'Interview', '');


--
-- Data for Name: workflow; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO workflow VALUES (1, 'Simple Alert + merge', 'Two state (new/cleared) workflow', '<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow">
  <state id="empty">
    <transition event="create">
      <target next="new"/>
    </transition>
  </state>

  <state id="new">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is new" tags="3,5,10,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>
    <transition event="update">
      <target next="cleared"/>
    </transition>
    <transition event="ack">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,5,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>

    <transition event="update">
      <target next="cleared"/>
    </transition>
  </state>
</scxml>', true, false);
INSERT INTO workflow VALUES (2, 'Simple Info / no merge', 'Single state workflow', '<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow">
  <state id="empty">
    <transition event="create">
      <target next="new"/>
    </transition>
  </state>

  <state id="new">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="New" tags="4,5,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>

    <transition event="update">
      <target next="new"/>
    </transition>
  </state>
</scxml>', true, false);
INSERT INTO workflow VALUES (3, 'ACSG + merge', '', '<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow">
  <state id="empty">
    <transition event="create">
      <target next="new-updated"/>
    </transition>
  </state>

  <state id="new-updated">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is new or recently updated" tags="3,5,6,7,10,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>
    <onexit>
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>
    <transition event="sys-ontimer">
      <target next="timeout"/>
    </transition>
    <transition event="announce">
      <target next="announced"/>
    </transition>
    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="timeout">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event did not get acknowledged within required period of time" tags="2,3,5,6,7,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>

    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="announced">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event notification delivered to operator" tags="3,5,6,7,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>

    <transition event="raise-priority">
      <target next="new-updated"/>
    </transition>
    <transition event="ontimer">
      <target next="timeout"/>
    </transition>
    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="assessed">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is assessed (acknowledgement received)" tags="4,5,6,7"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
      <send target="elog_actions" targettype="x-runtime" event="eada"/>
    </onentry>
    <onexit>
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>

    <transition event="raise-priority">
      <target next="new-updated"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>

    <transition event="update">
      <target next="cleared"/>
    </transition>
  </state>
</scxml>', true, false);
INSERT INTO workflow VALUES (4, 'ACSG / no merge', '', '<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow">
  <state id="empty">
    <transition event="create">
      <target next="new-updated"/>
    </transition>
  </state>

  <state id="new-updated">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is new or recently updated" tags="3,5,6,7,10,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>
    <transition event="sys-ontimer">
      <target next="timeout"/>
    </transition>
    <transition event="announce">
      <target next="announced"/>
    </transition>
    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="timeout">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event did not get acknowledged within required period of time" tags="2,3,5,6,7,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>

    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="announced">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event notification delivered to operator" tags="3,5,6,7,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>

    <transition event="raise-priority">
      <target next="new-updated"/>
    </transition>
    <transition event="ontimer">
      <target next="timeout"/>
    </transition>
    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="assessed">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is assessed (acknowledgement received)" tags="4,5,6,7"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
      <send target="elog_actions" targettype="x-runtime" event="eada"/>
    </onentry>
    <onexit>
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>

    <transition event="raise-priority">
      <target next="new-updated"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>

    <transition event="update">
      <target next="cleared"/>
    </transition>
  </state>
</scxml>', true, false);
INSERT INTO workflow VALUES (5, 'Simple Alert / no merge', 'Two state (new/cleared) workflow', '<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow">
  <state id="empty">
    <transition event="create">
      <target next="new"/>
    </transition>
  </state>

  <state id="new">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is new" tags="3,5,10,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <transition event="update">
      <target next="cleared"/>
    </transition>
    <transition event="ack">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,5,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>

    <transition event="update">
      <target next="cleared"/>
    </transition>
  </state>
</scxml>', true, false);
INSERT INTO workflow VALUES (6, 'Simple Info + merge', 'Single state workflow with event merge', '<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow">
  <state id="empty">
    <transition event="create">
      <target next="new"/>
    </transition>
  </state>

  <state id="new">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="New" tags="4,5,8"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>

    <transition event="update">
      <target next="new"/>
    </transition>
  </state>
</scxml>', true, false);
INSERT INTO workflow VALUES (7, 'Analytic workflow', 'Analytic workflow with event merge', '<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow">
  <state id="empty">
    <transition event="create" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="create" target="red"/>
  </state>

  <state id="red">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Red" tags="4,5,7,10,11"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FF0000" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>
    <transition event="update" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="update" target="red"/>
    <transition event="clear" target="cleared"/>
  </state>

  <state id="yellow">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Yellow" tags="4,5,7,10"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FFFF00" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>
    <transition event="update" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="update" target="red"/>
    <transition event="clear" target="cleared"/>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,5,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FFFFFF" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <transition event="update" target="cleared"/>
  </state>
</scxml>
', true, false);


--
-- Data for Name: eventsourceworkflow; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventsourceworkflow VALUES (1, 1);
INSERT INTO eventsourceworkflow VALUES (2, 1);
INSERT INTO eventsourceworkflow VALUES (3, 1);
INSERT INTO eventsourceworkflow VALUES (4, 1);
INSERT INTO eventsourceworkflow VALUES (5, 1);
INSERT INTO eventsourceworkflow VALUES (6, 1);
INSERT INTO eventsourceworkflow VALUES (1, 2);
INSERT INTO eventsourceworkflow VALUES (2, 2);
INSERT INTO eventsourceworkflow VALUES (3, 2);
INSERT INTO eventsourceworkflow VALUES (4, 2);
INSERT INTO eventsourceworkflow VALUES (5, 2);
INSERT INTO eventsourceworkflow VALUES (6, 2);
INSERT INTO eventsourceworkflow VALUES (1, 3);
INSERT INTO eventsourceworkflow VALUES (2, 3);
INSERT INTO eventsourceworkflow VALUES (3, 3);
INSERT INTO eventsourceworkflow VALUES (4, 3);
INSERT INTO eventsourceworkflow VALUES (5, 3);
INSERT INTO eventsourceworkflow VALUES (6, 3);
INSERT INTO eventsourceworkflow VALUES (1, 4);
INSERT INTO eventsourceworkflow VALUES (2, 4);
INSERT INTO eventsourceworkflow VALUES (3, 4);
INSERT INTO eventsourceworkflow VALUES (4, 4);
INSERT INTO eventsourceworkflow VALUES (5, 4);
INSERT INTO eventsourceworkflow VALUES (6, 4);
INSERT INTO eventsourceworkflow VALUES (1, 5);
INSERT INTO eventsourceworkflow VALUES (2, 5);
INSERT INTO eventsourceworkflow VALUES (3, 5);
INSERT INTO eventsourceworkflow VALUES (4, 5);
INSERT INTO eventsourceworkflow VALUES (5, 5);
INSERT INTO eventsourceworkflow VALUES (6, 5);
INSERT INTO eventsourceworkflow VALUES (1, 6);
INSERT INTO eventsourceworkflow VALUES (2, 6);
INSERT INTO eventsourceworkflow VALUES (3, 6);
INSERT INTO eventsourceworkflow VALUES (4, 6);
INSERT INTO eventsourceworkflow VALUES (5, 6);
INSERT INTO eventsourceworkflow VALUES (6, 6);
INSERT INTO eventsourceworkflow VALUES (6, 7);
INSERT INTO eventsourceworkflow VALUES (7, 2);
INSERT INTO eventsourceworkflow VALUES (7, 1);
INSERT INTO eventsourceworkflow VALUES (7, 3);
INSERT INTO eventsourceworkflow VALUES (7, 4);
INSERT INTO eventsourceworkflow VALUES (7, 5);
INSERT INTO eventsourceworkflow VALUES (7, 6);


--
-- Data for Name: eventpolicycontent; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventpolicycontent VALUES (1, 4, 5, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (1, 5, 4, 2, 'priority=2|eventtype=1|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (2, 5, 4, 2, 'priority=2|eventtype=1|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (2, 6, 5, 2, 'priority=2|eventtype=1|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (1, 1, 1, 6, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (1, 2, 1, 6, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (1, 3, 5, 6, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (2, 1, 1, 6, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (2, 2, 1, 6, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (2, 3, 5, 6, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (2, 4, 1, 6, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (1, 6, 7, 2, 'priority=2|eventtype=1|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (1, 7, 1, 6, 'priority=2|eventtype=1|preevent=5|postevent=15');
INSERT INTO eventpolicycontent VALUES (2, 7, 1, 6, 'priority=2|eventtype=0|preevent=5|postevent=15');


--
-- Data for Name: eventpriority; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventpriority VALUES (4, 'Critical', 'Critical Priority', 'Red', '#FF0000');
INSERT INTO eventpriority VALUES (3, 'High', 'High priority', 'Orange', '#F88017');
INSERT INTO eventpriority VALUES (2, 'Normal', 'Normal Priority', 'Yellow', '#FFFF00');
INSERT INTO eventpriority VALUES (1, 'Low', 'Low Priority', 'Green', '#00FF00');


--
-- Data for Name: eventpropertydef; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventpropertydef VALUES ('MIGRATE', 'Event migration flag: 0-not migrate, 1-migrate, 2-migrated');
INSERT INTO eventpropertydef VALUES ('ACS_EVENTID', 'Id of event assigned by Access Control System');
INSERT INTO eventpropertydef VALUES ('USERID', 'Objid of user who created event');


--
-- Data for Name: eventstate; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventstate VALUES (1, 1, 'new', 'New', NULL, NULL);
INSERT INTO eventstate VALUES (2, 1, 'cleared', 'Cleared', NULL, NULL);
INSERT INTO eventstate VALUES (3, 2, 'new', 'New', NULL, NULL);
INSERT INTO eventstate VALUES (4, 3, 'new-updated', 'New/Updated', NULL, NULL);
INSERT INTO eventstate VALUES (5, 3, 'timeout', 'Event did not get acknowledged within required period of time', NULL, NULL);
INSERT INTO eventstate VALUES (6, 3, 'announced', 'Event notification delivered to operator', NULL, NULL);
INSERT INTO eventstate VALUES (7, 3, 'assessed', 'Event is assessed (acknowledgement received)', NULL, NULL);
INSERT INTO eventstate VALUES (8, 3, 'cleared', 'Cleared', NULL, NULL);
INSERT INTO eventstate VALUES (9, 4, 'new-updated', 'New/Updated', NULL, NULL);
INSERT INTO eventstate VALUES (10, 4, 'announced', 'Event notification delivered to operator', NULL, NULL);
INSERT INTO eventstate VALUES (11, 4, 'timeout', 'Event did not get acknowledged within required period of time', NULL, NULL);
INSERT INTO eventstate VALUES (12, 4, 'assessed', 'Event is assessed (acknowledgement received)', NULL, NULL);
INSERT INTO eventstate VALUES (13, 4, 'cleared', 'Cleared', NULL, NULL);
INSERT INTO eventstate VALUES (14, 5, 'new', 'New', NULL, NULL);
INSERT INTO eventstate VALUES (15, 5, 'cleared', 'Cleared', NULL, NULL);
INSERT INTO eventstate VALUES (16, 6, 'new', 'New', NULL, NULL);
INSERT INTO eventstate VALUES (17, 7, 'red', 'Red', NULL, NULL);
INSERT INTO eventstate VALUES (18, 7, 'yellow', 'Yellow', NULL, NULL);
INSERT INTO eventstate VALUES (19, 7, 'cleared', 'Cleared', NULL, NULL);


--
-- Data for Name: eventtag; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventtag VALUES (1, 'Needs announcement confirmation', '');
INSERT INTO eventtag VALUES (2, 'Needs supervisor attention', '');
INSERT INTO eventtag VALUES (3, 'Requires Acknowledgment', '');
INSERT INTO eventtag VALUES (4, 'Acknowledged', '');
INSERT INTO eventtag VALUES (5, 'Updatable', '');
INSERT INTO eventtag VALUES (6, 'EADA enabled', '');
INSERT INTO eventtag VALUES (7, 'Clearable', '');
INSERT INTO eventtag VALUES (8, 'Cleared', '');
INSERT INTO eventtag VALUES (9, 'Final state', '');
INSERT INTO eventtag VALUES (10, 'GUI pop up', '');
INSERT INTO eventtag VALUES (11, 'Marked', 'Event displays with red background');


--
-- Data for Name: eventstatetag; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventstatetag VALUES (1, 3);
INSERT INTO eventstatetag VALUES (1, 5);
INSERT INTO eventstatetag VALUES (1, 10);
INSERT INTO eventstatetag VALUES (1, 11);
INSERT INTO eventstatetag VALUES (2, 4);
INSERT INTO eventstatetag VALUES (2, 5);
INSERT INTO eventstatetag VALUES (2, 8);
INSERT INTO eventstatetag VALUES (2, 9);
INSERT INTO eventstatetag VALUES (3, 5);
INSERT INTO eventstatetag VALUES (3, 8);
INSERT INTO eventstatetag VALUES (3, 9);
INSERT INTO eventstatetag VALUES (3, 4);
INSERT INTO eventstatetag VALUES (4, 3);
INSERT INTO eventstatetag VALUES (4, 5);
INSERT INTO eventstatetag VALUES (4, 6);
INSERT INTO eventstatetag VALUES (4, 7);
INSERT INTO eventstatetag VALUES (4, 10);
INSERT INTO eventstatetag VALUES (4, 11);
INSERT INTO eventstatetag VALUES (5, 2);
INSERT INTO eventstatetag VALUES (5, 3);
INSERT INTO eventstatetag VALUES (5, 5);
INSERT INTO eventstatetag VALUES (5, 6);
INSERT INTO eventstatetag VALUES (5, 7);
INSERT INTO eventstatetag VALUES (5, 11);
INSERT INTO eventstatetag VALUES (6, 3);
INSERT INTO eventstatetag VALUES (6, 5);
INSERT INTO eventstatetag VALUES (6, 6);
INSERT INTO eventstatetag VALUES (6, 7);
INSERT INTO eventstatetag VALUES (6, 11);
INSERT INTO eventstatetag VALUES (7, 4);
INSERT INTO eventstatetag VALUES (7, 5);
INSERT INTO eventstatetag VALUES (7, 6);
INSERT INTO eventstatetag VALUES (7, 7);
INSERT INTO eventstatetag VALUES (8, 4);
INSERT INTO eventstatetag VALUES (8, 8);
INSERT INTO eventstatetag VALUES (8, 9);
INSERT INTO eventstatetag VALUES (9, 3);
INSERT INTO eventstatetag VALUES (9, 5);
INSERT INTO eventstatetag VALUES (9, 6);
INSERT INTO eventstatetag VALUES (9, 7);
INSERT INTO eventstatetag VALUES (9, 10);
INSERT INTO eventstatetag VALUES (9, 11);
INSERT INTO eventstatetag VALUES (10, 3);
INSERT INTO eventstatetag VALUES (10, 5);
INSERT INTO eventstatetag VALUES (10, 6);
INSERT INTO eventstatetag VALUES (10, 7);
INSERT INTO eventstatetag VALUES (10, 11);
INSERT INTO eventstatetag VALUES (11, 2);
INSERT INTO eventstatetag VALUES (11, 3);
INSERT INTO eventstatetag VALUES (11, 5);
INSERT INTO eventstatetag VALUES (11, 6);
INSERT INTO eventstatetag VALUES (11, 7);
INSERT INTO eventstatetag VALUES (11, 11);
INSERT INTO eventstatetag VALUES (12, 4);
INSERT INTO eventstatetag VALUES (12, 5);
INSERT INTO eventstatetag VALUES (12, 6);
INSERT INTO eventstatetag VALUES (12, 7);
INSERT INTO eventstatetag VALUES (13, 4);
INSERT INTO eventstatetag VALUES (13, 8);
INSERT INTO eventstatetag VALUES (13, 9);
INSERT INTO eventstatetag VALUES (14, 3);
INSERT INTO eventstatetag VALUES (14, 5);
INSERT INTO eventstatetag VALUES (14, 10);
INSERT INTO eventstatetag VALUES (14, 11);
INSERT INTO eventstatetag VALUES (15, 4);
INSERT INTO eventstatetag VALUES (15, 5);
INSERT INTO eventstatetag VALUES (15, 8);
INSERT INTO eventstatetag VALUES (15, 9);
INSERT INTO eventstatetag VALUES (16, 4);
INSERT INTO eventstatetag VALUES (16, 5);
INSERT INTO eventstatetag VALUES (16, 8);
INSERT INTO eventstatetag VALUES (17, 4);
INSERT INTO eventstatetag VALUES (17, 5);
INSERT INTO eventstatetag VALUES (17, 7);
INSERT INTO eventstatetag VALUES (17, 11);
INSERT INTO eventstatetag VALUES (18, 4);
INSERT INTO eventstatetag VALUES (18, 5);
INSERT INTO eventstatetag VALUES (18, 7);
INSERT INTO eventstatetag VALUES (19, 4);
INSERT INTO eventstatetag VALUES (19, 5);
INSERT INTO eventstatetag VALUES (19, 8);
INSERT INTO eventstatetag VALUES (19, 9);
INSERT INTO eventstatetag VALUES (17, 10);
INSERT INTO eventstatetag VALUES (18, 10);


--
-- Data for Name: eventtype; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO eventtype VALUES (0, 'Informational', '');
INSERT INTO eventtype VALUES (1, 'Alert', '');
INSERT INTO eventtype VALUES (2, 'Suppress', 'Do not create event');


--
-- Data for Name: obj_block; Type: TABLE DATA; Schema: confdb; Owner: postgres
--


--
-- Data for Name: password_history; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO password_history VALUES ('00000000-0000-0000-0000-000000000021', '{"sha512": "734c883fb55e212cfe7a48ba6e2a33ff2f7ed275be04aeff6ea228ee6a2ac885ac4dd962a7bafe3514cd0f7cda7163d467b5652e7e1de7fd74a1a12b74b2ee64"}', timezone('UTC'::text, now()), 0);
INSERT INTO password_history VALUES ('00000000-0000-0000-0000-000000000022', '{"sha512": "734c883fb55e212cfe7a48ba6e2a33ff2f7ed275be04aeff6ea228ee6a2ac885ac4dd962a7bafe3514cd0f7cda7163d467b5652e7e1de7fd74a1a12b74b2ee64"}', timezone('UTC'::text, now()), 0);


--
-- Data for Name: realmtype; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'D', 'C', 'camera', '00000000-0000-0000-0000-000000000014');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'D', 'R', 'relay', '00000000-0000-0000-0000-000000000001');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'D', 'S', 'sensor_skm', '00000000-0000-0000-0000-000000000002');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'D', 'A', 'audio', '00000000-0000-0000-0000-000000000003');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'D', 'V', 'monitor', '00000000-0000-0000-0000-000000000004');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'D', 'W', 'wall', '00000000-0000-0000-0000-000000000005');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'D', 'E', 'external', '00000000-0000-0000-0000-000000000006');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'M', '3', 'model3d', '00000000-0000-0000-0000-000000000015');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'M', 'L', 'modellayer', '00000000-0000-0000-0000-000000000016');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'X', 'G', 'gateway', '00000000-0000-0000-0000-000000000007');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'X', 'S', 'sensor_acsg', '00000000-0000-0000-0000-000000000008');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'X', 'D', 'door', '00000000-0000-0000-0000-000000000009');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'X', 'P', 'perimeter', '00000000-0000-0000-0000-000000000010');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'X', 'A', 'area', '00000000-0000-0000-0000-000000000011');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'V', '*', 'avatar', '00000000-0000-0000-0000-000000000018');
INSERT INTO realmtype(realm, otype, subtype, type, set) VALUES ('00000000-0000-0000-0000-000000000054', 'X', 'R', 'rfid', '00000000-0000-0000-0000-000000000019');


--
-- Name: seq_event_emailer_snapshot; Type: SEQUENCE SET; Schema: confdb; Owner: postgres
--

SELECT pg_catalog.setval('seq_event_emailer_snapshot', 1, false);


--
-- Name: seqblockid; Type: SEQUENCE SET; Schema: confdb; Owner: postgres
--

SELECT pg_catalog.setval('seqblockid', 1, false);


--
-- Data for Name: storagertntype; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO storagertntype VALUES (1, 'Fixed', '');
INSERT INTO storagertntype VALUES (2, 'Range', '');
INSERT INTO storagertntype VALUES (3, 'Space limited', '');
INSERT INTO storagertntype VALUES (4, 'Frame decimation', '');
INSERT INTO storagertntype VALUES (5, 'Motions and Events', '');
INSERT INTO storagertntype VALUES (6, 'Events only', '');


--
-- Data for Name: storagepolicy; Type: TABLE DATA; Schema: confdb; Owner: postgres
--

INSERT INTO storagepolicy VALUES (1, 'STD: 24x7 Space Limited', 'Storage policy with initially defined parameters', 3, 0, 1, NULL, NULL, true);
INSERT INTO storagepolicy VALUES (-5, 'STD: Motions and Events', 'In this mode, Motion Detection is executed in background even if not specifically enabled in individual camera (events are not generated upon detection). Camera will store video only if motion is detected or if video is "tagged" by any Event (Motion Detection, Analytics, associated ACS event, etc..). If you enable Motion Detection on individual cameras, Events will be registered.', 5, 0, 1, NULL, NULL, true);
INSERT INTO storagepolicy VALUES (-6, 'STD: Events only', 'Camera will store video only if it is "tagged" by any Event (Motion Detection, Analytics, associated ACS event, etc..). Motion Detection is not automatically enabled in this mode. You have to specifically enable it in individual cameras', 6, 0, 1, NULL, NULL, true);
INSERT INTO storagepolicy VALUES (-7, 'STD: No Archive', 'Video and audio streams are not recorded', 1, 0, 0, NULL, NULL, true);
