package Overcast::Stat;

use 5.008008;
use strict;
use warnings;
use Redis;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw(
    GetStats SetStats
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
    GetStats SetStats
);

our $VERSION = '0.01';
our $Redis;

# Preloaded methods go here.
sub GetStats {
    return undef if not $Redis;
    my ($objs, $attrs) = @_;
    return undef if not $objs or ref $objs ne 'ARRAY';
    return undef if not $attrs or ref $attrs ne 'ARRAY';
    
    return {} if not @$attrs;
    
    my %res;
    foreach my $objid (@$objs) {
        my $ret = $Redis->hmget("stat:$objid", @$attrs, sub {
            my ($reply, $error) = @_;
            return if $error;
            my @vals = @$reply;
            for (my $i = 0; $i < @$attrs; $i++) {
                my $attr = $attrs->[$i];
                $res{$objid}{$attr} = $vals[$i];
            }
        });
    }
    
    $Redis->wait_all_responses;
    return \%res;
}

sub SetStats {
    return undef if not $Redis;
    my $req = shift;
    return undef if not $req or ref $req ne 'HASH';
    
    foreach my $objid (keys %$req) {
        my $attrs = $req->{$objid};
        next if not $attrs or ref $attrs ne 'HASH';
        my $ret = $Redis->hmset("stat:$objid", %$attrs, sub {});
        return undef if not defined $ret;
    }
    $Redis->wait_all_responses;
    return 1;
}

1;
