package Overcast::Redis;

use 5.008008;
use strict;
use warnings;
use Redis;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw(
    RedisConnect
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
    RedisConnect
);

our $VERSION = '0.01';
our $Redis;

# Preloaded methods go here.
sub RedisConnect {
    my $reconnect = shift;
    if (not $reconnect and $Redis and $Redis->ping) {
        return $Redis;
    }
    my $host = $ENV{OVERCAST_REDIS_SERVICE_HOST} || 'overcast-redis';
    my $port = $ENV{OVERCAST_REDIS_SERVICE_PORT} || 6379;
    $Redis->quit if $Redis;
    $Redis = Redis->new(
        server => "$host:$port",
        cnx_timeout => 5,
        name => "perl/redis"
    );
    
    return $Redis;
}


1;
