package Overcast::AMQ;

use 5.008008;
use strict;
use warnings;
use Net::STOMP::Client;
use JSON;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw(
    AMQSend AMQRequest AMQClose
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
    AMQSend AMQRequest AMQClose
);

our $VERSION = '0.01';
our $Stomp;
our $Error;

my $ReplyWaitTimeout = 3;

# Preloaded methods go here.
sub _connect {
    my $ret = 1;
    eval {
        $Stomp->disconnect if $Stomp;
        $Stomp = Net::STOMP::Client->new(
            host => $ENV{'OVERCAST_ACTIVEMQ_SERVICE_HOST'} ? $ENV{'OVERCAST_ACTIVEMQ_SERVICE_HOST'} : 'localhost',
            port => $ENV{'OVERCAST_ACTIVEMQ_PORT_STOMP'} ? $ENV{'OVERCAST_ACTIVEMQ_PORT_STOMP'} : 61616,
            timeout => {
                connect    => 3,
                connected  => 3,
                disconnect => 1,
                receive    => 3,
                send       => 3
            });
        $Stomp->connect(login => $ENV{OVERCAST_ACTIVEMQ_SERVICE_USER}, passcode => $ENV{OVERCAST_ACTIVEMQ_SERVICE_PASS});
    };
    if ($@) {
        $Error = $@; chomp $Error;
        $ret = 0;
    }
    return $ret;
}

sub AMQClose {
    return if not $Stomp;
    eval { $Stomp->disconnect };
    $Error = $@, chomp $Error if $@;
    $Stomp = undef;
}

sub AMQSend {
    my ($dst, $msg, $opts) = @_;
    $opts = {} if not $opts or not ref $opts or ref $opts ne 'HASH';

    if (not $Stomp) {
        return undef if not _connect;
    }

    my %send = (
        destination      => $dst,
        body             => encode_json($msg),
        'content-length' => ""
    );
    $send{'destination-type'} = 'MULTICAST' if $opts->{multicast};
    $Stomp->send(%send);
    
    AMQClose if $opts->{close};
}

sub AMQRequest {
    my ($dst, $msg, $opts) = @_;
    $opts = {} if not $opts or not ref $opts or ref $opts ne 'HASH';
    
    if (not $Stomp) {
        return undef if not _connect;
    }
    
    my $qid = "stomprpc.". int(rand 1000);
    $Stomp->subscribe(
        destination => $qid,
        id          => $qid
    );
    my %send = (
        destination => $dst,
        body => encode_json($msg),
        'content-length' => "",
        'reply-to' => $qid
    );
    $send{'destination-type'} = 'MULTICAST' if $opts->{multicast};
    $Stomp->send(%send);

    my $frame = $Stomp->receive_frame( timeout => $ReplyWaitTimeout );
    AMQClose if $opts->{close};
    return undef if not $frame;
    my $rsp = eval { decode_json($frame->body) };
    return $@ ? undef : $rsp;
}


1;
