set search_path to transdb;
ALTER TABLE audit DROP COLUMN parameters;

ALTER TABLE audit RENAME COLUMN parameters_temp TO parameters;

SET search_path TO apl;

CREATE OR REPLACE VIEW audit AS SELECT audit.date,
    audit.category,
    audit.userid,
    audit.objid,
    audit.level,
    audit.parameters,
    audit.realm
   FROM transdb.audit;
REVOKE ALL ON TABLE audit FROM PUBLIC;
GRANT SELECT,INSERT,DELETE ON TABLE audit TO apl;


SET search_path TO transdb;

CREATE TABLE message (
	msgid bigserial PRIMARY KEY,
	time timestamp,
	type integer,
	info jsonb
);

CREATE INDEX message_time on message (time asc);

CREATE TABLE message_role (
	msgid bigint,
	roleid uuid,
	policyid uuid[],
	state integer,
	read_by uuid,
	PRIMARY KEY(msgid, roleid)
);

CREATE INDEX message_roleid ON message_role USING hash (roleid);
GRANT SELECT,UPDATE ON SEQUENCE message_msgid_seq TO apl;

SET search_path TO apl;

CREATE OR REPLACE VIEW message AS SELECT msgid,
	time,
	type,
	info
   FROM transdb.message;
REVOKE ALL ON TABLE message FROM PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE message TO apl;


CREATE OR REPLACE VIEW message_role AS SELECT msgid,
	roleid,
	policyid,
	state
FROM transdb.message_role;

REVOKE ALL ON TABLE message_role FROM PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE message_role TO apl;

INSERT INTO objtype (type, otype, subtype, name, issystemset, setname) VALUES ('notification_policy', 'N', 'P', 'Notification policy', false, 'All Notification Policies');

INSERT INTO _objs (realm, type, otype, subtype, name, protected) (SELECT realm, 'set', 'S', '*', 'All Notification Policies', 1 from _objs where type='realm' and deleted=0);

INSERT INTO realmtype (realm,type,otype,subtype,set) (select realm,'notification_policy','N','P',obj from _objs where name='All Notification Policies' and type='set');

INSERT INTO _link_types (link_type, type_res, type_cons, name) VALUES ('notification_policy2set', 'notification_policy', 'set', 'Notification Policy to Set');

INSERT INTO _links (obj_res, obj_cons, link_type, permission) (select sets.obj obj_res, roles.obj obj_cons,'set2role' link_type, 'M' permission from _objs sets left join _objs roles on sets.realm = roles.realm left join _obj_attr ra on roles.obj=ra.obj and ra.attr='IS_ADMIN_ROLE'  where sets.type = 'set' and sets.name='All Notification Policies' and roles.type='role' and ra.val='1');


