SET search_path TO apl;

CREATE TYPE cm_realm_stream_usage AS (
    realmid uuid,
    usage   integer,
    period_start TIMESTAMP WITHOUT TIME ZONE
);


CREATE OR REPLACE FUNCTION cm_realm_stream_usage(realmids uuid[]) RETURNS SETOF cm_realm_stream_usage
    LANGUAGE plpgsql
    AS $$
DECLARE
    realm_subs record;
BEGIN
    FOR realm_subs IN SELECT o.realm, to_timestamp( COALESCE( (a.val::jsonb #>> '{subscription,periodStart}')::integer, 0) ) AT TIME ZONE 'UTC' AS period_start
     FROM _objs o INNER JOIN _obj_attr a ON o.obj=a.obj 
     WHERE o.obj = ANY(realmids) AND o.deleted=0 AND a.attr='ENTITLEMENT'
    LOOP
        BEGIN
            RETURN QUERY SELECT o.realm,(sum(bws.consumed)*1024)::integer AS stream_kb, realm_subs.period_start
                         FROM cm_bw_stat bws INNER JOIN _objs o ON o.obj=bws.objid 
                         WHERE o.realm = realm_subs.realm AND o.deleted=0 AND bws.ts >= realm_subs.period_start
                         GROUP BY o.realm;
            RETURN QUERY SELECT o.realm,(sum(bwc.bytes)/1024)::integer AS stream_kb, realm_subs.period_start
                         FROM cm_bw_cache bwc INNER JOIN _objs o ON o.obj=bwc.objid 
                         WHERE o.realm = realm_subs.realm AND o.deleted=0 AND bwc.ts >= realm_subs.period_start
                         GROUP BY o.realm;
        END;
    END LOOP;
    RETURN;
END;
$$;
