SET search_path TO confdb;

-- clean deprecated column
UPDATE _links SET special_credentials = '';

-- clean CREDENTIALS for all roles
UPDATE _obj_attr SET val = '' WHERE attr = 'CREDENTIALS';

-- set correct default CREDENTIALS for Admin role
UPDATE _obj_attr as cred
  SET val = 'uUFfREsV'
  FROM _obj_attr as isadmin
  WHERE
    cred.obj = isadmin.obj
    AND isadmin.attr = 'IS_ADMIN_ROLE'
    AND isadmin.val = '1'
    AND cred.attr = 'CREDENTIALS';

-- update credentials of permissions, move Vs to role CREDENTIALS
UPDATE permission_type SET credentials = 'Lv' WHERE permission = 'V';
UPDATE permission_type SET credentials = 'LvApaeDMrCSPmx' WHERE permission = 'M';
UPDATE permission_type SET credentials = 'LvApaeDMrCz' WHERE permission = 'C';


SET search_path TO apl;

--
-- Name: getobject(uuid, uuid, uuid); Type: FUNCTION; Schema: apl; Owner: postgres
--

CREATE OR REPLACE FUNCTION getobject(realm uuid, userobj uuid, roleobj uuid, objectobj uuid) RETURNS SETOF object_list_with_credentials
    LANGUAGE plpgsql
    AS $_$
BEGIN
    RETURN QUERY
    SELECT
      _objs.realm,
      _objs.obj,
      _objs.udid,
      _objs.name,
      _objs.description,
      _objs.type,
      _objs.otype,
      _objs.subtype,
      _objs.protected,
      concatFields(set2role.permission)::varchar as permission,
      concatFields(permission_type.credentials || role_attr.val)::varchar as credentials
    FROM
      _objs,
      _obj_attr as role_attr,
      permission_type,
      _links as set2role,
      _links as user2role,
      _links as object2set
    WHERE
      ($1 IS NULL OR _objs.realm = $1)
      AND set2role.link_type = 'set2role'
      AND user2role.link_type = 'user2role'
      AND object2set.link_type LIKE '%2set'
      AND _objs.obj = object2set.obj_res
      AND set2role.obj_cons = roleobj
      AND set2role.obj_cons = user2role.obj_cons
      AND object2set.obj_cons = set2role.obj_res
      AND set2role.permission = permission_type.permission
      AND user2role.obj_res = userobj
      AND role_attr.obj = set2role.obj_cons
      AND role_attr.attr = 'CREDENTIALS'
      AND object2set.obj_res = objectobj
    GROUP BY _objs.realm, _objs.obj, _objs.udid, _objs.name, _objs.description, _objs.type, _objs.otype, _objs.subtype, _objs.protected
    ORDER BY _objs.name;
END
$_$;


--
-- Name: getobjects(uuid, uuid, uuid, character, character); Type: FUNCTION; Schema: apl; Owner: postgres
--

CREATE OR REPLACE FUNCTION getobjects(realm uuid, userobj uuid, roleobj uuid, objtype character, objsubtype character) RETURNS SETOF object_list_with_credentials
    LANGUAGE plpgsql
    AS $_$
BEGIN
    RETURN QUERY
    SELECT
      _objs.realm,
      _objs.obj,
      _objs.udid,
      _objs.name,
      _objs.description,
      _objs.type,
      _objs.otype,
      _objs.subtype,
      _objs.protected,
      concatFields(set2role.permission)::varchar AS permission,
      concatFields(permission_type.credentials || CASE WHEN roleobj IS NULL THEN '' ELSE role_attr.val END)::varchar as credentials
    FROM
      _objs,
      _obj_attr as role_attr,
      permission_type,
      _links as set2role,
      _links as user2role,
      _links as object2set
    WHERE
      ($1 IS NULL OR _objs.realm = $1)
      AND (objtype IS NULL OR _objs.otype = objtype)
      AND (objsubtype IS NULL OR _objs.subtype = objsubtype)
      AND _objs.deleted = 0
      AND set2role.link_type = 'set2role'
      AND user2role.link_type = 'user2role'
      AND object2set.link_type LIKE '%2set'
      AND _objs.obj = object2set.obj_res
      AND set2role.obj_cons = user2role.obj_cons
      AND object2set.obj_cons = set2role.obj_res
      AND set2role.permission = permission_type.permission
      AND user2role.obj_res = userobj
      AND (roleobj IS NULL
        OR (
          user2role.obj_cons = roleobj
          AND role_attr.obj = set2role.obj_cons
          AND role_attr.attr = 'CREDENTIALS'
        )
      )
    GROUP BY _objs.realm, _objs.obj, _objs.udid, _objs.name, _objs.description, _objs.type, _objs.otype, _objs.subtype, _objs.protected
    ORDER BY _objs.name;
END
$_$;


--
-- Name: getobjects(uuid, uuid, uuid, uuid, character, character); Type: FUNCTION; Schema: apl; Owner: postgres
--

CREATE OR REPLACE FUNCTION getobjects(realm uuid, userobj uuid, roleobj uuid, setobj uuid, objtype character, objsubtype character) RETURNS SETOF object_list_with_credentials
    LANGUAGE plpgsql
    AS $_$
BEGIN
    RETURN QUERY
    SELECT
      object.realm,
      object.obj,
      object.udid,
      object.name,
      object.description,
      object.type,
      object.otype,
      object.subtype,
      object.protected,
      object.permission,
      object.credentials
    FROM (
      SELECT
        _objs.realm,
        _objs.obj,
        _objs.udid,
        _objs.name,
        _objs.description,
        _objs.type,
        _objs.otype,
        _objs.subtype,
        _objs.protected,
        concatFields(set2role.permission)::varchar AS permission,
        concatFields(permission_type.credentials || CASE WHEN roleobj IS NULL THEN '' ELSE role_attr.val END)::varchar as credentials
      FROM
        _objs,
        _obj_attr as role_attr,
        permission_type,
        _links as set2role,
        _links as user2role,
        _links as object2set
      WHERE
        ($1 IS NULL OR _objs.realm = $1)
        AND (objtype IS NULL OR _objs.otype = objtype)
        AND (objsubtype IS NULL OR _objs.subtype = objsubtype)
        AND _objs.deleted = 0
        AND set2role.link_type = 'set2role'
        AND user2role.link_type = 'user2role'
        AND object2set.link_type LIKE '%2set'
        AND _objs.obj = object2set.obj_res
        AND set2role.obj_cons = user2role.obj_cons
        AND object2set.obj_cons = set2role.obj_res
        AND set2role.permission = permission_type.permission
        AND user2role.obj_res = userobj
        AND (
          CASE WHEN roleobj IS NULL
            THEN true
          ELSE (
            user2role.obj_cons = roleobj
            AND role_attr.obj = set2role.obj_cons
            AND role_attr.attr = 'CREDENTIALS'
          )
          END
        )
        GROUP BY _objs.realm, _objs.obj, _objs.udid, _objs.name, _objs.description, _objs.type, _objs.otype, _objs.subtype, _objs.protected
    ) AS object, _links as object2set
    WHERE
      object2set.link_type LIKE '%2set'
      AND object.obj = object2set.obj_res
      AND object2set.obj_cons = setobj
    ORDER BY object.name;
END
$_$;


--
-- Name: getsetsfromrole(uuid, uuid); Type: FUNCTION; Schema: apl; Owner: postgres
--

CREATE OR REPLACE FUNCTION getsetsfromrole(realm uuid, roleobj uuid) RETURNS SETOF object_list_with_credentials
    LANGUAGE plpgsql
    AS $_$
BEGIN
    RETURN QUERY
    SELECT
      _objs.realm,
      _objs.obj,
      _objs.udid,
      _objs.name,
      _objs.description,
      _objs.type,
      _objs.otype,
      _objs.subtype,
      _objs.protected,
      set2role.permission::varchar,
      (permission_type.credentials || role_attr.val)::varchar
    FROM
      _objs,
      _obj_attr as role_attr,
      _links as set2role
      LEFT OUTER JOIN permission_type ON set2role.permission = permission_type.permission
    WHERE
      _objs.deleted = 0
      AND ($1 IS NULL OR _objs.realm = $1)
      AND set2role.link_type = 'set2role'
      AND set2role.obj_res = _objs.obj
      AND set2role.obj_cons = $2
      AND role_attr.obj = roleobj
      AND role_attr.attr = 'CREDENTIALS'
    ORDER BY _objs.name;
END
$_$;
