SET search_path TO confdb;

-------------------------------------------------------------------
----- Add default TTL value for watchlist entries
ALTER TABLE watchlist ADD COLUMN ttl_days INTEGER NULL;

-------------------------------------------------------------------
----- Add expiration date to each entry
ALTER TABLE watchlist_entries ADD COLUMN expire_date TIMESTAMP WITHOUT TIME ZONE NULL;

-------------------------------------------------------------------
----- public interface

SET search_path TO apl;

CREATE OR REPLACE VIEW watchlist AS SELECT * FROM confdb.watchlist;
REVOKE ALL ON TABLE watchlist FROM PUBLIC;
GRANT SELECT,INSERT,UPDATE,DELETE ON TABLE watchlist TO apl;

CREATE OR REPLACE VIEW watchlist_entries AS SELECT * FROM confdb.watchlist_entries;
REVOKE ALL ON TABLE watchlist_entries FROM PUBLIC;
GRANT SELECT,INSERT,UPDATE,DELETE ON TABLE watchlist_entries TO apl;
