set search_path TO confdb;

--
-- Name: _cred_types; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE _cred_types (
    cred character(1) NOT NULL,
    type varchar(255) NOT NULL,
    name character varying,
    description character varying
);


--
-- Name: _link_types; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE _link_types (
    link_type varchar(255) NOT NULL,
    type_res varchar(255) NOT NULL,
    type_cons varchar(255) NOT NULL,
    name character varying
);


--
-- Name: _links; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE _links (
    obj_res uuid NOT NULL,
    obj_cons uuid NOT NULL,
    link_type varchar(255) NOT NULL,
    permission character(1),
    special_credentials varchar(64) DEFAULT '',
    protected integer DEFAULT 0,
    updated_at timestamp without time zone DEFAULT timezone('UTC'::text, now())
);


--
-- Name: _obj_attr; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE _obj_attr (
    obj uuid NOT NULL,
    attr character varying NOT NULL,
    val character varying
);


--
-- Name: objtype; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE objtype (
    type character varying NOT NULL,
    otype character(1),
    subtype character(1),
    name character varying,
    setname character varying(255) DEFAULT ''::character varying NOT NULL,
    issystemset boolean DEFAULT false NOT NULL
);


--
-- Name: _objs; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE _objs (
    realm uuid NOT NULL,
    obj uuid DEFAULT uuid_generate_v1(),
    udid character varying(22) DEFAULT NULL::character varying,
    type varchar(255) NOT NULL,
    otype character(1),
    subtype character(1),
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description character varying(255) DEFAULT ''::character varying,
    deleted integer DEFAULT 0,
    protected integer DEFAULT 0,
    stime timestamp without time zone DEFAULT timezone('UTC'::text, now()),
    rtime timestamp without time zone,
    updated_at timestamp without time zone DEFAULT timezone('UTC'::text, now())
);


--
-- Name: event_emailer_snapshot; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE event_emailer_snapshot (
    snapshotid integer NOT NULL,
    userid uuid NOT NULL,
    eventid integer NOT NULL,
    ts_created timestamp without time zone DEFAULT timezone('UTC'::text, now())
);


--
-- Name: event_emailer_tag; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE event_emailer_tag (
    userid uuid NOT NULL,
    last_eventid integer,
    last_send bigint
);


--
-- Name: eventannounce; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventannounce (
    eventid integer NOT NULL,
    announced_by_userid uuid NOT NULL,
    announced_at timestamp without time zone DEFAULT timezone('UTC'::text, now()) NOT NULL,
    announce_to_userid uuid NOT NULL
);


--
-- Name: eventlifespan; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventlifespan (
    eventlifespan integer NOT NULL,
    name character varying NOT NULL,
    description character varying
);


--
-- Name: eventpolicy; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventpolicy (
    eventpolicy integer NOT NULL,
    name character varying NOT NULL,
    description character varying,
    protected boolean DEFAULT false NOT NULL
);


--
-- Name: eventpolicycontent; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventpolicycontent (
    eventpolicy integer NOT NULL,
    eventsource integer NOT NULL,
    workflow integer NOT NULL,
    infworkflow integer NOT NULL,
    parameters character varying
);


--
-- Name: eventpriority; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventpriority (
    eventpriority smallint NOT NULL,
    name character varying NOT NULL,
    description character varying,
    colorname character varying,
    colorcode character varying
);


--
-- Name: eventpropertydef; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventpropertydef (
    name character varying NOT NULL,
    description character varying
);


--
-- Name: eventsource; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventsource (
    eventsource integer NOT NULL,
    name character varying NOT NULL,
    description character varying
);


--
-- Name: eventsourceworkflow; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventsourceworkflow (
    eventsource integer NOT NULL,
    workflow integer NOT NULL
);


--
-- Name: eventstate; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventstate (
    eventstate integer NOT NULL,
    workflow integer NOT NULL,
    name character varying NOT NULL,
    description character varying,
    actions character varying,
    userdirective character varying
);


--
-- Name: eventstatetag; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventstatetag (
    eventstate integer NOT NULL,
    eventtag integer NOT NULL
);


--
-- Name: eventtag; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventtag (
    eventtag integer NOT NULL,
    name character varying NOT NULL,
    description character varying
);


--
-- Name: eventtype; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventtype (
    eventtype integer NOT NULL,
    name character varying NOT NULL,
    description character varying
);


--
-- Name: seqblockid; Type: SEQUENCE; Schema: confdb; Owner: postgres
--

CREATE SEQUENCE seqblockid
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: obj_block; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE obj_block (
    obj uuid NOT NULL,
    blockid integer DEFAULT nextval('seqblockid'::regclass) NOT NULL,
    name character varying DEFAULT ''::character varying,
    description character varying DEFAULT ''::character varying,
    mime character varying(255) DEFAULT 'application/octet-stream'::character varying,
    block bytea NOT NULL
);


--
-- Name: password_history; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE password_history (
    userid uuid NOT NULL,
    password character varying NOT NULL,
    changed timestamp without time zone DEFAULT timezone('UTC'::text, now()) NOT NULL,
    expired integer DEFAULT 0 NOT NULL
);


--
-- Name: permission_type; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE permission_type (
    permission character(1) NOT NULL,
    credentials character varying(64) DEFAULT ''::character varying,
    description character varying
);


--
-- Name: realmtype; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE realmtype (
    realm uuid NOT NULL,
    type character varying(255) NOT NULL,
    otype character(1),
    subtype character(1),
    set uuid
);


--
-- Name: schedulehist; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE schedulehist (
    scheduleid uuid NOT NULL,
    subjectid uuid NOT NULL,
    propname character varying NOT NULL,
    data character varying
);


--
-- Name: schedulelink; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE schedulelink (
    scheduleid uuid NOT NULL,
    timecardid uuid NOT NULL,
    postureid uuid NOT NULL
);


--
-- Name: storagepolicy; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE storagepolicy (
    storagepolicy integer NOT NULL,
    name character varying NOT NULL,
    description character varying,
    storagertntype integer,
    preservedaysmin integer DEFAULT 0,
    preservedaysmax integer DEFAULT 0,
    frdtype character varying,
    frdschedule character varying,
    protected boolean DEFAULT false NOT NULL,
    CONSTRAINT c_storagepolicy_preservedays CHECK ((preservedaysmin <= preservedaysmax))
);


--
-- Name: storagertntype; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE storagertntype (
    storagertntype integer NOT NULL,
    name character varying NOT NULL,
    description character varying
);


--
-- Name: seq_event_emailer_snapshot; Type: SEQUENCE; Schema: confdb; Owner: postgres
--

CREATE SEQUENCE seq_event_emailer_snapshot
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: workflow; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE workflow (
    workflow integer NOT NULL,
    name character varying NOT NULL,
    description character varying,
    context character varying NOT NULL,
    protected boolean DEFAULT false NOT NULL,
    deleted boolean DEFAULT false NOT NULL
);

--
-- Name: avatar_key; Type: TABLE; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE TABLE avatar_key (
    avatarid uuid NOT NULL,
    public varchar NOT NULL,
    created timestamp without time zone DEFAULT timezone('UTC'::text, now()),
    isactive boolean DEFAULT false NOT NULL
);
