#!/usr/bin/python

from subprocess import Popen, PIPE, STDOUT
import sys
import os
import re
import random
from subprocess import check_output

try:
	__import__("argparse")
except ImportError:
	print "Argparse module is not installed. Please install it via 'sudo pip install argparse'"
	sys.exit()

import argparse

reg = re.compile("^export ([^=]+)='(.+)'$")
fenv = open(os.path.expanduser("~")+"/.overcast-env")
env = {}
args = None
for varline in fenv:
	m = reg.match(varline)
	if m == None:
		continue
	env[m.group(1)] = m.group(2)
print "got bucket " + env['GCE_CONF_BUCKET']
def cpFile(source, pods, target) :
	tmpFolder = "tmp%d" % (random.randint(0,10000))
	filename = os.path.basename(source)
	os.system("gsutil cp "+source+" gs://%s/%s%s" % (env['GCE_CONF_BUCKET'], tmpFolder, filename))
	for pod in pods :
		if pod == "":
			continue
		print "kubectl exec %s -- cp /opt/sarch/etc/%s%s /tmp/%s" % (pod, tmpFolder, filename, filename)
		os.system("kubectl exec %s -- cp /opt/sarch/etc/%s%s /tmp/%s" % (pod, tmpFolder, filename, filename))
		print "kubectl exec %s -- mv /tmp/%s %s" % (pod, filename, target)
		os.system("kubectl exec %s -- cp /tmp/%s %s" % (pod, filename, target))
	os.system("gsutil rm gs://%s/%s%s" % (env['GCE_CONF_BUCKET'], tmpFolder, filename) )

def cpRecursively(root, pods, dest):
	if not (root.endswith("/")):
		root = root + "/"
	if not (dest.endswith("/")):
		dest=dest+"/"
	for _root, dirs,files in os.walk(root):
		for f in files:
			cpFile(os.path.join(root,f), pods, os.path.join(dest, _root.replace(root, ""), f))
def getPods(pod_grep) :
	pods=check_output(["kubectl get pods | cut --delimiter=' ' -f 1 | grep "+pod_grep], shell=True);
	return pods.split('\n');

parser = argparse.ArgumentParser(description='Copy files to POD', usage="pod-cp.py /path/to/src/file pod-id-aa12345:/path/to/dest/file\r\n       pod-cp.py -r /path/to/src/dir pod-id-aa12345:/path/to/dest/dir\r")

parser.add_argument("-r", action='store_true', required=False, help="Copy files recursive")
parser.add_argument("-v", action='store_true', required=False, help="Show debug info")
parser.add_argument("-e", action='store_true', required=False, help="Grep pod name from kubectl get pods");
parser.add_argument("source", help="Source file to copy")
parser.add_argument("dest", help="Destination file")


args = parser.parse_args()
print args
podPathPat = re.compile("^([^:]+):(.+)$");
podPath = podPathPat.match(args.dest);
pods = [podPath.group(1)]
if podPath == None :
	print "Invalid destination"
	sys.exit()
if os.path.exists(args.source) == False:
	print "Invalid source"
	sys.exit()
if args.e == True :
	pods = getPods(podPath.group(1))
if args.r == True :
	cpRecursively(args.source, pods, podPath.group(2))
else:
	cpFile(args.source, pods, podPath.group(2))
