-- TODO: CREATE DATABASE faces;
-- TODO: CREATE SCHEMA / SET search_path / etc...
--CREATE DATABASE faces;
--CREATE EXTENSION IF NOT EXISTS "timescaledb" CASCADE WITH SCHEMA pg_catalog;

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA pg_catalog;

CREATE TABLE subject (
    subject_id      uuid                            NOT NULL,
    template        bytea                           NOT NULL,
    properties      jsonb                           NULL                              -- { "realms": [ "realm_id1": { "descr": "John Doe", "ttype": "3divi6.6", "ext_props": { ... }}, "realm_id2": { ... } ] }
);

CREATE INDEX subject_subject_id ON subject(subject_id);
CREATE INDEX subject_properties_realms ON subject USING GIN ((properties -> 'realms'));

CREATE TABLE subject_history (
    history_id      uuid                            DEFAULT uuid_generate_v1 (),      -- unique ID for the entry
    subject_id      uuid                            NOT NULL,                         -- references "subject"
    realm_id        uuid                            NOT NULL,
    event_when      timestamp without time zone     NOT NULL,
    event_faces     bytea[],                                                          -- face cut-outs
    face_quality    real                            NOT NULL
);

CREATE INDEX subject_history_subject_id ON subject_history(subject_id);
