-- TODO: CREATE DATABASE audit;
-- TODO: CREATE SCHEMA / SET search_path / etc...
--CREATE DATABASE audit;
--CREATE EXTENSION IF NOT EXISTS "timescaledb" CASCADE WITH SCHEMA pg_catalog;

CREATE OPERATOR CLASS _uuid_ops DEFAULT FOR TYPE _uuid USING gin AS
OPERATOR 1 &&(anyarray, anyarray),
OPERATOR 2 @>(anyarray, anyarray),
OPERATOR 3 <@(anyarray, anyarray),
OPERATOR 4 =(anyarray, anyarray),
FUNCTION 1 uuid_cmp(uuid, uuid),
FUNCTION 2 ginarrayextract(anyarray, internal, internal),
FUNCTION 3 ginqueryarrayextract(anyarray, internal, smallint, internal, internal, internal, internal),
FUNCTION 4 ginarrayconsistent(internal, smallint, anyarray, integer, internal, internal, internal, internal),
STORAGE uuid;

CREATE TABLE audit_entry_type (
    entry_type      integer PRIMARY KEY,
    name            varchar NOT NULL,
    description     varchar NOT NULL
);

INSERT INTO audit_entry_type VALUES ( 1, 'System Event', 'System-wide event' );
INSERT INTO audit_entry_type VALUES ( 2, 'Realm Event', 'Event within the Realm scope' ); -- including obj.status changes and audit of user actions
INSERT INTO audit_entry_type VALUES ( 3, 'Event', 'Event on device/object' );
INSERT INTO audit_entry_type VALUES ( 4, 'Alarm', 'Alarm event created by the Rules Engine' );
INSERT INTO audit_entry_type VALUES ( 5, 'Notificatrion', 'Notification created by notifications engine' );

CREATE TABLE audit_level (
    level           integer PRIMARY KEY,
    name            varchar,
    description     varchar
);

INSERT INTO audit_level VALUES ( 1, 'DEBUG', 'Debug messages' );
INSERT INTO audit_level VALUES ( 2, 'INFO',  'Audit messages at INFO level' );
INSERT INTO audit_level VALUES ( 3, 'WARN',  'Audit messages at WARNING level' );
INSERT INTO audit_level VALUES ( 4, 'ERROR', 'Audit messages at ERROR level' );
INSERT INTO audit_level VALUES ( 5, 'FATAL', 'Audit messages at FATAL level' );
INSERT INTO audit_level VALUES ( 6, 'EVENT', 'Device event reports' );
INSERT INTO audit_level VALUES ( 7, 'ALARM', 'Alarms generated by Rules Engine' );

CREATE TYPE create_access AS ENUM ('INTERNAL', 'INTERNAL_ADMIN', 'REGULAR');

CREATE TABLE audit_category (
    category    integer PRIMARY KEY,
    parent      integer REFERENCES audit_category(category),
    shortname   varchar NOT NULL,
    digest      jsonb   -- i18n messages: {'en-us': 'User opened \'%1\'', 'ru-ru': 'Пользователь открыл \'%1\''}
);

INSERT INTO audit_category VALUES (1, NULL, 'User: Authentication', NULL);
INSERT INTO audit_category VALUES (2, 1, 'Login', '{"en-us": "Login successful"}');
INSERT INTO audit_category VALUES (3, 1, 'Logout', '{"en-us": "Logout successful"}');
INSERT INTO audit_category VALUES (4, 1, 'Session expired', '{"en-us": "Session of user #%1 %2 expired"}');
INSERT INTO audit_category VALUES (5, 1, 'Session forced closed', '{"en-us": "Session of user #%1 %2 forced closed"}');
INSERT INTO audit_category VALUES (6, NULL, 'User: Actions', NULL);
INSERT INTO audit_category VALUES (7, 6, 'Open GUI', '{"en-us": "User opened ''%1''"}');
INSERT INTO audit_category VALUES (8, 6, 'Load/Save/Delete/Share configuration', '{"en-us": "Matrix GUI configuration %1"}');
INSERT INTO audit_category VALUES (9, 6, 'PTZ: lock/unlock/expired/override', '{"en-us": "PTZ: %1"}');
INSERT INTO audit_category VALUES (10, 6, 'PTZ Tour: create/delete/edit/share/activate/stop', NULL);
INSERT INTO audit_category VALUES (12, 6, 'Open video: live/archive', '{"en-us": "%1 stream request"}');
INSERT INTO audit_category VALUES (14, 6, 'Export media-clip', '{"en-us": "Media clip export"}');
INSERT INTO audit_category VALUES (16, NULL, 'User: Eventlog', NULL);
INSERT INTO audit_category VALUES (17, 16, 'Review event (open dialog)', '{"en-us": "Event %1 review"}');
INSERT INTO audit_category VALUES (18, 16, 'Execute action/command on event', '{"en-us": "Execute command \"%1\" on event"}');
INSERT INTO audit_category VALUES (19, 16, 'Execute command on assocaited device', '{"en-us": "Execute command on associated device"}');
INSERT INTO audit_category VALUES (20, 16, 'Update event properties', '{"en-us": "Update event properties"}');
INSERT INTO audit_category VALUES (23, 16, 'Review video: on originator / on all witnesses', '{"en-us": "Review event %1 video from %2"}');
INSERT INTO audit_category VALUES (24, 16, 'Create event through "[R]" (recording)', NULL);
INSERT INTO audit_category VALUES (28, NULL, 'Object: Health', NULL);
INSERT INTO audit_category VALUES (29, 28, 'Health Status: on/off/broken/...', '{"en-us": "Health status set to \"%1\""}');
INSERT INTO audit_category VALUES (32, 28, 'System health status', '{"en-us": "System status set to \"%1\" %2"}');
INSERT INTO audit_category VALUES (33, NULL, 'Credentials: Users', NULL);
INSERT INTO audit_category VALUES (34, 33, 'User add/edit/remove', '{"en-us": "User \"%1\" %2"}');
INSERT INTO audit_category VALUES (35, NULL, 'Credentials: Objects', NULL);
INSERT INTO audit_category VALUES (39, NULL, 'Schedule Planner', NULL);
INSERT INTO audit_category VALUES (44, 1, 'Login failure', '{"en-us": "Login failed for user \"%1\""}');
INSERT INTO audit_category VALUES (45, 1, 'Account blocked', '{"en-us": "User \"%1\" blocked for %2 minute(s)"}');
INSERT INTO audit_category VALUES (46, NULL, 'Events registered on Objects', NULL);
INSERT INTO audit_category VALUES (47, 46, 'Simple Event', '{"en-us": "{{message}}"}');
INSERT INTO audit_category VALUES (48, 46, 'Event with parameters', '{"en-us": "%1 %2 %3 %4 %5 %6 %7 %8"}');
INSERT INTO audit_category VALUES (50, NULL, 'Alarms generated by the Rules Engine', NULL);
INSERT INTO audit_category VALUES (51, 50, 'Simple Alarm', '{"en-us": "%1"}');
INSERT INTO audit_category VALUES (52, 50, 'AlarmEvent with parameters', '{"en-us": "%1 %2 %3 %4 %5 %6 %7 %8"}');
INSERT INTO audit_category VALUES (53, NULL, 'Notifications', NULL);
INSERT INTO audit_category VALUES (54, 53, 'Simple Notification', '{"en-us": "%1"}');
INSERT INTO audit_category VALUES (55, NULL, 'Realm admin actions', NULL);
INSERT INTO audit_category VALUES (56, 55, 'User Impersonated', '{"en-us": "User %1 of role %2 impersonated user %3 of Realm %4"}');
INSERT INTO audit_category VALUES (57, 55, 'User Renewed Subscription', '{"en-us": "User %1 of role %2 made temporary subscription renewal on Realm %3"}');
INSERT INTO audit_category VALUES (58, 55, 'User created Realm', '{"en-us": "User %1 of role %2 created Realm %3"}');
INSERT INTO audit_category VALUES (59, 55, 'User updated Realm', '{"en-us": "User %1 of role %2 updated Realm %3"}');
INSERT INTO audit_category VALUES (60, 55, 'User deleted Realm', '{"en-us": "User %1 of role %2 deleted Realm %3"}');
INSERT INTO audit_category VALUES (61, 46, 'User Event', '{"en-us": "{{message}}"}');



CREATE TABLE audit_log (
    realm       uuid                            NOT NULL,	-- realm must be provided when running queries!
    inited_at   timestamp without time zone     NOT NULL,   -- context initialization time
    witness     uuid[]                          NOT NULL,   -- w[1] must be object where event originated
    context     uuid                            NULL,   	-- "event context", links multiple entries of the same event as it mutates
    entry_type  int                             NOT NULL    REFERENCES audit_entry_type(entry_type),
    category    integer                         NOT NULL    REFERENCES audit_category(category),
    meta        jsonb                           NULL,       -- category' parameters and other event metadata
    created_at   timestamp without time zone    NOT NULL,   -- entry creation time
    imported_at  timestamp without time zone    NOT NULL    -- time the entry got to the overcast DB
);

CREATE INDEX audit_log_witness_idx ON audit_log USING GIN(witness);

-- https://docs.timescale.com/v1.0/getting-started/creating-hypertables
--SELECT create_hypertable('audit_log', 'inited_at', 'realm', 25);

-- The next index is automatically created by TimescaleDB: https://docs.timescale.com/v1.0/using-timescaledb/schema-management#indexing
-- CREATE INDEX idx_audit_log_objid_ts ON audit_log(realm, ts DESC);
