SET search_path = transdb, pg_catalog;

--
-- Name: event_repl_log(); Type: FUNCTION; Schema: transdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION event_repl_log() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    op      char;
    evid    integer;
    upd_at  timestamp without time zone;
	objid   uuid;
	cnt     integer;
BEGIN
    IF (TG_OP = 'DELETE') THEN
        evid = OLD.eventid;
        upd_at = OLD.updated_at;
		objid = OLD.objid;
		op = 'D';
    ELSE
        evid = NEW.eventid;
        upd_at = NEW.updated_at;
		objid = NEW.objid;
		IF(TG_OP = 'INSERT') THEN
			op = 'I';
		ELSE
			op = 'U';
		END IF;
    END IF;
    INSERT INTO eventrepllog VALUES(evid, op, objid, upd_at);

	SELECT nextval('transdb.eventrepllog_seq') INTO cnt;
    IF(cnt > 500) THEN -- purge once in 500 executions
		PERFORM setval('transdb.eventrepllog_seq',0);
		SELECT count(*) FROM eventrepllog INTO cnt;
		cnt = cnt - 10000; -- maintain 10_000 entries in replication log, purge the rest
		IF( cnt  > 0 ) THEN
			DELETE FROM eventrepllog WHERE ctid IN (SELECT ctid FROM eventrepllog ORDER BY updated_at LIMIT cnt);
		END IF;
    END IF;
    
	RETURN NULL; -- "everything is OK"
END;
$$;



--
-- Name: gismo_upd_timestamp(); Type: FUNCTION; Schema: transdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION gismo_upd_timestamp() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    if OLD.stime = NEW.stime then
        NEW.stime := now() at time zone 'UTC';
    end if;
    return NEW;
END;
$$;


--
-- Name: upd_timestamp(); Type: FUNCTION; Schema: transdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION upd_timestamp() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    if OLD.updated_at = NEW.updated_at then
        NEW.updated_at := now() at time zone 'UTC';
    end if;
    return NEW;
END;
$$;


--
-- Name: upd_timestamp_cascading_event(); Type: FUNCTION; Schema: transdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION upd_timestamp_cascading_event() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (TG_OP = 'DELETE') THEN
	    UPDATE event SET updated_at=now() at time zone 'UTC' WHERE eventid=OLD.eventid;
		RETURN OLD;
	ELSE
	    UPDATE event SET updated_at=now() at time zone 'UTC' WHERE eventid=NEW.eventid;
		RETURN NEW;
	END IF;
END;
$$;
